/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.agents;

import inferno.geom.Inter;
import inferno.sim.VehicleBody;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import merlin.Intl;
import merlin.data.AMerlinObj;
import merlin.data.ICompElement;
import merlin.data.IRestorable;
import merlin.data.MerlinData;
import merlin.data.egress.agents.IAvatar;
import merlin.data.property.DisplayProp;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropertyDefs;
import merlin.data.tag.Tag;
import merlin.data.tag.TagsUtil;
import merlin.util.ILabeledEnum;
import org.jscience.physics.units.SI;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.NGon;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.ISurrogate;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.Sets;
import thunderheadeng.util.theUtil;

public class VehicleShape
extends AMerlinObj
implements Serializable,
ICompElement,
IRestorable,
ISurrogate,
IDirectDependent<MerlinData> {
    private static final long serialVersionUID = -425533861258326633L;
    private static Point3d[] pointsWheelchair;
    private static IPolygon polygonWheelchair;
    private static Point3d[] attachedAgentsPositionsWheelchair;
    private static Point3d[] pointsBed;
    private static IPolygon polygonBed;
    private static Point3d[] attachedAgentsPositionsBed;
    public static final VehicleShape NONE;
    public static final DisplayProp<String> PROP_NAME;
    public static final DisplayProp<String> PROP_DESC;
    public static final DisplayProp<UnitDouble> PROP_HEIGHT;
    @Deprecated
    public static final IPropertySet.Prop<AnimType> PROP_ANIM_TYPE;
    public static final DisplayProp<Set<String>> PROP_ANIM_TAGS;
    public static final DisplayProp<UnitPoint3D> PROP_OCCAVATAR_OFFSET;
    public static final DisplayProp<IAvatar> PROP_MODEL;
    public static final IPropertySet.Prop<IPolygon> PROP_POINTS_DEFAULT_WHEELCHAIR;
    public static final IPropertySet.Prop<Point3d[]> PROP_ATTACHED_AGENTS_POSITIONS_DEFAULT_WHEELCHAIR;
    public static final IPropertySet.Prop<IPolygon> PROP_POINTS_DEFAULT_BED_TWO_NURSES;
    public static final IPropertySet.Prop<Point3d[]> PROP_ATTACHED_AGENTS_POSITIONS_DEFAULT_BED_TWO_NURSES;
    public static final DisplayProp<IPolygon> PROP_POINTS;
    public static final DisplayProp<Point3d[]> PROP_ATTACHED_AGENTS_POSITIONS;
    public static final DisplayProp<Point3d> PROP_PIVOT;
    public static final DisplayProp<Boolean> PROP_ALLOW_LATERAL;
    public static final PropertyDefs<VehicleShape> PROP_TYPES;
    private PropertySet d_props = new PropertySet();

    private static String formatIPolygon(IPolygon p) {
        if (p.getNumLoops() < 0 || p.getNumPoints(0) < 1) {
            return "[]";
        }
        Object s = "[";
        for (int i = 0; i < p.getNumPoints(0); ++i) {
            if (i > 0) {
                s = (String)s + ", ";
            }
            Point3d point = p.getPoint(0, i);
            s = (String)s + new Point2d(point.x, point.y).toString();
        }
        s = (String)s + "]";
        return s;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_props.isDefined(PROP_ANIM_TYPE)) {
            AnimType type = this.d_props.get(PROP_ANIM_TYPE);
            this.d_props.set(PROP_ANIM_TAGS, type.tags);
            this.d_props.remove(PROP_ANIM_TYPE);
        }
    }

    @Override
    public String getName() {
        return this.getProperty(PROP_NAME);
    }

    @Override
    public void setName(String name) {
        this.setProperty(PROP_NAME, name);
    }

    public PropertyDefs<VehicleShape> getAllLocalProperties() {
        return PROP_TYPES;
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES.props();
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property instanceof IPropertySet.Prop) {
            this.setProperty((IPropertySet.Prop)property, value);
        }
    }

    public <T> void setProperty(IPropertySet.Prop<T> prop, T value) {
        if (!Objects.equals(this.d_props.get(prop), value)) {
            this.d_props.set(prop, value);
            this.changedEvt(prop);
        }
    }

    @Override
    public Object getProperty(Object property) {
        if (property instanceof IPropertySet.Prop) {
            return this.getProperty((IPropertySet.Prop)property);
        }
        return NOT_SUPPORTED;
    }

    public <T> T getProperty(IPropertySet.Prop<T> prop) {
        return this.d_props.get(prop);
    }

    @Override
    public VehicleShape clone() {
        VehicleShape clone = (VehicleShape)super.clone();
        clone.d_props = this.d_props.clone();
        return clone;
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof VehicleShape)) {
            return;
        }
        VehicleShape vs = (VehicleShape)obj;
        this.d_props = vs.d_props;
        this.changedEvt(new Object[0]);
    }

    @Override
    public Object getRestoreObj() {
        return this.clone();
    }

    public Point3d[] getBodyPoints(Point3d loc, double angle) {
        Point3d[] bodyShapePoints = PolyUtil.getLoop(this.getProperty(PROP_POINTS), 0, false);
        return VehicleShape.getPoints(loc, angle, bodyShapePoints);
    }

    public Point3d[] getBodyPoints(double angle) {
        Point3d[] bodyShapePoints = this.getBodyPoints();
        return VehicleShape.getPoints(angle, bodyShapePoints);
    }

    public Point3d[] getBodyPoints() {
        return PolyUtil.getLoop(this.getProperty(PROP_POINTS), 0, false);
    }

    public Point3d[] getAttachedPositions(Point3d loc, double angle) {
        Point3d[] attachedPositions = this.getProperty(PROP_ATTACHED_AGENTS_POSITIONS);
        return VehicleShape.getPoints(loc, angle, attachedPositions);
    }

    public Point3d[] getAttachedPositions(double angle) {
        Point3d[] attachedPositions = this.getProperty(PROP_ATTACHED_AGENTS_POSITIONS);
        return VehicleShape.getPoints(angle, attachedPositions);
    }

    private static Point3d[] getPoints(Point3d loc, double angle, Point3d[] points) {
        Point3d[] pointsOnFace = VehicleShape.getPoints(angle, points);
        for (int i = 0; i < pointsOnFace.length; ++i) {
            pointsOnFace[i].add(loc);
        }
        return pointsOnFace;
    }

    private static Point3d[] getPoints(double angleRad, Point3d[] points) {
        Point3d origin = new Point3d(0.0, 0.0, 0.0);
        Point3d[] pointsOnFace = new Point3d[points.length];
        for (int i = 0; i < points.length; ++i) {
            pointsOnFace[i] = new Point3d(points[i]);
            Inter.rotateTuple2D(pointsOnFace[i], angleRad, origin);
        }
        return pointsOnFace;
    }

    public Point3d[] getOuterPoints(Point3d loc, double angle) {
        Point3d[] pointsOnFace = this.getBodyPoints(loc, angle);
        Point3d[] attachedAgentsPositions = this.getAttachedPositions(loc, angle);
        return VehicleBody.calcOuterPoints(pointsOnFace, Arrays.asList(attachedAgentsPositions));
    }

    public static Point3d[] get3dPoints(Point3d[] points, double height) {
        Point3d[] ret = new Point3d[points.length * 2];
        for (int i = 0; i < points.length; ++i) {
            ret[i] = points[i];
            ret[i + points.length] = new Point3d(points[i].x, points[i].y, points[i].z + height);
        }
        return ret;
    }

    private static Point3d[] generateRectangle(double length, double width) {
        int i = 0;
        Point3d[] points = new Point3d[4];
        points[i++] = new Point3d(-length / 2.0, -width / 2.0, 0.0);
        points[i++] = new Point3d(length / 2.0, -width / 2.0, 0.0);
        points[i++] = new Point3d(length / 2.0, width / 2.0, 0.0);
        points[i++] = new Point3d(-length / 2.0, width / 2.0, 0.0);
        return points;
    }

    private int surrogateHashCode() {
        int hash = 7;
        for (Point3d p : this.getBodyPoints()) {
            hash = 31 * hash + theUtil.hashCode(p);
        }
        hash = 31 * hash + theUtil.hashCode(this.getProperty(PROP_NAME));
        return hash;
    }

    @Override
    public boolean surrogateEquals(Object comparable) {
        if (comparable == this) {
            return true;
        }
        if (!(comparable instanceof VehicleShape)) {
            return false;
        }
        VehicleShape comparableVehicleShape = (VehicleShape)comparable;
        Object[] comparablePoints = comparableVehicleShape.getBodyPoints();
        return comparableVehicleShape.getProperty(PROP_NAME).equals(this.getProperty(PROP_NAME)) && Arrays.equals(comparablePoints, this.getBodyPoints());
    }

    public Set<Tag> getTags() {
        return this.getProperty(MerlinData.TAGS);
    }

    public void setTags(Set<Tag> newTags) {
        this.setProperty(MerlinData.TAGS, newTags);
    }

    @Override
    public void takeDepSnapshot(DepList<MerlinData> deps) {
        PROP_TYPES.takeDepSnapshot(this, deps);
    }

    public String toString() {
        return this.getName();
    }

    static {
        double widthWC = 0.76;
        double lengthWC = 1.32;
        double fullLengthWC = 1.72;
        pointsWheelchair = VehicleShape.generateRectangle(lengthWC, widthWC);
        polygonWheelchair = new NGon(pointsWheelchair);
        Point3d p1 = new Point3d(-(fullLengthWC / 2.0 - 0.15), 0.0, 0.0);
        attachedAgentsPositionsWheelchair = new Point3d[]{p1};
        double widthB = 1.0;
        double lengthB = 2.15;
        double fullLengthB = lengthB + 0.6;
        pointsBed = VehicleShape.generateRectangle(lengthB, widthB);
        polygonBed = new NGon(pointsBed);
        Point3d p2 = new Point3d(-(fullLengthB / 2.0 - 0.15), 0.0, 0.0);
        Point3d p3 = new Point3d(fullLengthB / 2.0 - 0.15, 0.0, 0.0);
        attachedAgentsPositionsBed = new Point3d[]{p2, p3};
        NONE = null;
        PROP_NAME = DisplayProps.build((Object)"VehicleShape.NAME", "", Intl.intl("Name"), "").attrToProp();
        PROP_DESC = ((DisplayProps.Builder)DisplayProps.build((Object)"VehicleShape.DESC", "", Intl.intl("Description"), "").attrMarkScenarioSupported()).attrToProp();
        PROP_HEIGHT = ((DisplayProps.Builder)DisplayProps.build((Object)"VehicleShape.HEIGHT", new UnitDouble(1.0, SI.METER), Intl.intl("Height"), "", 0).attrMarkScenarioSupported()).attrToProp();
        PROP_ANIM_TYPE = new IPropertySet.Prop<AnimType>("VehicleShape.ANIM_TYPE", AnimType.NORMAL);
        PROP_ANIM_TAGS = ((DisplayProps.Builder)DisplayProps.buildGeneric("VehicleShape.ANIM_TAGS", Set.class, AnimType.NORMAL.tags, Intl.intl("Occupant Animation"), Intl.intl("The animation applied to occupants using the shape.")).attrMarkScenarioSupported()).attrToProp();
        PROP_OCCAVATAR_OFFSET = ((DisplayProps.Builder)DisplayProps.build((Object)"VehicleShape.OCCAVATAR_OFFSET", UnitPoint3D.class, new UnitPoint3D(0.0, 0.0, 0.0, SI.METER), Intl.intl("Occupant Offset"), Intl.intl("The offset for the occupant's 3d model so it lines up with the shape's 3d model.")).attrMarkScenarioSupported()).attrToProp();
        PROP_MODEL = ((DisplayProps.Builder)DisplayProps.build((Object)"VehicleShape.MODEL", IAvatar.class, null, Intl.intl("3d Model"), "<html>" + Intl.intl("The 3d model that represents the shape. This is shown in addition to<br>the 3d model of the occupant using the shape.")).attrMarkScenarioSupported()).attrToProp();
        PROP_POINTS_DEFAULT_WHEELCHAIR = new IPropertySet.Prop<IPolygon>("VehicleShape.POINTS_DEFAULT_WHEELCHAIR", polygonWheelchair);
        PROP_ATTACHED_AGENTS_POSITIONS_DEFAULT_WHEELCHAIR = new IPropertySet.Prop<Point3d[]>("VehicleShape.ATTACHED_AGENTS_POSITIONS_DEFAULT_WHEELCHAIR", attachedAgentsPositionsWheelchair);
        PROP_POINTS_DEFAULT_BED_TWO_NURSES = new IPropertySet.Prop<IPolygon>("VehicleShape.POINTS_DEFAULT_BED_TWO_NURSES", polygonBed);
        PROP_ATTACHED_AGENTS_POSITIONS_DEFAULT_BED_TWO_NURSES = new IPropertySet.Prop<Point3d[]>("VehicleShape.ATTACHED_AGENTS_POSITIONS_DEFAULT_WHEELCHAIR", attachedAgentsPositionsBed);
        PROP_POINTS = ((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.build((Object)"VehicleShape.POINTS", IPolygon.class, polygonWheelchair, Intl.intl("Points"), "").attrMarkScenarioSupported()).attrFormatValue(v -> VehicleShape.formatIPolygon(v))).attrToProp();
        PROP_ATTACHED_AGENTS_POSITIONS = ((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.buildGeneric("VehicleShape.ATTACHED_AGENTS_POSITIONS", Point3d[].class, attachedAgentsPositionsWheelchair, Intl.intl("Positions of attached occupants"), "").attrMarkScenarioSupported()).attrFormatValue(v -> Arrays.stream(v).map(p -> new Point2d(p.x, p.y).toString()).collect(Collectors.joining()))).attrToProp();
        PROP_PIVOT = ((DisplayProps.Builder)DisplayProps.build((Object)"VehicleShape.PIVOT", Point3d.class, new Point3d(0.0, 0.0, 0.0), Intl.intl("Pivot"), "").attrMarkScenarioSupported()).attrToProp();
        PROP_ALLOW_LATERAL = ((DisplayProps.Builder)DisplayProps.build((Object)"VehicleShape.ALLOW_LATERAL", Boolean.class, false, Intl.intl("Allow sideways movement"), "<html>" + Intl.intl("Whether occupants using this shape can move in a direction they<br>are not facing in order to avoid other occupants.")).attrMarkScenarioSupported()).attrToProp();
        PROP_TYPES = new PropertyDefs<VehicleShape>(VehicleShape.class, List.of(), PROP_NAME, PROP_DESC, PROP_HEIGHT, PROP_MODEL, PROP_ANIM_TAGS, PROP_OCCAVATAR_OFFSET, PROP_POINTS, PROP_ATTACHED_AGENTS_POSITIONS, PROP_PIVOT, PROP_ALLOW_LATERAL, MerlinData.TAGS);
        TagsUtil.registerTagsDependency(PROP_TYPES);
    }

    public static enum AnimType implements ILabeledEnum
    {
        NORMAL(Intl.intl("Default"), Intl.intl("The occupant uses the animation defined in the their profile."), new String[0]),
        WHEELCHAIR(Intl.intl("Wheelchair"), Intl.intl("The occupant uses an animation where they operate a wheelchair."), "default", "wheelchair"),
        BED(Intl.intl("Bed"), Intl.intl("The occupant uses an animation where they lie on their back."), "default", "lay");

        public final String displayName;
        public final String displayDesc;
        public final Set<String> tags;

        private AnimType(String name, String desc, String ... tags) {
            this.displayName = name;
            this.displayDesc = desc;
            this.tags = Sets.fromArrayLHS(tags);
        }

        @Override
        public String getName() {
            return this.displayName;
        }

        @Override
        public String getDescription() {
            return this.displayDesc;
        }
    }

    public static enum ShapeType {
        POLYGON,
        CYLINDER;

    }
}

