/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.agents;

import java.io.ObjectStreamException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import merlin.Intl;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.egress.SimError;
import merlin.data.egress.agents.IProfileProp;
import merlin.data.egress.agents.IProfilePropDist;
import merlin.data.egress.agents.IProfilePropUnary;
import merlin.data.egress.agents.OccProfile;
import merlin.data.property.DisplayProp;
import merlin.data.property.DisplayProps;
import merlin.data.property.Function1dProp;
import merlin.data.property.IDisplayProp;
import merlin.data.property.IFormatValue;
import merlin.data.value.ConstFunction1d;
import merlin.data.value.IFunction1d;
import merlin.unitsystem.SIUS;
import merlin.util.MerlinUtil;
import thunderheadeng.dependencies.DepCallback;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.TypedProp;

public class ProfileProps {
    public static <T> UnaryPropBuilder<T> buildUnaryProp(Group group, String key, Class<T> type, T defVal, String displayName, String description) {
        return (UnaryPropBuilder)((UnaryPropBuilder)new UnaryPropBuilder().init(key, type, defVal, displayName, description)).attrGroup(group);
    }

    public static <SampledT, DistT> DistPropBuilder<SampledT, DistT> buildDistProp(Group group, String key, long seed, Class<DistT> distType, Class<SampledT> sampledType, DistT defVal, String displayName, String description) {
        return (DistPropBuilder)((DistPropBuilder)new DistPropBuilder<SampledT, DistT>().init(key, distType, sampledType, defVal, displayName, description, seed)).attrGroup(group);
    }

    public static class UnaryPropBuilder<T>
    extends UnaryPropTBuilder<T, UnaryProp<T>, UnaryPropBuilder<T>> {
    }

    public static abstract class PropTBuilder<OccT, ProfT, PropT extends Prop<OccT, ProfT>, BuilderT extends PropTBuilder<OccT, ProfT, PropT, BuilderT>>
    extends DisplayProps.TBuilder<ProfT, PropT, BuilderT> {
        protected Group group = Group.NONE;
        protected Object simKey = null;
        protected boolean geometric = false;
        protected IGetErrors<ProfT> getErrors;
        protected Function<? super PropT, ? extends DepCallback<MerlinData, ICompElement, ProfT, ?>> depCallback;

        protected BuilderT init(String key, Class<ProfT> type, ProfT defVal, String name, String desc) {
            return (BuilderT)((PropTBuilder)super.init(key, type, defVal, name, desc));
        }

        public BuilderT attrGroup(Group group) {
            this.group = group;
            return (BuilderT)this;
        }

        public BuilderT attrSimKey(Object key) {
            this.simKey = key;
            return (BuilderT)this;
        }

        public BuilderT attrMarkGeometric() {
            this.geometric = true;
            return (BuilderT)this;
        }

        public BuilderT attrGetErrors(IGetErrors<ProfT> getErrors) {
            this.getErrors = getErrors;
            return (BuilderT)this;
        }

        public <RefT> BuilderT attrDependency(Function<? super PropT, ? extends DepCallback<MerlinData, ICompElement, ProfT, RefT>> dep) {
            this.depCallback = dep;
            return (BuilderT)this;
        }
    }

    public static enum Group {
        NONE(""),
        APPEARANCE(Intl.intl("Appearance")),
        CHARACTERISTICS(Intl.intl("Characteristics")),
        MOVEMENT(Intl.intl("Movement")),
        RESTRICTIONS(Intl.intl("Restrictions")),
        DOOR_CHOICE(Intl.intl("Door Choice")),
        OUTPUT(Intl.intl("Output")),
        ADVANCED(Intl.intl("Advanced")),
        ADVANCED_SPEED(Intl.intl("Advanced Speed")),
        ANIMATION(Intl.intl("Animation"));

        public final String displayStr;

        private Group(String displayStr) {
            this.displayStr = displayStr;
        }
    }

    public static class DistPropBuilder<SampledT, DistT>
    extends DistPropTBuilder<SampledT, DistT, DistProp<SampledT, DistT>, DistPropBuilder<SampledT, DistT>> {
    }

    public static class DistPropTBuilder<SampledT, DistT, PropT extends DistProp<SampledT, DistT>, BuilderT extends DistPropTBuilder<SampledT, DistT, PropT, BuilderT>>
    extends PropTBuilder<SampledT, DistT, PropT, BuilderT> {
        protected Class<SampledT> sampledType = null;
        protected long seed = 0L;
        protected IDisplayProp.ValEditorSupplier<SampledT> getSampledValEditor;
        protected Function<? super SampledT, ? extends DistT> valFromSample;
        protected Function<? super PropT, ? extends ISampleVal<SampledT, DistT>> getSampleValue;

        protected BuilderT init(String key, Class<DistT> distType, Class<SampledT> sampledType, DistT defVal, String name, String desc, long seed) {
            super.init(key, distType, defVal, name, desc);
            this.sampledType = sampledType;
            this.seed = seed;
            return (BuilderT)this;
        }

        public BuilderT attrSampledValEditor(IDisplayProp.ValEditorSupplier<SampledT> editor) {
            this.getSampledValEditor = editor;
            return (BuilderT)this;
        }

        public BuilderT attrSampleVal(Function<? super PropT, ? extends ISampleVal<SampledT, DistT>> getSampleValue) {
            this.getSampleValue = getSampleValue;
            return (BuilderT)this;
        }

        public BuilderT attrValFromSample(Function<? super SampledT, ? extends DistT> valFromSample) {
            this.valFromSample = valFromSample;
            return (BuilderT)this;
        }

        @Override
        public PropT attrToProp() {
            assert (this.valFromSample != null) : String.format("%s(%s) must supply attrNewConstValue", this.key.toString(), this.name);
            assert (this.getSampleValue != null) : String.format("%s(%s) must supply attrSampleVal", this.key.toString(), this.name);
            return (PropT)new DistProp<SampledT, DistT>(this.group, (String)this.key, this.simKey, this.seed, this.type, this.sampledType, this.defVal, this.geometric, this.name, this.desc, this.formatValue, this.cloneValue, this.valEditorSupplier, this.getSampledValEditor, this.getErrors, this.depCallback, this.valFromSample, this.getSampleValue, this.markers);
        }
    }

    static interface IGetErrors<T> {
        public void get(MerlinData var1, IMerlinObj var2, T var3, Consumer<? super SimError> var4);
    }

    public static class ProfileFunction1dProp
    extends TypedProp<IFunction1d>
    implements IProfilePropUnary<IFunction1d> {
        private static final long serialVersionUID = 1L;
        public final Group group;
        public final Function1dProp fprop;

        public ProfileFunction1dProp(Group group, Function1dProp fprop) {
            super(fprop.key, IFunction1d.class, (IFunction1d)fprop.defVal, fprop.markers);
            this.group = group;
            this.fprop = fprop;
        }

        @Override
        public String getGroupDisplayName() {
            return this.group.displayStr;
        }

        @Override
        public String getDisplayName() {
            return this.fprop.getDisplayName();
        }

        @Override
        public Object getSimKey() {
            return this.fprop.key;
        }

        @Override
        public String getDisplayDesc() {
            return this.fprop.getDisplayDesc();
        }

        @Override
        public IDisplayProp.ValEditorSupplier<IFunction1d> getValEditorSupplier() {
            return this.fprop.getValEditorSupplier();
        }

        @Override
        public IFunction1d cloneValue(IFunction1d value) {
            return value;
        }

        @Override
        public String formatValue(ICompElement src, IFunction1d value) {
            return value.format(MerlinUtil.getDisplayUnitSupplier(new int[0]));
        }

        @Override
        public void getValueErrors(MerlinData md, IMerlinObj owner, IFunction1d value, Consumer<? super SimError> errors) {
        }

        @Override
        public Stream<DepCallback<MerlinData, ICompElement, IFunction1d, ?>> streamDependencies() {
            return Stream.empty();
        }

        @Override
        public IPropertySet.Prop<IFunction1d> asProp() {
            return this;
        }

        public ProfileFunctionProp toProfileFunctionProp() {
            return new ProfileFunctionProp(this.group, this.fprop);
        }
    }

    public static class ProfileFunctionProp
    extends IPropertySet.Prop<OccProfile.IProfileFunction>
    implements IProfilePropUnary<OccProfile.IProfileFunction> {
        private static final long serialVersionUID = 1L;
        public final Group group;
        public final Function1dProp fprop;

        public ProfileFunctionProp(Group group, Function1dProp fprop) {
            super(fprop.key, OccProfile.FromLevelFundamental.INSTANCE);
            this.group = group;
            this.fprop = fprop;
        }

        @Override
        public String getGroupDisplayName() {
            return this.group.displayStr;
        }

        @Override
        public String getDisplayName() {
            return this.fprop.getDisplayName();
        }

        @Override
        public Object getSimKey() {
            return this.fprop.key;
        }

        @Override
        public String getDisplayDesc() {
            return this.fprop.getDisplayDesc();
        }

        @Override
        public IDisplayProp.ValEditorSupplier<OccProfile.IProfileFunction> getValEditorSupplier() {
            return (md, inline) -> OccProfile.newSlopedFundEditor(this, () -> this.defVal instanceof OccProfile.ConstProfileFunction ? ((OccProfile.ConstProfileFunction)this.defVal).function : new ConstFunction1d(SIUS.newud(0.0, this.fprop.y.unitType)));
        }

        @Override
        public OccProfile.IProfileFunction cloneValue(OccProfile.IProfileFunction value) {
            return value;
        }

        @Override
        public String formatValue(ICompElement src, OccProfile.IProfileFunction value) {
            Optional<Function1dProp.PredefFunction> pre;
            IFunction1d constFunc = value.apply(null);
            if (constFunc != null && (pre = Stream.of(this.fprop.predef).filter(p -> p.func != null && p.func.equals(constFunc)).findFirst()).isPresent()) {
                return pre.get().shortDesc;
            }
            return value.format();
        }

        @Override
        public void getValueErrors(MerlinData md, IMerlinObj owner, OccProfile.IProfileFunction value, Consumer<? super SimError> errors) {
        }

        @Override
        public Stream<DepCallback<MerlinData, ICompElement, OccProfile.IProfileFunction, ?>> streamDependencies() {
            return Stream.empty();
        }

        @Override
        public IPropertySet.Prop<OccProfile.IProfileFunction> asProp() {
            return this;
        }

        @Override
        public boolean testMarker(Object marker) {
            return this.fprop.testMarker(marker);
        }

        @Override
        public Stream<?> streamMarkers() {
            return this.fprop.streamMarkers();
        }
    }

    public static class DistProp<SampledT, DistT>
    extends Prop<SampledT, DistT>
    implements IProfilePropDist<SampledT, DistT> {
        private static final long serialVersionUID = 1L;
        public final long seed;
        public final Class<SampledT> sampledType;
        public final IDisplayProp.ValEditorSupplier<SampledT> getSampledValEditor;
        public final Function<? super SampledT, ? extends DistT> newConstValue;
        public final ISampleVal<SampledT, DistT> sampleValue;

        public DistProp(Group group, String key, Object simKey, long seed, Class<DistT> distType, Class<SampledT> sampledType, DistT defVal, boolean geometric, String displayName, String description, IFormatValue<ICompElement, DistT> formatValue, UnaryOperator<DistT> cloneValue, IDisplayProp.ValEditorSupplier<DistT> getValEditor, IDisplayProp.ValEditorSupplier<SampledT> getDistValEditor, IGetErrors<DistT> getErrors, Function<? super DistProp<SampledT, DistT>, ? extends DepCallback<MerlinData, ICompElement, DistT, ?>> dependency, Function<? super SampledT, ? extends DistT> newConstValue, Function<? super DistProp<SampledT, DistT>, ? extends ISampleVal<SampledT, DistT>> getSampleValue, Set<Object> markers) {
            super(group, key, simKey, distType, defVal, geometric, displayName, description, formatValue, cloneValue, getValEditor, getErrors, dependency, markers);
            this.sampledType = sampledType;
            this.getSampledValEditor = getDistValEditor;
            this.newConstValue = newConstValue;
            this.sampleValue = getSampleValue.apply(this);
            this.seed = seed;
        }

        @Override
        public long getSeed() {
            return this.seed;
        }

        @Override
        public Class<DistT> getDistType() {
            return this.type;
        }

        @Override
        public Class<SampledT> getSampledType() {
            return this.sampledType;
        }

        @Override
        public IDisplayProp.ValEditorSupplier<SampledT> getSampledValEditor() {
            return this.getSampledValEditor;
        }

        @Override
        public DistT toProfileValue(SampledT val) {
            return this.newConstValue.apply(val);
        }

        @Override
        public SampledT toOccValue(OccProfile profile, DistT distVal, long profileSeed, long orientSeed) {
            return this.sampleValue.sampleValue(profile, distVal, profileSeed, orientSeed);
        }
    }

    public static interface ISampleVal<SampledT, DistT> {
        public SampledT sampleValue(OccProfile var1, DistT var2, long var3, long var5);
    }

    public static class UnaryPropTBuilder<T, PropT extends UnaryProp<T>, BuilderT extends UnaryPropTBuilder<T, PropT, BuilderT>>
    extends PropTBuilder<T, T, PropT, BuilderT> {
        @Override
        public PropT attrToProp() {
            return (PropT)new UnaryProp<Object>(this.group, (String)this.key, this.simKey, this.type, this.defVal, this.geometric, this.name, this.desc, this.formatValue, this.cloneValue, this.valEditorSupplier, this.getErrors, this.depCallback, (Set<Object>)this.markers);
        }
    }

    public static class UnaryProp<T>
    extends Prop<T, T>
    implements IProfilePropUnary<T> {
        private static final long serialVersionUID = 1L;

        <PropT extends UnaryProp<T>> UnaryProp(Group group, String key, Object simKey, Class<T> type, T defVal, boolean geometric, String displayName, String description, IFormatValue<ICompElement, T> formatValue, UnaryOperator<T> cloneValue, IDisplayProp.ValEditorSupplier<T> getValEditor, IGetErrors<T> getErrors, Function<? super PropT, ? extends DepCallback<MerlinData, ICompElement, T, ?>> dependency, Set<Object> markers) {
            super(group, key, simKey, type, defVal, geometric, displayName, description, formatValue, cloneValue, getValEditor, getErrors, dependency, markers);
        }
    }

    public static abstract class Prop<OccT, ProfT>
    extends DisplayProp<ProfT>
    implements IProfileProp<OccT, ProfT> {
        private static final long serialVersionUID = 1L;
        public final Object simKey;
        public final Group group;
        public final boolean geometric;
        public final IGetErrors<ProfT> getErrors;
        public final DepCallback<MerlinData, ICompElement, ProfT, ?> depCallback;

        <PropT extends Prop<OccT, ProfT>> Prop(Group group, String key, Object simKey, Class<ProfT> type, ProfT defVal, boolean geometric, String displayName, String description, IFormatValue<ICompElement, ProfT> formatValue, UnaryOperator<ProfT> cloneValue, IDisplayProp.ValEditorSupplier<ProfT> getValEditor, IGetErrors<ProfT> getErrors, Function<? super PropT, ? extends DepCallback<MerlinData, ICompElement, ProfT, ?>> dependency, Set<Object> markers) {
            super(key, group != null ? group.displayStr : "", displayName, description, type, defVal, getValEditor, cloneValue, formatValue, markers);
            this.simKey = simKey != null ? simKey : key;
            this.group = group;
            this.geometric = geometric;
            this.getErrors = getErrors;
            this.depCallback = dependency != null ? dependency.apply(this) : null;
        }

        protected Object writeReplace() throws ObjectStreamException {
            return new OccProfile.SerializedProp(this.getKey());
        }

        @Override
        public Object getSimKey() {
            return this.simKey;
        }

        @Override
        public String toString() {
            return "[OccProfile.Prop:" + String.valueOf(this.key) + "]";
        }

        @Override
        public ProfT cloneValue(ProfT value) {
            return (ProfT)this.cloneValue.apply(value);
        }

        @Override
        public boolean testMarker(Object marker) {
            return this.markers.contains(marker);
        }

        @Override
        public Stream<?> streamMarkers() {
            return this.markers.stream();
        }

        @Override
        public void getValueErrors(MerlinData md, IMerlinObj owner, ProfT value, Consumer<? super SimError> errors) {
            if (this.getErrors != null) {
                this.getErrors.get(md, owner, value, errors);
            }
        }

        @Override
        public Stream<DepCallback<MerlinData, ICompElement, ProfT, ?>> streamDependencies() {
            return this.depCallback != null ? Stream.of(this.depCallback) : Stream.empty();
        }
    }
}

