/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.agents;

import inferno.geom.Inter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.OccGenerator;
import merlin.data.AMerlinObj;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.IOrientable;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.ObjsFilter;
import merlin.data.OccGroupObj;
import merlin.data.Proxy;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.agents.IAvatar;
import merlin.data.egress.agents.IProfileProp;
import merlin.data.egress.agents.IProfilePropDist;
import merlin.data.egress.agents.OccLocation;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.agents.ProfileProps;
import merlin.data.egress.agents.VehicleShape;
import merlin.data.egress.geom.EgressDoor;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.AssistOccupants;
import merlin.data.egress.scripting.Behavior;
import merlin.data.egress.scripting.WaitForAssistance;
import merlin.data.property.DisplayProp;
import merlin.data.property.DisplayProps;
import merlin.data.property.IDisplayProp;
import merlin.data.property.PropertyDefs;
import merlin.data.stat.DisabledCurve;
import merlin.geom.GeomUtil;
import merlin.geom.Geometry;
import merlin.geom.Inter2D;
import merlin.io.MerlinIO;
import merlin.io.MerlinOIS;
import merlin.util.Dependencies;
import merlin.util.MerlinUtil;
import org.jscience.physics.units.SI;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepCallback;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.CancelObjectPicking;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.scene3d.picking.PlanarConstraint;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.ICyclicSurrogate;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.Sets;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.UnorderedPair;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.ICurve;
import thunderheadeng.util.theUtil;

public class EgressAgent
extends AMerlinObj
implements Serializable,
IEgressObj,
IDirectDependent<MerlinData>,
ICyclicSurrogate,
IOrientable,
IEventObserver {
    static final long serialVersionUID = 1L;
    public static final UnitDouble AVG_SHOULDER_WIDTH = new UnitDouble(0.4558, SI.METER);
    public static final DisplayProp<String> NAME = NamedMerlinObj.NAME;
    public static final DisplayProp<OccLocation> LOC = ((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.build((Object)"Agent.LOC", OccLocation.class, new OccLocation(new Point3d()), Intl.intl("Location"), "").attrFormatValue(OccLocation::toString)).attrMarkScenarioSupported()).attrToProp();
    public static final DisplayProp<OccProfile> PARENT_PROFILE = OccProfile.PROP_PROF_PARENT;
    public static final DisplayProp<OccProfile> PROFILE = DisplayProps.build((Object)"Agent.Profile", OccProfile.class, null, Intl.intl("Profile"), "").attrToProp();
    public static final DisplayProp<Behavior> BEHAVIOR = ((DisplayProps.Builder)DisplayProps.build((Object)"Agent.Behavior", Behavior.class, null, Intl.intl("Behavior"), "").attrMarkScenarioSupported()).attrToProp();
    public static final TypedProp<OccGroupObj> MOVEMENT_GROUP = ((DisplayProps.Builder)DisplayProps.build((Object)"Agent.MovementGroup", OccGroupObj.class, null, Intl.intl("Movement Group"), "").attrFormatValue(group -> group == null ? Intl.intl("[none]") : group.getName())).attrToProp();
    public static final IPropertySet.Prop<Long> PROFILE_SEED = MerlinData.SEED;
    private static final Set<Object> PROP_TYPES = new LinkedHashSet<IPropertySet.Prop>(Arrays.asList(NAME, LOC, PROFILE, BEHAVIOR, MOVEMENT_GROUP, PROFILE_SEED));
    private static final PropertyDefs<EgressAgent> s_propTypes = new PropertyDefs<EgressAgent>(EgressAgent.class, (Collection<PropertyDefs<ICompElement>>)List.of(), OccProfile.streamProfileProps().map(prop -> new AgentProfProp((IProfileProp)prop)), OccProfile.streamProfileProps().map(prop -> {
        AgentOccProp<Object, Object, IProfileProp> agentOccProp;
        if (prop instanceof IProfilePropDist) {
            IProfilePropDist dprop = (IProfilePropDist)prop;
            agentOccProp = new AgentOccProp<Object, Object, IProfilePropDist>(dprop, (a, dval) -> dprop.toOccValue(a.getProfile(), dval, a.getProfileSeed(), a.getOrientSeed()), (a, sval) -> dprop.toProfileValue(sval));
        } else {
            agentOccProp = new AgentOccProp<Object, Object, IProfileProp>((IProfileProp)prop, (a, val) -> val, (a, val) -> val);
        }
        return agentOccProp;
    }), Stream.of(PARENT_PROFILE), PROP_TYPES.stream(), Stream.of(MerlinData.VISIBILITY, MerlinData.ENABLED));
    private static final Map<IProfileProp, AgentProfProp> s_propProfPropMap = s_propTypes.props().stream().filter(p -> p instanceof AgentProfProp).map(p -> (AgentProfProp)p).collect(Collectors.toMap(p -> p.baseProp, p -> p));
    private static final Map<IProfileProp, AgentOccProp> s_propOccPropMap = s_propTypes.props().stream().filter(p -> p instanceof AgentOccProp).map(p -> (AgentOccProp)p).collect(Collectors.toMap(p -> p.baseProp, p -> p));
    private String d_name;
    @SkipDep
    private OccProfile d_profile;
    private long d_profileSeed;
    private long d_orientSeed;
    private OccLocation d_location = new OccLocation(new Point3d());
    private Behavior d_behavior;
    private boolean d_visible = true;
    private boolean d_enabled = true;
    @Deprecated
    private Object d_exit = null;
    private static final double PI2 = Math.PI * 2;
    private static final DepCallback<MerlinData, EgressAgent, IEgressOccupiable, IEgressOccupiable> ROOM_CALLBACK;

    public static <ObjT extends ICompElement> void initAgentProps(PropertyDefs<ObjT> props) {
        OccProfile.streamProfileProps().map(profProp -> EgressAgent.asAgentProfProp(profProp)).filter(aprop -> props.contains(aprop)).forEach(aprop -> {
            if (OccProfile.ALL_PROPS.isWrapperProp(aprop.baseProp)) {
                props.markWrapperProps(aprop);
            }
            aprop.streamDependencies().forEach(dep -> props.registerDependency(aprop, dep));
        });
    }

    public EgressAgent(OccProfile prof, Behavior behavior) {
        this(prof, behavior, MerlinUtil.newSeed());
    }

    public EgressAgent(OccProfile prof, Behavior behavior, long profileSeed) {
        assert (prof.getProfParent() != null);
        this.d_profile = prof;
        this.d_behavior = behavior;
        this.d_profileSeed = profileSeed;
        this.d_orientSeed = profileSeed;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.d_enabled = true;
        in.defaultReadObject();
        if (this.d_profile == null) {
            this.d_profile = new OccProfile();
        }
        if (MerlinOIS.isPrior(in, MerlinIO.Version.VER_0004)) {
            this.d_profileSeed = MerlinUtil.newSeed();
        }
        if (MerlinOIS.isPrior(in, MerlinIO.Version.VER_0123)) {
            this.d_orientSeed = this.d_profileSeed;
        }
        if (MerlinOIS.isPrior(in, MerlinIO.Version.VER_0165)) {
            AgentValue socialDistVal = this.getStoredProfileVal(EgressAgent.asAgentProfProp(OccProfile.PROP_SOCIAL_DIST));
            if (socialDistVal.isLocal) {
                ICurve socialDist = (ICurve)socialDistVal.value;
                if (socialDist instanceof DisabledCurve || socialDist == OccProfile.PROP_SOCIAL_DIST.defVal) {
                    this.setLocalProfileVal(OccProfile.PROP_SOCIAL_DIST_FILTER, new ObjsFilter(ObjsFilter.Mode.NONE, false, Collections.emptySet()));
                    this.removeProfileValue(OccProfile.PROP_SOCIAL_DIST);
                } else {
                    this.setLocalProfileVal(OccProfile.PROP_SOCIAL_DIST_FILTER, new ObjsFilter(ObjsFilter.Mode.ALL, false, Collections.emptySet()));
                }
            }
        }
    }

    @Override
    public void writeTopology(ObjectOutputStream oos) throws IOException {
        this.d_location.writeTopology(oos);
    }

    @Override
    public void readTopology(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.d_location.readTopology(ois);
    }

    @Override
    public EgressAgent clone() {
        EgressAgent agent = (EgressAgent)super.clone();
        agent.d_profile = this.d_profile.clone();
        return agent;
    }

    public Predicate<IEgressOccupiable> getRoomFilter() {
        return EgressAgent.getRoomFilter(this.d_profile);
    }

    public static Predicate<IEgressOccupiable> getRoomFilter(OccProfile profile) {
        Predicate<IEgressOccupiable> filter = Filters.acceptAll(IEgressOccupiable.class);
        MerlinData md = (MerlinData)profile.getDomain();
        if (md == null) {
            return filter;
        }
        OccProfile.CompRestrictions compRestrictions = profile.getProperty(OccProfile.PROP_RESTRICTED_COMPONENTS);
        return Predicates.and(filter, o -> compRestrictions.isAccepted((IMerlinObj)o));
    }

    @Override
    public Object getRestoreObj() {
        return this.clone();
    }

    @Override
    public void restoreFrom(Object obj) {
        assert (obj instanceof EgressAgent);
        EgressAgent agent = (EgressAgent)obj;
        this.pauseUpdates();
        this.d_name = agent.d_name;
        this.setProfile(agent.d_profile);
        this.d_behavior = agent.d_behavior;
        this.d_profileSeed = agent.d_profileSeed;
        this.d_orientSeed = agent.d_orientSeed;
        this.d_visible = agent.d_visible;
        this.d_enabled = agent.d_enabled;
        this.setLocation(agent.d_location);
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
    }

    public boolean getAssistanceOffered() {
        return !this.getBehavior().flatten(AssistOccupants.class).isEmpty();
    }

    public boolean getAssistanceDesired() {
        VehicleShape shape = this.getProfile().getProperty(OccProfile.PROP_VEHICLE_SHAPE);
        if (shape == VehicleShape.NONE) {
            return false;
        }
        if (this.toOccValue(OccProfile.PROP_REQUIRES_ASSISTANCE).booleanValue()) {
            return true;
        }
        return !this.getBehavior().flatten(WaitForAssistance.class).isEmpty();
    }

    @Override
    public boolean updateTopo() {
        OccLocation loc;
        this.d_location = loc = ((MerlinData)this.getDomain()).findValidOccLocation(this.getProfile(), this.getProfileSeed(), this.d_location.point, this.getAngle().getValue(Geometry.ANGLE_UNIT), 0, Filters.accept(this));
        this.changedEvt(new Object[0]);
        return true;
    }

    @Override
    public boolean hasOpenSpots(Class<? extends IEgressObj> type) {
        return this.getRoom() == null;
    }

    private void markTopoDirty() {
        this.changedEvt(MerlinData.TOPOLOGY);
    }

    @Override
    public Class<? extends IEgressObj>[] getTopoTypes() {
        return new Class[]{IEgressOccupiable.class, EgressAgent.class};
    }

    @Override
    public Collection<? extends IEgressObj> getConnections() {
        ArrayList<IEgressObj> conns = new ArrayList<IEgressObj>(this.d_location.getOverlappingAgents().size() + 1);
        if (this.d_location.room != null) {
            conns.add(this.d_location.room);
        }
        conns.addAll(this.d_location.getOverlappingAgents());
        return conns;
    }

    @Override
    public void connectTo(IEgressObj obj) {
        if (obj instanceof EgressAgent && this.d_location.add((EgressAgent)obj)) {
            this.changedEvt(LOC, MerlinData.CONNECTION);
        }
    }

    @Override
    public void disconnectFrom(IEgressObj obj) {
        if (obj instanceof IEgressOccupiable) {
            if (this.d_location.room == obj) {
                this.d_location = new OccLocation(null, this.d_location.getOverlappingAgents(), this.d_location.overlapsWalls, this.d_location.failsFilter, this.d_location.point);
                this.changedEvt(LOC, MerlinData.CONNECTION);
            }
        } else if (obj instanceof EgressAgent && this.d_location.remove((EgressAgent)obj)) {
            this.changedEvt(LOC, MerlinData.CONNECTION);
        }
    }

    @Override
    protected void addToDomain(MerlinData domain, IMerlinObj parent) {
        super.addToDomain(domain, parent);
        domain.agentOverlapDetector.add(this);
        this.d_profile.setDomain(domain);
        domain.getEvents().addObserverInDomain((IEventObserver)this, OccProfile.class, false, false, OccProfile.PROP_SHAPE, OccProfile.PROP_VEHICLE_SHAPE, OccProfile.PROP_COLOR, OccProfile.PROP_OCCMODEL, OccProfile.PROP_ANIMS_IDLE, OccProfile.PROP_ANIMS_MOVING);
        domain.getEvents().addObserverInDomain((IEventObserver)this, VehicleShape.class, false, false, VehicleShape.PROP_HEIGHT, VehicleShape.PROP_MODEL, VehicleShape.PROP_POINTS, VehicleShape.PROP_OCCAVATAR_OFFSET, VehicleShape.PROP_PIVOT, VehicleShape.PROP_ANIM_TAGS);
        domain.getEvents().addObserverInDomain((IEventObserver)this, OccGroupObj.class, true, true, OccGroupObj.PROP_COLOR, OccGroupObj.PROP_TEMPLATE_COLOR);
    }

    @Override
    protected void removeFromDomain(MerlinData domain, IMerlinObj parent) {
        domain.getEvents().removeObserverInDomain(this);
        this.d_profile.setDomain(null);
        domain.agentOverlapDetector.remove(this);
        super.removeFromDomain(domain, parent);
    }

    @Override
    public void update(Events events) {
        BooleanSupplier test = () -> {
            if (events.isChanged(this.getProfile().getProfParent())) {
                return true;
            }
            Optional optVehicle = this.getNullableProp(EgressAgent.asAgentOccProp(OccProfile.PROP_VEHICLE_SHAPE));
            if (optVehicle.isPresent() && optVehicle.get().val != null && events.isChanged((VehicleShape)((AgentValue)optVehicle.get().val).value)) {
                return true;
            }
            OccGroupObj group = this.getMovementGroup();
            return group != null && (events.isChanged(group, OccGroupObj.PROP_COLOR) || events.isChanged(group, OccGroupObj.PROP_TEMPLATE_COLOR));
        };
        if (test.getAsBoolean()) {
            this.updateProps(new Object[0]);
        }
    }

    @Override
    public void notifyProxyAdded(Proxy<? extends ICompElement> proxy) {
        IEgressObj.super.notifyProxyAdded(proxy);
        this.updateProps(new Object[0]);
    }

    @Override
    public void notifyProxyRemoved(Proxy<? extends ICompElement> proxy) {
        IEgressObj.super.notifyProxyRemoved(proxy);
        this.updateProps(new Object[0]);
    }

    @Override
    public Point3d astarProject(IEgressObj obj, Point3d p) {
        return this.d_location.point;
    }

    @Override
    public Point3d astarGetSharedPt(IEgressObj adj) {
        return this.d_location.point;
    }

    private void markOverlapDirty() {
        if (this.getDomain() != null) {
            ((MerlinData)this.getDomain()).agentOverlapDetector.update(this);
        }
    }

    public boolean isEnabled() {
        return this.d_enabled;
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.d_enabled) {
            this.d_enabled = enabled;
            this.changedEvt(MerlinData.VISIBILITY, MerlinData.ENABLED, EventChannel.EVT_GENERAL);
        }
    }

    @Override
    public boolean isVisible() {
        return this.d_visible && this.d_enabled;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible != this.d_visible) {
            this.d_visible = visible;
            this.changedEvt(MerlinData.VISIBILITY);
        }
    }

    @Override
    public void setName(String name) {
        if (Objects.equals(name, this.d_name)) {
            return;
        }
        this.d_name = name;
        this.changedEvt(NAME);
    }

    @Override
    public String getName() {
        return this.d_name;
    }

    public static UnitDouble getShoulderWidth(OccProfile profile, long profileSeed) {
        return profile.toOccValue(OccProfile.PROP_DIAMETER, profileSeed, 0L);
    }

    public UnitDouble getShoulderWidth() {
        return this.toOccValue(OccProfile.PROP_DIAMETER);
    }

    public UnitDouble getMaxShoulderWidth() {
        ICurve diam = (ICurve)this.d_profile.getProperty(OccProfile.PROP_DIAMETER);
        return diam.getMax();
    }

    public UnitDouble getGeomShoulderWidth(boolean nullAllowed) {
        UnitDouble geomDiameter = this.getProfile().getProperty(OccProfile.PROP_GEOM_DIAMETER);
        if (geomDiameter == null) {
            return nullAllowed ? null : this.getShoulderWidth();
        }
        return geomDiameter;
    }

    public OccGroupObj getMovementGroup() {
        MerlinData md = (MerlinData)this.getDomain();
        if (md == null) {
            return null;
        }
        for (Proxy<? extends ICompElement> proxy : md.proxies.getProxies(this)) {
            Object parent = md.hierarchy.getParent(proxy);
            if (!(parent instanceof OccGroupObj)) continue;
            return (OccGroupObj)parent;
        }
        return null;
    }

    public UnitDouble getAngle() {
        return this.toOccValue(OccProfile.PROP_INIT_ORIENT);
    }

    public UnitDouble getMaxSpeed() {
        ICurve vel = (ICurve)this.d_profile.getProperty(OccProfile.PROP_MAXVEL);
        return vel.getMax();
    }

    public IAvatar getAvatar() {
        return this.d_profile.toOccValue(OccProfile.PROP_OCCMODEL, this.d_profileSeed, this.d_orientSeed);
    }

    public long getProfileSeed() {
        return this.d_profileSeed;
    }

    public void setProfileSeed(long seed) {
        if (this.d_profileSeed == seed) {
            return;
        }
        this.d_profileSeed = seed;
        this.updateProps(PROFILE_SEED);
    }

    public long getOrientSeed() {
        return this.d_orientSeed;
    }

    public void setOrientSeed(long seed) {
        if (this.d_orientSeed == seed) {
            return;
        }
        this.d_orientSeed = seed;
        this.updateProps(OccProfile.PROP_INIT_ORIENT);
    }

    public void setLocation(OccLocation loc) {
        if (this.d_location.equals(loc)) {
            return;
        }
        this.pauseUpdates();
        this.d_location = new OccLocation(this.d_location.room, this.d_location.getOverlappingAgents(), this.d_location.overlapsWalls, this.d_location.failsFilter, loc.point);
        this.markTopoDirty();
        this.markOverlapDirty();
        this.changedEvt(LOC);
        this.resumeUpdates();
    }

    public void setOrient(double angle) {
        UnitDouble newAngle;
        UnitDouble oldAngle = this.toOccValue(OccProfile.PROP_INIT_ORIENT);
        if (!EgressAgent.equalAngles(oldAngle, newAngle = new UnitDouble(angle, Geometry.ANGLE_UNIT), 1.0E-9)) {
            this.setLocalProfileVal(OccProfile.PROP_INIT_ORIENT, new ConstantCurve(newAngle));
        }
    }

    @Override
    public void setOrientTarget(Point3d target) {
        UnitDouble angle = GeomUtil.getOccOrient(this.getLocPoint(), target);
        this.setOrient(angle);
    }

    @Override
    public void setOrient(UnitDouble angle) {
        this.setOrient(angle.get(Geometry.ANGLE_UNIT));
    }

    @Override
    public boolean isValidOrient(UnitDouble angle) {
        MerlinData md = (MerlinData)this.getDomain();
        OccProfile.OccShape occShape = (OccProfile.OccShape)this.getProfile().getProperty(OccProfile.PROP_SHAPE);
        if (md == null || occShape.type.equals((Object)VehicleShape.ShapeType.CYLINDER)) {
            return true;
        }
        UnitDouble maxDiam = OccGenerator.getMaxDiam(Arrays.asList(this.getProfile()));
        OccLocation oloc = md.findValidOccLocation(occShape, this.getLocPoint(), maxDiam, maxDiam.getValue(Geometry.LENGTH_UNIT), angle.getValue(Geometry.ANGLE_UNIT), 0, Predicates.alwaysTrue(), Filters.accept(this));
        return oloc.room != null && !oloc.overlapsWalls && !oloc.failsFilter && !oloc.isOverlappingAgents();
    }

    private static double toCompareAngle(UnitDouble angle) {
        double arad = angle.get(SI.RADIAN);
        double div = arad / (Math.PI * 2);
        double frac = (div - Math.floor(div)) * (Math.PI * 2);
        return frac;
    }

    private static boolean equalAngles(UnitDouble a1, UnitDouble a2, double tol) {
        double a1r = EgressAgent.toCompareAngle(a1);
        double a2r = EgressAgent.toCompareAngle(a2);
        return theUtil.eq(a1r, a2r, tol);
    }

    public IEgressOccupiable getRoom() {
        return this.d_location.room;
    }

    public OccLocation getLocation() {
        return this.d_location;
    }

    public Point3d getLocPoint() {
        return this.d_location.point;
    }

    @Override
    public IGeomNode getGeom() {
        boolean checkAttachedPositions = true;
        AgentGeom geom = new AgentGeom((OccProfile.OccShape)this.getProfile().getProperty(OccProfile.PROP_SHAPE), this.d_location, this.getShoulderWidth().getValue(Geometry.LENGTH_UNIT) * 0.5, this.getAngle().getValue(Geometry.ANGLE_UNIT), this.getRoomFilter(), checkAttachedPositions);
        return GeomNodeUtil.newNode(geom);
    }

    @Override
    public void setGeom(IGeomNode node) {
        IGeom geom = node.flatten().getLocalGeom();
        if (geom instanceof AgentGeom) {
            AgentGeom ag = (AgentGeom)geom;
            this.setLocation(ag.location);
            this.setOrient(ag.angle);
        } else if (geom instanceof Point) {
            this.setLocation(new OccLocation(((Point)geom).loc));
        }
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        return DisplayGeom.EMPTY;
    }

    @Override
    public void getAll(Consumer<Object> result, IIsectFilter filter) {
    }

    @Override
    public void pickBox(IBoxCollector result, IIsectFilter filter, ConvexHull box, IDisplayProps dprops) {
    }

    @Override
    public void pickPoints(thunderheadeng.scene3d.picking.IIsectCollector isects, IIsectFilter filter, Point3d rayBegin, Vector3d rayDirN, double maxDist, ITest<AABox> tester, IDisplayProps dprops) {
    }

    public String toString() {
        return "name=" + this.d_name + " loc=" + String.valueOf(this.getLocPoint());
    }

    public OccProfile getProfile() {
        return this.d_profile;
    }

    public void setProfile(OccProfile profile) {
        this.d_profile = profile;
        this.d_profile.setDomain((MerlinData)this.getDomain());
        this.updateProps(new Object[0]);
    }

    public void setProfileParent(OccProfile parent) {
        this.pauseUpdates();
        this.d_profile.setProfParent(parent);
        this.updateProps(PARENT_PROFILE);
        this.resumeUpdates();
    }

    @Deprecated
    public Object getAndClearPre9ExitObj() {
        Object exit = this.d_exit;
        this.d_exit = null;
        return exit;
    }

    @Deprecated
    public Set<EgressDoor> getAndClearPre17Exits() {
        try {
            if (this.d_exit == null) {
                Set set = Collections.EMPTY_SET;
                return set;
            }
            if (this.d_exit instanceof EgressDoor) {
                IdentityHashSet<EgressDoor> identityHashSet = Sets.fromArrayIHS((EgressDoor)this.d_exit);
                return identityHashSet;
            }
            Set set = (Set)this.d_exit;
            return set;
        }
        finally {
            this.d_exit = null;
        }
    }

    public Behavior getBehavior() {
        return this.d_behavior;
    }

    public void setBehavior(Behavior behavior) {
        if (behavior == this.d_behavior) {
            return;
        }
        this.d_behavior = behavior;
        this.pauseUpdates();
        this.markOverlapDirty();
        this.markTopoDirty();
        this.changedEvt(BEHAVIOR);
        this.resumeUpdates();
    }

    public PropertyDefs<EgressAgent> getAllLocalProperties() {
        return s_propTypes;
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return s_propTypes.props();
    }

    @Override
    public Object getProperty(Object prop) {
        if (prop == MerlinData.VISIBILITY) {
            return this.isVisible();
        }
        if (prop == MerlinData.ENABLED) {
            return this.isEnabled();
        }
        if (prop == LOC) {
            return this.getLocation();
        }
        if (prop == NAME) {
            return this.d_name;
        }
        if (prop == PROFILE) {
            return this.d_profile;
        }
        if (prop == BEHAVIOR) {
            return this.getBehavior();
        }
        if (prop == MOVEMENT_GROUP) {
            return this.getMovementGroup();
        }
        if (prop == PROFILE_SEED) {
            return this.getProfileSeed();
        }
        if (prop == MerlinData.TAGS) {
            return this.getStoredProfileVal(OccProfile.PROP_TAGS).value();
        }
        if (prop == PARENT_PROFILE) {
            return this.getProfile().getProfParent();
        }
        if (prop instanceof AgentProfProp) {
            AgentProfProp aprop = (AgentProfProp)prop;
            return this.getStoredProfileVal(aprop);
        }
        if (prop instanceof AgentOccProp) {
            AgentOccProp rprop = (AgentOccProp)prop;
            return this.getOccProfileVal(rprop);
        }
        assert (!(prop instanceof IProfileProp)) : String.format("Instances of %s must not be retrieved directly from %s (prop = %s). Wrap the property using 'asAgentOccProp' instead.", IProfileProp.class.getSimpleName(), EgressAgent.class.getSimpleName(), ((IProfileProp)prop).getDisplayName());
        return NOT_SUPPORTED;
    }

    @Override
    public <T> void setProperty(Object prop, T value) {
        if (prop == MerlinData.VISIBILITY) {
            this.setVisible((Boolean)value);
        } else if (prop == MerlinData.ENABLED) {
            this.setEnabled((Boolean)value);
        } else if (prop == NAME) {
            this.setName((String)value);
        } else if (prop == PROFILE) {
            this.setProfile((OccProfile)value);
        } else if (prop == BEHAVIOR) {
            this.setBehavior((Behavior)value);
        } else if (prop == PROFILE_SEED) {
            this.setProfileSeed((Long)value);
        } else if (prop == LOC) {
            this.setLocation((OccLocation)value);
        } else if (prop == MerlinData.TAGS) {
            this.setProfileVal(EgressAgent.asAgentProfProp(OccProfile.PROP_TAGS), new AgentValue<Set>(true, (Set)value));
        } else if (prop == PARENT_PROFILE) {
            this.setProfileParent((OccProfile)value);
        } else if (prop instanceof AgentProfProp) {
            AgentProfProp aprop = (AgentProfProp)prop;
            this.setProfileVal(aprop, (AgentValue)value);
        } else if (prop instanceof AgentOccProp) {
            AgentOccProp rprop = (AgentOccProp)prop;
            this.setOccupantVal(rprop, (AgentValue)value);
        } else assert (false) : "Unsupported Operation: <EgressAgent>.setProperty(" + String.valueOf(prop) + ")";
    }

    public <OccT, ProfT, PropT extends IProfileProp<OccT, ProfT>> AgentValue<ProfT> getStoredProfileVal(PropT prop) {
        return this.getStoredProfileVal(EgressAgent.asAgentProfProp(prop));
    }

    public <OccT, ProfT, PropT extends IProfileProp<OccT, ProfT>> AgentValue<ProfT> getStoredProfileVal(AgentProfProp<OccT, ProfT, PropT> oprop) {
        boolean local = this.isDefinedLocally((IProfileProp<?, ?>)oprop.baseProp);
        Object baseVal = this.getProfile().getProperty(oprop.baseProp.asProp());
        return new AgentValue(local, baseVal);
    }

    public <OccT, ProfT> void setLocalProfileVal(IProfileProp<OccT, ProfT> oprop, ProfT value) {
        this.setProfileVal(EgressAgent.asAgentProfProp(oprop), new AgentValue<ProfT>(true, value));
    }

    public <OccT, ProfT, PropT extends IProfileProp<OccT, ProfT>> void setProfileVal(AgentProfProp<OccT, ProfT, PropT> oprop, AgentValue<ProfT> value) {
        if (!value.isLocal) {
            this.removeProfileValue((IProfileProp<?, ?>)oprop.baseProp);
            return;
        }
        try (IMerlinObj.EventPause pause = this.openPause();){
            if (this.getProfile().setProperty(oprop.baseProp.asProp(), value.value)) {
                this.propChanged((IProfileProp<?, ?>)oprop.baseProp);
            }
        }
    }

    public <OccT, ProfT, PropT extends IProfileProp<OccT, ProfT>> AgentValue<OccT> getOccProfileVal(AgentOccProp<OccT, ProfT, PropT> rprop) {
        boolean local = this.isDefinedLocally((IProfileProp<?, ?>)rprop.baseProp);
        OccT resolvedVal = this.toOccValue((IProfileProp<OccT, ProfT>)rprop.baseProp);
        return new AgentValue<OccT>(local, resolvedVal);
    }

    public <OccT, ProfT, PropT extends IProfileProp<OccT, ProfT>> void setOccupantVal(AgentOccProp<OccT, ProfT, PropT> rprop, AgentValue<OccT> occVal) {
        if (!occVal.isLocal) {
            this.removeProfileValue((IProfileProp<?, ?>)rprop.baseProp);
            return;
        }
        try (IMerlinObj.EventPause pause = this.openPause();){
            Object baseVal = rprop.toProf.apply(this, occVal.value);
            if (this.getProfile().setProperty(rprop.baseProp.asProp(), baseVal)) {
                this.propChanged((IProfileProp<?, ?>)rprop.baseProp);
            }
        }
    }

    public boolean isDefinedLocally(IProfileProp<?, ?> prop) {
        return this.getProfile().isDefinedLocally(prop.asProp());
    }

    public <OccT, ProfT> OccT toOccValue(IProfileProp<OccT, ProfT> oprop) {
        return this.getProfile().toOccValue(oprop, this.getProfileSeed(), this.getOrientSeed());
    }

    public void removeProfileValue(IProfileProp<?, ?> prop) {
        if (!this.isDefinedLocally(prop)) {
            return;
        }
        try (IMerlinObj.EventPause paused = this.openPause();){
            this.getProfile().remove(prop.asProp());
            this.propChanged(prop);
        }
    }

    protected void propChanged(IProfileProp<?, ?> prop) {
        try (IMerlinObj.EventPause paused = this.openPause();){
            if (prop instanceof ProfileProps.Prop) {
                ProfileProps.Prop pprop = (ProfileProps.Prop)prop;
                if (pprop.geometric) {
                    this.markTopoDirty();
                }
            }
            if (prop == OccProfile.PROP_DIAMETER || prop == OccProfile.PROP_SHAPE || prop == OccProfile.PROP_INIT_ORIENT) {
                this.markOverlapDirty();
            }
            this.changedEvt(prop, EgressAgent.asAgentOccProp(prop), EgressAgent.asAgentProfProp(prop), PROFILE);
        }
    }

    public void updateProps(Object ... propsChanged) {
        this.pauseUpdates();
        this.markTopoDirty();
        this.markOverlapDirty();
        this.changedEvt(propsChanged);
        this.changedEvt(PROFILE);
        this.resumeUpdates();
    }

    @Override
    public void takeDepSnapshot(DepList<MerlinData> deps) {
        deps.add(this, this.getRoom(), ROOM_CALLBACK);
        s_propTypes.takeDepSnapshot(this, deps);
    }

    @Override
    public boolean cyclicEquals(Object comparable, HashSet<UnorderedPair<Object, Object>> comparedSet) {
        if (comparable == this) {
            return true;
        }
        if (comparable == null || this.getClass() != comparable.getClass()) {
            return false;
        }
        EgressAgent comparableAgent = (EgressAgent)comparable;
        for (Object prop : PROP_TYPES) {
            if (theUtil.equal(this.getProperty(prop), comparableAgent.getProperty(prop), comparedSet)) continue;
            return false;
        }
        return true;
    }

    public static <OccT, ProfT, PropT extends IProfileProp<OccT, ProfT>> AgentProfProp<OccT, ProfT, PropT> asAgentProfProp(PropT prop) {
        AgentProfProp aprop = s_propProfPropMap.get(prop);
        assert (aprop != null);
        return aprop;
    }

    public static <OccT, ProfT, PropT extends IProfileProp<OccT, ProfT>> AgentOccProp<OccT, ProfT, PropT> asAgentOccProp(PropT prop) {
        AgentOccProp result = s_propOccPropMap.get(prop);
        assert (result != null);
        return result;
    }

    static {
        s_propTypes.add(MerlinData.TAGS, false);
        s_propTypes.markWrapperProps(LOC);
        s_propTypes.registerDependency(PARENT_PROFILE, Dependencies.newDependencyAsValue(PARENT_PROFILE, DLink.STRONG, OccProfile.class, Predicates.alwaysTrue()));
        s_propTypes.registerDependency(BEHAVIOR, Dependencies.newDependencyAsValue(BEHAVIOR, DLink.STRONG, Behavior.class, Predicates.alwaysTrue()));
        EgressAgent.initAgentProps(s_propTypes);
        ROOM_CALLBACK = Dependencies.newDependencyContainedBy(IEgressOccupiable.class);
    }

    public static class AgentProfProp<OccT, ProfT, PropT extends IProfileProp<OccT, ProfT>>
    extends TypedProp<AgentValue<ProfT>>
    implements IDisplayProp<AgentValue<ProfT>> {
        public final PropT baseProp;

        private AgentProfProp(PropT baseProp) {
            this(baseProp, baseProp.streamMarkers().collect(Collectors.toSet()));
        }

        private AgentProfProp(PropT baseProp, Set<Object> markers) {
            super(new AgentProfPropKey(baseProp.getKey()), AgentValue.class, markers);
            this.baseProp = baseProp;
        }

        @Override
        public String getGroupDisplayName() {
            return this.baseProp.getGroupDisplayName();
        }

        @Override
        public String getDisplayName() {
            return this.baseProp.getDisplayName();
        }

        @Override
        public String getDisplayDesc() {
            return this.baseProp.getDisplayDesc();
        }

        @Override
        public String formatValue(ICompElement src, AgentValue<ProfT> value) {
            return String.format(value.isLocal ? Intl.intl("[Customized] %s") : Intl.intl("[Inherited] %s"), this.baseProp.formatValue(src, value.value));
        }

        @Override
        public IDisplayProp.ValEditorSupplier<AgentValue<ProfT>> getValEditorSupplier() {
            return null;
        }

        @Override
        public AgentValue<ProfT> cloneValue(AgentValue<ProfT> value) {
            Object baseClone = this.baseProp.cloneValue(value.value);
            return baseClone == value.value ? value : new AgentValue(value.isLocal, baseClone);
        }

        @Override
        public IPropertySet.Prop<AgentValue<ProfT>> asProp() {
            return this;
        }

        public Stream<DepCallback<MerlinData, ICompElement, AgentValue<ProfT>, ?>> streamDependencies() {
            return this.baseProp.streamDependencies().map(dep -> AgentProfProp.toAgentPropDep(this, dep));
        }

        private static <OccT, ProfT, PropT extends IProfileProp<OccT, ProfT>, RefT> DepCallback<MerlinData, ICompElement, AgentValue<ProfT>, RefT> toAgentPropDep(AgentProfProp<OccT, ProfT, PropT> aprop, DepCallback<MerlinData, ICompElement, ProfT, RefT> dep) {
            return Dependencies.newDependency(aprop, dep.link(), dep.refType(), (md, src, aval) -> aval.isLocal ? dep.streamRefs().stream((MerlinData)md, (ICompElement)src, aval.value()) : Stream.empty(), dep.getReplFilter() != null ? (md, src) -> dep.getReplFilter().getReplacementFilter((MerlinData)md, (ICompElement)src) : null, dep.replDep() != null ? (md, src, val, old, repl) -> {
                if (val.value() == null) {
                    return val;
                }
                Object baseRepl = dep.replDep().replace((MerlinData)md, (ICompElement)src, val.value(), old, repl);
                if (baseRepl == val.value()) {
                    return val;
                }
                return new AgentValue(val.isLocal, baseRepl);
            } : null);
        }
    }

    public record AgentValue<T>(boolean isLocal, T value) implements Serializable
    {
    }

    protected static class AgentGeom
    implements IGeom,
    IManipulatable {
        private static final long serialVersionUID = -5824877637848085033L;
        private final OccLocation location;
        private final double radius;
        private final Predicate<IEgressOccupiable> roomFilter;
        private final OccProfile.OccShape shape;
        private final double angle;
        private final boolean includeAttachedPositions;

        public AgentGeom(OccProfile.OccShape shape, OccLocation loc, double radius, double angle, Predicate<IEgressOccupiable> roomFilter, boolean includesAttachedPositions) {
            this.shape = shape;
            this.location = loc;
            this.radius = radius;
            this.angle = angle;
            this.roomFilter = roomFilter;
            this.includeAttachedPositions = includesAttachedPositions;
        }

        @Override
        public IGeom optimize(IPointOptimizer pointOptimizer) {
            return this;
        }

        @Override
        public AABox getBoundingBox(AABox aabb) {
            Point3d loc = this.location.point;
            aabb.add(switch (this.shape.type) {
                case VehicleShape.ShapeType.POLYGON -> {
                    Point3d[] points = this.includeAttachedPositions ? this.shape.vehicleShape.getOuterPoints(loc, this.angle) : this.shape.vehicleShape.getBodyPoints(loc, this.angle);
                    yield new AABox(points);
                }
                default -> {
                    Point3d min = new Point3d(loc.x - this.radius, loc.y - this.radius, loc.z - this.radius);
                    Point3d max = new Point3d(loc.x + this.radius, loc.y + this.radius, loc.z + this.radius);
                    yield new AABox(min, max);
                }
            });
            return aabb;
        }

        @Override
        public IDOF getDOF() {
            return IDOF.INVERTIBLE;
        }

        @Override
        public IDOF getRetainingDOF() {
            return IDOF.INVERTIBLE;
        }

        @Override
        public IGeom transform(TransformInfo ti, int options) {
            if (ti.isIdentity()) {
                return this;
            }
            Matrix4d xform = ti.getMatrix();
            Point3d newLoc = Util3D.xform(xform, this.location.point);
            Vector3d ref = new Vector3d(1.0, 0.0, 0.0);
            Inter.rotateTuple2D(ref, this.angle, GeomConstants.VEC3D_ZPOS);
            xform.transform(ref);
            double newAngle = Util3D.angle0To2PI(GeomConstants.VEC3D_XPOS, new Vector3d(ref.x, ref.y, 0.0), GeomConstants.VEC3D_ZPOS);
            OccLocation loc = MerlinApp.getApp().getData().findValidOccLocation(this.shape, newLoc, new UnitDouble(this.radius * 2.0, Geometry.LENGTH_UNIT), newAngle, 0, this.roomFilter);
            return new AgentGeom(this.shape, loc, this.radius, newAngle, this.roomFilter, this.includeAttachedPositions);
        }

        @Override
        public boolean isAxisAlignedBlock(TransformInfo parentXform) {
            return false;
        }

        @Override
        public boolean isShell() {
            return false;
        }

        @Override
        public int getNumPrims(int types) {
            return 0;
        }

        @Override
        public Iterator<Byte> iteratePrimTypes(int offset) {
            return Collections.emptyIterator();
        }

        @Override
        public boolean canExplode() {
            return false;
        }

        @Override
        public Collection<IGeom> explode(Collection<IGeom> prims) {
            return prims;
        }

        @Override
        public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, IElemSource<Boolean> creases, Point3d rayBegin, Vector3d rayDirN, double maxDist, ITest<AABox> tester) {
        }

        @Override
        public void pickBox(Object source, IElemSource<Boolean> visFaceEdges, IIsectFilter filter, ConvexHull region, thunderheadeng.geometry.objs.IBoxCollector isects) throws CancelObjectPicking {
        }

        @Override
        public void find(ITest<AABox> test, IResult<? super IGeom.FoundPrimitive> result) {
        }

        @Override
        public void getAll(IResult<? super IPrimitive> result) {
        }

        @Override
        public void generateManipHandles(Consumer<? super IHandle> handles) {
            handles.accept(new LocHandle(this));
            handles.accept(new OrientHandle(this));
        }

        protected static class LocHandle
        implements IHandle {
            protected AgentGeom d_geom;

            public LocHandle(AgentGeom geom) {
                this.d_geom = geom;
            }

            public boolean equals(Object obj) {
                return obj == this || obj instanceof LocHandle;
            }

            @Override
            public IGeomNode getGeom() {
                return GeomNodeUtil.newNode(new Point(this.d_geom.location.point));
            }

            @Override
            public Pair<SnapMode, IIsectFilter> getPickFilter() {
                DefaultFilter filter = new DefaultFilter(this, IEgressOccupiable.class, GeomType.FACE){

                    @Override
                    public boolean acceptPickObject(Object obj) {
                        return super.acceptPickObject(obj) && ((IEgressOccupiable)obj).getOccupantsAllowed();
                    }
                };
                return new Pair<SnapMode, IIsectFilter>(SnapMode.FILTERED_TWO_PASS, filter);
            }

            @Override
            public ISnapConstraint getConstraint(Point3d handleLoc) {
                return null;
            }

            @Override
            public void begin(Point3d handleLoc, ISnapConstraint constraint) {
            }

            @Override
            public AgentGeom modify(IsectInfo constraintInfo, Point3d newLoc) throws ManipException {
                MerlinData md = MerlinApp.getApp().getData();
                OccLocation loc = md.findValidOccLocation(this.d_geom.shape, newLoc, new UnitDouble(this.d_geom.radius * 2.0, Geometry.LENGTH_UNIT), this.d_geom.angle, 0, this.d_geom.roomFilter);
                boolean blocked = GeomUtil.isPoint3dInPreventingBlockage(md, loc.point, 0);
                if (loc.room == null || loc.overlapsWalls || loc.failsFilter || blocked) {
                    throw new ManipException();
                }
                this.d_geom = new AgentGeom(this.d_geom.shape, loc, this.d_geom.radius, this.d_geom.angle, this.d_geom.roomFilter, this.d_geom.includeAttachedPositions);
                return this.d_geom;
            }

            @Override
            public AgentGeom end() {
                return this.d_geom;
            }
        }

        protected static class OrientHandle
        implements IHandle {
            private final double handleLength;
            private AgentGeom d_geom;

            public OrientHandle(AgentGeom geom) {
                double handleLength;
                this.d_geom = geom;
                if (geom.shape.type == VehicleShape.ShapeType.POLYGON && geom.shape.vehicleShape != null) {
                    Point3d[] shape = geom.shape.vehicleShape.getBodyPoints();
                    Point3d centroid = Util3D.simplePolygonCentroid(shape);
                    double minDistSq = Double.MAX_VALUE;
                    for (int m = 0; m < shape.length; ++m) {
                        Point3d p1 = shape[m];
                        Point3d p2 = shape[(m + 1) % shape.length];
                        double distsq = Inter3D.distSqToNearestPtOnLineSeg(p1, p2, centroid);
                        if (!(distsq < minDistSq)) continue;
                        minDistSq = distsq;
                    }
                    handleLength = minDistSq == Double.MAX_VALUE ? 1.0 : Math.sqrt(minDistSq);
                } else {
                    handleLength = geom.radius;
                }
                this.handleLength = Math.max(handleLength, 0.5);
            }

            public boolean equals(Object obj) {
                return obj == this || obj instanceof OrientHandle;
            }

            @Override
            public IGeomNode getGeom() {
                Vector3d orient = new Vector3d(1.0, 0.0, 0.0);
                Inter.rotateTuple2D(orient, this.d_geom.angle, new Point3d(0.0, 0.0, 0.0));
                orient.scale(this.handleLength);
                orient.add(this.d_geom.location.point);
                Point3d orientPoint = new Point3d(orient);
                return GeomNodeUtil.newNode(new LineSeg(this.d_geom.location.point, orientPoint));
            }

            @Override
            public void begin(Point3d handleLoc, ISnapConstraint constraint) {
            }

            @Override
            public AgentGeom modify(IsectInfo constraintInfo, Point3d newLoc) throws ManipException {
                Point3d agentLoc = this.d_geom.location.point;
                Point3d agentOrient = new Point3d(agentLoc);
                agentOrient.add(new Point3d(1.0, 0.0, 0.0));
                double newAngle = Inter2D.getAngle(agentLoc, agentOrient, newLoc);
                OccLocation loc = MerlinApp.getApp().getData().findValidOccLocation(this.d_geom.shape, this.d_geom.location.point, new UnitDouble(this.d_geom.radius * 2.0, Geometry.LENGTH_UNIT), newAngle, 0, this.d_geom.roomFilter);
                if (loc.room == null || loc.overlapsWalls || loc.failsFilter) {
                    throw new ManipException();
                }
                this.d_geom = new AgentGeom(this.d_geom.shape, loc, this.d_geom.radius, newAngle, this.d_geom.roomFilter, this.d_geom.includeAttachedPositions);
                return this.d_geom;
            }

            @Override
            public Object end() {
                return this.d_geom;
            }

            @Override
            public Pair<SnapMode, IIsectFilter> getPickFilter() {
                return new Pair<SnapMode, Object>(SnapMode.ANY, null);
            }

            @Override
            public ISnapConstraint getConstraint(Point3d handleLoc) {
                return new PlanarConstraint(new Plane3d(GeomConstants.VEC3D_ZPOS, this.d_geom.location.point));
            }
        }
    }

    public static class AgentOccProp<OccT, ProfT, PropT extends IProfileProp<OccT, ProfT>>
    extends TypedProp<AgentValue<OccT>> {
        public final PropT baseProp;
        public final BiFunction<? super EgressAgent, ProfT, OccT> fromProf;
        public final BiFunction<? super EgressAgent, OccT, ProfT> toProf;

        private AgentOccProp(PropT baseProp, BiFunction<? super EgressAgent, ProfT, OccT> fromProf, BiFunction<? super EgressAgent, OccT, ProfT> toProf) {
            super(new AgentOccPropKey(baseProp), AgentValue.class, Set.of());
            this.baseProp = baseProp;
            this.fromProf = fromProf;
            this.toProf = toProf;
        }
    }

    public record AgentOccPropKey<OccT, ProfT, PropT extends IProfileProp<OccT, ProfT>>(PropT prop) {
    }

    public record AgentProfPropKey<OccT, ProfT, PropT extends IProfileProp<OccT, ProfT>>(Object propKey) implements Serializable
    {
    }
}

