/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import merlin.Intl;
import merlin.data.Composite;
import merlin.data.GeomComposite;
import merlin.data.ICompElement;
import merlin.data.IRestorable;
import merlin.data.MerlinData;
import merlin.data.egress.FloorComposite;
import merlin.data.egress.IEgressObj;
import merlin.data.property.DisplayProp;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropertyDefs;
import merlin.io.MerlinIO;
import merlin.io.MerlinOIS;
import merlin.util.Dependencies;
import merlin.util.MerlinUtil;
import org.jscience.physics.units.BaseUnit;
import org.jscience.physics.units.SI;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepCallback;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;
import thunderheadeng.util.ICyclicSurrogate;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;
import thunderheadeng.util.UnorderedPair;

public class Floor
extends GeomComposite<ICompElement>
implements ICompElement,
IRestorable,
IDirectDependent<MerlinData>,
ICyclicSurrogate {
    static final long serialVersionUID = 1L;
    public static final TypedProp<GeomComposite<ICompElement>> WORKING_GROUP = TypedProps.newProp((Object)"Floor.WORKING_GROUP_CHANGED", GeomComposite.class, new Object[0]);
    public static final UnitDouble CURR_FLOOR = new UnitDouble(Double.NaN, SI.METER);
    public static final UnitDouble NEXT_FLOOR = new UnitDouble(Double.NaN, SI.METER);
    public static final DisplayProp<UnitDouble> WORKING_Z = DisplayProps.build((Object)"Floor.WORKING_Z", new UnitDouble(0.0, SI.METER), Intl.intl("Working Z"), "", 0).attrToProp();
    public static final DisplayProp<UnitDouble> ZMIN_FILTER = DisplayProps.build((Object)"Floor.ZMIN_FILTER", new UnitDouble(Double.NaN, SI.METER), Intl.intl("Z Min Filter"), "", 0).attrToProp();
    public static final DisplayProp ZMAX_FILTER = DisplayProps.build((Object)"Floor.ZMAX_FILTER", new UnitDouble(Double.NaN, SI.METER), Intl.intl("Z Max Filter"), "", 0).attrToProp();
    public static final PropertyDefs<Floor> PROP_TYPES = new PropertyDefs<Floor>(Floor.class, GeomComposite.PROP_TYPES, MerlinData.VISIBILITY, WORKING_Z, ZMIN_FILTER, ZMAX_FILTER);
    private UnitDouble d_defWorkingZ;
    private UnitDouble d_zminFilter;
    private UnitDouble d_zmaxFilter;
    @SkipDep
    private GeomComposite<ICompElement> d_workingNavGroup;
    private static final DepCallback<MerlinData, Floor, GeomComposite<ICompElement>, GeomComposite<ICompElement>> WORKING_GROUP_CALLBACK = Dependencies.newDependencyGeneric(WORKING_GROUP, DLink.WEAK, GeomComposite.class, null, (md, src, group) -> Stream.of(group), null, (md, src, val, old, repl) -> {
        if (repl == null) {
            return null;
        }
        return repl;
    });

    public Floor(UnitDouble defWorkingZ) {
        this(null, defWorkingZ);
    }

    public Floor(String name, UnitDouble defWorkingZ) {
        super(name);
        this.d_defWorkingZ = defWorkingZ;
        this.d_workingNavGroup = this;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        block2: {
            block3: {
                in.defaultReadObject();
                if (!(in instanceof MerlinOIS)) break block2;
                if (!MerlinOIS.isBetween(in, MerlinIO.Version.VER_0009, MerlinIO.Version.VER_0012)) break block3;
                for (IEgressObj obj : this.d_workingNavGroup.getDeepMembers(IEgressObj.class)) {
                    obj.readTopology(in);
                }
                break block2;
            }
            if (!MerlinOIS.isSameOrLater(in, MerlinIO.Version.VER_0012)) break block2;
            for (IEgressObj obj : this.getDeepMembers(IEgressObj.class)) {
                obj.readTopology(in);
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        for (IEgressObj obj : this.getDeepMembers(IEgressObj.class)) {
            obj.writeTopology(out);
        }
    }

    @Override
    public String getName() {
        String name = super.getName();
        if (name == null) {
            MerlinData md = (MerlinData)this.getDomain();
            BaseUnit lu = md != null ? md.getUnitSystem().getLength() : SI.METER;
            name = String.format(Intl.intl("Floor %s"), Global.format(this.d_defWorkingZ.convert(lu)));
        }
        return name;
    }

    public String getBaseName() {
        return super.getName();
    }

    @Override
    public boolean cyclicEquals(Object comparable, HashSet<UnorderedPair<Object, Object>> comparedSet) {
        if (comparable == this) {
            return true;
        }
        if (comparable == null || !comparable.getClass().equals(this.getClass())) {
            return false;
        }
        Floor other = (Floor)comparable;
        return Objects.equals(this.getSetName(), other.getSetName()) && Objects.equals(this.d_defWorkingZ, other.d_defWorkingZ) && Objects.equals(this.d_zminFilter, other.d_zminFilter) && Objects.equals(this.d_zmaxFilter, other.d_zmaxFilter);
    }

    public void setWorkingGeomGroup(GeomComposite<ICompElement> group) {
        if (group == null) {
            group = this;
        }
        if (this.d_workingNavGroup == group) {
            return;
        }
        this.pauseUpdates();
        if (this.d_workingNavGroup != null) {
            this.d_workingNavGroup.changedEvt(WORKING_GROUP);
        }
        this.d_workingNavGroup = group;
        this.changedEvt(WORKING_GROUP);
        if (this.d_workingNavGroup != null) {
            this.d_workingNavGroup.changedEvt(WORKING_GROUP);
        }
        this.resumeUpdates();
    }

    public GeomComposite<ICompElement> getWorkingGeomGroup() {
        return this.d_workingNavGroup;
    }

    public UnitDouble getWorkingZ() {
        return this.d_defWorkingZ;
    }

    public void setWorkingZ(UnitDouble workingZ) {
        this.d_defWorkingZ = workingZ;
        this.invalidateClippingRegion();
        this.changedEvt(new Object[0]);
    }

    public UnitDouble[] getZFilter() {
        UnitDouble min = this.d_zminFilter == null ? CURR_FLOOR : this.d_zminFilter;
        UnitDouble max = this.d_zmaxFilter == null ? NEXT_FLOOR : this.d_zmaxFilter;
        return new UnitDouble[]{min, max};
    }

    public void setZFilter(UnitDouble zMin, UnitDouble zMax) {
        this.d_zminFilter = zMin == CURR_FLOOR ? null : zMin;
        this.d_zmaxFilter = zMax == NEXT_FLOOR ? null : zMax;
        this.invalidateClippingRegion();
        this.changedEvt(new Object[0]);
    }

    private void invalidateClippingRegion() {
        if (this.getDomain() != null) {
            ((MerlinData)this.getDomain()).floors.invalidateClippingRegions();
        }
    }

    @Override
    public void restoreFrom(Object nn) {
        this.pauseUpdates();
        super.restoreFrom(nn);
        Floor floor = (Floor)nn;
        this.setWorkingGeomGroup(floor.getWorkingGeomGroup());
        this.setWorkingZ(floor.d_defWorkingZ);
        UnitDouble[] filter = floor.getZFilter();
        this.setZFilter(filter[0], filter[1]);
        this.resumeUpdates();
    }

    @Override
    public PropertyDefs<Floor> getAllLocalProperties() {
        return PROP_TYPES;
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        if (MerlinUtil.test(options, 1)) {
            return PROP_TYPES.props();
        }
        return super.getPropTypes(options);
    }

    @Override
    public Object getProperty(Object property) {
        if (property == WORKING_Z) {
            return this.getWorkingZ();
        }
        if (property == ZMIN_FILTER) {
            return this.getZFilter()[0];
        }
        if (property == ZMAX_FILTER) {
            return this.getZFilter()[1];
        }
        if (property == WORKING_GROUP) {
            return this.getWorkingGeomGroup();
        }
        return super.getProperty(property);
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property == WORKING_Z) {
            this.setWorkingZ((UnitDouble)value);
        } else if (property == ZMIN_FILTER) {
            this.setZFilter((UnitDouble)value, this.getZFilter()[1]);
        } else if (property == ZMAX_FILTER) {
            this.setZFilter(this.getZFilter()[0], (UnitDouble)value);
        } else if (property == WORKING_GROUP) {
            this.setWorkingGeomGroup((GeomComposite)value);
        } else {
            super.setProperty(property, value);
        }
    }

    public void repairBrokenFloors(FloorComposite topFloorNode) {
        ArrayDeque<Floor> brokenFloors = new ArrayDeque<Floor>(this.getDeepMembers(Floor.class));
        for (Floor f : brokenFloors) {
            System.out.println("Moving floor to Floors node: " + f.toString());
            Composite<Floor> parent = Composite.findParent(this, f);
            if (parent != null) {
                parent.remove(f);
                topFloorNode.add(f);
                continue;
            }
            throw new RuntimeException("Unable to repair floor grouping error.");
        }
    }

    @Override
    public String toString() {
        return String.format("Floor[name=\"%s\", z=%s]", this.getName(), this.d_defWorkingZ.toString());
    }

    @Override
    public void takeDepSnapshot(DepList<MerlinData> deps) {
        if (this.d_workingNavGroup != this) {
            deps.add(this, this.d_workingNavGroup, WORKING_GROUP_CALLBACK);
        }
    }
}

