/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.animation;

import java.util.Objects;
import merlin.Intl;
import merlin.data.animation.AAnimationClip;
import merlin.data.property.DisplayProp;
import merlin.data.property.DisplayProps;
import org.jscience.physics.units.SI;
import thunderheadeng.units.UnitDouble;

public class PivotAnimationClip
extends AAnimationClip {
    private static final long serialVersionUID = 1L;
    public static final DisplayProp<UnitDouble> NATURAL_SPEED = DisplayProps.build((Object)-1262855578, UnitDouble.class, new UnitDouble(0.0, SI.RADIAN.divide(SI.SECOND)), Intl.intl("Natural Speed"), Intl.intl("The natural turning speed of this animation.\nWhen the occupant is turning at this speed, the animation will be played back at 1x speed.\nIf the occupant is turning at twice this speed, the animation will be played back at 2x speed, etc.")).attrToProp();
    public static final DisplayProp<UnitDouble> TOP_SPEED = DisplayProps.build((Object)-325372069, UnitDouble.class, new UnitDouble(Double.POSITIVE_INFINITY, SI.RADIAN.divide(SI.SECOND)), Intl.intl("Top Speed"), Intl.intl("The maximum movement speed at which this clip will be used.")).attrToProp();
    private UnitDouble d_naturalSpeed = new UnitDouble(0.0, SI.RADIAN.divide(SI.SECOND));
    private UnitDouble d_topSpeed = new UnitDouble(0.0, SI.RADIAN.divide(SI.SECOND));

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        PivotAnimationClip clip = (PivotAnimationClip)obj;
        return super.equals(clip) && Objects.equals(this.d_naturalSpeed, clip.d_naturalSpeed) && Objects.equals(this.d_topSpeed, clip.d_topSpeed);
    }

    @Override
    public PivotAnimationClip clone() {
        PivotAnimationClip clone = (PivotAnimationClip)super.clone();
        clone.d_naturalSpeed = NATURAL_SPEED.cloneValue(this.d_naturalSpeed);
        clone.d_topSpeed = TOP_SPEED.cloneValue(this.d_topSpeed);
        return clone;
    }

    public UnitDouble getNaturalSpeed() {
        return this.d_naturalSpeed;
    }

    public void setNaturalSpeed(UnitDouble speed) {
        this.d_naturalSpeed = speed;
    }

    public UnitDouble getTopSpeed() {
        return this.d_topSpeed;
    }

    public void setTopSpeed(UnitDouble speed) {
        this.d_topSpeed = speed;
    }
}

