/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.animation;

import java.util.Objects;
import merlin.Intl;
import merlin.data.animation.AAnimationClip;
import merlin.data.property.DisplayProp;
import merlin.data.property.DisplayProps;
import org.jscience.physics.units.SI;
import thunderheadeng.units.UnitDouble;

public class MoveAnimationClip
extends AAnimationClip {
    private static final long serialVersionUID = 1L;
    public static final DisplayProp<UnitDouble> NATURAL_SPEED = DisplayProps.build((Object)-1880550362, UnitDouble.class, new UnitDouble(Double.POSITIVE_INFINITY, SI.METER.divide(SI.SECOND)), Intl.intl("Natural Speed"), Intl.intl("The natural movement speed of this animation.\nWhen the occupant is moving at this speed, the animation will be played back at 1x speed.\nIf the occupant is moving at twice this speed, the animation will be played back at 2x speed, etc.")).attrToProp();
    public static final DisplayProp<UnitDouble> TOP_SPEED = DisplayProps.build((Object)-1112093708, UnitDouble.class, new UnitDouble(0.0, SI.METER.divide(SI.SECOND)), Intl.intl("Top Speed"), Intl.intl("The maximum movement speed at which this animation will be used.")).attrToProp();
    private UnitDouble d_naturalSpeed = new UnitDouble(0.0, SI.METER.divide(SI.SECOND));
    private UnitDouble d_topSpeed = new UnitDouble(0.0, SI.METER.divide(SI.SECOND));

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        MoveAnimationClip clip = (MoveAnimationClip)obj;
        return super.equals(clip) && Objects.equals(this.d_naturalSpeed, clip.d_naturalSpeed) && Objects.equals(this.d_topSpeed, clip.d_topSpeed);
    }

    @Override
    public MoveAnimationClip clone() {
        MoveAnimationClip clone = (MoveAnimationClip)super.clone();
        clone.d_naturalSpeed = NATURAL_SPEED.cloneValue(this.d_naturalSpeed);
        clone.d_topSpeed = TOP_SPEED.cloneValue(this.d_topSpeed);
        return clone;
    }

    public UnitDouble getNaturalSpeed() {
        return this.d_naturalSpeed;
    }

    public void setNaturalSpeed(UnitDouble speed) {
        this.d_naturalSpeed = speed;
    }

    public UnitDouble getTopSpeed() {
        return this.d_topSpeed;
    }

    public void setTopSpeed(UnitDouble speed) {
        this.d_topSpeed = speed;
    }
}

