/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.animation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import merlin.Intl;
import merlin.data.ICompElement;
import merlin.data.IRestorable;
import merlin.data.NamedMerlinObj;
import merlin.data.animation.AAnimationClip;
import merlin.data.animation.AnimDirection;
import merlin.data.animation.AnimType;
import merlin.data.animation.IdleAnimationClip;
import merlin.data.animation.MoveAnimationClip;
import merlin.data.animation.PivotAnimationClip;
import merlin.data.property.DisplayProp;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropertyDefs;
import merlin.util.StringTagsUtil;
import org.json.simple.JSONObject;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.ISurrogate;
import thunderheadeng.util.theUtil;

public class Animation
extends NamedMerlinObj
implements ICompElement,
IRestorable,
ISurrogate {
    private static final long serialVersionUID = 1L;
    public static final DisplayProp<AnimType> TYPE = ((DisplayProps.Builder)DisplayProps.build((Object)-1969745471, AnimType.class, AnimType.IDLE, Intl.intl("Type"), Intl.intl("Defines whether this animation will play while idling or moving.")).attrFormatValue(v -> v.displayName)).attrToProp();
    public static final DisplayProp<Set<String>> TAGS = ((DisplayProps.Builder)DisplayProps.buildGeneric(634846507, Set.class, theUtil.emptySet(String.class), Intl.intl("Tags"), Intl.intl("Identifies the animation. These tags are matched against those in an occupant's profile\nto determine which animation to play.")).attrFormatValue(v -> StringTagsUtil.format(v))).attrToProp();
    public static final DisplayProp<IdleAnimationClip> IDLE_CLIP = ((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.build((Object)136676565, IdleAnimationClip.class, new IdleAnimationClip(), Intl.intl("Clip"), "").attrCloneValue(v -> v.clone())).attrFormatValue((obj, v) -> AAnimationClip.FILE.formatValue(obj, v.getPath()))).attrToProp();
    public static final DisplayProp<List<MoveAnimationClip>> MOVE_CLIPS = ((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.buildGeneric(-601540412, List.class, theUtil.emptyList(MoveAnimationClip.class), Intl.intl("Clips"), Intl.intl("Animation clips to pick between depending on the occupant's movement speed.")).attrCloneValue(v -> v.stream().map(MoveAnimationClip::clone).collect(Collectors.toList()))).attrFormatValue((obj, v) -> v.stream().map(c -> AAnimationClip.FILE.formatValue(obj, c.getPath())).collect(Collectors.joining(",")))).attrToProp();
    public static final DisplayProp<List<PivotAnimationClip>> PIVOT_CLIPS = ((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.buildGeneric(1021934925, List.class, theUtil.emptyList(PivotAnimationClip.class), Intl.intl("Clips"), Intl.intl("Animation clips to pick between depending on the occupant's turning speed.")).attrCloneValue(v -> v.stream().map(PivotAnimationClip::clone).collect(Collectors.toList()))).attrFormatValue((obj, v) -> v.stream().map(c -> AAnimationClip.FILE.formatValue(obj, c.getPath())).collect(Collectors.joining(",")))).attrToProp();
    public static final DisplayProp<Set<AnimDirection>> DIRECTION = ((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.buildGeneric(1913319301, Set.class, theUtil.emptySet(AnimDirection.class), Intl.intl("Direction"), Intl.intl("The direction an occupant must be moving to use this animation.")).attrCloneValue(v -> new LinkedHashSet(v))).attrFormatValue(v -> v.stream().map(d -> d.displayName).collect(Collectors.joining(",")))).attrToProp();
    private UUID d_uuid = UUID.randomUUID();
    private AnimType d_animType = AnimType.IDLE;
    private Set<String> d_tags = Collections.emptySet();
    private IdleAnimationClip d_idleClip = new IdleAnimationClip();
    private List<MoveAnimationClip> d_moveClips = new ArrayList<MoveAnimationClip>();
    private List<PivotAnimationClip> d_pivotClips = new ArrayList<PivotAnimationClip>();
    private Set<AnimDirection> d_directions = Collections.emptySet();
    private JSONObject d_extraFileProps = new JSONObject();
    private JSONObject d_extraAnimProps = new JSONObject();
    public static final PropertyDefs<Animation> PROPS = new PropertyDefs<Animation>(Animation.class, List.of(), IPropertySet.getAllDeclaredPublicStaticProps(Animation.class), NamedMerlinObj.NAME);

    public UUID getUuid() {
        return this.d_uuid;
    }

    public void setUuid(UUID uuid) {
        this.d_uuid = uuid;
    }

    public AnimType getType() {
        return this.d_animType;
    }

    public void setType(AnimType type) {
        if (this.d_animType != type) {
            this.pauseUpdates();
            this.d_animType = type;
            switch (type) {
                case IDLE: {
                    this.setDirections(Collections.emptySet());
                    this.setMoveClips(Collections.emptyList());
                    this.setPivotClips(Collections.emptyList());
                    break;
                }
                case MOVE: {
                    this.setPivotClips(Collections.emptyList());
                    break;
                }
                case PIVOT: {
                    this.setMoveClips(Collections.emptyList());
                }
            }
            this.changedEvt(TYPE);
            this.resumeUpdates();
        }
    }

    public Set<String> getTags() {
        return Collections.unmodifiableSet(this.d_tags);
    }

    public void setTags(Set<String> tags) {
        if (!this.d_tags.equals(tags)) {
            this.pauseUpdates();
            this.d_tags = tags;
            this.changedEvt(TAGS);
            this.resumeUpdates();
        }
    }

    public IdleAnimationClip getIdleClip() {
        return this.d_idleClip;
    }

    public void setIdleClip(IdleAnimationClip clip) {
        if (!this.d_idleClip.equals(clip)) {
            this.d_idleClip = clip;
            this.changedEvt(IDLE_CLIP);
        }
    }

    public List<MoveAnimationClip> getMoveClips() {
        return Collections.unmodifiableList(this.d_moveClips);
    }

    public void setMoveClips(List<MoveAnimationClip> clips) {
        if (!this.d_moveClips.equals(clips)) {
            this.d_moveClips = clips;
            this.changedEvt(MOVE_CLIPS);
        }
    }

    public List<PivotAnimationClip> getPivotClips() {
        return Collections.unmodifiableList(this.d_pivotClips);
    }

    public void setPivotClips(List<PivotAnimationClip> clips) {
        if (!this.d_pivotClips.equals(clips)) {
            this.d_pivotClips = clips;
            this.changedEvt(PIVOT_CLIPS);
        }
    }

    public JSONObject getExtraAnimProps() {
        return this.d_extraAnimProps;
    }

    public void setExtraAnimProps(JSONObject props) {
        this.d_extraAnimProps = props;
    }

    public JSONObject getExtraFileProps() {
        return this.d_extraFileProps;
    }

    public void setExtraFileProps(JSONObject props) {
        this.d_extraFileProps = props;
    }

    public Set<AnimDirection> getDirections() {
        return Collections.unmodifiableSet(this.d_directions);
    }

    public void setDirections(Set<AnimDirection> directions) {
        if (!this.d_directions.equals(directions)) {
            this.pauseUpdates();
            this.d_directions = directions;
            this.changedEvt(DIRECTION);
            this.resumeUpdates();
        }
    }

    public List<AAnimationClip> getClips() {
        switch (this.getType()) {
            case IDLE: {
                return Collections.singletonList(this.getIdleClip());
            }
            case MOVE: {
                return Collections.unmodifiableList(this.getMoveClips());
            }
            case PIVOT: {
                return Collections.unmodifiableList(this.getPivotClips());
            }
        }
        return Collections.emptyList();
    }

    @Override
    public Animation clone() {
        Animation clone = (Animation)super.clone();
        clone.setName(this.getName());
        clone.d_animType = TYPE.cloneValue(this.d_animType);
        clone.d_tags = TAGS.cloneValue(this.d_tags);
        clone.d_idleClip = IDLE_CLIP.cloneValue(this.d_idleClip);
        clone.d_moveClips = MOVE_CLIPS.cloneValue(this.d_moveClips);
        clone.d_pivotClips = PIVOT_CLIPS.cloneValue(this.d_pivotClips);
        clone.d_directions = DIRECTION.cloneValue(this.d_directions);
        clone.d_extraFileProps = this.d_extraFileProps;
        clone.d_extraAnimProps = this.d_extraAnimProps;
        return clone;
    }

    public void generateUuids() {
        this.pauseUpdates();
        this.setUuid(UUID.randomUUID());
        this.d_idleClip.setUuid(UUID.randomUUID());
        this.d_moveClips.forEach(c -> c.setUuid(UUID.randomUUID()));
        this.d_pivotClips.forEach(c -> c.setUuid(UUID.randomUUID()));
        this.resumeUpdates();
    }

    @Override
    public Object getRestoreObj() {
        return this.clone();
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof Animation)) {
            return;
        }
        Animation anim = (Animation)obj;
        this.pauseUpdates();
        this.setName(anim.getName());
        this.d_uuid = anim.d_uuid;
        this.d_animType = anim.d_animType;
        this.d_tags = anim.d_tags;
        this.d_idleClip = anim.d_idleClip;
        this.d_moveClips = anim.d_moveClips;
        this.d_pivotClips = anim.d_pivotClips;
        this.d_directions = anim.d_directions;
        this.d_extraFileProps = anim.d_extraFileProps;
        this.d_extraAnimProps = anim.d_extraAnimProps;
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property == NamedMerlinObj.NAME) {
            this.setName((String)value);
        } else if (property == TYPE) {
            this.setType((AnimType)((Object)value));
        } else if (property == TAGS) {
            this.setTags((Set)value);
        } else if (property == IDLE_CLIP) {
            this.setIdleClip((IdleAnimationClip)value);
        } else if (property == MOVE_CLIPS) {
            this.setMoveClips((List)value);
        } else if (property == PIVOT_CLIPS) {
            this.setPivotClips((List)value);
        } else if (property == DIRECTION) {
            this.setDirections((Set)value);
        }
    }

    @Override
    public Object getProperty(Object property) {
        if (property == NamedMerlinObj.NAME) {
            return this.getName();
        }
        if (property == TYPE) {
            return this.getType();
        }
        if (property == TAGS) {
            return this.getTags();
        }
        if (property == IDLE_CLIP) {
            return this.getIdleClip();
        }
        if (property == MOVE_CLIPS) {
            return this.getMoveClips();
        }
        if (property == PIVOT_CLIPS) {
            return this.getPivotClips();
        }
        if (property == DIRECTION) {
            return this.getDirections();
        }
        return NOT_SUPPORTED;
    }

    public PropertyDefs<Animation> getAllLocalProperties() {
        return PROPS;
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROPS.props();
    }

    @Override
    public boolean surrogateEquals(Object comparable) {
        if (comparable == this) {
            return true;
        }
        if (comparable == null || !comparable.getClass().equals(this.getClass())) {
            return false;
        }
        Animation anim = (Animation)comparable;
        return this.d_animType == anim.d_animType && Objects.equals(this.d_tags, anim.d_tags) && Objects.equals(this.d_idleClip, anim.d_idleClip) && Objects.equals(this.d_moveClips, anim.d_moveClips) && Objects.equals(this.d_pivotClips, anim.d_pivotClips) && Objects.equals(this.d_directions, anim.d_directions) && Objects.equals(this.d_extraFileProps, anim.d_extraFileProps) && Objects.equals(this.d_extraAnimProps, anim.d_extraAnimProps);
    }
}

