/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.animation;

import java.io.Serializable;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.UUID;
import merlin.Intl;
import merlin.data.animation.AnimRetargetMode;
import merlin.data.animation.AnimationTransform;
import merlin.data.property.DisplayProp;
import merlin.data.property.DisplayProps;
import merlin.gui.guiUtil;
import org.jscience.physics.units.Unit;
import org.json.simple.JSONObject;
import thunderheadeng.units.UnitDouble;

public abstract class AAnimationClip
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final DisplayProp<String> FILE = ((DisplayProps.Builder)DisplayProps.build((Object)1987994580, "", Intl.intl("Clip"), Intl.intl("The animation file that will be played.")).attrFormatValue(v -> Paths.get(v, new String[0]).getFileName().toString())).attrToProp();
    public static final DisplayProp<UnitDouble> FRAME_OFFSET = DisplayProps.build((Object)355421375, UnitDouble.class, new UnitDouble(0.0, Unit.ONE), Intl.intl("Start Frame"), Intl.intl("Remaps the specified frame as the first frame of the animation.\nFor walking animations, this should be the frame at which the\navatar's legs are together and the left leg is about to step forward.")).attrToProp();
    public static final DisplayProp<AnimationTransform> TRANSFORM = ((DisplayProps.Builder)DisplayProps.build((Object)75572467, AnimationTransform.class, new AnimationTransform(), Intl.intl("Transform"), Intl.intl("Transformation applied to this animation during playback.")).attrCloneValue(v -> new AnimationTransform((AnimationTransform)v))).attrToProp();
    public static final DisplayProp<AnimRetargetMode> RETARGET_MODE = ((DisplayProps.Builder)DisplayProps.build((Object)1097401916, AnimRetargetMode.class, AnimRetargetMode.SELF, Intl.intl("Retarget Mode"), Intl.intl("Defines how this animation will be retargeted to avatars.")).attrFormatValue(v -> v.displayName)).attrToProp();
    public static final DisplayProp<String> RETARGET_SOURCE = ((DisplayProps.Builder)DisplayProps.build((Object)-1377799430, "", Intl.intl("Base Pose"), guiUtil.encodeToHtmlLabel(Intl.intl("Defines the file containing either a T-pose or A-pose for the animation's avatar.\nUsually, this is a file containing the avatar itself. Some animation files may contain\nboth the animation and the base pose."))).attrFormatValue(v -> Paths.get(v, new String[0]).getFileName().toString())).attrToProp();
    private UUID d_uuid = UUID.randomUUID();
    private String d_path = "";
    private UnitDouble d_frameOffset = new UnitDouble(0.0, Unit.ONE);
    private AnimationTransform d_transform = new AnimationTransform();
    private AnimRetargetMode d_retargetMode = AnimRetargetMode.SELF;
    private String d_retargetSource = "";
    private JSONObject d_extraProps = new JSONObject();

    protected AAnimationClip() {
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        AAnimationClip clip = (AAnimationClip)obj;
        return this.d_uuid.equals(clip.d_uuid) && Objects.equals(this.d_path, clip.d_path) && Objects.equals(this.d_frameOffset, clip.d_frameOffset) && Objects.equals(this.d_transform, clip.d_transform) && Objects.equals((Object)this.d_retargetMode, (Object)clip.d_retargetMode) && Objects.equals(this.d_retargetSource, clip.d_retargetSource);
    }

    public AAnimationClip clone() {
        try {
            AAnimationClip clone = (AAnimationClip)super.clone();
            clone.d_path = FILE.cloneValue(this.d_path);
            clone.d_frameOffset = FRAME_OFFSET.cloneValue(this.d_frameOffset);
            clone.d_transform = TRANSFORM.cloneValue(this.d_transform);
            clone.d_retargetMode = RETARGET_MODE.cloneValue(this.d_retargetMode);
            clone.d_retargetSource = RETARGET_SOURCE.cloneValue(this.d_retargetSource);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            assert (false);
            return null;
        }
    }

    public UUID getUuid() {
        return this.d_uuid;
    }

    public void setUuid(UUID uuid) {
        this.d_uuid = uuid;
    }

    public String getPath() {
        return this.d_path;
    }

    public void setPath(String path) {
        this.d_path = path;
    }

    public UnitDouble getFrameOffset() {
        return this.d_frameOffset;
    }

    public void setFrameOffset(UnitDouble offset) {
        this.d_frameOffset = offset;
    }

    public AnimationTransform getTransform() {
        return this.d_transform;
    }

    public void setTransform(AnimationTransform transform) {
        this.d_transform = transform;
    }

    public AnimRetargetMode getRetargetMode() {
        return this.d_retargetMode;
    }

    public void setRetargetMode(AnimRetargetMode mode) {
        this.d_retargetMode = mode;
    }

    public String getRetargetSource() {
        return this.d_retargetSource;
    }

    public void setRetargetSource(String source) {
        this.d_retargetSource = source;
    }

    public JSONObject getExtraProps() {
        return this.d_extraProps;
    }

    public void setExtraProps(JSONObject props) {
        this.d_extraProps = props;
    }
}

