/*
 * Decompiled with CFR 0.152.
 */
package merlin.data;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import merlin.data.AMerlinObj;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.property.IDisplayProp;
import merlin.data.property.PropertyDefs;
import merlin.util.Dependencies;
import thunderheadeng.dependencies.DepCallback;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.LinkedIdentityHashSet;

public class Proxy<T extends ICompElement>
extends AMerlinObj
implements ICompElement,
IDirectDependent<MerlinData> {
    static final long serialVersionUID = -3893471045648835311L;
    private T d_obj;
    private boolean d_enabled = true;
    private static final DepCallback<MerlinData, Proxy, ICompElement, ICompElement> OBJ_CALLBACK = Dependencies.newDependencyNoReplace(ICompElement.class);

    public Proxy(T obj) {
        this.d_obj = obj;
    }

    @Override
    public String getName() {
        return this.d_obj.getName();
    }

    @Override
    public void setName(String name) {
        this.d_obj.setName(name);
    }

    @Override
    public boolean isSetNameSupported() {
        return this.d_obj.isSetNameSupported();
    }

    @Override
    public Set<IDisplayProp<?>> getSupportedScenarioProps(PropertyDefs.ScenarioProps filter) {
        return Set.of(MerlinData.ENABLED);
    }

    @Override
    public boolean isComposite() {
        return this.d_obj.isComposite();
    }

    @Override
    public Collection<? extends IMerlinObj> getChildren() {
        return this.d_obj.getChildren();
    }

    @Override
    public PropertyDefs<? extends ICompElement> getAllLocalProperties() {
        return this.d_obj.getAllLocalProperties();
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return this.d_obj.getPropTypes(options);
    }

    public <U> void setProperty(Object property, U value) {
        if (property == MerlinData.ENABLED) {
            this.setEnabled((Boolean)value);
        } else {
            this.d_obj.setProperty(property, value);
        }
    }

    @Override
    public Object getProperty(Object property) {
        if (property == MerlinData.ENABLED) {
            return this.isEnabled();
        }
        return this.d_obj.getProperty(property);
    }

    public boolean isEnabled() {
        return this.d_enabled;
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.d_enabled) {
            this.d_enabled = enabled;
            this.changedEvt(MerlinData.VISIBILITY, MerlinData.ENABLED, EventChannel.EVT_GENERAL);
            this.d_obj.changedEvt(MerlinData.VISIBILITY, MerlinData.ENABLED, EventChannel.EVT_GENERAL);
        }
    }

    public T getObj() {
        return this.d_obj;
    }

    @Override
    protected void addToDomain(MerlinData domain, IMerlinObj parent) {
        super.addToDomain(domain, parent);
        domain.proxies.add(this);
        this.d_obj.notifyProxyAdded(this);
    }

    @Override
    protected void removeFromDomain(MerlinData domain, IMerlinObj parent) {
        this.d_obj.notifyProxyRemoved(this);
        domain.proxies.remove(this);
        super.removeFromDomain(domain, parent);
    }

    public static Collection<Object> getProxyParents(ICompElement obj, boolean includeDisabledProxies) {
        Set<Proxy> allProxies;
        MerlinData md = (MerlinData)obj.getDomain();
        if (md == null) {
            return null;
        }
        Set<Proxy> set = allProxies = md.proxies != null ? md.proxies.getProxies(obj) : Collections.emptySet();
        if (allProxies.isEmpty()) {
            return null;
        }
        LinkedIdentityHashSet<Object> allParents = new LinkedIdentityHashSet<Object>();
        for (Proxy p : allProxies) {
            Object parent;
            if (!includeDisabledProxies && !p.isEnabled() || (parent = ((MerlinData)obj.getDomain()).hierarchy.getParent(p)) == null) continue;
            allParents.add(parent);
        }
        return allParents;
    }

    @Override
    public void takeDepSnapshot(DepList<MerlinData> deps) {
        deps.add(this, this.d_obj, OBJ_CALLBACK);
    }
}

