/*
 * Decompiled with CFR 0.152.
 */
package merlin.data;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import merlin.Intl;
import merlin.data.Composite;
import merlin.data.MerlinData;
import merlin.data.OccGroupObj;
import merlin.data.egress.agents.OccProfile;
import merlin.data.property.CompositeProp;
import merlin.data.property.CompositeProps;
import merlin.data.property.DisplayProp;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropertyDefs;
import merlin.data.tag.TagsUtil;
import merlin.util.Dependencies;
import merlin.util.MerlinUtil;
import org.jscience.physics.units.Unit;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.ISurrogate;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.NameGenerator;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.ICurve;
import thunderheadeng.util.stat.LogNormCurve;
import thunderheadeng.util.stat.StdNormCurve;
import thunderheadeng.util.stat.UniformCurve;
import thunderheadeng.util.theUtil;

public class OccGroupTypeObj
extends OccGroupObj
implements Serializable,
IDirectDependent<MerlinData>,
ISurrogate {
    static final long serialVersionUID = 1L;
    public static final DisplayProp<ICurve> PROP_MIN_NUMBER_OF_MEMBERS = ((DisplayProps.Builder)DisplayProps.build((Object)"OccGroupObj.MIN_NUMBER_OF_MEMBERS", ICurve.class, new ConstantCurve(new UnitDouble(1.0, Unit.ONE)), Intl.intl("Min Number of Members"), "").attrMarkScenarioSupported()).attrToProp();
    public static final DisplayProp<ICurve> PROP_PREF_NUMBER_OF_MEMBERS = ((DisplayProps.Builder)DisplayProps.build((Object)"OccGroupObj.PREF_NUMBER_OF_MEMBERS", ICurve.class, new ConstantCurve(new UnitDouble(2.0, Unit.ONE)), Intl.intl("Number of Members"), "").attrMarkScenarioSupported()).attrToProp();
    public static final DisplayProp<Boolean> PROP_ALLOW_SMALLER_GROUPS = ((DisplayProps.Builder)DisplayProps.build((Object)"OccGroupObj.ALLOW_SMALLER_GROUPS", true, Intl.intl("Allow Smaller Groups"), "").attrMarkScenarioSupported()).attrToProp();
    public static final IPropertySet.Prop<Boolean> PROP_USE_EXACT_DIST_CALCULATION = new IPropertySet.Prop<Boolean>("OccGroupObj.USE_EXACT_DIST_CALCULATION", true);
    public static final IPropertySet.Prop<UnitDouble> PROP_HEIGHT_MULTIPLIER = new IPropertySet.Prop<UnitDouble>("OccGroupObj.HEIGHT_MULTIPLIER", new UnitDouble(10.0, Unit.ONE));
    public static final DisplayProp<Map<OccProfile, GroupCreationDataObj>> PROP_PROFILE_DATA = ((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.buildGeneric("OccGroupObj.PROFILE_DATA", Map.class, DisplayProps.emptyMap(OccProfile.class, GroupCreationDataObj.class), Intl.intl("Number of Members per Profile"), "").attrMarkScenarioSupported()).attrFormatValue(v -> OccGroupTypeObj.formatProfileData(v))).attrToProp();
    public static final DisplayProp<Boolean> PROP_SPECIFY_PROFILES = ((DisplayProps.Builder)DisplayProps.build((Object)"OccGroupObj.SPECIFY_PROFILES", false, Intl.intl("Specify Number of Members per Profile"), "").attrMarkScenarioSupported()).attrToProp();
    public static final DisplayProp<OccProfile> PROP_LEADER_PROFILE = ((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.build((Object)"OccGroupObj.LEADER_PROFILE", OccProfile.class, null, Intl.intl("Leader's Profile"), "<html>" + String.format(Intl.intl("Profile of the groups' leader. This option is enabled only if <b>%s</b> and <b>%s</b> are selected."), Intl.intl("Follow Leader"), Intl.intl("Specify Number of Members per Profile") + "</html>")).attrMarkScenarioSupported()).attrFormatValue(v -> v != null ? v.getName() : Intl.intl("[any]"))).attrToProp();
    public static final PropertyDefs<OccGroupTypeObj> PROP_TYPES = PropertyDefs.explicitProps(OccGroupTypeObj.class, List.of(OccGroupObj.PROP_TYPES), IPropertySet.getAllDeclaredPublicStaticProps(OccGroupTypeObj.class).stream(), IPropertySet.getAllDeclaredPublicStaticProps(OccGroupObj.class).stream().filter(Filters.reject(OccGroupObj.PROP_GROUP_LEADER)), Stream.of(MerlinData.TAGS));
    public static final CompositeProp PROP_CREATION = (CompositeProp)((CompositeProps.CompositePropBuilder)CompositeProps.build(Intl.intl("Creation"), "", PROP_SPECIFY_PROFILES, PROP_MIN_NUMBER_OF_MEMBERS, PROP_PREF_NUMBER_OF_MEMBERS, PROP_ALLOW_SMALLER_GROUPS, PROP_PROFILE_DATA, PROP_LEADER_PROFILE).attrMarkScenarioSupported()).attrStoreIn(PROP_TYPES);
    private NameGenerator newGroupNameGenerator;

    private static String formatProfileData(Map<OccProfile, GroupCreationDataObj> map) {
        return map.entrySet().stream().filter(entry -> entry.getValue() != null).map(entry -> ((GroupCreationDataObj)entry.getValue()).allowSmallerGroups ? String.format(Intl.intl("(%1$s: %2$s, Min %3$s)"), ((OccProfile)entry.getKey()).getName(), ((GroupCreationDataObj)entry.getValue()).prefNumberOfMembers.toString(), ((GroupCreationDataObj)entry.getValue()).minNumberOfMembers.toString()) : String.format(Intl.intl("(%1$s: %2$s)"), ((OccProfile)entry.getKey()).getName(), ((GroupCreationDataObj)entry.getValue()).prefNumberOfMembers.toString())).collect(Collectors.joining("; "));
    }

    public OccGroupTypeObj() {
        this.initNewGroupNameGenerator();
        this.setRandomColor();
    }

    @Override
    public PropertyDefs<OccGroupTypeObj> getAllLocalProperties() {
        return PROP_TYPES;
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        if (MerlinUtil.test(options, 1)) {
            return PROP_TYPES.props();
        }
        return super.getPropTypes(options);
    }

    public String createNewGroupName() {
        this.initNewGroupNameGenerator();
        String name = this.newGroupNameGenerator.generateName();
        this.newGroupNameGenerator.registerName(name);
        return name;
    }

    private void initNewGroupNameGenerator() {
        if (this.newGroupNameGenerator != null) {
            return;
        }
        this.newGroupNameGenerator = new NameGenerator(this.getName() + "_");
    }

    @Override
    public OccGroupTypeObj clone() {
        OccGroupTypeObj clone = (OccGroupTypeObj)super.clone();
        clone.newGroupNameGenerator = null;
        clone.initNewGroupNameGenerator();
        return clone;
    }

    public boolean mightCreateNonSingularGroups() {
        OccGroupTypeObj gt = this;
        if (!gt.getProperty(PROP_SPECIFY_PROFILES).booleanValue()) {
            UnitDouble one = new UnitDouble(1.0, Unit.ONE);
            BiPredicate<ICurve, ICurve> testCounts = (pref, min) -> pref != null && pref.getMax().gt(one, 0.0) || min != null && min.getMax().gt(one, 0.0);
            return testCounts.test(gt.getProperty(PROP_PREF_NUMBER_OF_MEMBERS), gt.getProperty(PROP_MIN_NUMBER_OF_MEMBERS));
        }
        Map<OccProfile, GroupCreationDataObj> profData = gt.getProperty(PROP_PROFILE_DATA);
        return profData.values().stream().filter(data -> data.prefNumberOfMembers != null).mapToDouble(data -> data.prefNumberOfMembers.getMax().get(Unit.ONE)).sum() > 1.0 || profData.values().stream().filter(data -> data.minNumberOfMembers != null).mapToDouble(data -> data.minNumberOfMembers.getMax().get(Unit.ONE)).sum() > 1.0;
    }

    public GroupCreationInfo getGroupCreationData(Random rnd) {
        if (this.getProperty(PROP_SPECIFY_PROFILES).booleanValue()) {
            int prefNumberOfMembers = 0;
            int minNumberOfMembers = 0;
            Map<OccProfile, GroupCreationDataObj> map = this.discretizeCurves(this.getProperty(PROP_PROFILE_DATA));
            LinkedIdentityHashMap<OccProfile, Integer> profPrefCounts = new LinkedIdentityHashMap<OccProfile, Integer>();
            LinkedIdentityHashMap<OccProfile, Integer> profMinCounts = new LinkedIdentityHashMap<OccProfile, Integer>();
            for (OccProfile prof : map.keySet()) {
                GroupCreationDataObj data = map.get(prof);
                int prefNumOfMembers = (int)Math.round(data.prefNumberOfMembers.getValue(rnd).get(Unit.ONE));
                int minNumOfMembers = data.allowSmallerGroups ? Math.min((int)Math.round(data.minNumberOfMembers.getValue(rnd).get(Unit.ONE)), prefNumberOfMembers += prefNumOfMembers) : prefNumOfMembers;
                minNumberOfMembers += minNumOfMembers;
                profPrefCounts.put(prof, prefNumOfMembers);
                profMinCounts.put(prof, minNumOfMembers);
            }
            GroupCreationDataObj data = new GroupCreationDataObj(new ConstantCurve(new UnitDouble(prefNumberOfMembers, Unit.ONE)), prefNumberOfMembers != minNumberOfMembers, new ConstantCurve(new UnitDouble(minNumberOfMembers, Unit.ONE)));
            return new GroupCreationInfo(data, profPrefCounts, profMinCounts);
        }
        return new GroupCreationInfo(new GroupCreationDataObj(this.getProperty(PROP_PREF_NUMBER_OF_MEMBERS), this.getProperty(PROP_ALLOW_SMALLER_GROUPS), this.getProperty(PROP_MIN_NUMBER_OF_MEMBERS)), null, null);
    }

    private Map<OccProfile, GroupCreationDataObj> discretizeCurves(Map<OccProfile, GroupCreationDataObj> map) {
        if (map == null) {
            return null;
        }
        LinkedHashMap<OccProfile, GroupCreationDataObj> newMap = new LinkedHashMap<OccProfile, GroupCreationDataObj>();
        for (OccProfile prof : map.keySet()) {
            GroupCreationDataObj data = map.get(prof);
            ICurve prefNumberOfMembers = OccGroupTypeObj.discretizeCurve(data.prefNumberOfMembers);
            ICurve minNumberOfMembers = OccGroupTypeObj.discretizeCurve(data.minNumberOfMembers);
            GroupCreationDataObj newData = new GroupCreationDataObj(prefNumberOfMembers, data.allowSmallerGroups, minNumberOfMembers);
            newMap.put(prof, newData);
        }
        return newMap;
    }

    private static ICurve discretizeCurve(ICurve curve) {
        if (curve == null) {
            return null;
        }
        if (curve instanceof ConstantCurve) {
            return curve;
        }
        Unit unit = curve.getAvg().getUnit();
        double min = curve.getMin().get(unit);
        double max = curve.getMax().get(unit);
        min = min == Math.floor(min) ? min - 0.5 : Math.floor(min) + 0.5;
        max = Math.floor(max) + 0.5;
        UnitDouble minUD = new UnitDouble(min, unit);
        UnitDouble maxUD = new UnitDouble(max, unit);
        if (curve instanceof UniformCurve) {
            return new UniformCurve(minUD, maxUD);
        }
        if (curve instanceof StdNormCurve) {
            return new StdNormCurve(minUD, maxUD, curve.getAvg(), ((StdNormCurve)curve).getStdDev());
        }
        if (curve instanceof LogNormCurve) {
            return new LogNormCurve(minUD, maxUD, curve.getAvg(), ((LogNormCurve)curve).getStdDev());
        }
        assert (false);
        return null;
    }

    @Override
    public void setName(String name) {
        this.initNewGroupNameGenerator();
        this.newGroupNameGenerator.setBaseName(name + "_");
        super.setName(name);
    }

    public Set<OccProfile> getAllProfiles() {
        if (!this.getProperty(PROP_SPECIFY_PROFILES).booleanValue()) {
            return Collections.emptySet();
        }
        LinkedHashSet<OccProfile> allProfiles = new LinkedHashSet<OccProfile>();
        Map<OccProfile, GroupCreationDataObj> profileData = this.getProperty(PROP_PROFILE_DATA);
        for (Map.Entry<OccProfile, GroupCreationDataObj> entry : profileData.entrySet()) {
            double maxCount = entry.getValue().prefNumberOfMembers.getMax().get(Unit.ONE);
            if (!theUtil.gt0(maxCount, 0.0)) continue;
            allProfiles.add(entry.getKey());
        }
        return allProfiles;
    }

    @Override
    public void takeDepSnapshot(DepList<MerlinData> deps) {
        super.takeDepSnapshot(deps);
        PROP_TYPES.takeDepSnapshot(this, deps);
    }

    @Override
    public boolean surrogateEquals(Object comparable) {
        if (comparable == this) {
            return true;
        }
        if (comparable == null || !comparable.getClass().equals(this.getClass())) {
            return false;
        }
        OccGroupTypeObj occGroupTypeObj = (OccGroupTypeObj)comparable;
        return Objects.equals(this.getName(), occGroupTypeObj.getName()) && theUtil.equal(this.getProperty(PROP_LEADER_PROFILE), occGroupTypeObj.getProperty(PROP_LEADER_PROFILE)) && theUtil.surrogateMapsEqual(this.getProperty(PROP_PROFILE_DATA), occGroupTypeObj.getProperty(PROP_PROFILE_DATA), false) && Objects.equals(this.getProperty(PROP_MIN_NUMBER_OF_MEMBERS), occGroupTypeObj.getProperty(PROP_MIN_NUMBER_OF_MEMBERS)) && Objects.equals(this.getProperty(PROP_PREF_NUMBER_OF_MEMBERS), occGroupTypeObj.getProperty(PROP_PREF_NUMBER_OF_MEMBERS)) && Objects.equals(this.getProperty(PROP_HEIGHT_MULTIPLIER), occGroupTypeObj.getProperty(PROP_HEIGHT_MULTIPLIER)) && Objects.equals(this.getProperty(PROP_ALLOW_SMALLER_GROUPS), occGroupTypeObj.getProperty(PROP_ALLOW_SMALLER_GROUPS)) && Objects.equals(this.getProperty(PROP_USE_EXACT_DIST_CALCULATION), occGroupTypeObj.getProperty(PROP_USE_EXACT_DIST_CALCULATION)) && Objects.equals(this.getProperty(PROP_SPECIFY_PROFILES), occGroupTypeObj.getProperty(PROP_SPECIFY_PROFILES)) && theUtil.surrogateSetsEqual((Collection)this.getProperty(MerlinData.TAGS), (Collection)occGroupTypeObj.getProperty(MerlinData.TAGS));
    }

    static {
        PROP_TYPES.registerDependency(PROP_LEADER_PROFILE, Dependencies.newDependencyAsValue(PROP_LEADER_PROFILE, DLink.WEAK, OccProfile.class, Predicates.alwaysTrue()));
        PROP_TYPES.registerDependency(PROP_PROFILE_DATA, Dependencies.newDependency(PROP_PROFILE_DATA, DLink.WEAK, OccProfile.class, (md, src, map) -> map.keySet().stream(), Predicates.alwaysTrue(), (md, src, val, old, replacement) -> {
            LinkedIdentityHashMap<OccProfile, GroupCreationDataObj> profileData = new LinkedIdentityHashMap<OccProfile, GroupCreationDataObj>((Map<OccProfile, GroupCreationDataObj>)val);
            GroupCreationDataObj oldData = (GroupCreationDataObj)profileData.remove(old);
            assert (oldData != null);
            if (oldData != null && replacement != null) {
                profileData.put((OccProfile)replacement, oldData);
            }
            return profileData;
        }));
        TagsUtil.registerTagsDependency(PROP_TYPES);
    }

    public static class GroupCreationDataObj
    implements Serializable,
    ISurrogate {
        static final long serialVersionUID = 1L;
        public final ICurve prefNumberOfMembers;
        public final boolean allowSmallerGroups;
        public final ICurve minNumberOfMembers;

        public GroupCreationDataObj(ICurve prefNumberOfMembers, boolean allowSmallerGroups, ICurve minNumberOfMembers) {
            this.prefNumberOfMembers = prefNumberOfMembers;
            this.allowSmallerGroups = allowSmallerGroups;
            this.minNumberOfMembers = minNumberOfMembers;
        }

        public GroupCreationDataObj(OccGroupTypeObj dataObj) {
            this.prefNumberOfMembers = dataObj.getProperty(PROP_PREF_NUMBER_OF_MEMBERS);
            this.allowSmallerGroups = dataObj.getProperty(PROP_ALLOW_SMALLER_GROUPS);
            this.minNumberOfMembers = dataObj.getProperty(PROP_MIN_NUMBER_OF_MEMBERS);
        }

        public GroupCreationDataObj(OccProfile prof) {
            this.prefNumberOfMembers = new ConstantCurve(new UnitDouble(0.0, Unit.ONE));
            this.allowSmallerGroups = false;
            this.minNumberOfMembers = new ConstantCurve(new UnitDouble(0.0, Unit.ONE));
        }

        @Override
        public boolean surrogateEquals(Object comparable) {
            if (comparable == this) {
                return true;
            }
            if (comparable == null || !comparable.getClass().equals(this.getClass())) {
                return false;
            }
            GroupCreationDataObj creationDataObj = (GroupCreationDataObj)comparable;
            return Objects.equals(this.prefNumberOfMembers, creationDataObj.prefNumberOfMembers) && Objects.equals(this.minNumberOfMembers, creationDataObj.minNumberOfMembers) && this.allowSmallerGroups == creationDataObj.allowSmallerGroups;
        }
    }

    public record GroupCreationInfo(GroupCreationDataObj limits, Map<OccProfile, Integer> profilePrefCounts, Map<OccProfile, Integer> profileMinCounts) {
    }

    public static class OccGroupTypeComp
    extends Composite<OccGroupTypeObj> {
        static final long serialVersionUID = 4200385297076337319L;
        @SkipDep
        public OccGroupTypeObj NO_GROUP_TYPE;

        public OccGroupTypeComp() {
            this(Intl.intl("Movement Group Templates"));
        }

        public OccGroupTypeComp(String name) {
            super(name);
            this.initNoGroupType();
        }

        public void initNoGroupType() {
            this.NO_GROUP_TYPE = new OccGroupTypeObj();
            this.NO_GROUP_TYPE.setName(Intl.intl("Ungrouped"));
            this.NO_GROUP_TYPE.setProperty(PROP_PREF_NUMBER_OF_MEMBERS, new ConstantCurve(new UnitDouble(1.0, Unit.ONE)));
        }

        @Override
        public Composite<?> newGroup(String name) {
            return new OccGroupTypeComp(name);
        }

        @Override
        public Object getProperty(Object property) {
            if (property == OccGroupObj.PROP_NAME) {
                return this.getName();
            }
            return super.getProperty(property);
        }

        @Override
        public String getNewGroupName() {
            return Intl.intl("Movement Group Template Group");
        }

        @Override
        public void loadFrom(Composite<OccGroupTypeObj> obj) {
            assert (obj instanceof OccGroupTypeComp);
            this.loadFrom((OccGroupTypeComp)obj);
        }

        public void loadFrom(OccGroupTypeComp root) {
            this.pauseUpdates();
            super.loadFrom(root);
            this.NO_GROUP_TYPE = root.NO_GROUP_TYPE;
            if (this.NO_GROUP_TYPE == null) {
                this.initNoGroupType();
            }
            this.resumeUpdates();
        }
    }
}

