/*
 * Decompiled with CFR 0.152.
 */
package merlin.data;

import java.awt.Color;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import merlin.Intl;
import merlin.data.Composite;
import merlin.data.GeomComposite;
import merlin.data.ICompElement;
import merlin.data.IRestorable;
import merlin.data.MerlinData;
import merlin.data.OccGroupTypeObj;
import merlin.data.Proxy;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.OccProfile;
import merlin.data.property.DisplayProp;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropertyDefs;
import merlin.data.tag.Tag;
import merlin.data.tag.TagsUtil;
import merlin.util.Dependencies;
import merlin.util.MerlinUtil;
import org.jscience.physics.units.SI;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.APredicate;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.TypeFilter;

public class OccGroupObj
extends GeomComposite<Proxy<EgressAgent>>
implements Serializable,
ICompElement,
IRestorable,
IDirectDependent<MerlinData> {
    static final long serialVersionUID = 1L;
    public static final DisplayProp<String> PROP_NAME = DisplayProps.build((Object)"OccGroupObj.NAME", "", Intl.intl("Name"), "").attrToProp();
    public static final DisplayProp<String> PROP_DESC = ((DisplayProps.Builder)DisplayProps.build((Object)"OccGroupObj.DESC", "", Intl.intl("Description"), "").attrMarkScenarioSupported()).attrToProp();
    public static final DisplayProp<Boolean> PROP_REQUIRES_GROUP_LEADER = ((DisplayProps.Builder)DisplayProps.build((Object)"OccGroupObj.REQUIRES_GROUP_LEADER", false, Intl.intl("Follow Leader"), Intl.intl("Whether the group should follow a leader.")).attrMarkScenarioSupported()).attrToProp();
    public static final DisplayProp<EgressAgent> PROP_GROUP_LEADER = ((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.build((Object)"OccGroupObj.GROUP_LEADER", EgressAgent.class, null, Intl.intl("Leader"), "").attrMarkScenarioSupported()).attrFormatValue(v -> v != null ? v.getName() : Intl.intl("[none]"))).attrToProp();
    public static final DisplayProp<UnitDouble> PROP_MAX_DISTANCE = ((DisplayProps.Builder)DisplayProps.build((Object)"OccGroupObj.MAX_DISTANCE", new UnitDouble(2.0, SI.METER), Intl.intl("Maximum Distance"), "<html>" + Intl.intl("Maximum distance from any group member to the closest other group member.<br>Enforcing social distancing in the group will cause this value to be <br>expanded by the maximum social distance of the group members."), 0).attrMarkScenarioSupported()).attrToProp();
    public static final DisplayProp<UnitDouble> PROP_SLOWDOWN_TIME = ((DisplayProps.Builder)DisplayProps.build((Object)"OccGroupObj.SLOWDOWN_TIME", new UnitDouble(3.0, SI.SECOND), Intl.intl("Slowdown Time"), Intl.intl("Time interval during which the group will keep slowing down after it is disconnected."), 1).attrMarkScenarioSupported()).attrToProp();
    public static final DisplayProp<Boolean> PROP_SOCIAL_DIST_IN_GROUP = ((DisplayProps.Builder)DisplayProps.build((Object)"OccGroupObj.SOCIAL_DIST_IN_GROUP", false, Intl.intl("Enforce social distancing between group members"), "<html>" + Intl.intl("Whether an occupant in the group should try to separate with other<br>group members if the <b>Social Distance</b> property is enabled<br>in the occupant's profile. Enabling this option expands the group's<br><b>Maximum Distance</b> to include the maximum social distance of<br>the group members.")).attrMarkScenarioSupported()).attrToProp();
    public static final DisplayProp<Color> PROP_COLOR = ((DisplayProps.Builder)DisplayProps.build((Object)"OccGroupObj.COLOR", Color.class, Color.BLUE, Intl.intl("Movement Group Color"), "").attrMarkScenarioSupported()).attrToProp();
    public static final DisplayProp<Color> PROP_TEMPLATE_COLOR = DisplayProps.build((Object)"OccGroupObj.TEMPLATE_COLOR", Color.class, Color.BLUE, Intl.intl("Color"), "").attrToProp();
    public static final PropertyDefs<OccGroupObj> PROP_TYPES = new PropertyDefs<OccGroupObj>(OccGroupObj.class, List.of(), IPropertySet.getAllDeclaredPublicStaticProps(OccGroupObj.class), MerlinData.TAGS, EgressAgent.asAgentOccProp(OccProfile.PROP_TAGS));
    private PropertySet d_props = new PropertySet();
    private static final Predicate<ICompElement> s_filter;

    public OccGroupObj() {
        super("OccGroupObj");
    }

    @Override
    public String getName() {
        return this.getProperty(PROP_NAME);
    }

    @Override
    public void setName(String name) {
        this.setProperty(PROP_NAME, name);
    }

    public void setRandomColor() {
        this.setProperty(PROP_COLOR, MerlinUtil.newRandomOccColor());
    }

    public void setColor(Color color) {
        if (color != null) {
            this.setProperty(PROP_COLOR, color);
        } else {
            this.setRandomColor();
        }
    }

    public void setTemplateColor(Color color) {
        this.setProperty(PROP_TEMPLATE_COLOR, color);
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof OccGroupObj)) {
            return;
        }
        OccGroupObj occGroup = (OccGroupObj)obj;
        this.d_props = occGroup.d_props;
        this.changedEvt(new Object[0]);
    }

    @Override
    public OccGroupObj getRestoreObj() {
        return this.clone();
    }

    @Override
    public OccGroupObj clone() {
        OccGroupObj clone = (OccGroupObj)super.clone();
        clone.d_props = this.d_props.clone();
        return clone;
    }

    @Override
    public PropertyDefs<? extends ICompElement> getAllLocalProperties() {
        return PROP_TYPES;
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        if (MerlinUtil.test(options, 1)) {
            return PROP_TYPES.props();
        }
        return super.getPropTypes(options);
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (EgressAgent.asAgentOccProp(OccProfile.PROP_TAGS).equals(property)) {
            return;
        }
        if (this.getPropTypes(1).contains(property) && property instanceof IPropertySet.Prop) {
            this.setProperty((IPropertySet.Prop)property, value);
        } else {
            super.setProperty(property, value);
        }
    }

    public <T> void setProperty(IPropertySet.Prop<T> prop, T value) {
        if (Objects.equals(value, this.d_props.get(prop))) {
            return;
        }
        this.d_props.set(prop, value);
        this.changedEvt(prop);
    }

    @Override
    public Object getProperty(Object property) {
        if (EgressAgent.asAgentOccProp(OccProfile.PROP_TAGS).equals(property)) {
            return new EgressAgent.AgentValue<Set<Tag>>(true, this.getProperty(MerlinData.TAGS));
        }
        if (this.getPropTypes(1).contains(property) && property instanceof IPropertySet.Prop) {
            return this.getProperty((IPropertySet.Prop)property);
        }
        return super.getProperty(property);
    }

    public <T> T getProperty(IPropertySet.Prop<T> prop) {
        return this.d_props.get(prop);
    }

    @Override
    public boolean canAddGroup() {
        return false;
    }

    @Override
    public Predicate<ICompElement> getFilter() {
        return s_filter;
    }

    @Override
    public void takeDepSnapshot(DepList<MerlinData> deps) {
        PROP_TYPES.takeDepSnapshot(this, deps);
    }

    public static OccGroupObj newGroup(String name, Collection<EgressAgent> agents, Color templateColor, Color color) {
        OccGroupObj newGroup = new OccGroupObj();
        newGroup.setName(name);
        for (EgressAgent a : agents) {
            newGroup.add(new Proxy<EgressAgent>(a));
        }
        newGroup.setColor(color);
        newGroup.setTemplateColor(templateColor);
        return newGroup;
    }

    public void loadTemplate(OccGroupTypeObj groupTemplate, List<EgressAgent> members) {
        this.setProperty(PROP_MAX_DISTANCE, groupTemplate.getProperty(PROP_MAX_DISTANCE));
        this.setProperty(PROP_SLOWDOWN_TIME, groupTemplate.getProperty(PROP_SLOWDOWN_TIME));
        this.setProperty(PROP_SOCIAL_DIST_IN_GROUP, groupTemplate.getProperty(PROP_SOCIAL_DIST_IN_GROUP));
        boolean requiresLeader = groupTemplate.getProperty(PROP_REQUIRES_GROUP_LEADER);
        this.setProperty(PROP_REQUIRES_GROUP_LEADER, Boolean.valueOf(requiresLeader));
        if (requiresLeader) {
            OccProfile leaderProfile = groupTemplate.getProperty(OccGroupTypeObj.PROP_LEADER_PROFILE);
            if (leaderProfile == null) {
                this.setProperty(PROP_GROUP_LEADER, members.get(0));
            } else {
                for (EgressAgent a : members) {
                    if (a.getProfile().getProfParent() != leaderProfile) continue;
                    this.setProperty(PROP_GROUP_LEADER, a);
                    break;
                }
            }
            assert (this.getProperty(PROP_GROUP_LEADER) != null) : "Failed to assign a group leader";
        }
    }

    static {
        PROP_TYPES.registerCompositeScenarioProperty(PROP_REQUIRES_GROUP_LEADER, PROP_GROUP_LEADER);
        PROP_TYPES.registerDependency(PROP_GROUP_LEADER, Dependencies.newDependencyGeneric(PROP_GROUP_LEADER, DLink.WEAK, Proxy.class, null, (md, src, agent) -> md.proxies.getProxies((ICompElement)agent).stream().filter(proxy -> proxy.getParent() == src).map(p -> p), (md, src) -> proxy -> proxy.getParent() == src, (md, src, val, old, repl) -> repl != null ? (EgressAgent)repl.getObj() : null));
        TagsUtil.registerTagsDependency(PROP_TYPES);
        s_filter = new APredicate<ICompElement>(){
            private static final long serialVersionUID = 7382663705197223905L;

            @Override
            public boolean test(ICompElement t) {
                if (!(t instanceof Proxy)) {
                    return false;
                }
                Proxy p = (Proxy)t;
                Object obj = p.getObj();
                return obj instanceof EgressAgent;
            }
        };
    }

    public static class OccGroupComp
    extends Composite<OccGroupObj>
    implements Serializable {
        static final long serialVersionUID = 3553758720985786240L;
        private static final Predicate<ICompElement> s_filter = new TypeFilter<ICompElement>(OccGroupObj.class, OccGroupComp.class);

        public OccGroupComp() {
            this(Intl.intl("Movement Groups"));
        }

        public OccGroupComp(String name) {
            super(name);
        }

        @Override
        public Predicate<ICompElement> getFilter() {
            return s_filter;
        }

        @Override
        public Composite<?> newGroup(String name) {
            return new OccGroupComp(name);
        }

        @Override
        public String getNewGroupName() {
            return Intl.intl("Movement Group Group");
        }
    }
}

