/*
 * Decompiled with CFR 0.152.
 */
package merlin.data;

import inferno.data2.ai.AssistOccupantsOrder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.Undo;
import merlin.data.AMerlinObj;
import merlin.data.ICompElement;
import merlin.data.IRestorable;
import merlin.data.MerlinData;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.property.DisplayProp;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropertyDefs;
import merlin.data.tag.Tag;
import merlin.data.tag.TagsUtil;
import merlin.util.Dependencies;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.util.Filters;
import thunderheadeng.util.ICyclicSurrogate;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.UnorderedPair;
import thunderheadeng.util.theUtil;

public class AssistedEvacTeam
extends AMerlinObj
implements Serializable,
ICompElement,
IRestorable,
IDirectDependent<MerlinData>,
ICyclicSurrogate {
    private static final long serialVersionUID = -1921363056388890558L;
    public static final DisplayProp<String> PROP_NAME = DisplayProps.build((Object)"AssistedEvacTeam.NAME", "", Intl.intl("Name"), "").attrToProp();
    public static final DisplayProp<String> PROP_DESC = ((DisplayProps.Builder)DisplayProps.build((Object)"AssistedEvacTeam.DESC", "", Intl.intl("Description"), "").attrMarkScenarioSupported()).attrToProp();
    public static final DisplayProp<List<EgressAgent>> PROP_OCC_ASSIST_ORDER = ((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.buildGeneric("AssistedEvacTeam.OCCS_TO_ASSIST", List.class, DisplayProps.emptyList(EgressAgent.class), Intl.intl("Client Priority"), Intl.intl("Determines the order of assistance")).attrMarkScenarioSupported()).attrFormatValue(v -> v.isEmpty() ? Intl.intl("Distance to Assistants") : v.stream().map(a -> a.getName()).collect(Collectors.joining()))).attrToProp();
    @Deprecated
    public static final IPropertySet.Prop<List<EgressAgent>> PROP_OCCS_TO_ASSIST = new IPropertySet.Prop("AssistedEvacTeam.OCCS_TO_ASSIST", new ArrayList());
    @Deprecated
    public static final IPropertySet.Prop<Boolean> PROP_ASSIST_ALL = new IPropertySet.Prop<Boolean>("AssistedEvacTeam.ASSIST_ALL", true);
    @Deprecated
    public static final IPropertySet.Prop<AssistOccupantsOrder> PROP_ASSIST_ORDER = new IPropertySet.Prop<AssistOccupantsOrder>("AssistedEvacTeam.ASSIST_ORDER", AssistOccupantsOrder.DISTANCE);
    public static final List<IPropertySet.Prop<?>> ALL_PROPS = IPropertySet.getAllDeclaredPublicStaticProps(AssistedEvacTeam.class).stream().filter(Filters.reject(PROP_OCCS_TO_ASSIST, PROP_ASSIST_ORDER, PROP_ASSIST_ALL)).collect(Collectors.toList());
    public static final PropertyDefs<AssistedEvacTeam> PROP_TYPES = new PropertyDefs<AssistedEvacTeam>(AssistedEvacTeam.class, List.of(), ALL_PROPS, MerlinData.TAGS);
    private PropertySet d_props = new PropertySet();

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    @Override
    public String getName() {
        return this.getProperty(PROP_NAME);
    }

    @Override
    public void setName(String name) {
        this.setProperty(PROP_NAME, name);
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof AssistedEvacTeam)) {
            return;
        }
        AssistedEvacTeam aeTeam = (AssistedEvacTeam)obj;
        this.d_props = aeTeam.d_props;
        this.changedEvt(new Object[0]);
    }

    @Override
    public AssistedEvacTeam clone() {
        AssistedEvacTeam clone = (AssistedEvacTeam)super.clone();
        clone.d_props = this.d_props.clone();
        List<EgressAgent> occsToAssist = this.getProperty(PROP_OCC_ASSIST_ORDER);
        clone.setProperty(PROP_OCC_ASSIST_ORDER, new ArrayList<EgressAgent>(occsToAssist));
        return clone;
    }

    @Override
    public Object getRestoreObj() {
        return this.clone();
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES.props();
    }

    @Override
    public PropertyDefs<? extends ICompElement> getAllLocalProperties() {
        return PROP_TYPES;
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property instanceof IPropertySet.Prop) {
            this.setProperty((IPropertySet.Prop)property, value);
        }
    }

    public <T> void setProperty(IPropertySet.Prop<T> prop, T value) {
        if (Objects.equals(value, this.d_props.get(prop))) {
            return;
        }
        this.d_props.set(prop, value);
        this.changedEvt(prop);
    }

    @Override
    public Object getProperty(Object property) {
        if (property instanceof IPropertySet.Prop) {
            return this.getProperty((IPropertySet.Prop)property);
        }
        return NOT_SUPPORTED;
    }

    public <T> T getProperty(IPropertySet.Prop<T> prop) {
        return this.d_props.get(prop);
    }

    public <T> T removeProperty(IPropertySet.Prop<T> prop) {
        T val = this.getProperty(prop);
        this.d_props.remove(prop);
        return val;
    }

    public String toString() {
        return this.getName();
    }

    public static void removeAgentsFromAssistedEvacTeams(Collection<EgressAgent> selectedAgents, boolean removeAll) {
        Consumer<List> remove;
        MerlinData md = MerlinApp.getApp().getData();
        Collection<AssistedEvacTeam> teams = md.assistedEvacTeams.getDeepMembers(AssistedEvacTeam.class);
        Undo.insertUndoEntry_restore(md, teams);
        if (removeAll) {
            remove = occsToAssist -> occsToAssist.clear();
        } else {
            Predicate filter = Filters.accept(selectedAgents instanceof Set ? selectedAgents : new IdentityHashSet(selectedAgents));
            remove = occsToAssist -> occsToAssist.removeIf(filter);
        }
        teams.forEach(team -> {
            List<EgressAgent> occsToAssist = team.getProperty(PROP_OCC_ASSIST_ORDER);
            remove.accept(occsToAssist);
            team.setProperty(PROP_OCC_ASSIST_ORDER, occsToAssist);
        });
    }

    public void addOccsToAssist(List<EgressAgent> occs) {
        List<EgressAgent> occList = this.getProperty(PROP_OCC_ASSIST_ORDER);
        occs.forEach(occ -> {
            if (!occList.contains(occ)) {
                occList.add((EgressAgent)occ);
            }
        });
        this.setProperty(PROP_OCC_ASSIST_ORDER, occList);
    }

    private int surrogateHashCode() {
        int hash = 7;
        hash = 31 * hash + theUtil.hashCode(this.getProperty(PROP_NAME));
        hash = 31 * hash + theUtil.hashCode(this.getProperty(PROP_DESC));
        return hash;
    }

    @Override
    public boolean cyclicEquals(Object comparable, HashSet<UnorderedPair<Object, Object>> comparedSet) {
        if (comparable == this) {
            return true;
        }
        if (comparable == null || this.getClass() != comparable.getClass()) {
            return false;
        }
        AssistedEvacTeam comparableTeam = (AssistedEvacTeam)comparable;
        List<EgressAgent> order1 = this.getProperty(PROP_OCC_ASSIST_ORDER);
        List<EgressAgent> order2 = comparableTeam.getProperty(PROP_OCC_ASSIST_ORDER);
        Set<Tag> tags1 = this.getProperty(MerlinData.TAGS);
        Set<Tag> tags2 = comparableTeam.getProperty(MerlinData.TAGS);
        return this.getProperty(PROP_NAME).equals(comparableTeam.getProperty(PROP_NAME)) && this.getProperty(PROP_DESC).equals(comparableTeam.getProperty(PROP_DESC)) && theUtil.surrogateSetsEqual(order1, order2, comparedSet) && theUtil.surrogateSetsEqual(tags1, tags2, comparedSet);
    }

    @Override
    public void takeDepSnapshot(DepList<MerlinData> deps) {
        PROP_TYPES.takeDepSnapshot(this, deps);
    }

    static {
        PROP_TYPES.registerDependency(PROP_OCC_ASSIST_ORDER, Dependencies.newDependency(PROP_OCC_ASSIST_ORDER, DLink.WEAK, EgressAgent.class, (md, src, val) -> val.stream(), Predicates.alwaysTrue(), (md, src, val, old, replacement) -> {
            ArrayList<EgressAgent> newAssistOrder = new ArrayList<EgressAgent>((Collection<EgressAgent>)val);
            int ix = newAssistOrder.indexOf(old);
            if (ix >= 0) {
                if (replacement == null || newAssistOrder.stream().anyMatch(o -> o == replacement)) {
                    newAssistOrder.remove(ix);
                } else {
                    newAssistOrder.set(ix, (EgressAgent)replacement);
                }
            }
            return newAssistOrder;
        }));
        TagsUtil.registerTagsDependency(PROP_TYPES);
    }
}

