/*
 * Decompiled with CFR 0.152.
 */
package merlin.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import merlin.actions.Undo;
import merlin.data.AMerlinObj;
import merlin.data.IMerlinObj;
import merlin.data.IRestorable;
import merlin.data.MerlinData;
import merlin.data.RestorableProperties;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class ActionProps
extends AMerlinObj
implements IRestorable {
    private static final long serialVersionUID = 1L;
    private Map<String, RestorableProperties> d_actionProps = new LinkedHashMap<String, RestorableProperties>();

    @Override
    public boolean isComposite() {
        return true;
    }

    @Override
    public Collection<? extends IMerlinObj> getChildren() {
        return this.d_actionProps.values();
    }

    @Override
    public ActionProps clone() {
        ActionProps clone = (ActionProps)super.clone();
        clone.d_actionProps = new LinkedHashMap<String, RestorableProperties>();
        return clone;
    }

    @Override
    public Object getRestoreObj() {
        ActionProps clone = (ActionProps)super.clone();
        clone.d_actionProps = new LinkedHashMap<String, RestorableProperties>(this.d_actionProps);
        return clone;
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof ActionProps)) {
            return;
        }
        ActionProps actionProps = (ActionProps)obj;
        try (IMerlinObj.EventPause pause = this.openPause();){
            ArrayList<Pair<String, RestorableProperties>> toRemove = new ArrayList<Pair<String, RestorableProperties>>();
            ArrayList<Pair<String, RestorableProperties>> toAdd = new ArrayList<Pair<String, RestorableProperties>>();
            for (Map.Entry<String, RestorableProperties> entry : this.d_actionProps.entrySet()) {
                if (actionProps.d_actionProps.containsKey(entry.getKey())) continue;
                toRemove.add(new Pair<String, RestorableProperties>(entry.getKey(), entry.getValue()));
            }
            for (Map.Entry<String, RestorableProperties> entry : actionProps.d_actionProps.entrySet()) {
                if (this.d_actionProps.containsKey(entry.getKey())) continue;
                toAdd.add(new Pair<String, RestorableProperties>(entry.getKey(), entry.getValue()));
            }
            toRemove.forEach(pair -> this.d_actionProps.remove(pair.v1));
            this.removeChildren(theUtil.map(toRemove, p -> (RestorableProperties)p.v2));
            toAdd.forEach(pair -> this.d_actionProps.put((String)pair.v1, (RestorableProperties)pair.v2));
            this.addChildren(theUtil.map(toAdd, p -> (RestorableProperties)p.v2));
        }
    }

    public <T extends RestorableProperties> T getActionProps(String key) {
        return (T)this.d_actionProps.get(key);
    }

    public void setActionProps(String key, RestorableProperties props) {
        RestorableProperties existing = this.d_actionProps.put(key, props);
        if (existing != props) {
            try (IMerlinObj.EventPause pause = this.openPause();){
                if (existing != null) {
                    this.removeChild(existing);
                }
                this.addChild(props);
            }
        }
    }

    public void opSetActionProps(MerlinData md, String key, RestorableProperties props) {
        Object existing = this.getActionProps(key);
        if (props == existing) {
            return;
        }
        if (existing != null) {
            Undo.insertEntry(md, new Undo.CustomOp(() -> this.setActionProps(key, (RestorableProperties)existing), () -> this.setActionProps(key, props)));
        } else {
            Undo.insertEntry(md, new Undo.CustomOp(() -> this.removeActionProps(key), () -> this.setActionProps(key, props)));
        }
        this.setActionProps(key, props);
    }

    public void removeActionProps(String key) {
        RestorableProperties existing = this.d_actionProps.remove(key);
        if (existing != null) {
            this.removeChild(existing);
        }
    }

    public <T extends RestorableProperties> T opGetOrCreateActionProps(MerlinData md, String key, Supplier<? extends T> create) {
        T existing = this.getActionProps(key);
        if (existing == null) {
            RestorableProperties newProps = (RestorableProperties)create.get();
            Undo.insertEntry(md, new Undo.CustomOp(() -> this.removeActionProps(key), () -> this.setActionProps(key, newProps)));
            this.setActionProps(key, newProps);
            return (T)newProps;
        }
        return existing;
    }

    public void reset() {
        ArrayList<? extends IMerlinObj> children = new ArrayList<IMerlinObj>(this.getChildren());
        this.d_actionProps.clear();
        this.removeChildren(children);
    }

    public void loadFrom(ActionProps actionProps) {
        try (IMerlinObj.EventPause paused = this.openPause();){
            this.restoreFrom(actionProps);
            this.setResultsId(actionProps.getResultsId());
        }
    }
}

