/*
 * Decompiled with CFR 0.152.
 */
package merlin.builders;

import merlin.builders.ABehaviorActionBuilder;
import merlin.data.MerlinData;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.egress.scripting.Wait;
import org.jscience.physics.units.SI;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.IDistributedVal;

public class WaitActionBuilder
extends ABehaviorActionBuilder {
    public static final Object WAIT_TIME_CHANGED = "WaitActionBuilder.WAIT_TIME_CHANGED";
    private IDistributedVal<UnitDouble> d_waitTime = new ConstantCurve(new UnitDouble(10.0, SI.SECOND));

    public WaitActionBuilder(MerlinData md) {
        super(md);
    }

    public void setWaitTime(IDistributedVal<UnitDouble> waitTime) {
        if (!this.lock()) {
            return;
        }
        this.d_waitTime = waitTime;
        this.firePropChanged(WAIT_TIME_CHANGED);
        this.release();
    }

    public IDistributedVal<UnitDouble> getWaitTime() {
        return this.d_waitTime;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    protected IBehaviorAction create(MerlinData md) {
        return new Wait(this.d_waitTime);
    }

    @Override
    public void reset() {
    }

    @Override
    protected String getName(MerlinData md) {
        return this.create(md).getName();
    }

    @Override
    protected boolean mustBeLast(MerlinData md) {
        return this.create(md).mustBeLast();
    }
}

