/*
 * Decompiled with CFR 0.152.
 */
package merlin.builders;

import java.awt.Component;
import java.util.Collections;
import java.util.function.Supplier;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.AddObject;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.MerlinData;
import merlin.data.ObjsFilter;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.Behavior;
import merlin.data.egress.scripting.attractors.Attractor;
import merlin.data.property.DisplayProp;
import merlin.data.property.DisplayProps;
import merlin.data.tag.Tag;
import merlin.data.tag.TagsUtil;
import merlin.gui.StrTagsEditor;
import merlin.gui.filter.ObjsFilterEditor;
import merlin.gui.filter.ObjsFilterEditorComponents;
import merlin.gui.value.PopupValEditor;
import merlin.util.MerlinProps;
import org.jscience.physics.units.NonSI;
import thunderheadeng.gui.value.IValEditor;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.theUtil;

public class AttractorBuilder
extends MerlinProps
implements IEventObserver {
    public static final Object COMPLETED = new Object();
    public static final IPropertySet.Prop<IEgressOccupiable> ROOM = new IPropertySet.Prop<Object>(6435503, null);
    public static final DisplayProp<ObjsFilter<String>> OCC_TAG_FILTER = ((DisplayProps.Builder)((DisplayProps.Builder)DisplayProps.buildGeneric(Attractor.OCC_TAG_FILTER.key, ObjsFilter.class, ObjsFilter.acceptAll(String.class), Attractor.OCC_TAG_FILTER.name, Attractor.OCC_TAG_FILTER.desc).attrValEditor((md, inline) -> {
        Supplier<IValEditor> getEditor = () -> new ObjsFilterEditor<String>(new ObjsFilterEditorComponents<String>(null, String.class, new StrTagsEditor(true)));
        if (!inline) {
            return new PopupValEditor<ObjsFilter>(PopupValEditor.Mode.HTML, ObjsFilter.class, Intl.intl("Allow Occupants with Tags"), getEditor, v -> v.format(30));
        }
        return getEditor.get();
    })).attrFormatValue(v -> v.format(30))).attrToProp();

    public AttractorBuilder(MerlinData md) {
        this.set(Attractor.BEHAVIOR, Attractor.WAIT_AT_ATTRACTOR_BEHAVIOR);
        this.set(Attractor.WAIT_TIME, new ConstantCurve(new UnitDouble(1.0, NonSI.MINUTE)));
        md.getEvents().addObserver(this);
    }

    public void setLocation(IEgressOccupiable room, Vector3d roomNormal, Point3d loc) {
        this.pause();
        this.set(ROOM, room);
        this.set(Attractor.LOCATION, loc);
        this.set(Attractor.ROOM_NORMAL, roomNormal);
        this.resume();
    }

    public boolean isValid() {
        if (this.get(Attractor.BEHAVIOR) == null) {
            return false;
        }
        if (Attractor.requiresLocation(this) && this.get(ROOM) == null) {
            return false;
        }
        return this.get(Attractor.AWARENESS) != Attractor.Awareness.ROOMS || !this.get(Attractor.ROOMS).isEmpty();
    }

    @Override
    public void update(Events events) {
        if (events.getEvents(Behavior.class, new Class[0]).getRemovedObjs().contains(this.get(Attractor.BEHAVIOR))) {
            this.set(Attractor.BEHAVIOR, Attractor.WAIT_AT_ATTRACTOR_BEHAVIOR);
        }
    }

    public void create(Component c) {
        if (!this.isValid()) {
            return;
        }
        final Attractor attr = this.createAttractor();
        AMerlinOp op = new AMerlinOp(){

            @Override
            public void run(MerlinApp app, MerlinData md) {
                try (MerlinData.WriteLock lock = md.lockWrite();){
                    Undo.begin(Intl.intl("New Trigger"));
                    String name = md.attractorsNameGen.getCurrentName();
                    md.attractorsNameGen.nextName();
                    attr.setName(name);
                    AddObject.add(md, md.attractors, md.attractors.getMembers().size(), Collections.singleton(attr));
                    ObjsFilter<String> strTagsFilter = AttractorBuilder.this.get(OCC_TAG_FILTER);
                    attr.set(Attractor.OCC_TAG_FILTER, new ObjsFilter<Tag>(strTagsFilter.mode, strTagsFilter.rejected, TagsUtil.getOrCreateTags(strTagsFilter.objects, md)));
                    Undo.end(md);
                }
            }
        };
        UIHook.run(c, "AttractorBuilder.create", op, 4);
        this.firePropChanged(COMPLETED);
    }

    public Attractor createAttractor() {
        Attractor attr = new Attractor("temp");
        attr.setLocation(this.get(ROOM), this.get(Attractor.ROOM_NORMAL), this.get(Attractor.LOCATION));
        for (IPropertySet.Prop prop : theUtil.filter(Attractor.PROPS.props(), IPropertySet.Prop.class)) {
            attr.set(prop, this.get(prop));
        }
        return attr;
    }
}

