/*
 * Decompiled with CFR 0.152.
 */
package merlin.builders;

import common.data.ClientAwareness;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import merlin.MerlinApp;
import merlin.builders.ABehaviorActionBuilder;
import merlin.data.AssistedEvacTeam;
import merlin.data.MerlinData;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.AssistOccupants;
import merlin.data.egress.scripting.DetachAssistants;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.egress.scripting.WaitForAssistance;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.RProp;
import thunderheadeng.util.RWProp;

public class AssistedEvacActionBuilder
extends ABehaviorActionBuilder
implements IEventObserver {
    public static final RWProp<Type> TYPE = new RWProp<Type>((Object)"AssistedEvacActionBuilder.TYPE", Type.class, Type.ASSIST);
    public static final RProp<Boolean> VALID = new RProp<Boolean>((Object)"AssistedEvacActionBuilder.VALID", Boolean.class, false);
    public static final Prop<Set<AssistedEvacTeam>> TEAMS = new Prop(Type.WAIT_FOR_ASSISTANCE, "AssistedEvacActionBuilder.TEAMS", Set.class, Collections.emptySet());
    public static final Prop<AssistedEvacTeam> TEAM = new Prop<AssistedEvacTeam>(Type.ASSIST, "AssistedEvacActionBuilder.TEAM", AssistedEvacTeam.class);
    public static final Prop<ClientAwareness> CLIENT_AWARENESS = new Prop<ClientAwareness>(Type.ASSIST, "AssistedEvacActionBuilder.CLIENT_AWARENESS", ClientAwareness.class, (ClientAwareness)((Object)AssistOccupants.CLIENT_AWARENESS.getDefaultVal()));
    public static final Prop<Set<IEgressOccupiable>> ROOMS = new Prop(Type.ASSIST, "AssistedEvacActionBuilder.ROOMS", Set.class, Collections.emptySet());
    public static final Prop<UnitDouble> AWARENESS_RADIUS = new Prop<UnitDouble>(Type.ASSIST, "AssistedEvacActionBuilder.AWARENESS_RADIUS", UnitDouble.class, (UnitDouble)AssistOccupants.AWARENESS_RADIUS.getDefaultVal());
    private PropertySet d_props = new PropertySet();

    public AssistedEvacActionBuilder(MerlinData md, Type initialType) {
        super(md);
        MerlinApp.getApp().getData().getEvents().addObserver(this);
        this.set(TYPE, (Object)((Object)initialType));
        this.reset();
    }

    public <T> void set(RWProp<T> prop, T value) {
        if (!this.lock()) {
            return;
        }
        try {
            this.setLocked(prop, value);
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void setLocked(RWProp<T> prop, T value) {
        this.pause();
        try {
            if (prop instanceof Prop) {
                Prop p = (Prop)prop;
                this.setLocked(TYPE, p.type);
            }
            if (Objects.equals(this.get(prop), value)) {
                return;
            }
            this.d_props.setIfNotDefault(prop, value);
            this.firePropChanged(prop);
            this.firePropChanged(VALID);
            this.firePropChanged(VALIDITY);
        }
        finally {
            this.resume();
        }
    }

    public <T> T get(RProp<T> prop) {
        if (prop == VALID) {
            return (T)Boolean.valueOf(this.isValid());
        }
        return this.d_props.get(prop);
    }

    @Override
    public boolean isValid() {
        switch (this.get(TYPE).ordinal()) {
            case 2: {
                return this.get(TEAM) != null && (this.get(CLIENT_AWARENESS) != ClientAwareness.ROOMS || !this.get(ROOMS).isEmpty());
            }
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected IBehaviorAction create(MerlinData md) {
        switch (this.get(TYPE).ordinal()) {
            case 0: {
                return new WaitForAssistance(this.get(TEAMS));
            }
            case 1: {
                return new DetachAssistants();
            }
            case 2: {
                AssistOccupants assist = new AssistOccupants(this.get(TEAM));
                ClientAwareness awareness = this.get(CLIENT_AWARENESS);
                assist.set(AssistOccupants.CLIENT_AWARENESS, awareness);
                if (awareness == ClientAwareness.ROOMS) {
                    assist.set(AssistOccupants.ROOMS, this.get(ROOMS));
                } else if (awareness == ClientAwareness.LINE_OF_SIGHT) {
                    assist.set(AssistOccupants.AWARENESS_RADIUS, this.get(AWARENESS_RADIUS));
                }
                return assist;
            }
        }
        return null;
    }

    @Override
    public void reset() {
        Collection<AssistedEvacTeam> teams;
        if (this.get(TYPE) == Type.ASSIST && this.get(TEAM) == null && !(teams = MerlinApp.getApp().getData().assistedEvacTeams.flatten(AssistedEvacTeam.class)).isEmpty()) {
            this.set(TEAM, (T)teams.iterator().next());
        }
    }

    @Override
    protected String getName(MerlinData md) {
        return this.create(md).getName();
    }

    @Override
    protected boolean mustBeLast(MerlinData md) {
        return this.create(md).mustBeLast();
    }

    @Override
    public void update(Events events) {
        super.update(events);
        IdentityHashSet teams = new IdentityHashSet((Collection)this.get(TEAMS));
        for (EventChannel<AssistedEvacTeam> channel : events.getAffectedChannels(AssistedEvacTeam.class, new Class[0])) {
            for (AssistedEvacTeam team : channel.getRemovedObjs()) {
                if (this.get(TEAM) == team) {
                    this.set(TEAM, (T)null);
                    this.reset();
                }
                teams.remove(team);
            }
        }
        if (this.get(TYPE) == Type.WAIT_FOR_ASSISTANCE) {
            this.set(TEAMS, (T)teams);
        }
        if (this.get(TYPE) == Type.ASSIST) {
            IdentityHashSet rooms = new IdentityHashSet((Collection)this.get(ROOMS));
            for (EventChannel<IEgressOccupiable> channel : events.getAffectedChannels(IEgressOccupiable.class, new Class[0])) {
                for (IEgressOccupiable room : channel.getRemovedObjs()) {
                    rooms.remove(room);
                }
            }
            this.set(ROOMS, (T)rooms);
        }
    }

    public static class Prop<T>
    extends RWProp<T> {
        public final Type type;

        public Prop(Type type, Object key, Class<T> valType, T defVal) {
            super(key, valType, defVal);
            this.type = type;
        }

        public Prop(Type type, Object key, Class<T> clazz) {
            super(key, clazz);
            this.type = type;
        }
    }

    public static enum Type {
        WAIT_FOR_ASSISTANCE,
        DETACH_ASSISTANTS,
        ASSIST;

    }
}

