/*
 * Decompiled with CFR 0.152.
 */
package merlin.builders;

import java.awt.Component;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.swing.JOptionPane;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.AddObject;
import merlin.actions.Delete;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import merlin.data.egress.scripting.Behavior;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.util.MerlinProps;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Sets;

public abstract class ABehaviorActionBuilder
extends MerlinProps
implements IEventObserver {
    public static final Object BEHAVIOR_CHANGED = "ABehaviorActionBuilder.BEHAVIOR_CHANGED";
    public static final Object COMMITTED = "ABehaviorActionBuilder.COMMITTED";
    public static final Object CANCELLED = "ABehaviorActionBuilder.CANCELLED";
    public static final Object VALIDITY = "ABehaviorActionBuilder.VALID";
    private final MerlinData d_data;
    private Behavior d_currentBehavior;
    private IBehaviorAction d_insertAfterAction;
    private final Predicate<Object> d_validityProps;
    private BiConsumer<MerlinData, ? super ABehaviorActionBuilder> d_delayedCommit = (md, b) -> {};

    public ABehaviorActionBuilder(MerlinData md) {
        this(md, Filters.rejectAll());
    }

    public ABehaviorActionBuilder(MerlinData md2, Predicate<Object> validityProps) {
        this.d_data = md2;
        this.d_validityProps = validityProps;
        SelectionObserver.add(this, Behavior.class, IBehaviorAction.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void set(IPropertySet.Prop<T> prop, T val) {
        block8: {
            this.pause();
            try {
                super.set(prop, val);
                if (!this.d_validityProps.test(prop)) break block8;
                if (!this.lock()) {
                    return;
                }
                try {
                    this.firePropChanged(VALIDITY);
                }
                finally {
                    this.release();
                }
            }
            finally {
                this.resume();
            }
        }
    }

    public void setDelayedCommit(BiConsumer<MerlinData, ? super ABehaviorActionBuilder> commit) {
        this.d_delayedCommit = commit;
    }

    protected abstract void reset();

    public abstract boolean isValid();

    protected abstract boolean mustBeLast(MerlinData var1);

    protected abstract String getName(MerlinData var1);

    protected abstract IBehaviorAction create(MerlinData var1);

    @Override
    public void update(Events events) {
        Behavior behavior = null;
        IBehaviorAction action = null;
        if (this.d_data.selection.isExclusive(Behavior.class)) {
            behavior = (Behavior)this.d_data.selection.getSelected(Behavior.class).iterator().next();
        } else if (this.d_data.selection.isExclusive(IBehaviorAction.class)) {
            action = (IBehaviorAction)this.d_data.selection.getSelected(IBehaviorAction.class).iterator().next();
            behavior = (Behavior)this.d_data.hierarchy.getParent(action);
        }
        this.setCurrentBehavior(behavior, action);
    }

    protected void setCurrentBehavior(Behavior behavior, IBehaviorAction insertAfterAction) {
        if (!this.lock()) {
            return;
        }
        this.d_currentBehavior = behavior;
        this.d_insertAfterAction = insertAfterAction;
        this.firePropChanged(BEHAVIOR_CHANGED);
        this.release();
    }

    public Behavior getCurrentBehavior() {
        return this.d_currentBehavior;
    }

    public IBehaviorAction getInsertAfterAction() {
        return this.d_insertAfterAction;
    }

    public void cancel() {
        this.reset();
        this.firePropChanged(CANCELLED);
    }

    protected boolean validate(Component c) {
        return true;
    }

    public void commit(Component c) {
        assert (this.d_currentBehavior != null);
        if (!this.isValid()) {
            return;
        }
        if (!this.validate(c)) {
            return;
        }
        AMerlinOp op = new AMerlinOp(){

            @Override
            public void run(MerlinApp app, MerlinData md) {
                boolean add;
                IBehaviorAction existingLastAction = ABehaviorActionBuilder.this.d_currentBehavior.flatten(IBehaviorAction.class, ba -> ba.mustBeLast()).stream().findAny().orElse(null);
                if (ABehaviorActionBuilder.this.mustBeLast(md) && existingLastAction != null && !(add = md.ui(() -> {
                    int choice = JOptionPane.showConfirmDialog(app.getActiveFrame(), String.format(Intl.intl("The new action, \"%1$s\", will replace \"%2$s\"."), ABehaviorActionBuilder.this.getName(md), existingLastAction.getName()), Intl.intl("Delete Existing Action?"), 2);
                    return choice == 0;
                }).booleanValue())) {
                    return;
                }
                try (MerlinData.WriteLock lock = md.lockWrite();){
                    int ix;
                    Undo.begin(Intl.intl("Add Action"));
                    ABehaviorActionBuilder.this.d_delayedCommit.accept(md, ABehaviorActionBuilder.this);
                    IBehaviorAction newAction = ABehaviorActionBuilder.this.create(md);
                    if (newAction.mustBeLast()) {
                        if (existingLastAction != null) {
                            Delete.headlessDelete(md, Sets.fromArrayLIHS(existingLastAction), true);
                        }
                        ix = ABehaviorActionBuilder.this.d_currentBehavior.getMembers().size();
                    } else {
                        ix = ABehaviorActionBuilder.this.d_currentBehavior.indexOf(ABehaviorActionBuilder.this.d_insertAfterAction) + 1;
                    }
                    AddObject.add((MerlinData)md, (Composite)ABehaviorActionBuilder.this.d_currentBehavior, (int)ix, (ICompElement[])new IBehaviorAction[]{newAction});
                    Undo.end(md);
                }
                ABehaviorActionBuilder.this.reset();
            }
        };
        UIHook.run(c, "ABehaviorActionBuilder.commit", op, 4);
        this.firePropChanged(COMMITTED);
    }
}

