/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions.importinferno;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.JOptionPane;
import javax.vecmath.Point3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.MerlinPrefs;
import merlin.actions.AMerlinOp;
import merlin.actions.Undo;
import merlin.actions.importgeom.Import;
import merlin.actions.importinferno.EgressType;
import merlin.data.Composite;
import merlin.data.MerlinData;
import merlin.data.SimParams;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.OccLocation;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.geom.EgressRoom;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.geom.GeomUtil;
import merlin.geom.Geometry;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.util.FileFilters;

public abstract class ImportInferno
extends AMerlinOp {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        if (!app.promptSaveIfModified()) {
            return;
        }
        guiJFXFileChooser chooser = new guiJFXFileChooser(null, MerlinPrefs.get(MerlinPrefs.OPEN_DIR_PREF), null, (Boolean)false, (Boolean)false, (Boolean)false, FileFilters.EXT_FILTER_INFERNO);
        File f = chooser.showOpenDialog();
        if (f == null) {
            return;
        }
        MerlinPrefs.set(MerlinPrefs.OPEN_DIR_PREF, f.getParent());
        app.beginWaitCursor();
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
            try (MerlinData.WriteLock lock = md.lockWrite();){
                Undo.insertEntry_breakChain(md);
                md.reset();
                this.parse(is, md);
                md.getEvents().changed(md, Import.MODEL_IMPORTED);
            }
            System.gc();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(Application.getApp().getActiveFrame(), String.format(Intl.intl("Could not open file: %s"), f.getAbsolutePath()), Intl.intl("File error"), 0);
            return;
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            app.endWaitCursor();
        }
    }

    protected abstract void parse(InputStream var1, MerlinData var2);

    protected EgressRoom findMergeGeom(MerlinData md, Composite<IEgressComp> node, EgressType terrain, Point3d ... polyPoints) {
        IPolygon poly = PolyUtil.newPoly(polyPoints);
        Plane3d plane = poly.getPlane(true);
        for (EgressRoom geom : node.getMembers(EgressRoom.class)) {
            for (IFace face : thunderheadeng.geometry.objs.GeomUtil.explode(geom.getGeom().flatten().getLocalGeom(), IFace.class)) {
                List<? extends IPolygon> planarFaces = GeomUtil.toPolys(face, md.simParams.get(SimParams.EDGE_ERROR));
                for (IPolygon iPolygon : planarFaces) {
                    Plane3d pfplane = iPolygon.getPlane(true);
                    if (!plane.epsilonEquals(pfplane, 1.0E-6)) continue;
                    return geom;
                }
            }
        }
        Model model = new Model();
        GeomUtil.addFaceToModel(poly, model, 0, 0.0, 0.0);
        int[] group = new int[]{1};
        for (Edge edge : model.getEdges()) {
            edge.groups = group;
        }
        EgressRoom geom = new EgressRoom("mesh", model);
        node.add(geom);
        return geom;
    }

    protected static EgressRoom toTempRoom(Point3d ... points) {
        ArrayList<LineSeg3D> segs = new ArrayList<LineSeg3D>();
        for (int m = 0; m < points.length; ++m) {
            Point3d p1 = points[m];
            Point3d p2 = points[(m + 1) % points.length];
            segs.add(new LineSeg3D(p1, p2));
        }
        Model model = new Model();
        if (GeomUtil.addFaceToModel(model, 0, new Plane3d(true, points), segs)) {
            return new EgressRoom("", model);
        }
        return null;
    }

    protected boolean addOcc(MerlinData mdd, EgressAgent agent, String x, String y, String z) {
        Point3d loc = new Point3d(Double.parseDouble(x), Double.parseDouble(y), Double.parseDouble(z));
        Predicate<IEgressOccupiable> roomFilter = agent.getRoomFilter();
        int options = 2;
        OccLocation occLoc = mdd.findValidOccLocation((OccProfile.OccShape)agent.getProfile().getProperty(OccProfile.PROP_SHAPE), loc, EgressAgent.AVG_SHOULDER_WIDTH, agent.getAngle().getValue(Geometry.ANGLE_UNIT), options, roomFilter);
        if (occLoc.room == null) {
            return false;
        }
        agent.setLocation(occLoc);
        mdd.agents.add(agent);
        return true;
    }
}

