/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions.geomops;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.swing.JOptionPane;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.MerlinData;
import merlin.data.egress.geom.EgressModelGeom;
import merlin.data.egress.geom.EgressRoom;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.Nullable;
import thunderheadeng.util.TaskProgress;
import thunderheadeng.util.theUtil;

public class CleanupRooms
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new CleanupRooms(), Intl.intl("Remove extra vertices...,-,Remove extra vertices on unused edges."));

    public CleanupRooms() {
        SelectionObserver.add(this, EgressRoom.class);
        this.update(null);
    }

    protected Set<EgressRoom> getValidRooms(MerlinData md) {
        return theUtil.filter(md.selection.getDeepSelected(EgressRoom.class), EgressRoom::getModificationsAllowed);
    }

    @Override
    public void update(Events events) {
        this.setEnabled(MerlinApp.getApp().getData().selection.isExclusive(EgressRoom.class));
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        TaskProgress progress = new TaskProgress();
        LinkedIdentityHashMap newRoomGeom = new LinkedIdentityHashMap();
        Optional<Nullable<Integer>> removed = this.execLongReadTaskNoThrowOpt(app.getMainFrame(), md, Intl.intl("Removing Extra Vertices"), progress, () -> {
            int vertsRemoved = 0;
            Set<EgressRoom> rooms = this.getValidRooms(md);
            for (EgressRoom room : rooms) {
                progress.check();
                Model model = room.getModel();
                Model newModel = room.cleanup(model);
                if (newModel == model) continue;
                if (newModel.getVerts().size() < model.getVerts().size()) {
                    vertsRemoved += model.getVerts().size() - newModel.getVerts().size();
                }
                newRoomGeom.put(room, newModel);
            }
            progress.check();
            return vertsRemoved;
        });
        if (removed.isEmpty()) {
            return;
        }
        if (!newRoomGeom.isEmpty()) {
            try (MerlinData.WriteLock lock = md.lockWrite();){
                Undo.begin(Intl.intl("Remove Extra Vertices"));
                for (Map.Entry entry : newRoomGeom.entrySet()) {
                    EgressRoom room = (EgressRoom)entry.getKey();
                    Model newModel = (Model)entry.getValue();
                    Undo.insertUndoEntry_restore(md, room);
                    room.setGeom(new EgressModelGeom(newModel));
                }
                Undo.end(md);
            }
        }
        JOptionPane.showMessageDialog(app.getActiveFrame(), String.format(Intl.intl("Vertices removed: %d"), removed.get().val), Intl.intl("Removed Vertices"), 1);
    }
}

