/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions.floorextract;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import merlin.Intl;
import merlin.data.MerlinData;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.agents.VehicleShape;
import merlin.unitsystem.SIUS;
import org.jscience.physics.units.Unit;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.IDistributedVal;
import thunderheadeng.util.stat.LogNormCurve;
import thunderheadeng.util.stat.StdNormCurve;
import thunderheadeng.util.stat.UniformCurve;
import thunderheadeng.util.stat.Urn;
import thunderheadeng.util.theUtil;

public class Evac4BIMParseUtil {
    public static IDistributedVal<UnitDouble> parseDist(String dist, Unit unit, double constantVal) throws IllegalArgumentException {
        try {
            try {
                double val = theUtil.parseDoubleRobust(dist);
                return new ConstantCurve(new UnitDouble(val, unit));
            }
            catch (RuntimeException e) {
                String type;
                StringTokenizer tokenizer = new StringTokenizer(dist, "(),", false);
                switch (type = tokenizer.nextToken()) {
                    case "Constant": {
                        return new ConstantCurve(new UnitDouble(constantVal, unit));
                    }
                    case "Uniform": {
                        if (tokenizer.countTokens() >= 2) {
                            double min = theUtil.parseDoubleRobust(tokenizer.nextToken());
                            double max = theUtil.parseDoubleRobust(tokenizer.nextToken());
                            return new UniformCurve(new UnitDouble(min, unit), new UnitDouble(max, unit));
                        }
                        throw new IllegalArgumentException("Wrong number of arguments for Uniform distribution");
                    }
                    case "Normal": {
                        if (tokenizer.countTokens() >= 4) {
                            double min = theUtil.parseDoubleRobust(tokenizer.nextToken());
                            double max = theUtil.parseDoubleRobust(tokenizer.nextToken());
                            double mean = theUtil.parseDoubleRobust(tokenizer.nextToken());
                            double stdDev = theUtil.parseDoubleRobust(tokenizer.nextToken());
                            return new StdNormCurve(new UnitDouble(min, unit), new UnitDouble(max, unit), new UnitDouble(mean, unit), new UnitDouble(stdDev, unit));
                        }
                        throw new IllegalArgumentException("Wrong number of arguments for Normal distribution");
                    }
                    case "LogNormal": {
                        if (tokenizer.countTokens() >= 4) {
                            double min = theUtil.parseDoubleRobust(tokenizer.nextToken());
                            double max = theUtil.parseDoubleRobust(tokenizer.nextToken());
                            double location = theUtil.parseDoubleRobust(tokenizer.nextToken());
                            double scale = theUtil.parseDoubleRobust(tokenizer.nextToken());
                            return new LogNormCurve(new UnitDouble(min, unit), new UnitDouble(max, unit), new UnitDouble(location, unit), new UnitDouble(scale, unit));
                        }
                        throw new IllegalArgumentException("Wrong number of arguments for LogNormal distribution");
                    }
                }
                throw new IllegalArgumentException("Invalid distribution specified");
            }
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(t.getMessage(), t);
        }
    }

    private static Collection<Map<String, String>> parseProfileProps(String profiles) throws IllegalArgumentException {
        try {
            StringTokenizer tokenizer = new StringTokenizer(profiles, "{}=;", true);
            ArrayList<Map<String, String>> parsed = new ArrayList<Map<String, String>>();
            HashMap<String, String> current = null;
            block12: while (tokenizer.hasMoreTokens()) {
                String token;
                switch (token = tokenizer.nextToken()) {
                    case "{": {
                        current = new HashMap<String, String>();
                        continue block12;
                    }
                    case "}": {
                        if (current == null) {
                            throw new IllegalArgumentException("Profile description must begin with {");
                        }
                        parsed.add(current);
                        current = null;
                        continue block12;
                    }
                    case ";": {
                        continue block12;
                    }
                }
                if (current == null) {
                    throw new IllegalArgumentException("Profile description must begin with {");
                }
                String prop = token.trim();
                if (tokenizer.countTokens() < 2 || !tokenizer.nextToken().equals("=") || (token = tokenizer.nextToken()).equals(";")) continue;
                current.put(prop, token.trim());
            }
            return parsed;
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(t.getMessage(), t);
        }
    }

    public static Collection<OccProfile> parseProfiles(String profiles, MerlinData md) {
        try {
            Optional<VehicleShape> impairedShape = md.vehicleShapes.flatten(VehicleShape.class).stream().filter(shape -> shape.getProperty(VehicleShape.PROP_ANIM_TAGS).equals(VehicleShape.AnimType.WHEELCHAIR.tags) && shape.getName().equals(Intl.intl("Default Wheelchair"))).findFirst();
            Collection<Map<String, String>> props = Evac4BIMParseUtil.parseProfileProps(profiles);
            ArrayList<OccProfile> createdProfiles = new ArrayList<OccProfile>();
            for (Map<String, String> propSet : props) {
                if (!propSet.containsKey("name")) continue;
                OccProfile profile = new OccProfile();
                profile.setName(propSet.get("name"));
                if (propSet.containsKey("speedProfile")) {
                    double constSpeed = theUtil.parseDoubleRobust(propSet.getOrDefault("speed", "0"));
                    profile.setProperty(OccProfile.PROP_MAXVEL, Evac4BIMParseUtil.parseDist(propSet.get("speedProfile"), SIUS.unit(5), constSpeed));
                }
                if (propSet.containsKey("diameter")) {
                    profile.setProperty(OccProfile.PROP_DIAMETER, new ConstantCurve(new UnitDouble(theUtil.parseDoubleRobust(propSet.get("diameter")), SIUS.unit(6))));
                }
                if (propSet.containsKey("isMobilityImpaired") && Boolean.parseBoolean(propSet.get("isMobilityImpaired"))) {
                    profile.setProperty(OccProfile.PROP_REQUIRES_ASSISTANCE, new Urn<Boolean>(true));
                    impairedShape.ifPresent(vehicleShape -> profile.setProperty(OccProfile.PROP_VEHICLE_SHAPE, vehicleShape));
                }
                createdProfiles.add(profile);
            }
            return createdProfiles;
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(t.getMessage(), t);
        }
    }
}

