/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions.copypaste;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Predicate;
import merlin.MerlinApp;
import merlin.actions.copypaste.CopyPasteUtil;
import merlin.actions.copypaste.PasteHandler;
import merlin.actions.copypaste.PasteHints;
import merlin.data.Composite;
import merlin.data.GeomComposite;
import merlin.data.MerlinData;
import merlin.data.OccSourceObj;
import merlin.data.egress.agents.EgressAgentComp;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.util.Warning;

public class GeomPasteHandler
implements PasteHandler {
    @Override
    public boolean isHandlerFor(IDomainObject obj, String mdRootClassName) {
        return GeomComposite.class.getName().equals(mdRootClassName) || EgressAgentComp.class.getName().equals(mdRootClassName) || OccSourceObj.OccSourceComp.class.getName().equals(mdRootClassName);
    }

    public boolean shouldRename(String mdRootClassName) {
        return EgressAgentComp.class.getName().equals(mdRootClassName);
    }

    @Override
    public PasteHints getPasteHints(MerlinData md, IDomainObject pasteObj) {
        return CopyPasteUtil.getGeomPasteHints(md, pasteObj);
    }

    @Override
    public void pasteApply(MerlinData md, MerlinApp app, Predicate<? super IDomainObject> isPasteObj, Consumer<? super IDomainObject> allPastedObjs, Consumer<? super Warning> warnings, Collection<? extends PasteHandler.PasteEntry> entries) {
        for (PasteHandler.PasteEntry pasteEntry : entries) {
            Composite insertRoot = (Composite)pasteEntry.pasteLoc();
            boolean shouldRename = this.shouldRename(insertRoot.getClass().getName());
            CopyPasteUtil.pasteIntoAndTransform(md, app, pasteEntry.pasteObj(), pasteEntry.hints(), allPastedObjs, insertRoot, -1, shouldRename ? CopyPasteUtil.DEFAULT_NAME_GEN : null);
        }
    }
}

