/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions.copypaste;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import merlin.MerlinApp;
import merlin.actions.copypaste.CopyPasteUtil;
import merlin.actions.copypaste.PasteHandler;
import merlin.actions.copypaste.PasteHints;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.INamed;
import merlin.data.MerlinData;
import merlin.util.MerlinUtil;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.util.Warning;

public class DefaultPasteHandler
implements PasteHandler {
    public final Class<?> rootType;
    public final CopyPasteUtil.INameGenerator generateName;
    public final Set<Class<?>> uniqueNameTypes;

    public DefaultPasteHandler(Class<?> rootType) {
        this(rootType, Collections.emptySet(), CopyPasteUtil.DEFAULT_NAME_GEN);
    }

    public DefaultPasteHandler(Class<?> rootType, Set<Class<?>> uniqueNameTypes, CopyPasteUtil.INameGenerator nameGen) {
        this.rootType = rootType;
        this.uniqueNameTypes = uniqueNameTypes;
        this.generateName = nameGen;
    }

    @Override
    public boolean isHandlerFor(IDomainObject obj, String mdRootField) {
        return this.rootType.getName().equals(mdRootField);
    }

    @Override
    public PasteHints getPasteHints(MerlinData md, IDomainObject pasteObj) {
        return new PasteHints();
    }

    @Override
    public void pasteApply(MerlinData md, MerlinApp app, Predicate<? super IDomainObject> isPasteObj, Consumer<? super IDomainObject> allPastedObjs, Consumer<? super Warning> warnings, Collection<? extends PasteHandler.PasteEntry> entries) {
        for (PasteHandler.PasteEntry pasteEntry : entries) {
            IDomainObject pasteObj = pasteEntry.pasteObj();
            Composite<ICompElement> defaultRoot = CopyPasteUtil.getDefaultRoot(md, pasteObj, pasteEntry.mdRootClassName());
            Composite insertRoot = (Composite)pasteEntry.pasteLoc();
            HashMap inUseNames = new HashMap();
            BiConsumer<IDomainObject, Boolean> testRename = (obj, forceRename) -> {
                Class renameSibType = this.uniqueNameTypes.stream().filter(c -> c.isAssignableFrom(obj.getClass())).findFirst().orElse(null);
                if (renameSibType == null && !forceRename.booleanValue()) {
                    return;
                }
                Set inUse = inUseNames.computeIfAbsent(renameSibType, t -> {
                    Collection<INamed> nameSibs = t == null ? insertRoot.getMembers(INamed.class) : defaultRoot.flatten(INamed.class, t::isInstance);
                    return CopyPasteUtil.getInUseNames(nameSibs);
                });
                CopyPasteUtil.renamePasteObj(obj, inUse, this.generateName);
            };
            testRename.accept(pasteObj, true);
            for (IDomainObject descendant : MerlinUtil.flatten(Collections.singleton(pasteObj), IDomainObject.class, o -> o != pasteObj)) {
                testRename.accept(descendant, false);
            }
            CopyPasteUtil.pasteIntoAndTransform(md, app, pasteObj, pasteEntry.hints(), allPastedObjs, insertRoot, -1, null);
            allPastedObjs.accept(pasteObj);
        }
    }
}

