/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions.copypaste;

import inferno.elevator.ElevatorLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import merlin.EntryPoint;
import merlin.EntryPointFactory;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.TransformAction;
import merlin.actions.Undo;
import merlin.actions.copypaste.Paste;
import merlin.actions.copypaste.PasteHints;
import merlin.data.Composite;
import merlin.data.GeomComposite;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.INamed;
import merlin.data.MerlinData;
import merlin.data.OccGroupObj;
import merlin.data.egress.FloorComposite;
import merlin.data.egress.elevators.Elevator;
import merlin.data.egress.elevators.ElevatorGroup;
import merlin.data.egress.elevators.ElevatorRoot;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.scripting.Behavior;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.egress.scripting.attractors.Attractor;
import merlin.data.egress.scripting.attractors.AttractorComp;
import merlin.data.egress.scripting.attractors.AttractorTemplateComp;
import merlin.data.egress.scripting.queues.QueueObject;
import merlin.data.egress.scripting.queues.QueueObjectComp;
import merlin.data.egress.scripting.queues.QueuePath;
import merlin.data.egress.scripting.queues.QueuePathNode;
import merlin.geom.IMerlinGeomSrc;
import merlin.util.MerlinUtil;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxTest;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Warning;
import thunderheadeng.util.theUtil;

public class CopyPasteUtil {
    public static final INameGenerator DEFAULT_NAME_GEN = (srcName, n) -> n == null ? String.format(Intl.intl("%s - Copy"), srcName) : String.format(Intl.intl("%s - Copy (%d)"), srcName, n);

    public static boolean isGeomRoot(String mdRootClassName) {
        return GeomComposite.class.getName().equals(mdRootClassName) || FloorComposite.class.getName().equals(mdRootClassName) || ElevatorRoot.class.getName().equals(mdRootClassName);
    }

    public static Composite<ICompElement> getGeomRoot(MerlinData md, String mdRootClassName) {
        ElevatorRoot root;
        if (GeomComposite.class.getName().equals(mdRootClassName)) {
            root = md.sceneGeom;
        } else if (FloorComposite.class.getName().equals(mdRootClassName)) {
            root = md.floors;
        } else if (ElevatorRoot.class.getName().equals(mdRootClassName)) {
            root = md.elevators;
        } else {
            throw new IllegalArgumentException("No root for " + mdRootClassName);
        }
        return root;
    }

    public static Composite<ICompElement> getDefaultRoot(MerlinData md, IDomainObject pasteObj, String mdRootClassName) {
        if (CopyPasteUtil.isGeomRoot(mdRootClassName)) {
            return CopyPasteUtil.getGeomRoot(md, mdRootClassName);
        }
        EntryPoint<IDomainObject> ep = EntryPointFactory.get(pasteObj);
        return ep.getRootComposite(md);
    }

    public static String getRootString(MerlinData md, IDomainObject pasteObj) {
        Object[] rootPath;
        String mdRootClassName = "";
        EntryPoint<IDomainObject> ep = EntryPointFactory.get(pasteObj);
        Composite<ICompElement> root = ep.getRootComposite(md);
        if (root != null && (rootPath = md.hierarchy.getPath(root)).length > 1 && rootPath[0] == md) {
            mdRootClassName = rootPath[1].getClass().getName();
        }
        return mdRootClassName;
    }

    public static void pasteInto(MerlinData md, Composite dest, int insertIx, IDomainObject pasteObj) {
        Undo.UndoOp op = insertIx != -1 ? new Undo.InsertOp(dest, Collections.singleton(pasteObj), insertIx) : new Undo.AddOp(dest, Collections.singleton(pasteObj));
        Undo.insertEntry(md, op.perform());
    }

    public static boolean compositeCanContain(Composite comp, IDomainObject obj) {
        if (OccGroupObj.class.isAssignableFrom(comp.getClass())) {
            return false;
        }
        if (ElevatorGroup.class.isAssignableFrom(obj.getClass()) && !ElevatorRoot.class.isAssignableFrom(comp.getClass())) {
            return false;
        }
        if (ElevatorGroup.class.isAssignableFrom(comp.getClass()) && !Elevator.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        if (obj instanceof Attractor) {
            Attractor attractor = (Attractor)obj;
            if (attractor.isTemplate()) {
                return comp instanceof AttractorTemplateComp;
            }
            return comp instanceof AttractorComp;
        }
        HashMap<Class, Class> exclusiveParentChildMap = new HashMap<Class, Class>();
        exclusiveParentChildMap.put(Behavior.class, IBehaviorAction.class);
        exclusiveParentChildMap.put(Elevator.class, ElevatorLevel.class);
        exclusiveParentChildMap.put(QueueObjectComp.class, QueueObject.class);
        exclusiveParentChildMap.put(QueuePath.class, QueuePathNode.class);
        for (Map.Entry entry : exclusiveParentChildMap.entrySet()) {
            Class parentClass = (Class)entry.getKey();
            Class childClass = (Class)entry.getValue();
            if (parentClass.isAssignableFrom(comp.getClass()) && !childClass.isAssignableFrom(obj.getClass())) {
                return false;
            }
            if (!childClass.isAssignableFrom(obj.getClass()) || parentClass.isAssignableFrom(comp.getClass())) continue;
            return false;
        }
        return true;
    }

    private static Composite getDeepestComposite(IDomainObject pasteObj, Object[] path) {
        Composite deepest = null;
        for (Object obj : path) {
            if (!(obj instanceof Composite) || !CopyPasteUtil.compositeCanContain((Composite)obj, pasteObj)) continue;
            deepest = (Composite)obj;
        }
        return deepest;
    }

    public static Composite getBestPasteTarget(MerlinData md, IDomainObject pasteObj, Composite defaultRoot, Collection<Composite<ICompElement>> selectedComposites, Collection<IMerlinObj> selectedLeaves) {
        HashSet<IMerlinObj> potentialTargets = new HashSet<IMerlinObj>();
        potentialTargets.add(defaultRoot);
        potentialTargets.addAll(selectedComposites);
        potentialTargets.addAll(selectedLeaves);
        HashMap<Composite, Object[]> compatTargets = new HashMap<Composite, Object[]>();
        for (Object e : potentialTargets) {
            Composite deepestComp;
            Object[] path = md.hierarchy.getPath(e);
            if (path == null || path.length <= 1 || path[1] != defaultRoot || (deepestComp = CopyPasteUtil.getDeepestComposite(pasteObj, path)) == null) continue;
            compatTargets.put(deepestComp, md.hierarchy.getPath(deepestComp));
        }
        ArrayList sortedTargets = new ArrayList(compatTargets.keySet());
        Collections.sort(sortedTargets, (a, b) -> {
            Object[] pathToA = (Object[])compatTargets.get(a);
            Object[] pathToB = (Object[])compatTargets.get(b);
            return Integer.compare(pathToB.length, pathToA.length);
        });
        return compatTargets.isEmpty() ? null : (Composite)sortedTargets.get(0);
    }

    public static void renamePasteObj(Collection<INamed> siblingsToBe, IDomainObject pasteObj, INameGenerator generateName) {
        CopyPasteUtil.renamePasteObj(pasteObj, CopyPasteUtil.getInUseNames(siblingsToBe), generateName);
    }

    public static void renamePasteObj(IDomainObject pasteObj, Set<String> inUseNames, INameGenerator generateName) {
        if (pasteObj instanceof INamed) {
            INamed nobj = (INamed)((Object)pasteObj);
            String srcName = nobj.getName();
            String dstName = srcName;
            if (inUseNames.contains(dstName)) {
                dstName = generateName.generate(srcName, null);
            }
            int n = 2;
            while (inUseNames.contains(dstName)) {
                dstName = generateName.generate(srcName, n);
                ++n;
            }
            nobj.setName(dstName);
        }
    }

    public static Set<String> getInUseNames(Collection<INamed> siblingsToBe) {
        HashSet<String> inUseNames = new HashSet<String>();
        for (INamed siblingToBe : siblingsToBe) {
            inUseNames.add(siblingToBe.getName());
        }
        return inUseNames;
    }

    public static PasteHints getGeomPasteHints(MerlinData md, IDomainObject pasteObj) {
        PasteHints hints = new PasteHints();
        AABoxTest test = new AABoxTest(CopyPasteUtil.getBounds(pasteObj), 1.0E-6);
        final ArrayList hitComps = new ArrayList();
        IResult<IDisplayableGeomSrc> result = new IResult<IDisplayableGeomSrc>(){

            @Override
            public void mark(IDisplayableGeomSrc src, Containment ctmt) {
                if (src instanceof IEgressComp) {
                    hitComps.add((IEgressComp)src);
                }
            }
        };
        md.geomLocation.getLocator().find((ITest<AABox>)test, (IResult<? super IDisplayableGeomSrc>)result, 3);
        hints.geomTransformShouldPrompt = !hitComps.isEmpty();
        return hints;
    }

    private static AABox getBounds(IDomainObject<MerlinData> obj) {
        Collection<IMerlinGeomSrc> elems = CopyPasteUtil.flattenToType(obj, IMerlinGeomSrc.class);
        AABox bounds = new AABox();
        for (IMerlinGeomSrc elem : elems) {
            bounds.add(elem.getBounds());
        }
        return bounds;
    }

    public static <T> Collection<T> flattenToType(IDomainObject<MerlinData> obj, Class<T> type) {
        if (obj instanceof Composite) {
            return ((Composite)obj).flatten(type);
        }
        if (obj != null && type.isAssignableFrom(obj.getClass())) {
            return Arrays.asList(obj);
        }
        assert (false) : "Unknown geom element: " + String.valueOf(obj) != null ? obj.getClass() : "Null obj";
        return Collections.emptyList();
    }

    public static void pasteIntoAndTransform(MerlinData md, MerlinApp app, IDomainObject pasteObj, PasteHints hints, Consumer<? super IDomainObject> pastedObjs, Composite<ICompElement> insertRoot, int insertIx, INameGenerator generateName) {
        Collection<IMerlinObj> merlinObjs = CopyPasteUtil.flattenToType(pasteObj, IMerlinObj.class);
        try (MerlinData.WriteLock lock = md.lockWrite();){
            Undo.begin(Intl.intl("Set Offset"));
            Undo.insertUndoEntry_restoreSelection(md);
            if (generateName != null) {
                Collection<INamed> nameSibs = insertRoot.getMembers(INamed.class);
                CopyPasteUtil.renamePasteObj(nameSibs, pasteObj, generateName);
            }
            CopyPasteUtil.pasteInto(md, insertRoot, insertIx, pasteObj);
            Collection<IMerlinGeomSrc> geomObjs = TransformAction.getGeom(md, MerlinUtil.flatten(merlinObjs, IMerlinObj.class));
            TransformAction.transform(app, md, theUtil.map(geomObjs, o -> new Pair<IMerlinGeomSrc, TransformInfo>((IMerlinGeomSrc)o, hints.geomTransform)));
            Undo.end(md);
        }
        pastedObjs.accept(pasteObj);
    }

    public static boolean validInsertRoot(Class caller, IDomainObject pasteObj, IDomainObject pasteLoc, Consumer<? super Warning> warnings) {
        if (pasteLoc == null) {
            warnings.accept(CopyPasteUtil.getInsertRootWarning(caller, pasteObj));
        }
        return pasteLoc != null;
    }

    public static Warning getInsertRootWarning(Class caller, IDomainObject obj) {
        String name = String.format("%s:%s", MerlinUtil.getName(obj), obj.getClass().getSimpleName());
        System.err.printf("[WARN] [%s] unable to determine valid insert location: %s%n", caller.getName(), obj);
        return new Warning(Intl.intl("Unable to determine valid insert location."), String.format(Intl.intl("%s object was not pasted."), name));
    }

    public static Warning getPasteSupportWarning(IDomainObject obj, boolean onCopy) {
        String name = String.format("%s:%s", MerlinUtil.getName(obj), obj.getClass().getSimpleName());
        System.err.printf("[WARN] [%s] unsupported object skipped: %s%n", Paste.class.getName(), obj);
        return new Warning(String.format(Intl.intl("%s is not currently supported for copy/paste."), obj.getClass().getSimpleName()), onCopy ? String.format(Intl.intl("%s was not copied."), name) : String.format(Intl.intl("%s was not pasted."), name));
    }

    public static Warning getPasteDependencySupportWarning(IDirectDependent dependent, IDomainObject dependency) {
        String name = String.format("%s:%s", MerlinUtil.getName(dependency), dependency.getClass().getSimpleName());
        System.err.printf("[WARN] [%s] unresolved paste dependency %s%n", Paste.class.getName(), dependency);
        return new Warning(String.format(Intl.intl("%s is not currently supported for copy/paste."), dependency.getClass().getSimpleName()), String.format(Intl.intl("%1$s paste dependency: %2$s was removed."), dependent.getClass().getSimpleName(), name));
    }

    public static interface INameGenerator {
        public String generate(String var1, Integer var2);
    }
}

