/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions.copypaste;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Predicate;
import merlin.MerlinApp;
import merlin.actions.copypaste.CopyPasteUtil;
import merlin.actions.copypaste.PasteHandler;
import merlin.actions.copypaste.PasteHints;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.INamed;
import merlin.data.MerlinData;
import merlin.data.egress.scripting.attractors.Attractor;
import merlin.data.egress.scripting.attractors.AttractorComp;
import merlin.data.egress.scripting.attractors.AttractorRootComp;
import merlin.data.egress.scripting.attractors.AttractorTemplateComp;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.util.Warning;

public class AttractorPasteHandler
implements PasteHandler {
    @Override
    public boolean isHandlerFor(IDomainObject pasteObj, String mdRootField) {
        return AttractorRootComp.class.getName().equals(mdRootField);
    }

    @Override
    public PasteHints getPasteHints(MerlinData md, IDomainObject pasteObj) {
        return new PasteHints();
    }

    @Override
    public IDomainObject getPasteLocation(MerlinData md, Composite<ICompElement> defaultRoot, IDomainObject pasteObj, Collection<Composite<ICompElement>> selectedComposites, Collection<IMerlinObj> selectedLeaves) {
        ArrayList<IMerlinObj> candidateLeaves = new ArrayList<IMerlinObj>(selectedLeaves);
        if (pasteObj instanceof Attractor) {
            Attractor at = (Attractor)pasteObj;
            Composite secondLevelRoot = at.isTemplate() ? md.attractorTemplates : md.attractors;
            candidateLeaves.add(secondLevelRoot);
        } else if (pasteObj instanceof AttractorTemplateComp) {
            candidateLeaves.add(md.attractorTemplates);
        } else if (pasteObj instanceof AttractorComp) {
            candidateLeaves.add(md.attractors);
        }
        return CopyPasteUtil.getBestPasteTarget(md, pasteObj, defaultRoot, selectedComposites, candidateLeaves);
    }

    @Override
    public void pasteApply(MerlinData md, MerlinApp app, Predicate<? super IDomainObject> isPasteObj, Consumer<? super IDomainObject> allPastedObjs, Consumer<? super Warning> warnings, Collection<? extends PasteHandler.PasteEntry> entries) {
        for (PasteHandler.PasteEntry pasteEntry : entries) {
            Composite insertRoot = (Composite)pasteEntry.pasteLoc();
            Collection<INamed> nameSibs = insertRoot.getMembers(INamed.class);
            CopyPasteUtil.renamePasteObj(nameSibs, pasteEntry.pasteObj(), CopyPasteUtil.DEFAULT_NAME_GEN);
            CopyPasteUtil.pasteIntoAndTransform(md, app, pasteEntry.pasteObj(), pasteEntry.hints(), allPastedObjs, insertRoot, -1, CopyPasteUtil.DEFAULT_NAME_GEN);
            allPastedObjs.accept(pasteEntry.pasteObj());
        }
    }
}

