/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.vecmath.Matrix4d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.MerlinPrefs;
import merlin.actions.AMerlinOp;
import merlin.actions.UIHook;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.ImportedGeom;
import merlin.data.MerlinData;
import merlin.data.egress.blockages.EgressBlockage;
import merlin.data.image.BGImage;
import merlin.gui.guiUtil;
import merlin.util.MerlinUtil;
import thunderheadeng.cad.bim.BIMType;
import thunderheadeng.cad.out.TeciGeomWriter;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.image.IImage;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.util.FileFilters;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.TaskProgress;
import thunderheadeng.util.theUtil;

public class WriteVis
extends AMerlinOp {
    public static final UIHook UI_HOOK = new UIHook(new WriteVis(), Intl.intl("Export Imported Geometry file...,-,Write Imported Geometry file"));

    @Override
    public void run(MerlinApp app, MerlinData md) {
        Path defaultVis = md.getNewFilePath(".geom");
        guiJFXFileChooser chooser = new guiJFXFileChooser(defaultVis.getFileName().toString(), defaultVis.getParent() != null ? defaultVis.getParent().toString() : MerlinPrefs.get(MerlinPrefs.OPEN_DIR_PREF), null, (Boolean)false, (Boolean)false, (Boolean)false, FileFilters.EXT_FILTER_GEOM);
        File f = chooser.showSaveDialog();
        if (f == null) {
            return;
        }
        MerlinPrefs.set(MerlinPrefs.OPEN_DIR_PREF, f.getParent());
        try {
            TaskProgress progress = new TaskProgress();
            this.execLongReadTask(app.getActiveFrame(), md, Intl.intl("Writing Visualization File"), progress, () -> {
                WriteVis.writeVis(md, f, true);
                return null;
            });
        }
        catch (CancellationException e) {
            return;
        }
        catch (ExecutionException e) {
            guiUtil.showError(app, Intl.intl("Geom File Error"), Intl.intl("Could not create file"), e.getCause());
        }
    }

    public static boolean writeVis(MerlinData md, File f, boolean force) throws IOException {
        DisplayRecorder displays = new DisplayRecorder();
        Collection<BGImage> bgImages = md.sceneGeom.getDeepMembers(BGImage.class);
        Collection bgWrappers = bgImages.stream().map(BGWrapper::new).collect(Collectors.toList());
        displays.record(md.sceneGeom, md.sceneGeom.flatten(ImportedGeom.class, obj -> !obj.isA(BIMType.Space)), ImportedGeomWrapper::new);
        displays.record(md.blockages, md.blockages.flatten(EgressBlockage.class, blkg -> blkg.getDisplayType() == EgressBlockage.DisplayType.CAD_GEOM), BlockageWrapper::new);
        List<TeciGeomWriter.IObject> objects = displays.getAllDisplays();
        if (!force && objects.isEmpty() && bgWrappers.isEmpty()) {
            f.delete();
            return false;
        }
        TeciGeomWriter.writeVis(f, new TeciGeomWriter.Options(MerlinPrefs.getDouble(MerlinPrefs.DISPLAY_EDGE_ERROR), MerlinPrefs.getDouble(MerlinPrefs.DISPLAY_FACE_ERROR)), objects, bgWrappers);
        return true;
    }

    private static class DisplayRecorder {
        public final Set<ICompElement> usedGroups = new LinkedIdentityHashSet<ICompElement>();
        public final List<TeciGeomWriter.IObject> nonGroups = new ArrayList<TeciGeomWriter.IObject>();

        private DisplayRecorder() {
        }

        public void recordAncestors(Object root, ICompElement obj) {
            if (obj == root) {
                return;
            }
            Object parent = obj.getParent();
            if (parent instanceof ICompElement && parent != root) {
                this.recordAncestors(root, (ICompElement)parent);
                this.usedGroups.add((ICompElement)parent);
            }
        }

        public <T extends ICompElement> void record(Object root, Collection<T> objs, Function<T, TeciGeomWriter.IObject> convert) {
            for (ICompElement obj : objs) {
                this.recordAncestors(root, obj);
            }
            for (ICompElement obj : objs) {
                this.nonGroups.add(convert.apply(obj));
            }
        }

        public List<TeciGeomWriter.IObject> getAllDisplays() {
            ArrayList<TeciGeomWriter.IObject> objects = new ArrayList<TeciGeomWriter.IObject>(this.usedGroups.size() + this.nonGroups.size());
            objects.addAll(theUtil.map(this.usedGroups, CompositeWrapper::new));
            objects.addAll(this.nonGroups);
            return objects;
        }
    }

    private static class BGWrapper
    implements TeciGeomWriter.BGImage {
        public final BGImage img;

        public BGWrapper(BGImage img) {
            this.img = img;
        }

        @Override
        public Matrix4d getLWXform() {
            return this.img.getLWXform();
        }

        @Override
        public float getOpacity() {
            return this.img.getOpacity();
        }

        @Override
        public String getName() {
            return this.img.getName();
        }

        @Override
        public IImage getImage() {
            return this.img.getImage();
        }
    }

    private static class CompositeWrapper
    extends AGeomWrapper<ICompElement> {
        public CompositeWrapper(ICompElement elem) {
            super(elem);
        }

        @Override
        public boolean isVisible() {
            Boolean bvis;
            Object vis = ((ICompElement)this.obj).getProperty(MerlinData.VISIBILITY);
            return vis instanceof Boolean && (bvis = (Boolean)vis) != false || vis == ICompElement.NON_UNIFORM;
        }

        @Override
        public TeciGeomWriter.Type getType() {
            return TeciGeomWriter.Type.GROUP;
        }

        @Override
        public DisplayGeom getDisplay() {
            return DisplayGeom.EMPTY;
        }
    }

    private static class BlockageWrapper
    extends AGeomWrapper<EgressBlockage> {
        public BlockageWrapper(EgressBlockage ig) {
            super(ig);
            assert (ig.getDisplayType() == EgressBlockage.DisplayType.CAD_GEOM);
        }

        @Override
        public boolean isVisible() {
            return ((EgressBlockage)this.obj).isVisible();
        }

        @Override
        public TeciGeomWriter.Type getType() {
            return TeciGeomWriter.Type.REF_GEOM;
        }

        @Override
        public DisplayGeom getDisplay() {
            return ((EgressBlockage)this.obj).getProp(EgressBlockage.CAD_GEOM).get();
        }
    }

    private static class ImportedGeomWrapper
    extends AGeomWrapper<ImportedGeom> {
        public ImportedGeomWrapper(ImportedGeom ig) {
            super(ig);
        }

        @Override
        public DisplayGeom getDisplay() {
            return ((ImportedGeom)this.obj).getDisplayGeom();
        }

        @Override
        public boolean isVisible() {
            return ((ImportedGeom)this.obj).isVisible();
        }

        @Override
        public TeciGeomWriter.Type getType() {
            return ((ImportedGeom)this.obj).get(ImportedGeom.PROP_RESULTS_VISIBILITY).isAlways(true) ? TeciGeomWriter.Type.GENERIC : TeciGeomWriter.Type.REF_GEOM;
        }
    }

    private static abstract class AGeomWrapper<T extends IMerlinObj>
    implements TeciGeomWriter.IObject {
        public final T obj;

        public AGeomWrapper(T ig) {
            this.obj = ig;
        }

        @Override
        public String getName() {
            return MerlinUtil.getName(this.obj);
        }

        @Override
        public long getId() {
            return this.obj.getResultsId();
        }

        @Override
        public long getParentId() {
            Object parent = this.obj.getParent();
            if (parent instanceof IMerlinObj && parent != this.obj.getDomain()) {
                return ((IMerlinObj)parent).getResultsId();
            }
            return 0L;
        }

        @Override
        public Collection<Integer> getFDSRepIds() {
            return Collections.emptyList();
        }
    }
}

