/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.MerlinPrefs;
import merlin.actions.AMerlinOp;
import merlin.actions.UIHook;
import merlin.data.MerlinData;
import merlin.data.camera.Camera;
import merlin.data.camera.CameraTour;
import merlin.data.camera.CameraTourKeyFrame;
import merlin.data.camera.ICameraObj;
import merlin.gui.guiUtil;
import org.jscience.physics.units.SI;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.io.IOUtil;
import thunderheadeng.scene3d.nativebuffered.CameraRecord;
import thunderheadeng.scene3d.nativebuffered.PerspectiveCamera;
import thunderheadeng.util.FileFilters;

public class WriteViews
extends AMerlinOp {
    public static final UIHook UI_HOOK = new UIHook(new WriteViews(), Intl.intl("Export Views File...,-,Update the 3D Results Views file"));

    @Override
    public void run(MerlinApp app, MerlinData md) {
        Path defaultViews = md.getNewFilePath("_views.json");
        guiJFXFileChooser chooser = new guiJFXFileChooser(defaultViews.getFileName().toString(), defaultViews.getParent() != null ? defaultViews.getParent().toString() : MerlinPrefs.get(MerlinPrefs.OPEN_DIR_PREF), null, (Boolean)false, (Boolean)false, (Boolean)false, FileFilters.EXT_FILTER_JSON);
        File f = chooser.showSaveDialog();
        if (f == null) {
            return;
        }
        MerlinPrefs.set(MerlinPrefs.OPEN_DIR_PREF, f.getParent());
        WriteViews.writeInputFile(app, md, f.getAbsolutePath());
    }

    public static boolean writeInputFile(MerlinApp app, MerlinData md, String fn) {
        try {
            WriteViews.writeInputFile(md, fn);
            return true;
        }
        catch (IOException e) {
            guiUtil.showError(app, Intl.intl("File Error"), String.format(Intl.intl("Could not write file: %s"), fn), (Throwable)e);
            return false;
        }
    }

    public static void writeInputFile(MerlinData md, String fn) throws IOException {
        try (PrintWriter fWrite = IOUtil.newPrintWriterUTF8(fn);){
            JSONArray objects = new JSONArray();
            for (ICameraObj obj : md.cameras.flatten(ICameraObj.class)) {
                if (obj instanceof Camera && !((Camera)obj).get(Camera.PROP_SECURITY).booleanValue()) {
                    objects.add(WriteViews.toJSON((Camera)obj));
                    continue;
                }
                if (!(obj instanceof CameraTour)) continue;
                objects.add(WriteViews.toJSON((CameraTour)obj));
            }
            String text = objects.toJSONString();
            fWrite.println(text);
        }
    }

    public static JSONObject toJSON(Camera view) {
        JSONObject obj = new JSONObject();
        obj.put("type", "camera_view");
        obj.put("name", view.getName());
        CameraRecord cr = view.getCameraState();
        JSONObject state = WriteViews.toJSON(cr);
        obj.put("state", state);
        return obj;
    }

    public static JSONObject toJSON(CameraTour cscript) {
        JSONObject obj = new JSONObject();
        obj.put("type", "camera_script");
        obj.put("name", cscript.getName());
        obj.put("tstart", cscript.get(CameraTour.TSTART).get(SI.SECOND));
        obj.put("loop", cscript.get(CameraTour.LOOP));
        obj.put("repeat", cscript.get(CameraTour.REPEAT));
        obj.put("crsalpha", cscript.get(CameraTour.CRSTYPE).alpha);
        JSONArray nodes = new JSONArray();
        for (CameraTourKeyFrame node : cscript.flatten(CameraTourKeyFrame.class)) {
            CameraRecord cr = node.get(CameraTourKeyFrame.CAMDATA);
            JSONObject jsnode = WriteViews.toJSON(cr);
            jsnode.put("treach", node.get(CameraTourKeyFrame.TREACH).get(SI.SECOND));
            jsnode.put("twait", node.get(CameraTourKeyFrame.TWAIT).get(SI.SECOND));
            nodes.add(jsnode);
        }
        obj.put("nodes", nodes);
        return obj;
    }

    private static JSONObject toJSON(CameraRecord cr) {
        JSONObject jsnode = new JSONObject();
        jsnode.put("loc", WriteViews.toArray(cr.loc));
        jsnode.put("ref", WriteViews.toArray(cr.ref));
        jsnode.put("up", WriteViews.toArray(cr.up));
        jsnode.put("zoom", cr.zoom);
        jsnode.put("zoomloc", WriteViews.toArray(cr.zoomLoc));
        jsnode.put("near", cr.near);
        jsnode.put("far", cr.far);
        if (cr.frustum instanceof PerspectiveCamera.FrustumRecord) {
            PerspectiveCamera.FrustumRecord pfr = (PerspectiveCamera.FrustumRecord)cr.frustum;
            jsnode.put("fov", pfr.fov);
        } else {
            jsnode.put("fov", Math.toRadians(45.0));
        }
        return jsnode;
    }

    private static JSONArray toArray(Tuple3d t) {
        JSONArray arr = new JSONArray();
        arr.add(t.x);
        arr.add(t.y);
        arr.add(t.z);
        return arr;
    }

    private static JSONArray toArray(Tuple2d t) {
        JSONArray arr = new JSONArray();
        arr.add(t.x);
        arr.add(t.y);
        return arr;
    }
}

