/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import inferno.sim.Param;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.MerlinPrefs;
import merlin.actions.AMerlinOp;
import merlin.actions.InfernoUtil;
import merlin.actions.MonteCarloVariationGenerator;
import merlin.actions.RunInferno;
import merlin.actions.UIHook;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import merlin.data.RestorableProperties;
import merlin.data.montecarlo.MonteCarlo;
import merlin.data.montecarlo.SimulationInputList;
import merlin.data.property.PropertyDefs;
import merlin.data.scenario.Scenario;
import merlin.data.scenario.ScenarioRoot;
import merlin.data.scenario.ScenarioUtil;
import merlin.data.scenario.SimOutputDir;
import merlin.gui.guiUtil;
import merlin.io.MerlinIO;
import merlin.util.Dependencies;
import merlin.util.MerlinUtil;
import montecarlo.ProcessResults;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepCallback;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.gui.guiJFXDirectoryChooser;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.Events;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.ITaskProgress;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.SplitProgress;
import thunderheadeng.util.TaskProgress;
import thunderheadeng.util.theTimer;

public class WriteScenarios
extends AMerlinOp {
    public static final UIHook UI_HOOK = new UIHook(new WriteScenarios(), Intl.intl("Export &Scenarios and Monte Carlo Variations...,-,Export PTH files for all scenarios and Monte Carlo variations and create batch files to run them from the command line."));
    private static final Logger LOGGER = Logger.getLogger(WriteScenarios.class.getName());

    @Override
    public void run(MerlinApp app, MerlinData md) {
        theTimer timer = new theTimer();
        Consumer<String> profileBegin = msg -> {
            LOGGER.info((String)msg);
            timer.reset();
        };
        Runnable profileEnd = () -> {
            LOGGER.info(String.format("Done (%.2f s)", timer.curr()));
            timer.reset();
        };
        JFrame parentFrame = app.getActiveFrame();
        try (Events.EventPause pause = md.getEvents().openPause(false);){
            File outputRootDir;
            List<Scenario> chosenScenarios;
            ArrayList<Scenario> existingScenarios = new ArrayList<Scenario>(md.scenarios.flatten(Scenario.class));
            existingScenarios.sort(ScenarioUtil.SCENARIO_SORTER);
            ActionProps props = (ActionProps)md.actionProperties.getActionProps("WriteScenarios.ActionProps");
            if (props == null) {
                props = new ActionProps();
                props.set(ActionProps.PROP_SCENARIOS, new IdentityHashSet<Scenario>(existingScenarios));
            }
            Set lastRunScenarios = props.get(ActionProps.PROP_SCENARIOS).stream().filter(scenario -> existingScenarios.contains(scenario)).collect(Collectors.toSet());
            if (existingScenarios.size() > 1) {
                RunInferno.ScenarioChooserDialog dialog = new RunInferno.ScenarioChooserDialog((Window)parentFrame, Intl.intl("Export Scenarios"), Intl.intl("Scenarios"), Intl.intl("Select the Scenarios to save:"));
                dialog.setAvailObjs(existingScenarios);
                dialog.setObjectSelectionState(lastRunScenarios, Collections.emptySet());
                if (dialog.doModal() != 1) {
                    return;
                }
                chosenScenarios = dialog.getSelectedObjs(Scenario.class).stream().sorted(ScenarioUtil.SCENARIO_SORTER).toList();
            } else {
                chosenScenarios = existingScenarios;
            }
            profileBegin.accept(Intl.intl("Checking errors..."));
            RunInferno.quickCheckForErrors(app, md, chosenScenarios);
            profileEnd.run();
            IdentityHashMap<Scenario, Integer> variationCounts = new IdentityHashMap<Scenario, Integer>();
            for (Scenario scenario2 : existingScenarios) {
                int count2 = (Integer)md.scenarios.getScenarioValue(scenario2, md.monteCarlo, MonteCarlo.VARIATION_COUNT).orElseGet(() -> new ScenarioRoot.ScenarioValue<Integer>(false, 1)).value();
                variationCounts.put(scenario2, count2);
            }
            if (md.filename != null) {
                try {
                    String baseName = InfernoUtil.rootFn(md.filename);
                    outputRootDir = Path.of(md.filename, new String[0]).getParent().resolve(baseName).toFile();
                    outputRootDir.mkdirs();
                }
                catch (InvalidPathException e) {
                    outputRootDir = new File(MerlinPrefs.get(MerlinPrefs.OPEN_DIR_PREF));
                }
            } else {
                outputRootDir = new File(MerlinPrefs.get(MerlinPrefs.OPEN_DIR_PREF));
            }
            Function<File, File> promptOutput = lastDir -> {
                guiJFXDirectoryChooser chooser = new guiJFXDirectoryChooser(lastDir.toString(), "");
                return chooser.showDirDialog();
            };
            HashMap<ScenarioUtil.ScenarioVariationKey, SimOutputDir> outputDirs = new HashMap<ScenarioUtil.ScenarioVariationKey, SimOutputDir>();
            String outputBaseName = "";
            Path simulationsListPath = null;
            while (outputDirs.isEmpty()) {
                if ((outputRootDir = promptOutput.apply(outputRootDir)) == null) {
                    return;
                }
                try {
                    for (Scenario scenario3 : existingScenarios) {
                        int variationCount = (Integer)variationCounts.get(scenario3);
                        for (int variationIndex = 0; variationIndex < variationCount; ++variationIndex) {
                            outputDirs.put(new ScenarioUtil.ScenarioVariationKey(scenario3, variationIndex, variationCount), ScenarioUtil.getOutputDir(outputRootDir.toString(), scenario3.getName(), existingScenarios.size(), variationIndex, variationCount));
                        }
                    }
                    outputBaseName = outputRootDir.getName();
                    simulationsListPath = outputRootDir.toPath().resolve(outputBaseName + "_simulations.json");
                }
                catch (IOException | InvalidPathException e) {
                    JOptionPane.showMessageDialog(app.getActiveFrame(), Intl.intl("Could not determine output file path. Try saving to a different location."), Intl.intl("Error Creating Outputs"), 0);
                    outputDirs.clear();
                }
            }
            props.set(ActionProps.PROP_SCENARIOS, new IdentityHashSet<Scenario>(chosenScenarios));
            md.actionProperties.setActionProps("WriteScenarios.ActionProps", props);
            MerlinPrefs.set(MerlinPrefs.OPEN_DIR_PREF, outputRootDir.toString());
            profileBegin.accept(Intl.intl("Creating scenario output directories..."));
            for (SimOutputDir outputDir : outputDirs.values()) {
                File dir = outputDir.current.outputDir().toFile();
                if (dir.getParentFile().isFile() || dir.isFile()) {
                    throw new CancelledException();
                }
                if (dir.isDirectory() || dir.mkdirs()) continue;
                throw new CancelledException();
            }
            profileEnd.run();
            File simulationsListFile = simulationsListPath.toFile();
            LinkedHashMap<ScenarioUtil.ScenarioVariationKey, Param> params = new LinkedHashMap<ScenarioUtil.ScenarioVariationKey, Param>();
            ScenarioUtil.forEachScenarioActivated(md, chosenScenarios, false, (scenario, index, count, prevActive) -> {
                int variationCount = (Integer)variationCounts.get(scenario);
                for (int i = 0; i < (Integer)variationCounts.get(scenario); ++i) {
                    SimOutputDir outputDir = (SimOutputDir)outputDirs.get(new ScenarioUtil.ScenarioVariationKey(scenario, i, variationCount));
                    params.put(new ScenarioUtil.ScenarioVariationKey(scenario, i, variationCount), InfernoUtil.mkInfernoParam(app, md, outputDir.current.outputDir().toFile(), outputDir.current.outputFileBasename().toString(), simulationsListFile, false));
                }
                return true;
            });
            profileBegin.accept(Intl.intl("Validating model..."));
            RunInferno.thoroughCheckForErrors(app.getActiveFrame(), app, md, params);
            profileEnd.run();
            TaskProgress progress = new TaskProgress();
            File finalOutputRootDir = outputRootDir;
            String finalOutputBaseName = outputBaseName;
            MerlinUtil.execLongTask(app.getActiveFrame(), Intl.intl("Writing Scenarios"), progress, () -> {
                WriteScenarios.writeScenarios(progress, app, md, chosenScenarios, finalOutputRootDir.toPath(), finalOutputBaseName, simulationsListFile, outputDirs);
                return null;
            });
        }
        catch (CancellationException | CancelledException e) {
            return;
        }
        catch (ExecutionException e) {
            guiUtil.showError(app, Intl.intl("Scenario File Error"), Intl.intl("Could not export scenarios"), e.getCause());
        }
    }

    private static void writeScenarios(ITaskProgress progress, MerlinApp app, MerlinData md, Collection<Scenario> scenarios, Path outputRootDir, String outputBaseName, File simulationsListFile, Map<ScenarioUtil.ScenarioVariationKey, SimOutputDir> outputDirs) {
        try (Events.EventPause pause = md.getEvents().openPause(false);
             SplitProgress scenariosProg = progress.split(scenarios.size());){
            ScenarioUtil.forEachScenarioActivated(md, scenarios, true, (scenario, scenarioIndex, scenarioCount, prevActive) -> {
                scenariosProg.check();
                try (SplitProgress variationsProg = scenariosProg.split(md.monteCarlo.get(MonteCarlo.VARIATION_COUNT));){
                    MonteCarloVariationGenerator.generateVariations(md, (variationIndex, variationCount, variationErrors) -> {
                        variationsProg.setParentMessage((curr, max) -> String.format(Intl.intl("Exporting scenario %1$d/%2$d; variation %3$d/%4$d."), scenarioIndex + 1, scenarioCount, variationIndex + 1, variationCount));
                        variationsProg.check();
                        SimOutputDir outputDir = (SimOutputDir)outputDirs.get(new ScenarioUtil.ScenarioVariationKey(scenario, variationIndex, variationCount));
                        outputDir.current.getEquivalentPthFile().getParent().toFile().mkdirs();
                        try {
                            WriteScenarios.writeModelWithoutScenarios(md, outputDir.current.getEquivalentPthFile());
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        variationsProg.incrementParent();
                        return true;
                    });
                }
                scenariosProg.incrementParent();
                return true;
            });
            try {
                SimulationInputList simulationList = new SimulationInputList(md, scenarios, outputRootDir, outputDirs);
                WriteScenarios.writeSimulationList(simulationList, simulationsListFile.toPath());
                WriteScenarios.writeScripts(app, outputRootDir, simulationsListFile.getName());
            }
            catch (IOException | InvalidPathException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void writeSimulationList(SimulationInputList simulationList, Path outputFile) throws IOException {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        String json = gson.toJson(simulationList);
        Files.writeString(outputFile, (CharSequence)json, new OpenOption[0]);
    }

    private static void writeScripts(MerlinApp app, Path outputRootDir, String simulationsFilename) throws IOException {
        String installFolder = app.getInstallDir();
        WriteScenarios.writeRunnerScript(outputRootDir.resolve("_run.bat"), simulationsFilename, installFolder);
        WriteScenarios.writeResultsScript(outputRootDir.resolve("_make_plots.bat"), simulationsFilename, installFolder);
        WriteScenarios.writeCleanScript(outputRootDir.resolve("_clean.bat"), simulationsFilename, installFolder);
    }

    private static void writeRunnerScript(Path filename, String simulationsFilename, String installFolder) throws IOException {
        StringBuilder data = new StringBuilder();
        InputStream instrm = ProcessResults.class.getResourceAsStream("runner.bat.template");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(instrm, StandardCharsets.UTF_8));){
            String line = reader.readLine();
            while (line != null) {
                data.append(line).append("\n");
                line = reader.readLine();
            }
        }
        String content = data.toString();
        content = content.replace("{INSTALL_FOLDER}", installFolder);
        content = content.replace("{SIMULATIONS}", simulationsFilename);
        Files.writeString(filename, (CharSequence)content, new OpenOption[0]);
    }

    private static void writeResultsScript(Path filename, String simulationsFilename, String installFolder) throws IOException {
        StringBuilder data = new StringBuilder();
        InputStream instrm = ProcessResults.class.getResourceAsStream("results.bat.template");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(instrm, StandardCharsets.UTF_8));){
            String line = reader.readLine();
            while (line != null) {
                data.append(line).append("\n");
                line = reader.readLine();
            }
        }
        String content = data.toString();
        content = content.replace("{INSTALL_FOLDER}", installFolder);
        content = content.replace("{SIMULATIONS}", simulationsFilename);
        Files.writeString(filename, (CharSequence)content, new OpenOption[0]);
    }

    public static void writeCleanScript(Path filename, String simulationsFilename, String installFolder) throws IOException {
        StringBuilder data = new StringBuilder();
        InputStream instrm = ProcessResults.class.getResourceAsStream("clean.bat.template");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(instrm, StandardCharsets.UTF_8));){
            String line = reader.readLine();
            while (line != null) {
                data.append(line).append("\n");
                line = reader.readLine();
            }
        }
        String content = data.toString();
        content = content.replace("{INSTALL_FOLDER}", installFolder);
        content = content.replace("{SIMULATIONS}", simulationsFilename);
        Files.writeString(filename, (CharSequence)content, new OpenOption[0]);
    }

    private static void writeModelWithoutScenarios(MerlinData md, Path path) throws IOException {
        ScenarioRoot root = md.scenarios;
        int variationCount = md.monteCarlo.get(MonteCarlo.VARIATION_COUNT);
        md.scenarios = new ScenarioRoot();
        md.monteCarlo.set(MonteCarlo.VARIATION_COUNT, 1);
        MerlinIO.writeModel(path.toString(), md);
        md.scenarios = root;
        md.monteCarlo.set(MonteCarlo.VARIATION_COUNT, variationCount);
    }

    private static class ActionProps
    extends RestorableProperties
    implements IDirectDependent<MerlinData> {
        private static final long serialVersionUID = 1L;
        public static final String KEY = "WriteScenarios.ActionProps";
        public static final IPropertySet.Prop<Set<Scenario>> PROP_SCENARIOS = new IPropertySet.Prop("WriteScenarios.SCENARIOS", Collections.emptySet());
        private static final PropertyDefs<ActionProps> PROPS = new PropertyDefs<ActionProps>(ActionProps.class, List.of(), IPropertySet.getAllDeclaredPublicStaticProps(ActionProps.class), new Object[0]);
        private static final DepCallback<MerlinData, ActionProps, Set<Scenario>, Scenario> SCENARIOS_CALLBACK = Dependencies.newDependencyInSet(PROP_SCENARIOS, DLink.WEAK, Scenario.class, null);

        private ActionProps() {
        }

        @Override
        public PropertyDefs<? extends ICompElement> getAllLocalProperties() {
            return PROPS;
        }

        @Override
        public void takeDepSnapshot(DepList<MerlinData> deps) {
            PROPS.takeDepSnapshot(this, deps);
        }

        static {
            PROPS.registerDependency(PROP_SCENARIOS, SCENARIOS_CALLBACK);
        }
    }
}

