/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import common.data.IElevatorTimingModel;
import common.data.SpeedInSmoke;
import common.geom.Trig;
import common.io.FileUtil;
import inferno.data2.ANode;
import inferno.data2.AnimatedGeom;
import inferno.data2.AttractorSim;
import inferno.data2.Blockage;
import inferno.data2.Camera;
import inferno.data2.Counter;
import inferno.data2.CylinderShape;
import inferno.data2.DoorDir;
import inferno.data2.EdgeData;
import inferno.data2.IAgentBodyShape;
import inferno.data2.IOccFilter;
import inferno.data2.Material;
import inferno.data2.OccTarget;
import inferno.data2.OccTargets;
import inferno.data2.Occupant;
import inferno.data2.PolygonShape;
import inferno.data2.QBaseQueue;
import inferno.data2.QMetaQueue;
import inferno.data2.QPath;
import inferno.data2.QServicePoint;
import inferno.data2.SpeedInSmokeSim;
import inferno.data2.StairData;
import inferno.data2.Tag;
import inferno.data2.Tri;
import inferno.data2.Vertex;
import inferno.data2.WingedEdge;
import inferno.data2.ai.AbandonOccTargetsGoal;
import inferno.data2.ai.AssistOccupantsGoal;
import inferno.data2.ai.AssistedEvacTeam;
import inferno.data2.ai.ChangeBehaviorGoal;
import inferno.data2.ai.ChangeCounterGoal;
import inferno.data2.ai.ChangeProfileGoal;
import inferno.data2.ai.ChangeTagGoal;
import inferno.data2.ai.CreateAttractorGoal;
import inferno.data2.ai.DestroyAttractorGoal;
import inferno.data2.ai.DetachGoal;
import inferno.data2.ai.DynamicTargetGoal;
import inferno.data2.ai.ExitGoal;
import inferno.data2.ai.FillRoomGoal;
import inferno.data2.ai.IEventTime;
import inferno.data2.ai.IGoal;
import inferno.data2.ai.IIdleGoal;
import inferno.data2.ai.JoinOccGroupGoal;
import inferno.data2.ai.LookAheadGoal;
import inferno.data2.ai.LookAtGoal;
import inferno.data2.ai.OccTargetGoal;
import inferno.data2.ai.PointGoal;
import inferno.data2.ai.QueueGoal;
import inferno.data2.ai.RemoveSelfGoal;
import inferno.data2.ai.RoomGoal;
import inferno.data2.ai.SetOccPropGoal;
import inferno.data2.ai.SetOccPropToProfileGoal;
import inferno.data2.ai.SetTagGoal;
import inferno.data2.ai.WaitForAssistanceGoal;
import inferno.data2.ai.WaitForCounterGoal;
import inferno.data2.ai.WaitGoal;
import inferno.data2.ai.WaitUntilEndGoal;
import inferno.data2.ai.WaitUntilGoal;
import inferno.data2.ai.WaitUntilInsideGoal;
import inferno.data2.ai.WaitUntilTaggedGoal;
import inferno.data2.value.IFunction1d;
import inferno.elevator.Elevator;
import inferno.elevator.ElevatorGoal;
import inferno.elevator.ElevatorLevel;
import inferno.elevator.ElevatorModel;
import inferno.sim.BehaviorSim;
import inferno.sim.DoorQueue;
import inferno.sim.EngineOp;
import inferno.sim.IDoorFlowrate;
import inferno.sim.IOccGroup;
import inferno.sim.KB;
import inferno.sim.OccGroup;
import inferno.sim.OccGroupType;
import inferno.sim.OccProfileSim;
import inferno.sim.Param;
import inferno.sim.VehicleBody;
import inferno.sim.occsource.IOccSourceFlowrate;
import inferno.sim.occsource.OccSource;
import inferno.util.BigDecimalOp;
import inferno.util.ComparePredicate;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.vecmath.Color3b;
import javax.vecmath.Color3f;
import javax.vecmath.Point2d;
import javax.vecmath.Point2f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.MerlinPrefs;
import merlin.actions.AMerlinOp;
import merlin.actions.InfernoUtil;
import merlin.actions.RunInferno;
import merlin.actions.UIHook;
import merlin.actions.WriteViews;
import merlin.actions.WriteVis;
import merlin.data.AMerlinObj;
import merlin.data.Composite;
import merlin.data.IGetJson;
import merlin.data.IMerlinObj;
import merlin.data.JsonObj;
import merlin.data.MeasurementRegionObj;
import merlin.data.MerlinData;
import merlin.data.egress.Floor;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.scripting.attractors.Attractor;
import merlin.data.egress.scripting.queues.QueueObject;
import merlin.data.scripting.ScriptObj;
import merlin.data.stat.AutoCurve;
import merlin.io.inferno.InfernoGeom;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.image.IImage;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.io.IOUtil;
import thunderheadeng.io.JsonUtil;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.FileFilters;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.ITaskProgress;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.SplitProgress;
import thunderheadeng.util.TaskProgress;
import thunderheadeng.util.TriConsumer;
import thunderheadeng.util.TypeFilter;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.ICurve;
import thunderheadeng.util.stat.IDistributedVal;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.LogNormCurve;
import thunderheadeng.util.stat.StdNormCurve;
import thunderheadeng.util.stat.UniformCurve;
import thunderheadeng.util.stat.UrnUtil;
import thunderheadeng.util.theUtil;

public class WriteMesh
extends AMerlinOp {
    public static final UIHook UI_HOOK = new UIHook(new WriteMesh(), Intl.intl("Export Si&mulator Input...,-,Write simulator input"));
    public static final Unit LENGTH_UNIT = SI.METER;
    public static final Unit VEL_UNIT = SI.METER.divide(SI.SECOND);
    public static final Unit TIME_UNIT = SI.SECOND;
    private static final Object DO_NOT_WRITE = "DO_NOT_WRITE";
    public static final Pattern GOAL_ESCAPE = Pattern.compile("([ ])|([\\;\\(\\)\\\"\\\\])");
    public static final Pattern NAME_ESCAPE = Pattern.compile("[\\\"\\\\]");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        try {
            app.beginWaitCursor();
            RunInferno.quickCheckForErrors(app, md, List.of(md.scenarios.getActive()));
        }
        catch (CancelledException e) {
            return;
        }
        finally {
            app.endWaitCursor();
        }
        Path defaultTxt = md.getNewFilePath(".txt");
        guiJFXFileChooser chooser = new guiJFXFileChooser(defaultTxt.getFileName().toString(), defaultTxt.getParent() != null ? defaultTxt.getParent().toString() : MerlinPrefs.get(MerlinPrefs.OPEN_DIR_PREF), null, (Boolean)false, (Boolean)false, (Boolean)false, FileFilters.EXT_FILTER_INFERNO);
        File f = chooser.showSaveDialog();
        if (f == null) {
            return;
        }
        MerlinPrefs.set(MerlinPrefs.OPEN_DIR_PREF, f.getParent());
        String rootFn = InfernoUtil.rootFn(f.getName());
        File dir = f.getParentFile();
        Param p = InfernoUtil.mkInfernoParam(app, md, dir, rootFn, null, false);
        ArrayList errors = new ArrayList();
        TaskProgress progress = new TaskProgress();
        this.execLongReadTaskNoThrow(app.getActiveFrame(), md, Intl.intl("Writing Input File"), progress, () -> {
            SplitProgress sprog = progress.split(2);
            try {
                sprog.check();
                InfernoUtil.KBInfo kb = InfernoUtil.mkInfernoKB(md, p, errors, sprog);
                sprog.incrementParent();
                WriteMesh.writeInputFile(app, md, f, kb, p, (ITaskProgress)sprog);
                sprog.incrementParent();
                Object var8_10 = null;
                if (sprog != null) {
                    sprog.close();
                }
                return var8_10;
            }
            catch (Throwable throwable) {
                try {
                    if (sprog != null) {
                        try {
                            sprog.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (CancellationException e) {
                    return null;
                }
            }
        });
    }

    private static String df(double d) {
        return Double.toString(d);
    }

    private static String ff(float f) {
        return Float.toString(f);
    }

    public static boolean writeInputFile(MerlinApp app, MerlinData md, File f, InfernoUtil.KBInfo kb, Param p, ITaskProgress progress) {
        try {
            WriteMesh.writeInputFile(md, f.getParentFile(), InfernoUtil.rootFn(f.getName()), kb, p, progress);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            app.error(Intl.intl("File Error"), String.format(Intl.intl("Could not write file: %s"), f.getAbsolutePath()));
            return false;
        }
    }

    public static void writeInputFile(MerlinData md, File dir, String rootFn, InfernoUtil.KBInfo kb, Param p, ITaskProgress progress) throws IOException, CancellationException {
        progress.setMessage(Intl.intl("Writing input file"));
        WriteMesh.createMetaFiles(md, p);
        progress.check();
        File inputFile = FileUtil.getInputFn(dir, rootFn);
        try (PrintWriter fWrite = IOUtil.newPrintWriterUTF8(inputFile.getAbsolutePath());){
            Map<BehaviorSim, Integer> behaviors = WriteMesh.getBehaviors(kb.kb);
            Map<OccProfileSim, Integer> profiles = WriteMesh.getProfiles(kb.kb, behaviors);
            Map<OccProfileSim.IShapeGen, Integer> shapes = WriteMesh.getShapes(kb.kb);
            progress.check();
            Map<QMetaQueue, Integer> queuesMap = WriteMesh.getQueues(kb.kb);
            Map<IFunction1d, Integer> functions = WriteMesh.getFunctions(kb.kb, profiles.keySet(), behaviors.keySet());
            progress.check();
            Map<Predicate<AttractorSim>, Integer> attrFilters = WriteMesh.buildAttractorFilterIxMap(kb.kb, profiles, behaviors);
            progress.check();
            Map<IDistributedVal<?>, Integer> distributions = WriteMesh.buildDistributionIxMap(kb.kb, profiles, behaviors, queuesMap);
            progress.check();
            Map<Material, Integer> mats = WriteMesh.getMatMap(kb.kb);
            Map<Counter, Integer> counters = WriteMesh.getCounters(kb.kb, behaviors.keySet());
            progress.check();
            Map<AssistedEvacTeam, Integer> aeteams = WriteMesh.getAETeams(kb.kb);
            Map<OccProfileSim.CompRestrictions, Integer> compRestrictionsMap = WriteMesh.getCompRestrictions(kb.kb);
            progress.check();
            WriteMesh.writeVersion(fWrite);
            WriteMesh.writeParam(fWrite, p);
            progress.check();
            WriteMesh.writeMaterials(inputFile, fWrite, kb.kb, mats);
            Map<ANode, Integer> nodeMap = WriteMesh.writeNodes(fWrite, kb, mats);
            progress.check();
            WriteMesh.writeFloors(fWrite, md, kb, nodeMap);
            Map<Vertex, Integer> vertMap = WriteMesh.writeVerts(fWrite, kb.kb);
            Map<Point2f, Integer> uvMap = WriteMesh.writeTexCoords(fWrite, kb.kb);
            progress.check();
            WriteMesh.writeStairs(fWrite, kb.kb, nodeMap);
            WriteMesh.writeDoors(fWrite, kb.kb, nodeMap, distributions);
            progress.check();
            WriteMesh.writeEdges(fWrite, kb.kb, nodeMap, vertMap);
            WriteMesh.writeMesh(fWrite, kb.kb, nodeMap, vertMap, uvMap);
            progress.check();
            Map<AttractorSim, Integer> attractors = WriteMesh.writeAttractors(fWrite, kb.kb, behaviors, nodeMap, distributions);
            WriteMesh.writeCameras(fWrite, kb.kb);
            progress.check();
            WriteMesh.writeBlockages(fWrite, kb.kb, mats);
            WriteMesh.writeAnimatedGeoms(fWrite, kb.kb);
            progress.check();
            WriteMesh.writeElevators(fWrite, kb.kb, nodeMap);
            WriteMesh.writeEvents(fWrite, kb.kb, nodeMap);
            progress.check();
            WriteMesh.writeJson(fWrite, md, kb.kb);
            WriteMesh.writeQueues(fWrite, queuesMap, distributions);
            progress.check();
            WriteMesh.writeShapes(fWrite, kb.kb, shapes, distributions);
            WriteMesh.writeAssistedEvacTeams(fWrite, aeteams);
            progress.check();
            Map<OccTarget, Integer> occTargets = WriteMesh.writeOccTargets(fWrite, kb.kb);
            progress.check();
            WriteMesh.writeBehaviors(fWrite, kb.kb, behaviors, profiles, nodeMap, distributions, counters, shapes, aeteams, functions, compRestrictionsMap, attrFilters, queuesMap, occTargets, attractors);
            progress.check();
            WriteMesh.writeTags(fWrite, kb.kb);
            WriteMesh.writeProfiles(fWrite, profiles.keySet(), shapes, functions, distributions, compRestrictionsMap, attrFilters);
            progress.check();
            WriteMesh.writeFunctions(fWrite, functions.keySet());
            WriteMesh.writeDistributions(fWrite, distributions.keySet());
            progress.check();
            WriteMesh.writeCompRestrictions(fWrite, compRestrictionsMap, nodeMap);
            WriteMesh.writeAttractorFilters(fWrite, kb.kb, attrFilters.keySet(), attractors);
            progress.check();
            WriteMesh.writeOccs(fWrite, kb.kb, profiles, behaviors, functions, shapes, compRestrictionsMap, attrFilters);
            progress.check();
            WriteMesh.writeOccSources(fWrite, kb.kb, profiles, behaviors, functions, nodeMap, distributions);
            progress.check();
            WriteMesh.writeOccGroups(fWrite, kb.kb, profiles, behaviors, distributions);
            progress.check();
            WriteMesh.writeCounters(fWrite, counters);
            progress.check();
            WriteMesh.writeHierarchy(fWrite, kb);
            progress.check();
        }
    }

    public static void createMetaFiles(MerlinData md, Param p) throws IOException {
        File visFile = new File(p.imported_geom);
        File viewsFile = new File(p.views);
        WriteViews.writeInputFile(md, viewsFile.getAbsolutePath());
        try {
            WriteVis.writeVis(md, visFile, false);
        }
        catch (IOException e) {
            System.err.println("[WriteMesh] Could not create geom file:");
            e.printStackTrace();
        }
    }

    private static Map<Counter, Integer> getCounters(KB kb, Collection<BehaviorSim> behaviors) {
        LinkedIdentityHashMap<Counter, Integer> counters = new LinkedIdentityHashMap<Counter, Integer>();
        Consumer<Counter> add = c -> counters.putIfAbsent((Counter)c, counters.size());
        for (BehaviorSim behavior : behaviors) {
            for (IGoal goal : behavior) {
                if (goal instanceof ChangeCounterGoal) {
                    add.accept(((ChangeCounterGoal)goal).counter);
                    continue;
                }
                if (!(goal instanceof WaitForCounterGoal)) continue;
                add.accept(((WaitForCounterGoal)goal).counter);
            }
        }
        return counters;
    }

    private static Map<OccProfileSim, Integer> getProfiles(KB kb, Map<BehaviorSim, Integer> behaviors) {
        LinkedHashMap<OccProfileSim, Integer> profileIxMap = new LinkedHashMap<OccProfileSim, Integer>();
        for (Occupant occ : kb.getOccs()) {
            profileIxMap.putIfAbsent(occ.parentProfile, profileIxMap.size());
        }
        for (OccSource occSource : kb.getOccSources()) {
            for (OccProfileSim prof : occSource.getProfiles(false)) {
                profileIxMap.putIfAbsent(prof, profileIxMap.size());
            }
        }
        IdentityHashSet visitedBehaviors = new IdentityHashSet();
        for (BehaviorSim behavior : behaviors.keySet()) {
            behavior.getReferencedProfiles(visitedBehaviors, profile -> profileIxMap.putIfAbsent((OccProfileSim)profile, profileIxMap.size()));
        }
        return profileIxMap;
    }

    private static Map<BehaviorSim, Integer> getBehaviors(KB kb) {
        Set<BehaviorSim> usedBehaviors = WriteMesh.getReferencedBehaviors(kb, true);
        LinkedIdentityHashMap<BehaviorSim, Integer> result = new LinkedIdentityHashMap<BehaviorSim, Integer>();
        usedBehaviors.forEach(b -> result.put((BehaviorSim)b, result.size()));
        return result;
    }

    private static Map<QueueObject, Integer> getQueues(MerlinData md) {
        LinkedHashMap<QueueObject, Integer> result = new LinkedHashMap<QueueObject, Integer>();
        md.queues.flatten(QueueObject.class).forEach(q -> result.putIfAbsent((QueueObject)q, result.size()));
        return result;
    }

    private static Map<QMetaQueue, Integer> getQueues(KB kb) {
        LinkedHashMap<QMetaQueue, Integer> result = new LinkedHashMap<QMetaQueue, Integer>();
        kb.getBaseQueues().forEach(q -> result.putIfAbsent((QMetaQueue)q, result.size()));
        kb.getMetaQueues().forEach(q -> result.putIfAbsent((QMetaQueue)q, result.size()));
        return result;
    }

    private static Map<OccProfileSim.IShapeGen, Integer> getShapes(KB kb) {
        LinkedHashMap<OccProfileSim.IShapeGen, Integer> shapeIxMap = new LinkedHashMap<OccProfileSim.IShapeGen, Integer>();
        Consumer<OccProfileSim.IShapeGen> addShape = shape -> shapeIxMap.putIfAbsent((OccProfileSim.IShapeGen)shape, shapeIxMap.size());
        Set<BehaviorSim> behaviors = WriteMesh.getReferencedBehaviors(kb, false);
        IdentityHashSet visitedBehaviors = new IdentityHashSet();
        behaviors.forEach(behavior -> behavior.getFutureProfileValues(visitedBehaviors, OccProfileSim.PROP_SHAPE, addShape));
        for (Occupant occ : kb.getOccs()) {
            if (occ.bodyShape instanceof PolygonShape) {
                addShape.accept(occ.bodyShape.toShapeGen());
            }
            addShape.accept(occ.parentProfile.getProp(OccProfileSim.PROP_SHAPE));
        }
        for (OccSource occSource : kb.getOccSources()) {
            occSource.getProfiles(false).stream().map(profile -> profile.getProperty(OccProfileSim.PROP_SHAPE)).forEach(addShape);
        }
        return shapeIxMap;
    }

    private static Map<IFunction1d, Integer> getFunctions(KB kb, Collection<OccProfileSim> profiles, Collection<BehaviorSim> behaviors) {
        LinkedHashMap<IFunction1d, Integer> functions = new LinkedHashMap<IFunction1d, Integer>();
        Consumer<IFunction1d> add = f -> functions.putIfAbsent((IFunction1d)f, functions.size());
        Consumer<OccProfileSim.IProfileFunction> addProfFunc = f -> f.getAllReferenced(add);
        Consumer<SpeedInSmokeSim> addSpeedInSmoke = o -> {
            if (o.mode == SpeedInSmoke.Mode.CUSTOM_VISIBILITY) {
                add.accept(o.customFuncVis);
            }
        };
        for (Occupant o2 : kb.getOccs()) {
            add.accept(o2.fundamental);
            add.accept(o2.stairSpeed.upSpeed);
            add.accept(o2.stairSpeed.upFundamental);
            add.accept(o2.stairSpeed.downSpeed);
            add.accept(o2.stairSpeed.downFundamental);
            add.accept(o2.rampSpeed.upSpeed);
            add.accept(o2.rampSpeed.upFundamental);
            add.accept(o2.rampSpeed.downSpeed);
            add.accept(o2.rampSpeed.downFundamental);
            addSpeedInSmoke.accept(o2.smokeSpeed);
        }
        for (OccSource occSource : kb.getOccSources()) {
            IOccSourceFlowrate flowrate = occSource.getFlowrate();
            flowrate.getFunctions(add);
        }
        for (OccProfileSim prof : profiles) {
            add.accept(prof.getProperty(OccProfileSim.PROP_FUNDAMENTAL));
            add.accept(prof.getProperty(OccProfileSim.PROP_STAIR_SPEED_UP));
            addProfFunc.accept(prof.getProperty(OccProfileSim.PROP_STAIR_FUNDAMENTAL_UP));
            add.accept(prof.getProperty(OccProfileSim.PROP_STAIR_SPEED_DOWN));
            addProfFunc.accept(prof.getProperty(OccProfileSim.PROP_STAIR_FUNDAMENTAL_DOWN));
            add.accept(prof.getProperty(OccProfileSim.PROP_RAMP_SPEED_UP));
            addProfFunc.accept(prof.getProperty(OccProfileSim.PROP_RAMP_FUNDAMENTAL_UP));
            add.accept(prof.getProperty(OccProfileSim.PROP_RAMP_SPEED_DOWN));
            addProfFunc.accept(prof.getProperty(OccProfileSim.PROP_RAMP_FUNDAMENTAL_DOWN));
            addSpeedInSmoke.accept(prof.getProperty(OccProfileSim.PROP_SPEED_IN_SMOKE));
        }
        for (BehaviorSim behavior : behaviors) {
            for (IGoal goal : behavior) {
                if (!(goal instanceof SetOccPropGoal)) continue;
                SetOccPropGoal sopg = (SetOccPropGoal)goal;
                if (sopg.value instanceof IFunction1d) {
                    add.accept((IFunction1d)sopg.value);
                    continue;
                }
                if (sopg.value instanceof OccProfileSim.IProfileFunction) {
                    addProfFunc.accept((OccProfileSim.IProfileFunction)sopg.value);
                    continue;
                }
                if (!(sopg.value instanceof SpeedInSmokeSim)) continue;
                addSpeedInSmoke.accept((SpeedInSmokeSim)sopg.value);
            }
        }
        return functions;
    }

    private static Map<Predicate<AttractorSim>, Integer> buildAttractorFilterIxMap(KB kb, Map<OccProfileSim, Integer> profiles, Map<BehaviorSim, Integer> behaviors) {
        LinkedHashMap<Predicate<AttractorSim>, Integer> result = new LinkedHashMap<Predicate<AttractorSim>, Integer>();
        Consumer<Predicate> add = filter -> result.putIfAbsent((Predicate<AttractorSim>)filter, result.size());
        for (OccProfileSim prof : profiles.keySet()) {
            if (!prof.isDefined(OccProfileSim.PROP_ATTRACTOR_RESTRICTIONS)) continue;
            add.accept(prof.getProperty(OccProfileSim.PROP_ATTRACTOR_RESTRICTIONS));
        }
        IdentityHashSet visitedBehaviors = new IdentityHashSet();
        for (BehaviorSim behavior : behaviors.keySet()) {
            behavior.getFutureProfileValues(visitedBehaviors, OccProfileSim.PROP_ATTRACTOR_RESTRICTIONS, add);
        }
        for (Occupant occ : kb.getOccs()) {
            add.accept(occ.allowedAttractors);
        }
        return result;
    }

    private static Map<IDistributedVal<?>, Integer> buildDistributionIxMap(KB kb, Map<OccProfileSim, Integer> profiles, Map<BehaviorSim, Integer> behaviors, Map<QMetaQueue, Integer> queues) {
        LinkedHashMap distributions = new LinkedHashMap();
        Consumer<IDistributedVal> addDist = dist -> distributions.putIfAbsent((IDistributedVal<?>)dist, distributions.size());
        for (AttractorSim attr : kb.getRootAttractors()) {
            attr.reactTime.getDistributions(addDist);
        }
        Map<Object, IPropertySet.Prop<?>> allProps = OccProfileSim.PROFILE_PROPS_MAP;
        for (OccProfileSim prof : profiles.keySet()) {
            for (IPropertySet.Prop<?> p : allProps.values()) {
                Object prop = WriteMesh.getProfileProp(prof, p);
                if (prop instanceof IDistributedVal) {
                    addDist.accept((IDistributedVal)prop);
                    continue;
                }
                if (!(prop instanceof OccProfileSim.CylShapeGen)) continue;
                OccProfileSim.CylShapeGen cyl = (OccProfileSim.CylShapeGen)prop;
                if (!(cyl.shoulderWidth instanceof ConstantCurve)) {
                    addDist.accept(cyl.shoulderWidth);
                }
                if (cyl.height instanceof ConstantCurve) continue;
                addDist.accept(cyl.height);
            }
        }
        for (BehaviorSim goal : behaviors.keySet()) {
            for (IGoal g : goal) {
                if (g instanceof WaitGoal) {
                    addDist.accept(((WaitGoal)g).time);
                    continue;
                }
                if (g instanceof WaitUntilGoal) {
                    WaitUntilGoal wg = (WaitUntilGoal)g;
                    wg.waitSrc.getDistributions(addDist);
                    continue;
                }
                if (!(g instanceof SetOccPropGoal)) continue;
                SetOccPropGoal sopg = (SetOccPropGoal)g;
                if (!(sopg.value instanceof IDistributedVal)) continue;
                addDist.accept((IDistributedVal)sopg.value);
            }
        }
        for (OccGroupType groupType : kb.getOccupantGroupTypes()) {
            if (groupType.allowSmallerGroups) {
                addDist.accept(groupType.minNumberOfMembers);
            }
            addDist.accept(groupType.prefNumberOfMembers);
            if (groupType.profileMap == null) continue;
            for (OccProfileSim prof : groupType.profileMap.keySet()) {
                OccGroupType.GroupCreationData groupCreationData = groupType.profileMap.get(prof);
                addDist.accept(groupCreationData.prefNumberOfMembers);
                if (!groupCreationData.allowSmallerGroups) continue;
                addDist.accept(groupCreationData.minNumberOfMembers);
            }
        }
        for (ANode door : kb.getDoorNodes()) {
            IDistributedVal waitTime = door.doorQueue.getWaitTime();
            if (waitTime == null || waitTime instanceof ConstantCurve && theUtil.eq0(((ConstantCurve)waitTime).getValue().getValueNoUnit(), 1.0E-6)) continue;
            addDist.accept(waitTime);
        }
        for (OccSource source : kb.getOccSources()) {
            addDist.accept(WriteMesh.toIndexUrn(source.getProfileUrn(), profiles::get));
            addDist.accept(WriteMesh.toIndexUrn(source.getBehaviorUrn(), behaviors::get));
            if (source.getGroupUrn() != null) {
                addDist.accept(WriteMesh.toIndexUrn(source.getGroupUrn(), type -> type.getID()));
            }
            if (source.getInitialOrient() == null) continue;
            addDist.accept(source.getInitialOrient());
        }
        for (BehaviorSim behavior : behaviors.keySet()) {
            for (IGoal goal : behavior.goals) {
                if (goal instanceof ChangeBehaviorGoal) {
                    ChangeBehaviorGoal changeBehaviorGoal = (ChangeBehaviorGoal)goal;
                    addDist.accept(WriteMesh.toIndexUrn(changeBehaviorGoal.getBehaviorUrn(), behaviors::get));
                    continue;
                }
                if (!(goal instanceof ChangeProfileGoal)) continue;
                ChangeProfileGoal changeProfileGoal = (ChangeProfileGoal)goal;
                addDist.accept(WriteMesh.toIndexUrn(changeProfileGoal.getProfileUrn(), profiles::get));
            }
        }
        for (QBaseQueue baseQueue : kb.getBaseQueues()) {
            for (QServicePoint qsp : baseQueue.getServicePoints()) {
                addDist.accept(qsp.getServiceTimeDistribution());
            }
            for (QPath qolp : baseQueue.getPaths()) {
                addDist.accept(qolp.getPathSpacingDistribution());
            }
            if (baseQueue.getDistributionUrn() == null) continue;
            addDist.accept(WriteMesh.toIndexUrn(baseQueue.getDistributionUrn(), queues::get));
        }
        return distributions;
    }

    private static Object getProfileProp(OccProfileSim prof, IPropertySet.Prop<?> p) {
        if (!prof.isDefined(p)) {
            return DO_NOT_WRITE;
        }
        Object prop = prof.getProperty(p);
        if (Objects.equals(prop, p.defVal)) {
            return DO_NOT_WRITE;
        }
        return prop;
    }

    public static void writeVersion(PrintWriter out) {
        out.println("[version]");
        out.println(19);
        out.println();
    }

    public static void writeParam(PrintWriter out, Param p) {
        out.println("[param]");
        WriteMesh.writeParam(out, p, 8, "scenario");
        WriteMesh.writeParam(out, p, 8, "show_vis");
        out.println();
        WriteMesh.writeParam(out, p, 12, "dt_init");
        WriteMesh.writeParam(out, p, 12, "max_time");
        WriteMesh.writeParam(out, p, 12, "dt_csv_data");
        WriteMesh.writeParam(out, p, 12, "dt_vis");
        WriteMesh.writeParam(out, p, 12, "dt_wall_meta");
        WriteMesh.writeParam(out, p, 12, "dt_snapshot");
        out.println();
        WriteMesh.writeParam(out, p, 17, "reactive_steering");
        WriteMesh.writeParam(out, p, 17, "inertia");
        WriteMesh.writeParam(out, p, 17, "handle_collisions");
        WriteMesh.writeParam(out, p, 17, "vel_from_density");
        WriteMesh.writeParam(out, p, 17, "density_max");
        out.println();
        WriteMesh.writeParam(out, p, 31, "path_cleanup");
        WriteMesh.writeParam(out, p, 31, "specific_flowrate_max");
        WriteMesh.writeParam(out, p, 31, "attr_default_idle_time");
        WriteMesh.writeParam(out, p, 31, "occtarget_conflict_resolve_time");
        WriteMesh.writeParam(out, p, 31, "dynamictarget_search_dt");
        WriteMesh.writeParam(out, p, 31, "door_flow_from_density");
        WriteMesh.writeParam(out, p, 31, "door_flow_density_min");
        WriteMesh.writeParam(out, p, 31, "door_flow_density_max");
        WriteMesh.writeParam(out, p, 31, "boundary_layer");
        WriteMesh.writeParam(out, p, 31, "low_speed_threshold");
        WriteMesh.writeParam(out, p, 31, "low_speed_averaging_time");
        WriteMesh.writeParam(out, p, 31, "max_trim_error");
        WriteMesh.writeParam(out, p, 31, "min_flowrate_factor");
        WriteMesh.writeParam(out, p, 31, "occ_csv_file_as_one");
        WriteMesh.writeParam(out, p, 31, "write_occ_params_file");
        WriteMesh.writeParam(out, p, 31, "enable_json_output");
        WriteMesh.writeParam(out, p, 31, "measurement_region_seekspeed");
        WriteMesh.writeParam(out, p, 31, "force_separation");
        WriteMesh.writeParam(out, p, 31, "social_distance_csv_output");
        WriteMesh.writeParam(out, p, 31, "social_distance_value");
        WriteMesh.writeParam(out, p, 31, "out_occ_time_history", true);
        WriteMesh.writeParam(out, p, 31, "out_geom_time_history", true);
        WriteMesh.writeParam(out, p, 31, "out_room_usage", true);
        WriteMesh.writeParam(out, p, 31, "out_door_usage", true);
        WriteMesh.writeParam(out, p, 31, "out_summary", true);
        WriteMesh.writeParam(out, p, 31, "out_performance", true);
        WriteMesh.writeParam(out, p, 31, "out_snapshot_base", true);
        WriteMesh.writeParam(out, p, 31, "out_results", true);
        File geomFile = new File(p.imported_geom);
        File viewsFile = new File(p.views);
        if (geomFile.exists()) {
            WriteMesh.writeParam(out, p, 27, "imported_geom", true);
        }
        if (viewsFile.exists()) {
            WriteMesh.writeParam(out, p, 27, "views", true);
        }
        if (p.smvDataEnable) {
            out.println();
            WriteMesh.writeParam(out, p, 19, "smvDataEnable");
            WriteMesh.writeParam(out, p, 19, "smvDataFilePath");
            WriteMesh.writeParam(out, p, 19, "smvDataLastModified");
            WriteMesh.writeParam(out, p, 19, "smvHypoxiaLimit");
        }
        out.println();
    }

    private static void writeParam(PrintWriter out, Param p, int w, String var) {
        WriteMesh.writeParam(out, p, w, var, false);
    }

    private static void writeParam(PrintWriter out, Param p, int w, String var, boolean isFileName) {
        String sVal;
        Object oVal = p.get(var);
        assert (oVal != null);
        if (oVal instanceof Boolean) {
            sVal = (Boolean)oVal != false ? "1" : "0";
        } else if (oVal instanceof String) {
            if (isFileName) {
                oVal = ((String)oVal).substring(((String)oVal).lastIndexOf("\\") + 1);
            }
            sVal = WriteMesh.escapeName(oVal.toString());
        } else {
            sVal = oVal.toString();
        }
        String formatStr = "%-" + w + "s %s%n";
        out.printf(formatStr, var, sVal);
    }

    public static void writeMaterials(File outFile, PrintWriter out, KB kb, Map<Material, Integer> mats) {
        if (mats.isEmpty()) {
            return;
        }
        String outPath = outFile.getAbsolutePath();
        Function<IImage, String> imgSaver = img -> FilenameManager.getRelativeFilename(outPath, img.getFilename(), true);
        out.println("[materials]");
        for (Map.Entry<Material, Integer> entry : mats.entrySet()) {
            Material mat = entry.getKey();
            JSONObject jsonVal = entry.getKey().attrs.toJson(imgSaver);
            jsonVal.put("width", mat.worldWidth);
            jsonVal.put("height", mat.worldHeight);
            out.printf(Locale.US, "%d: %s%n", entry.getValue(), jsonVal);
        }
        out.println();
    }

    private static Map<Material, Integer> getMatMap(KB kb) {
        LinkedIdentityHashMap<Material, Integer> mats = new LinkedIdentityHashMap<Material, Integer>();
        Consumer<Material> addMat = mat -> {
            if (mat == null) {
                return;
            }
            mats.putIfAbsent((Material)mat, mats.size());
        };
        kb.getBlockages().stream().map(blkg -> blkg.material).forEach(addMat);
        kb.getNodes().stream().map(ANode::getMaterial).forEach(addMat);
        return mats;
    }

    public static void writeFloors(PrintWriter out, MerlinData md, InfernoUtil.KBInfo kb, Map<ANode, Integer> nodeMap) {
        out.println("[floors]");
        int ix = 0;
        for (Floor floor : md.floors.getMembers(Floor.class)) {
            out.printf(Locale.US, "%d: %s %s%n", ix, WriteMesh.escapeName(floor.getName()), WriteMesh.df(floor.getWorkingZ().getValue(InfernoUtil.LENGTH_UNIT)));
            ++ix;
        }
        out.println();
    }

    public static Map<ANode, Integer> writeNodes(PrintWriter out, InfernoUtil.KBInfo kb, Map<Material, Integer> materials) {
        int m;
        IdentityHashMap<ANode, Integer> nodeIxMap = new IdentityHashMap<ANode, Integer>();
        HashMap<IPrimProps, Integer> nodeDispMap = new HashMap<IPrimProps, Integer>();
        int[] nodeDisps = new int[kb.kb.getNodes().size()];
        out.println("[nodedisp]");
        for (m = 0; m < kb.kb.getNodes().size(); ++m) {
            ANode node = kb.kb.getNodes().get(m);
            nodeIxMap.put(node, m);
            nodeDisps[m] = WriteMesh.getNodeDisplay(node, nodeDispMap, materials, out);
        }
        out.println();
        out.println("[nodes]");
        for (m = 0; m < kb.kb.getNodes().size(); ++m) {
            ANode n = kb.kb.getNodes().get(m);
            Object capacityStr = "";
            ANode.Capacity c = n.getCapacity();
            if (c != null) {
                if (c instanceof ANode.Count) {
                    capacityStr = (String)capacityStr + String.format(Locale.US, ", %s %d", "count", c.getMaxOccCount());
                } else if (c instanceof ANode.Density) {
                    capacityStr = (String)capacityStr + String.format(Locale.US, ", %s %f", "dens", ((ANode.Density)c).getDensity());
                } else assert (false);
            }
            String tagsStr = "";
            if (!n.getOccTags().isEmpty()) {
                tagsStr = String.format(Locale.US, ", %s %s", "tags", WriteMesh.formatTags(new StringBuilder(), n.getOccTags()).toString());
            }
            out.printf(Locale.US, "%d: %s %d, %d, %d, %s%s%s%n", m, WriteMesh.escapeName(n.name), nodeDisps[m], n.getAnimationId(), n.getResultsID(), WriteMesh.escapeName(n.annotatedName), capacityStr, tagsStr);
        }
        out.println();
        return nodeIxMap;
    }

    private static int getNodeDisplay(ANode node, Map<IPrimProps, Integer> nodeDispMap, Map<Material, Integer> materials, PrintWriter out) {
        Color color = node.getColor();
        Material mat = node.getMaterial();
        if (color == null && mat == null) {
            return -1;
        }
        IPrimProps.Face props = new IPrimProps.Face(color, mat, 0);
        Integer dix = nodeDispMap.get(props);
        if (dix == null) {
            dix = nodeDispMap.size();
            nodeDispMap.put(props, dix);
            out.print(dix);
            out.print(": ");
            float[] ccomps = new float[4];
            color.getComponents(ccomps);
            for (float c : ccomps) {
                out.print(c);
                out.print(" ");
            }
            int matIx = mat != null && materials.containsKey(mat) ? materials.get(mat) : -1;
            out.printf(Locale.US, " %d", matIx);
            out.println();
        }
        return dix;
    }

    public static Map<Vertex, Integer> writeVerts(PrintWriter out, KB kb) {
        out.println("[verts]");
        IdentityHashMap<Vertex, Integer> vertMap = new IdentityHashMap<Vertex, Integer>();
        int ix = 0;
        for (Vertex v : kb.getMesh().getVerts()) {
            out.printf(Locale.US, "%d: %s %s %s%n", ix, WriteMesh.df(v.p.x), WriteMesh.df(v.p.y), WriteMesh.df(v.p.z));
            vertMap.put(v, ix);
            ++ix;
        }
        out.println();
        return vertMap;
    }

    public static Map<Point2f, Integer> writeTexCoords(PrintWriter out, KB kb) {
        out.println("[texcoords]");
        LinkedHashMap<Point2f, Integer> vertMap = new LinkedHashMap<Point2f, Integer>();
        Stream.of(kb.getMesh().getTris()).filter(tri -> tri.uv != null).flatMap(tri -> Stream.of(tri.uv)).forEach(uv -> vertMap.putIfAbsent((Point2f)uv, vertMap.size()));
        int ix = 0;
        for (Point2f uv2 : vertMap.keySet()) {
            out.printf(Locale.US, "%d: %s %s%n", ix, WriteMesh.ff(uv2.x), WriteMesh.ff(uv2.y));
            ++ix;
        }
        out.println();
        return vertMap;
    }

    public static void writeStairs(PrintWriter out, KB kb, Map<ANode, Integer> nodeMap) {
        out.println("[stairs]");
        int ix = 0;
        for (ANode stair : kb.getStairNodes()) {
            int ixNode = nodeMap.get(stair);
            StairData sd = stair.stairData;
            out.printf(Locale.US, "%d: %d %s %s%n", ix, ixNode, WriteMesh.df(sd.rise), WriteMesh.df(sd.tread));
            ++ix;
        }
        out.println();
    }

    public static void writeDoors(PrintWriter out, KB kb, Map<ANode, Integer> nodeMap, Map<IDistributedVal<?>, Integer> distributions) {
        out.println("[doors]");
        int ix = 0;
        for (ANode door : kb.getDoorNodes()) {
            DoorQueue dq = door.doorQueue;
            int ixNode = nodeMap.get(door);
            double effWid = dq.getEffWidth();
            String r1 = "-";
            String r2 = "-";
            if (dq.getR1() != null) {
                r1 = nodeMap.get(dq.getR1()).toString();
            }
            if (dq.getR2() != null) {
                r2 = nodeMap.get(dq.getR2()).toString();
            }
            IDoorFlowrate fr = dq.getFlowrate();
            DoorDir onewayDir = door.getOnewayDir();
            IDistributedVal waitTime = door.doorQueue.getWaitTime();
            String wt = waitTime == null || waitTime instanceof ConstantCurve && theUtil.eq0(((ConstantCurve)waitTime).getAvg().getValueNoUnit(), 1.0E-6) ? "-" : String.valueOf(distributions.get(waitTime));
            out.printf(Locale.US, "%d: %d %s %s %s %s %s %s%n", ix, ixNode, WriteMesh.df(effWid), r1, r2, WriteMesh.format(fr), WriteMesh.format(onewayDir), wt);
            ++ix;
        }
        out.println();
    }

    private static String format(Collection<String> strings, String separator) {
        StringBuilder sb = new StringBuilder();
        sb.append(strings.size());
        sb.append(separator);
        sb.append(String.join((CharSequence)separator, strings));
        return sb.toString();
    }

    private static String format(IDoorFlowrate fr) {
        if (fr instanceof IDoorFlowrate.Fixed) {
            IDoorFlowrate.Fixed fixed = (IDoorFlowrate.Fixed)fr;
            return WriteMesh.df(fixed.flowrate);
        }
        return "-";
    }

    private static String format(DoorDir dir) {
        if (dir == null) {
            return "-";
        }
        if (dir == DoorDir.POSITIVE) {
            return "dir+";
        }
        return "dir-";
    }

    public static void writeMesh(PrintWriter out, KB kb, Map<ANode, Integer> nodeMap, Map<Vertex, Integer> vertMap, Map<Point2f, Integer> uvMap) {
        out.println("[navmesh]");
        int ix = 0;
        for (Tri mt : kb.getMesh().getTris()) {
            int ixNode = nodeMap.get(mt.node);
            String strType = WriteMesh.getTypeStr(mt.terrain);
            out.printf(Locale.US, "%d: %d %s %d %d %d", ix, ixNode, strType, vertMap.get(mt.v[0]), vertMap.get(mt.v[1]), vertMap.get(mt.v[2]));
            if (mt.uv != null) {
                out.printf(Locale.US, " %d %d %d", uvMap.get(mt.uv[0]), uvMap.get(mt.uv[1]), uvMap.get(mt.uv[2]));
            }
            out.println();
            ++ix;
        }
        out.println();
    }

    private static void writeIndexes(PrintWriter out, int ... ixes) {
        for (int triid : ixes) {
            out.print(triid);
            out.print(' ');
        }
    }

    private static void writeIndexes(PrintWriter out, Collection<Integer> ixes) {
        for (int triid : ixes) {
            out.print(triid);
            out.print(' ');
        }
    }

    public static void writeBlockages(PrintWriter out, KB kb, Map<Material, Integer> mats) {
        if (kb.getBlockages().isEmpty()) {
            return;
        }
        out.println("[blockages]");
        int ix = 0;
        for (Blockage blkg : kb.getBlockages()) {
            out.printf(Locale.US, "%d: %s %d %s ", ix, WriteMesh.escapeName(blkg.name), blkg.resultsId, blkg.displayType.name);
            switch (blkg.displayType) {
                case NONE: {
                    break;
                }
                case SIMPLE: {
                    Integer matix = mats.get(blkg.material);
                    if (matix == null) {
                        matix = -1;
                    }
                    out.printf(Locale.US, "%d %s ", matix, WriteMesh.format(blkg.color));
                    break;
                }
                case CAD_GEOM: {
                    out.printf(Locale.US, "%d ", blkg.cadGeomId);
                }
            }
            WriteMesh.writeIndexes(out, blkg.tris);
            out.println();
            ++ix;
        }
        out.println();
    }

    public static void writeAnimatedGeoms(PrintWriter out, KB kb) {
        if (kb.getAnimatedGeoms().isEmpty()) {
            return;
        }
        out.println("[animated-geom]");
        int ix = 0;
        for (AnimatedGeom ageom : kb.getAnimatedGeoms().values()) {
            out.printf(Locale.US, "%d: %s%n", ix, WriteMesh.toJson(ageom).toJSONString());
            ++ix;
        }
        out.println();
    }

    private static JSONObject toJson(AnimatedGeom ageom) {
        JSONObject jobj = new JSONObject();
        jobj.put("id", ageom.resultsId);
        jobj.put("name", ageom.name);
        jobj.put("annotatedName", ageom.annotatedName);
        return jobj;
    }

    public static void writeCameras(PrintWriter out, KB kb) {
        if (kb.getCameras().isEmpty()) {
            return;
        }
        out.println("[cameras]");
        int ix = 0;
        for (Camera cam : kb.getCameras()) {
            Point3d loc = cam.get(Camera.PROP_LOC);
            Point3d ref = cam.get(Camera.PROP_REF);
            Vector3d up = cam.get(Camera.PROP_UP);
            Point2d zoomLoc = cam.get(Camera.PROP_ZOOM_LOC);
            out.printf(Locale.US, "%d: %s %s %s (%s %s %s) (%s %s %s) (%s %s %s) %s (%s %s) %d", ix, WriteMesh.escapeName(cam.get(Camera.PROP_NAME)), cam.get(Camera.PROP_TYPE) == Camera.Type.ORTHO ? "2D" : "3D", WriteMesh.df(cam.get(Camera.PROP_FOV)), WriteMesh.df(loc.x), WriteMesh.df(loc.y), WriteMesh.df(loc.z), WriteMesh.df(ref.x), WriteMesh.df(ref.y), WriteMesh.df(ref.z), WriteMesh.df(up.x), WriteMesh.df(up.y), WriteMesh.df(up.z), WriteMesh.df(cam.get(Camera.PROP_ZOOM)), WriteMesh.df(zoomLoc.x), WriteMesh.df(zoomLoc.y), cam.get(Camera.PROP_SECURITY) != false ? 1 : 0);
            if (cam.get(Camera.PROP_SECURITY).booleanValue()) {
                Vector3d panAxis = cam.get(Camera.PROP_PTZ_ORIENT);
                Camera.PTZSpec pan = cam.get(Camera.PROP_PAN_INFO);
                Camera.PTZSpec tilt = cam.get(Camera.PROP_TILT_INFO);
                Camera.PTZSpec zoom = cam.get(Camera.PROP_ZOOM_INFO);
                out.printf(Locale.US, " (%s %s %s) (%s %s %s) (%s %s %s) (%s %s %s)", WriteMesh.df(panAxis.x), WriteMesh.df(panAxis.y), WriteMesh.df(panAxis.z), WriteMesh.df(pan.rangeMin), WriteMesh.df(pan.rangeMax), WriteMesh.df(pan.maxSpeed), WriteMesh.df(tilt.rangeMin), WriteMesh.df(tilt.rangeMax), WriteMesh.df(tilt.maxSpeed), WriteMesh.df(zoom.rangeMin), WriteMesh.df(zoom.rangeMax), WriteMesh.df(zoom.maxSpeed));
            }
            out.println();
            ++ix;
        }
        System.out.println();
    }

    public static void writeJson(PrintWriter out, MerlinData md, KB kb) {
        ArrayList<AMerlinObj> stuffToWriteAsJson = new ArrayList<AMerlinObj>();
        stuffToWriteAsJson.addAll(md.json.flatten(JsonObj.class));
        stuffToWriteAsJson.addAll(md.regions.flatten(MeasurementRegionObj.class, r -> r.isEnabled()));
        stuffToWriteAsJson.addAll(md.customScripts.flatten(ScriptObj.class));
        if (!stuffToWriteAsJson.isEmpty()) {
            out.println("[json]");
            for (IGetJson iGetJson : stuffToWriteAsJson) {
                String str = iGetJson.getJson();
                str = str.replaceAll("\n", " ");
                out.println(str);
            }
            out.println();
        }
    }

    public static void writeEvents(PrintWriter out, KB kb, Map<ANode, Integer> nodeMap) {
        NavigableMap<Double, EngineOp> events = kb.getEvents();
        if (events.isEmpty()) {
            return;
        }
        out.println("[events]");
        IdentityHashMap<Blockage, Integer> blkgIdMap = new IdentityHashMap<Blockage, Integer>();
        for (int m = 0; m < kb.getBlockages().size(); ++m) {
            blkgIdMap.put(kb.getBlockages().get(m), m);
        }
        IdentityHashMap<AttractorSim, Integer> attrIdMap = new IdentityHashMap<AttractorSim, Integer>();
        for (int m = 0; m < kb.getRootAttractors().size(); ++m) {
            attrIdMap.put(kb.getRootAttractors().get(m), m);
        }
        ArrayList<EngineOp> tevents = new ArrayList<EngineOp>();
        for (Map.Entry entry : events.entrySet()) {
            tevents.clear();
            WriteMesh.flatten((EngineOp)entry.getValue(), tevents);
            for (EngineOp op : tevents) {
                out.print(WriteMesh.df((Double)entry.getKey()));
                out.print(' ');
                if (op instanceof EngineOp.AddBlockage) {
                    EngineOp.AddBlockage ablkg = (EngineOp.AddBlockage)op;
                    out.printf(Locale.US, "add_blockage %s", blkgIdMap.get(ablkg.b));
                } else if (op instanceof EngineOp.RemoveBlockage) {
                    EngineOp.RemoveBlockage rblkg = (EngineOp.RemoveBlockage)op;
                    out.printf(Locale.US, "remove_blockage %s", blkgIdMap.get(rblkg.b));
                } else if (op instanceof EngineOp.SetBlockageSpeedModifier) {
                    EngineOp.SetBlockageSpeedModifier sblkg = (EngineOp.SetBlockageSpeedModifier)op;
                    out.printf(Locale.US, "set_blockage_speed_mod %s %s %s", new Object[]{blkgIdMap.get(sblkg.b), sblkg.smod.type, WriteMesh.df(sblkg.smod.value)});
                } else if (op instanceof EngineOp.SetDoorState) {
                    EngineOp.SetDoorState sds = (EngineOp.SetDoorState)op;
                    int ix = nodeMap.get(sds.door);
                    double openTime = sds.est == null || sds.est.getTime(kb, null, null) == Double.POSITIVE_INFINITY ? -1.0 : sds.est.getTime(kb, null, null);
                    Object cmd = "";
                    if (sds.openOrClose) {
                        cmd = sds.est == null ? "open_door" : "close_door";
                    } else if (sds.setDirection) {
                        cmd = "change_door_dir " + sds.onewayVec.x + " " + sds.onewayVec.y;
                    }
                    out.printf(Locale.US, "%s %d %.1f", cmd, ix, openTime);
                } else if (op instanceof EngineOp.SetSpeedModifier) {
                    EngineOp.SetSpeedModifier sm = (EngineOp.SetSpeedModifier)op;
                    String type = sm.modifier.type.name();
                    out.printf(Locale.US, "set_speed_mod %s %s %d", type, WriteMesh.df(sm.modifier.value), nodeMap.get(sm.node));
                } else if (op instanceof EngineOp.SetAttractorInfluence) {
                    EngineOp.SetAttractorInfluence ai = (EngineOp.SetAttractorInfluence)op;
                    out.printf(Locale.US, "set_attractor_influence %d %s", attrIdMap.get(ai.attr), WriteMesh.df(ai.influence));
                }
                out.println();
            }
        }
        out.println();
    }

    private static void flatten(EngineOp op, List<EngineOp> ops) {
        ArrayDeque<EngineOp> open = new ArrayDeque<EngineOp>();
        open.push(op);
        while (!open.isEmpty()) {
            op = (EngineOp)open.pop();
            if (op instanceof EngineOp.MultiOp) {
                EngineOp.MultiOp mop = (EngineOp.MultiOp)op;
                for (EngineOp cop : mop.ops) {
                    open.push(cop);
                }
                continue;
            }
            ops.add(op);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeElevators(PrintWriter out, KB kb, Map<ANode, Integer> nodeMap) {
        void var8_15;
        Object elevator;
        int m;
        ElevatorModel em = kb.getElevatorModel();
        List<Elevator> elevators = em.getElevators();
        if (elevators.isEmpty()) {
            return;
        }
        LinkedHashMap<IElevatorTimingModel, Integer> timingModels = new LinkedHashMap<IElevatorTimingModel, Integer>();
        out.println("[elevators]");
        for (m = 0; m < elevators.size(); ++m) {
            elevator = elevators.get(m);
            timingModels.putIfAbsent(((Elevator)elevator).getTimingModel(), timingModels.size());
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("id", m);
            jSONObject.put("name", ((Elevator)elevator).getName());
            jSONObject.put("type", ((Elevator)elevator).getType().toString());
            jSONObject.put("call_distance", ((Elevator)elevator).getCallDistance());
            jSONObject.put("double_deck", ((Elevator)elevator).isDoubleDeck());
            jSONObject.put("initial_floor", nodeMap.get(((Elevator)elevator).getInitNode()));
            jSONObject.put("timing_model", timingModels.get(((Elevator)elevator).getTimingModel()));
            if (((Elevator)elevator).isDoubleDeck()) {
                ANode travleingNode = ((Elevator)elevator).getTravelingNode();
                jSONObject.put("lower_deck_discharge", nodeMap.get(travleingNode));
                jSONObject.put("upper_deck_discharge", nodeMap.get(((Elevator)elevator).getUpperLevelFor((ElevatorLevel)travleingNode.getElevatorLevel()).pickupNode));
            }
            out.println(jSONObject.toString());
        }
        out.println();
        out.println("[elevator-discharge]");
        for (m = 0; m < elevators.size(); ++m) {
            elevator = elevators.get(m);
            int n = nodeMap.get(((Elevator)elevator).getTravelingNode());
            double openTime = ((Elevator)elevator).getOpenTime();
            double closeDelay = ((Elevator)elevator).getCloseDelay();
            double sizeFactor = ((Elevator)elevator).getSizeFactor();
            double maxDensity = ((Elevator)elevator).getMaxDensity();
            out.printf(Locale.US, "%d: %d, %s, %s, %s, %s%n", m, n, WriteMesh.df(openTime), WriteMesh.df(closeDelay), WriteMesh.df(sizeFactor), WriteMesh.df(maxDensity));
        }
        out.println();
        out.println("[elevator-level-data]");
        for (m = 0; m < elevators.size(); ++m) {
            elevator = elevators.get(m);
            List<ElevatorLevel> list = ((Elevator)elevator).getLevels();
            Collections.sort(list, new Comparator<ElevatorLevel>(){

                @Override
                public int compare(ElevatorLevel o1, ElevatorLevel o2) {
                    AABox bounds1 = o1.pickupNode.getGeometryBounds();
                    AABox bounds2 = o2.pickupNode.getGeometryBounds();
                    return Double.compare(bounds1.getMinZ(), bounds2.getMinZ());
                }
            });
            if (m != 0) {
                out.println();
            }
            for (ElevatorLevel level : list) {
                double firstAvailable = level.isEnabled() ? level.tFirstAvailable : Double.POSITIVE_INFINITY;
                out.printf(Locale.US, "%d, %d, %d, %s, %s, %s%n", m, nodeMap.get(level.pickupNode), level.levelId, WriteMesh.df(level.openTime), WriteMesh.df(level.closeTime), WriteMesh.df(firstAvailable));
            }
            out.println();
        }
        Collection<Set<Elevator>> linkedElevators = em.getLinkedElevators();
        if (!linkedElevators.isEmpty()) {
            out.println("[elevator-links]");
            for (Set set : linkedElevators) {
                Iterator it = set.iterator();
                while (it.hasNext()) {
                    int ix = elevators.indexOf(it.next());
                    assert (ix >= 0);
                    out.print(ix);
                    if (!it.hasNext()) continue;
                    out.print(", ");
                }
                out.println();
            }
            out.println();
        }
        boolean priorityHeaderWritten = false;
        boolean bl = false;
        while (var8_15 < elevators.size()) {
            List<Integer> floorPriority = elevators.get((int)var8_15).getTopPriorityFloors();
            if (!floorPriority.isEmpty()) {
                if (!priorityHeaderWritten) {
                    out.println("[elevator-priority]");
                    priorityHeaderWritten = true;
                }
                out.printf(Locale.US, "%d,  ", (int)var8_15);
                for (int n = 0; n < floorPriority.size(); ++n) {
                    if (n != 0) {
                        out.print(", ");
                    }
                    out.print(floorPriority.get(n));
                }
                out.println();
            }
            ++var8_15;
        }
        if (priorityHeaderWritten) {
            out.println();
        }
        boolean bl2 = false;
        for (Map.Entry entry : timingModels.entrySet()) {
            boolean bl3;
            if (!bl3) {
                out.println("[elevator-timing-models]");
                bl3 = true;
            }
            out.printf(Locale.US, "%d: ", entry.getValue());
            if (entry.getKey() instanceof IElevatorTimingModel.AccelModel) {
                model = (IElevatorTimingModel.AccelModel)entry.getKey();
                timing = new JSONObject();
                timeVals = new JSONArray();
                timeVals.add(model.accel);
                timeVals.add(model.maxVel);
                timing.put("type", "acc");
                timing.put("values", timeVals);
                out.println(timing.toJSONString());
            } else if (entry.getKey() instanceof IElevatorTimingModel.VelModel) {
                model = (IElevatorTimingModel.VelModel)entry.getKey();
                timing = new JSONObject();
                timeVals = new JSONArray();
                timeVals.add(((IElevatorTimingModel.VelModel)model).vel);
                timing.put("type", "acc");
                timing.put("values", timeVals);
                out.println(timing.toJSONString());
            } else if (entry.getKey() instanceof IElevatorTimingModel.DistModel) {
                model = (IElevatorTimingModel.DistModel)entry.getKey();
                timing = new JSONObject();
                JSONArray timeMap = new JSONArray();
                for (Map.Entry<Double, Double> timeEntry : ((IElevatorTimingModel.DistModel)model).timeMap.entrySet()) {
                    JSONArray times = new JSONArray();
                    times.add(timeEntry.getKey());
                    times.add(timeEntry.getValue());
                    timeMap.add(times);
                }
                timing.put("type", "leg");
                timing.put("def_vel", ((IElevatorTimingModel.DistModel)model).defaultVel);
                timing.put("values", timeMap);
                out.println(timing.toJSONString());
            }
            out.println();
        }
    }

    private static void addParents(IMerlinObj obj, Collection<IMerlinObj> parents) {
        IMerlinObj parent = (IMerlinObj)obj.getParent();
        if (parent != null && parent != obj.getDomain()) {
            WriteMesh.addParents(parent, parents);
            parents.add(parent);
        }
    }

    public static void writeHierarchy(PrintWriter out, InfernoUtil.KBInfo kb) {
        LinkedIdentityHashSet<IMerlinObj> objs = new LinkedIdentityHashSet<IMerlinObj>();
        IdentityHashMap<IEgressObj, IEgressComp> implicitObjs = new IdentityHashMap<IEgressObj, IEgressComp>();
        for (Map.Entry<IEgressComp, List<InfernoGeom>> entry : kb.igeoms.finalComps.entrySet()) {
            IEgressComp node = entry.getKey();
            WriteMesh.addParents(node, objs);
            objs.add(node);
            for (InfernoGeom igeom : entry.getValue()) {
                if (igeom.source == node || !(igeom.source instanceof IMerlinObj)) continue;
                IEgressObj otherObj = igeom.source;
                WriteMesh.addParents(otherObj, objs);
                objs.add(otherObj);
                if (otherObj.getParent() != null) continue;
                implicitObjs.put(otherObj, node);
            }
        }
        for (QueueObject queue : kb.queueList) {
            WriteMesh.addParents(queue, objs);
            objs.add(queue);
        }
        for (Attractor attr : kb.attractorList) {
            WriteMesh.addParents(attr, objs);
            objs.add(attr);
        }
        Collection composites = objs.stream().filter(new TypeFilter(Composite.class)).map(obj -> (Composite)obj).collect(Collectors.toList());
        out.println("[composites]");
        for (Composite comp : composites) {
            out.printf(Locale.US, "%s %d%n", WriteMesh.escapeName(comp.getName()), comp.getResultsId());
        }
        out.println();
        out.println("[hierarchy]");
        for (IMerlinObj obj2 : objs) {
            IMerlinObj srcObj;
            long parentId = 0L;
            Object parent = obj2.getParent();
            if (parent == null && (srcObj = (IMerlinObj)implicitObjs.get(obj2)) != null) {
                parent = srcObj.getParent();
            }
            if (parent instanceof IMerlinObj) {
                parentId = ((IMerlinObj)parent).getResultsId();
            }
            out.printf(Locale.US, "%d %d%n", obj2.getResultsId(), parentId);
        }
        out.println();
    }

    public static void writeEdges(PrintWriter out, KB kb, Map<ANode, Integer> nodeMap, Map<Vertex, Integer> vertMap) {
        EdgeData ed;
        out.println("[edges]");
        LinkedHashMap<UEdge, EdgeData> edgeMap = new LinkedHashMap<UEdge, EdgeData>();
        for (WingedEdge e : kb.getMesh().getEdges()) {
            boolean overwrite;
            int i2;
            ed = e.data;
            int i1 = vertMap.get(e.base.n1);
            UEdge uedge = new UEdge(i1, i2 = vertMap.get(e.base.n2).intValue());
            EdgeData edExisting = (EdgeData)edgeMap.get(uedge);
            boolean bl = overwrite = edExisting == null || (ed.type & 1) > 0 || ed.type == 4 && edExisting.type == 0;
            if (!overwrite) continue;
            edgeMap.put(uedge, ed);
        }
        int ix = 0;
        for (Map.Entry entry : edgeMap.entrySet()) {
            UEdge edge = (UEdge)entry.getKey();
            ed = (EdgeData)entry.getValue();
            switch (ed.type) {
                case 4: {
                    out.printf(Locale.US, "%d: boundary  %d %d%n", ix, edge.i1, edge.i2);
                    ++ix;
                    break;
                }
                case 1: {
                    int ixNode = nodeMap.get(ed.node);
                    out.printf(Locale.US, "%d: door      %d %d %d%n", ix, ixNode, edge.i1, edge.i2);
                    ++ix;
                    break;
                }
                case 3: {
                    int ixNode = nodeMap.get(ed.node);
                    out.printf(Locale.US, "%d: exit_door %d %d %d%n", ix, ixNode, edge.i1, edge.i2);
                    ++ix;
                    break;
                }
            }
        }
        out.println();
    }

    private static String strNodeList(Collection<ANode> nodes, Map<ANode, Integer> nodeMap) {
        StringBuilder out = new StringBuilder();
        if (nodes != null && !nodes.isEmpty()) {
            for (ANode n : nodes) {
                int ixNode = nodeMap.get(n);
                out.append(String.format(Locale.US, "%d, ", ixNode));
            }
            out.replace(out.length() - 2, out.length(), "");
        } else {
            out.append("any");
        }
        return out.toString();
    }

    public static String escape(Pattern escapePattern, String s) {
        if (s.isEmpty()) {
            return s;
        }
        Matcher matcher = escapePattern.matcher(s);
        if (!matcher.find()) {
            return s;
        }
        int prevEnd = 0;
        StringBuffer result = new StringBuffer("\"");
        do {
            result.append(s, prevEnd, matcher.start());
            String group1 = matcher.group(1);
            if (group1 != null) {
                result.append(group1);
            } else {
                result.append('\\');
                result.append(s, matcher.start(), matcher.end());
            }
            prevEnd = matcher.end();
        } while (matcher.find());
        result.append(s, prevEnd, s.length());
        result.append("\"");
        return result.toString();
    }

    public static String quoteAndEscape(Pattern escapePattern, String s) {
        Matcher matcher = escapePattern.matcher(s);
        int prevEnd = 0;
        StringBuffer result = new StringBuffer("\"");
        while (matcher.find()) {
            result.append(s, prevEnd, matcher.start());
            result.append('\\');
            result.append(s, matcher.start(), matcher.end());
            prevEnd = matcher.end();
        }
        result.append(s, prevEnd, s.length());
        result.append("\"");
        return result.toString();
    }

    public static String escapeName(String name) {
        return WriteMesh.quoteAndEscape(NAME_ESCAPE, name);
    }

    private static StringBuilder formatTags(StringBuilder action, Collection<Tag> itags) {
        List tags = itags.stream().map(tag -> WriteMesh.escape(GOAL_ESCAPE, tag.name)).collect(Collectors.toList());
        action.append('(');
        action.append(String.join((CharSequence)", ", tags));
        action.append(')');
        return action;
    }

    public static void writeBehaviors(PrintWriter out, KB kb, Map<BehaviorSim, Integer> behaviors, Map<OccProfileSim, Integer> profiles, Map<ANode, Integer> nodeMap, Map<IDistributedVal<?>, Integer> distributions, Map<Counter, Integer> counters, Map<OccProfileSim.IShapeGen, Integer> shapes, Map<AssistedEvacTeam, Integer> aeTeams, Map<IFunction1d, Integer> functions, Map<OccProfileSim.CompRestrictions, Integer> compRestrictionsMap, Map<Predicate<AttractorSim>, Integer> attrFilters, Map<QMetaQueue, Integer> qMap, Map<OccTarget, Integer> occTargets, Map<AttractorSim, Integer> attractors) {
        out.println("[behaviors]");
        int ix = 0;
        for (BehaviorSim script : behaviors.keySet()) {
            out.printf(Locale.US, "%d: ", ix);
            ArrayList<String> strVals = new ArrayList<String>(script.size());
            for (IGoal goal : script) {
                String opStr;
                IIdleGoal ctg;
                IPropertySet.Prop prop;
                IIdleGoal sopg;
                JSONObject jobj;
                Collection<ANode> nodeTargets;
                String action;
                IIdleGoal wg;
                Object action2;
                String action3;
                if (goal instanceof ExitGoal) {
                    action3 = String.format(Locale.US, "goto exit %s", WriteMesh.strNodeList(((ExitGoal)goal).exits, nodeMap));
                    strVals.add(action3);
                    continue;
                }
                if (goal instanceof PointGoal) {
                    Point3d pt = ((PointGoal)goal).ptSrc.getTriPoint().p;
                    action2 = String.format(Locale.US, "goto point (%s, %s, %s) %s", WriteMesh.df(pt.x), WriteMesh.df(pt.y), WriteMesh.df(pt.z), WriteMesh.df(((PointGoal)goal).radius));
                    strVals.add((String)action2);
                    continue;
                }
                if (goal instanceof WaitGoal) {
                    wg = (WaitGoal)goal;
                    action2 = String.format(Locale.US, "wait mode %s curve %d", ((WaitGoal)wg).mode.name(), distributions.get(((WaitGoal)wg).time));
                    strVals.add((String)action2);
                    continue;
                }
                if (goal instanceof WaitUntilGoal) {
                    WaitUntilGoal wug = (WaitUntilGoal)goal;
                    if (wug.waitSrc instanceof IEventTime.SimpleEventTime) {
                        IEventTime.SimpleEventTime simpleSrc = (IEventTime.SimpleEventTime)wug.waitSrc;
                        String action4 = String.format(Locale.US, "wait_until %s mode %s %d", simpleSrc.getInputFileInfo().key, wug.mode.name(), distributions.get(simpleSrc.d_waitTime));
                        strVals.add(action4);
                        continue;
                    }
                    if (wug.waitSrc instanceof IEventTime.CycledEventTime) {
                        IEventTime.CycledEventTime cycleSrc = (IEventTime.CycledEventTime)wug.waitSrc;
                        String action5 = String.format(Locale.US, "wait_until %s mode %s %d %d", new Object[]{cycleSrc.getInputFileInfo(), wug.mode.name(), distributions.get(cycleSrc.d_initialTime), distributions.get(cycleSrc.d_intervalTime)});
                        strVals.add(action5);
                        continue;
                    }
                    if (!(wug.waitSrc instanceof IEventTime.ListedEventTime)) continue;
                    IEventTime.ListedEventTime listSrc = (IEventTime.ListedEventTime)wug.waitSrc;
                    StringBuilder curveStr = new StringBuilder();
                    for (ICurve goTime : listSrc.d_goTimes) {
                        curveStr.append(String.format(Locale.US, "%d ", distributions.get(goTime)));
                    }
                    curveStr.replace(curveStr.length() - 2, curveStr.length(), "");
                    action = String.format(Locale.US, "wait_until %s mode %s %s", new Object[]{listSrc.getInputFileInfo(), wug.mode.name(), curveStr.toString()});
                    strVals.add(action);
                    continue;
                }
                if (goal instanceof RoomGoal) {
                    RoomGoal rg = (RoomGoal)goal;
                    nodeTargets = rg.getRooms();
                    String action6 = String.format(Locale.US, "goto room %s", WriteMesh.strNodeList(nodeTargets, nodeMap));
                    strVals.add(action6);
                    continue;
                }
                if (goal instanceof QueueGoal) {
                    QueueGoal queueGoal = (QueueGoal)goal;
                    action2 = String.format(Locale.US, "goto queue %d", qMap.get(queueGoal.qSrc));
                    strVals.add((String)action2);
                    continue;
                }
                if (goal instanceof OccTargetGoal) {
                    OccTargetGoal olg = (OccTargetGoal)goal;
                    action2 = String.format(Locale.US, "goto occtargets %s %s", new Object[]{olg.distPref, olg.priorityPref});
                    if (!olg.targets.isEmpty()) {
                        assert (occTargets.keySet().containsAll(olg.targets));
                        String locStr = olg.targets.stream().map(target -> ((Integer)occTargets.get(target)).toString()).collect(Collectors.joining(","));
                        action2 = (String)action2 + " " + locStr;
                    }
                    strVals.add((String)action2);
                    continue;
                }
                if (goal instanceof DynamicTargetGoal) {
                    DynamicTargetGoal dtg = (DynamicTargetGoal)goal;
                    jobj = dtg.toJson(kb);
                    strVals.add(String.format(Locale.US, "goto dynamic_target \"%s\"", jobj.toJSONString()));
                    continue;
                }
                if (goal instanceof WaitUntilInsideGoal) {
                    wg = (WaitUntilInsideGoal)goal;
                    nodeTargets = ((WaitUntilInsideGoal)wg).getGoals();
                    String action7 = String.format(Locale.US, "wait_until_inside %s", WriteMesh.strNodeList(nodeTargets, nodeMap));
                    strVals.add(action7);
                    continue;
                }
                if (goal instanceof ElevatorGoal) {
                    ElevatorGoal eg = (ElevatorGoal)goal;
                    action2 = WriteMesh.writeElevatorGoal(eg, kb.getElevatorModel());
                    strVals.add((String)action2);
                    continue;
                }
                if (goal instanceof ChangeCounterGoal) {
                    ChangeCounterGoal ccg = (ChangeCounterGoal)goal;
                    assert (ccg.operator instanceof BigDecimalOp);
                    if (!(ccg.operator instanceof BigDecimalOp)) continue;
                    BigDecimalOp bdo = (BigDecimalOp)ccg.operator;
                    action = String.format("change_counter %d %s %s", counters.get(ccg.counter), switch (bdo.type) {
                        case BigDecimalOp.Type.ADD -> "+";
                        case BigDecimalOp.Type.SUBTRACT -> "-";
                        case BigDecimalOp.Type.DIVIDE -> "/";
                        case BigDecimalOp.Type.MULTIPLY -> "*";
                        default -> {
                            if (!$assertionsDisabled) {
                                throw new AssertionError();
                            }
                            yield "+";
                        }
                    }, bdo.rval.toString());
                    strVals.add(action);
                    continue;
                }
                if (goal instanceof WaitForCounterGoal) {
                    WaitForCounterGoal wfcg = (WaitForCounterGoal)goal;
                    assert (wfcg.condition instanceof ComparePredicate);
                    if (!(wfcg.condition instanceof ComparePredicate)) continue;
                    ComparePredicate cp = (ComparePredicate)wfcg.condition;
                    action = String.format("wait_counter mode %s %d %s %s", wfcg.mode.name(), counters.get(wfcg.counter), switch (cp.type) {
                        case ComparePredicate.Type.EQUAL -> "==";
                        case ComparePredicate.Type.GEQUAL -> ">=";
                        case ComparePredicate.Type.GREATER -> ">";
                        case ComparePredicate.Type.LEQUAL -> "<=";
                        case ComparePredicate.Type.LESS -> "<";
                        default -> {
                            if (!$assertionsDisabled) {
                                throw new AssertionError();
                            }
                            yield "==";
                        }
                    }, ((BigDecimal)cp.rval).toString());
                    strVals.add(action);
                    continue;
                }
                if (goal instanceof JoinOccGroupGoal) {
                    JoinOccGroupGoal jog = (JoinOccGroupGoal)goal;
                    action2 = "";
                    if (jog.group instanceof OccGroup) {
                        action2 = String.format(Locale.US, "join_group %d", jog.group.getID());
                    } else if (jog.group instanceof OccGroupType) {
                        action2 = String.format(Locale.US, "join_group_type %d", jog.group.getID());
                    }
                    strVals.add((String)action2);
                    continue;
                }
                if (goal instanceof SetOccPropGoal) {
                    sopg = (SetOccPropGoal)goal;
                    prop = (IPropertySet.Prop)((Object)sopg.prop);
                    Object jsonVal = WriteMesh.convertProfilePropToJson(prop, sopg.value, shapes, functions, distributions, compRestrictionsMap, attrFilters);
                    assert (jsonVal != null);
                    if (jsonVal == null) continue;
                    JSONObject jsonobj = new JSONObject();
                    jsonobj.put("val", jsonVal);
                    String jsonStr = jsonobj.toJSONString();
                    String action8 = String.format("set_prop %s, \"%s\"", prop.key.toString(), jsonStr);
                    strVals.add(action8);
                    continue;
                }
                if (goal instanceof SetOccPropToProfileGoal) {
                    sopg = (SetOccPropToProfileGoal)goal;
                    prop = (IPropertySet.Prop)((Object)((SetOccPropToProfileGoal)sopg).prop);
                    String action9 = String.format("set_prop_to_profile %s", prop.key.toString());
                    strVals.add(action9);
                    continue;
                }
                if (goal instanceof WaitForAssistanceGoal) {
                    WaitForAssistanceGoal wfa = (WaitForAssistanceGoal)goal;
                    action2 = new StringBuilder("get_assistance");
                    ((StringBuilder)action2).append(String.format(Locale.US, " mode %s", wfa.waitMode.name()));
                    Iterator<AssistedEvacTeam> it = wfa.teams.iterator();
                    if (it.hasNext()) {
                        ((StringBuilder)action2).append(' ');
                    }
                    while (it.hasNext()) {
                        AssistedEvacTeam team = it.next();
                        ((StringBuilder)action2).append(aeTeams.get(team));
                        if (!it.hasNext()) continue;
                        ((StringBuilder)action2).append(", ");
                    }
                    strVals.add(((StringBuilder)action2).toString());
                    continue;
                }
                if (goal instanceof DetachGoal) {
                    action3 = "detach_assistants";
                    strVals.add(action3);
                    continue;
                }
                if (goal instanceof AssistOccupantsGoal) {
                    AssistOccupantsGoal aog = (AssistOccupantsGoal)goal;
                    String rooms = ((AssistOccupantsGoal)goal).rooms.stream().map(room -> Integer.toString((Integer)nodeMap.get(room))).collect(Collectors.joining(","));
                    String action10 = String.format("assist %d %s %s %s", aeTeams.get(aog.team), aog.clientAwareness.name(), WriteMesh.df(aog.awarenessRadius), rooms);
                    strVals.add(action10.toString());
                    continue;
                }
                if (goal instanceof WaitUntilTaggedGoal && Predicates.alwaysTrue(((WaitUntilTaggedGoal)goal).occFilter) && Predicates.alwaysTrue(((WaitUntilTaggedGoal)goal).occSourceFilter)) {
                    WaitUntilTaggedGoal wutg = (WaitUntilTaggedGoal)goal;
                    action2 = new StringBuilder("wait_until_all_tagged ");
                    ((StringBuilder)action2).append(String.format(Locale.US, "mode %s ", wutg.mode.name()));
                    WriteMesh.formatTags((StringBuilder)action2, theUtil.filter(kb.getTags(), wutg.tagFilter));
                    strVals.add(((StringBuilder)action2).toString());
                    continue;
                }
                if (goal instanceof WaitUntilEndGoal) {
                    WaitUntilEndGoal wueg = (WaitUntilEndGoal)goal;
                    strVals.add(String.format(Locale.US, "wait_until_end mode %s", wueg.mode.name()));
                    continue;
                }
                if (goal instanceof ChangeTagGoal) {
                    ctg = (ChangeTagGoal)goal;
                    switch (ctg.operator) {
                        case TAG: {
                            opStr = "tag";
                            break;
                        }
                        case UNTAG: {
                            opStr = "untag";
                            break;
                        }
                        default: {
                            assert (false);
                            opStr = "";
                        }
                    }
                    StringBuilder action11 = new StringBuilder(opStr);
                    action11.append(' ');
                    WriteMesh.formatTags(action11, ctg.tags);
                    strVals.add(action11.toString());
                    continue;
                }
                if (goal instanceof SetTagGoal) {
                    ctg = (SetTagGoal)goal;
                    opStr = "set_tag";
                    StringBuilder action12 = new StringBuilder(opStr);
                    action12.append(' ');
                    WriteMesh.formatTags(action12, ((SetTagGoal)ctg).tags);
                    strVals.add(action12.toString());
                    continue;
                }
                if (goal instanceof LookAtGoal) {
                    LookAtGoal lag = (LookAtGoal)goal;
                    jobj = lag.toJson();
                    strVals.add(String.format(Locale.US, "look_at \"%s\"", jobj.toJSONString()));
                    continue;
                }
                if (goal instanceof LookAheadGoal) {
                    strVals.add("look_ahead");
                    continue;
                }
                if (goal instanceof FillRoomGoal) {
                    if (((FillRoomGoal)goal).onlyIfNeeded) {
                        strVals.add("fill_room_if_necessary");
                        continue;
                    }
                    strVals.add("fill_room");
                    continue;
                }
                if (goal instanceof ChangeBehaviorGoal) {
                    ChangeBehaviorGoal changeBehaviorGoal = (ChangeBehaviorGoal)goal;
                    action2 = new StringBuilder("change_behavior ");
                    int urnId = distributions.get(WriteMesh.toIndexUrn(changeBehaviorGoal.getBehaviorUrn(), behaviors::get));
                    ((StringBuilder)action2).append(urnId);
                    strVals.add(((StringBuilder)action2).toString());
                    continue;
                }
                if (goal instanceof ChangeProfileGoal) {
                    ChangeProfileGoal changeProfileGoal = (ChangeProfileGoal)goal;
                    assert (changeProfileGoal.getPropFilter() == ChangeProfileGoal.UI_PROP_FILTER) : "We don't support other property filters yet for ChangeProfileGoal";
                    action2 = new StringBuilder("change_profile ");
                    int urnId = distributions.get(WriteMesh.toIndexUrn(changeProfileGoal.getProfileUrn(), profiles::get));
                    ((StringBuilder)action2).append(urnId);
                    strVals.add(((StringBuilder)action2).toString());
                    continue;
                }
                if (goal instanceof CreateAttractorGoal) {
                    CreateAttractorGoal createAttractorGoal = (CreateAttractorGoal)goal;
                    action2 = new StringBuilder("create_attractor ");
                    ((StringBuilder)action2).append(createAttractorGoal.locationMode.toString());
                    ((StringBuilder)action2).append(' ');
                    if (createAttractorGoal.locationMode == CreateAttractorGoal.LocationMode.FIXED_LOCATION) {
                        Point3d loc = createAttractorGoal.fixedLocation.p;
                        ((StringBuilder)action2).append(String.format(Locale.US, "(%s, %s, %s) ", WriteMesh.df(loc.x), WriteMesh.df(loc.y), WriteMesh.df(loc.z)));
                    }
                    if (!createAttractorGoal.attractors.isEmpty()) {
                        assert (attractors.keySet().containsAll(createAttractorGoal.attractors));
                        String attrString = createAttractorGoal.attractors.stream().map(attr -> ((Integer)attractors.get(attr)).toString()).collect(Collectors.joining(","));
                        ((StringBuilder)action2).append(attrString);
                    }
                    strVals.add(((StringBuilder)action2).toString());
                    continue;
                }
                if (goal instanceof DestroyAttractorGoal) {
                    DestroyAttractorGoal destroyAttractorGoal = (DestroyAttractorGoal)goal;
                    action2 = new StringBuilder("destroy_attractor ");
                    if (!destroyAttractorGoal.attractors.isEmpty()) {
                        assert (attractors.keySet().containsAll(destroyAttractorGoal.attractors));
                        String attrString = destroyAttractorGoal.attractors.stream().map(attr -> ((Integer)attractors.get(attr)).toString()).collect(Collectors.joining(","));
                        ((StringBuilder)action2).append(attrString);
                    }
                    strVals.add(((StringBuilder)action2).toString());
                    continue;
                }
                if (goal instanceof RemoveSelfGoal) {
                    strVals.add("remove_self");
                    continue;
                }
                if (goal instanceof AbandonOccTargetsGoal) {
                    AbandonOccTargetsGoal aol = (AbandonOccTargetsGoal)goal;
                    action2 = new StringBuilder("abandon_occ_locs ");
                    ((StringBuilder)action2).append(aol.which.name());
                    strVals.add(((StringBuilder)action2).toString());
                    continue;
                }
                System.err.println("Simulator Input File Invalid, Unknown goal type: " + goal.getClass().getName());
            }
            JSONObject json = new JSONObject();
            json.put("name", script.name);
            json.put("color", WriteMesh.convertColorToJSON(script.color));
            json.put("script", String.join((CharSequence)"; ", strVals));
            out.println(json.toJSONString());
            ++ix;
        }
        out.println();
    }

    public static void writeTags(PrintWriter out, KB kb) {
        out.println("[tags]");
        int ix = 0;
        for (Tag tag : kb.getTags()) {
            if (tag.isPredefined()) continue;
            out.printf(Locale.US, "%d: ", ix++);
            JSONObject json = new JSONObject();
            json.put("name", tag.name);
            json.put("desc", tag.desc);
            for (Tag.Options option : tag.options) {
                json.put(option.name().toLowerCase(), true);
            }
            out.println(json.toJSONString());
        }
        out.println();
    }

    private static String writeElevatorGoal(ElevatorGoal eg, ElevatorModel elevatorModel) {
        StringBuilder sb = new StringBuilder();
        sb.append("goto elevator ");
        if (eg.useAnyElevator()) {
            sb.append("any");
        } else {
            int m = 0;
            for (Elevator el : eg.getElevators()) {
                int index = elevatorModel.getElevators().indexOf(el);
                sb.append(index);
                if (m != eg.getElevators().size() - 1) {
                    sb.append(", ");
                }
                ++m;
            }
        }
        sb.append(String.format(Locale.US, " %d", eg.getTargetLevelID()));
        return sb.toString();
    }

    private static void writeProfiles(PrintWriter out, Collection<OccProfileSim> profiles, Map<OccProfileSim.IShapeGen, Integer> shapes, Map<IFunction1d, Integer> functions, Map<IDistributedVal<?>, Integer> distributions, Map<OccProfileSim.CompRestrictions, Integer> compRestrictionsMap, Map<Predicate<AttractorSim>, Integer> attrFilters) {
        if (profiles.isEmpty()) {
            return;
        }
        out.println("[profiles]");
        int ix = 0;
        for (OccProfileSim occProfile : profiles) {
            out.printf(Locale.US, "%d: %s %n", ix, WriteMesh.convertOccProfileToJson(occProfile, shapes, functions, distributions, compRestrictionsMap, attrFilters).toJSONString());
            ++ix;
        }
        out.println();
    }

    public static void writeShapes(PrintWriter out, KB kb, Map<OccProfileSim.IShapeGen, Integer> shapes, Map<IDistributedVal<?>, Integer> distributions) {
        if (shapes.isEmpty()) {
            return;
        }
        out.println("[occshapes]");
        for (Map.Entry<OccProfileSim.IShapeGen, Integer> entry : shapes.entrySet()) {
            OccProfileSim.IShapeGen shape = entry.getKey();
            out.print(entry.getValue());
            out.print(": ");
            out.println(WriteMesh.formatBodyShape(shape, distributions));
        }
        out.println();
    }

    public static void writeQueues(PrintWriter out, Map<QMetaQueue, Integer> qMap, Map<IDistributedVal<?>, Integer> distributions) {
        ArrayList<QBaseQueue> baseQueues = new ArrayList<QBaseQueue>();
        ArrayList<QMetaQueue> metaQueues = new ArrayList<QMetaQueue>();
        for (QMetaQueue queue : qMap.keySet()) {
            if (queue instanceof QBaseQueue) {
                baseQueues.add((QBaseQueue)queue);
                continue;
            }
            metaQueues.add(queue);
        }
        if (!baseQueues.isEmpty()) {
            out.println("[basequeues]");
            for (QBaseQueue base : baseQueues) {
                out.print(qMap.get(base));
                out.print(": ");
                JSONObject jsonQueue = base.toJSON(distributions);
                out.println(jsonQueue.toJSONString());
            }
            out.println();
        }
        if (!metaQueues.isEmpty()) {
            assert (!baseQueues.isEmpty());
            out.println("[metaqueues]");
            for (QMetaQueue meta : metaQueues) {
                out.print(qMap.get(meta));
                out.print(": ");
                JSONObject obj = new JSONObject();
                JSONArray childJSON = new JSONArray();
                for (QMetaQueue child : meta.getChildren()) {
                    childJSON.add(qMap.get(child));
                }
                obj.put("children", childJSON);
                obj.put("sorting", meta.getBalancingType().type);
                out.println(obj.toJSONString());
            }
        }
    }

    private static JSONObject convertOccProfileToJson(OccProfileSim prof, Map<OccProfileSim.IShapeGen, Integer> shapes, Map<IFunction1d, Integer> functions, Map<IDistributedVal<?>, Integer> distributions, Map<OccProfileSim.CompRestrictions, Integer> compRestrictionsMap, Map<Predicate<AttractorSim>, Integer> attrFilters) {
        JSONObject json = new JSONObject();
        Map<Object, IPropertySet.Prop<?>> allProps = OccProfileSim.PROFILE_PROPS_MAP;
        for (Map.Entry<Object, IPropertySet.Prop<?>> entry : allProps.entrySet()) {
            Object jsonProp;
            IPropertySet.Prop<?> p = entry.getValue();
            Object prop = WriteMesh.getProfileProp(prof, p);
            if (prop == DO_NOT_WRITE || (jsonProp = WriteMesh.convertProfilePropToJson(p, prop, shapes, functions, distributions, compRestrictionsMap, attrFilters)) == null) continue;
            json.put(entry.getKey(), jsonProp);
        }
        return json;
    }

    private static <T> Object convertProfilePropToJson(IPropertySet.Prop<T> key, T prop, Map<OccProfileSim.IShapeGen, Integer> shapes, Map<IFunction1d, Integer> functions, Map<IDistributedVal<?>, Integer> distributions, Map<OccProfileSim.CompRestrictions, Integer> compRestrictionsMap, Map<Predicate<AttractorSim>, Integer> attrFilters) {
        if (prop instanceof String) {
            return prop;
        }
        if (prop instanceof IFunction1d) {
            return functions.get(prop);
        }
        if (prop instanceof IDistributedVal) {
            return distributions.get(prop);
        }
        if (key instanceof OccProfileSim.UnitDoubleOccProp) {
            return ((UnitDouble)prop).getValue(((OccProfileSim.UnitDoubleOccProp)key).defaultUnit);
        }
        if (prop instanceof Double) {
            return prop;
        }
        if (prop instanceof Boolean) {
            return prop;
        }
        if (prop instanceof OccProfileSim.FromLevelFundamental) {
            return "fromlevelfundamental";
        }
        if (prop instanceof OccProfileSim.ConstProfileFunction) {
            return functions.get(((OccProfileSim.ConstProfileFunction)prop).function);
        }
        if (prop instanceof OccProfileSim.Spacing) {
            OccProfileSim.Spacing sp = (OccProfileSim.Spacing)prop;
            JSONObject jsonProp = new JSONObject();
            jsonProp.put("type", sp.type.toString());
            jsonProp.put("val", WriteMesh.curveToJson(sp.val));
            return jsonProp;
        }
        if (prop instanceof SpeedInSmokeSim && !Objects.equals(prop, SpeedInSmokeSim.DEFAULT)) {
            SpeedInSmokeSim data = (SpeedInSmokeSim)prop;
            JSONObject jsonProp = new JSONObject();
            jsonProp.put("mode", data.mode.toString());
            jsonProp.put("customFuncVisType", data.customFuncVisType.toString());
            jsonProp.put("customFuncVisThreshold", data.customFuncVisThreshold.getValue(SI.METER));
            if (data.customFuncVis != null) {
                jsonProp.put("customFuncVis", functions.get(data.customFuncVis));
            }
            return jsonProp;
        }
        if (prop instanceof OccProfileSim.IShapeGen) {
            return shapes.get(prop);
        }
        if (key == OccProfileSim.PROP_SOCIAL_DIST_FILTER) {
            Optional<IOccFilter.InputFileInfo> occFilterInfo = IOccFilter.InputFileInfo.get((Predicate)prop);
            assert (occFilterInfo.isPresent());
            return occFilterInfo.get().toJson.get((Predicate)prop);
        }
        if (key == OccProfileSim.PROP_COLOR) {
            return WriteMesh.convertColorToJSON((Point3f)prop);
        }
        if (key.key.equals(OccProfile.PROP_RESTRICTED_COMPONENTS.key)) {
            return compRestrictionsMap.get(prop);
        }
        if (key == OccProfileSim.PROP_ATTRACTOR_RESTRICTIONS) {
            return attrFilters.get(prop);
        }
        if (prop == null && key instanceof OccProfileSim.NullableProp) {
            return "null";
        }
        return null;
    }

    public static Object convertColorToJSON(Color color) {
        if (color == null) {
            return null;
        }
        float[] comps = new float[4];
        color.getComponents(comps);
        JSONArray arr = new JSONArray();
        for (float c : comps) {
            arr.add(Double.valueOf(c));
        }
        return arr;
    }

    public static Object convertColorToJSON(Point3f color) {
        if (color == null) {
            return null;
        }
        JSONArray arr = new JSONArray();
        arr.add(Double.valueOf(color.x));
        arr.add(Double.valueOf(color.y));
        arr.add(Double.valueOf(color.z));
        arr.add(1.0);
        return arr;
    }

    private static String format(Tuple3d p) {
        return String.format(Locale.US, "%s %s %s", WriteMesh.df(p.x), WriteMesh.df(p.y), WriteMesh.df(p.z));
    }

    private static String format(Tuple4f c) {
        return String.format(Locale.US, "%s %s %s %s", WriteMesh.ff(c.x), WriteMesh.ff(c.y), WriteMesh.ff(c.z), WriteMesh.ff(c.w));
    }

    private static String formatBodyShape(OccProfileSim.IShapeGen shapeGen, Map<IDistributedVal<?>, Integer> distributions) {
        StringBuilder sb = new StringBuilder();
        if (shapeGen instanceof OccProfileSim.PolyShapeGen) {
            sb.append("name=");
            sb.append(WriteMesh.escapeName(((OccProfileSim.PolyShapeGen)shapeGen).shape.name));
            sb.append(", ");
        }
        sb.append("type=");
        if (shapeGen instanceof OccProfileSim.PolyShapeGen) {
            VehicleBody shape = ((OccProfileSim.PolyShapeGen)shapeGen).shape;
            Point3d[] points = shape.getStaticInnerPoints();
            sb.append(String.format(Locale.US, "poly %d", points.length));
            for (Point3d p : points) {
                sb.append(' ');
                sb.append(WriteMesh.format(p));
            }
            sb.append(", height=");
            sb.append(WriteMesh.df(shape.height));
            sb.append(", attachedAgentsPositions=");
            sb.append(WriteMesh.formatAttachedPositions(shape));
            sb.append(", animTags=");
            sb.append(WriteMesh.format(shape.occAnimTags, ", "));
            sb.append(", lateral=");
            sb.append(shape.allowLateral);
            if (shape.avatar != null) {
                sb.append(", model=");
                if (!shape.avatar.isEmpty()) {
                    sb.append(shape.avatar);
                } else {
                    sb.append("<shape>");
                }
            }
            if (!shape.occAvatarOffset.equals(GeomConstants.PNT3D_ORIGIN)) {
                sb.append(", occavataroffset=");
                sb.append(WriteMesh.format(shape.occAvatarOffset));
            }
            if (!shape.origin.equals(GeomConstants.PNT3D_ORIGIN)) {
                sb.append(", origin=");
                sb.append(WriteMesh.format(shape.origin));
            }
        } else if (shapeGen instanceof OccProfileSim.CylShapeGen) {
            OccProfileSim.CylShapeGen cyl = (OccProfileSim.CylShapeGen)shapeGen;
            sb.append("cylinder");
            TriConsumer<String, String, ICurve> writeCurve = (constKey, curveKey, curve) -> {
                if (curve instanceof ConstantCurve) {
                    sb.append(String.format(Locale.US, ", %s=%s", constKey, WriteMesh.df(curve.getMin().get(LENGTH_UNIT))));
                } else {
                    sb.append(String.format(Locale.US, ", %s=%d", curveKey, distributions.get(curve)));
                }
            };
            writeCurve.accept("diameter", "diameterdist", cyl.shoulderWidth);
            writeCurve.accept("height", "heightdist", cyl.height);
            if (cyl.geomWidth != null) {
                sb.append(", geomdiameter=");
                sb.append(WriteMesh.df(cyl.geomWidth.get(LENGTH_UNIT)));
            }
        } else {
            assert (false);
            sb.append("unknown");
        }
        return sb.toString();
    }

    private static String formatAttachedPositions(VehicleBody vehicleShape) {
        List<Point3d> points = vehicleShape.getStaticAttachedAgentsPositions();
        StringBuilder sb = new StringBuilder();
        sb.append(points.size());
        for (Point3d p : points) {
            sb.append(' ');
            sb.append(WriteMesh.format(p));
        }
        return sb.toString();
    }

    public static void writeFunctions(PrintWriter out, Collection<? extends IFunction1d> functions) {
        if (functions.isEmpty()) {
            return;
        }
        out.println("[functions]");
        int ix = 0;
        for (IFunction1d iFunction1d : functions) {
            out.println(ix + ": " + iFunction1d.toJson().toJSONString());
            ++ix;
        }
        out.println();
    }

    public static void writeAttractorFilters(PrintWriter out, KB kb, Collection<Predicate<AttractorSim>> values, Map<AttractorSim, Integer> attrMap) {
        if (values.isEmpty()) {
            return;
        }
        out.println("[attractor-filters]");
        int ix = 0;
        for (Predicate<AttractorSim> val : values) {
            out.printf(Locale.US, "%d: %s%n", ix, WriteMesh.toJsonObjsFilter(kb, val, attrMap));
            ++ix;
        }
        out.println();
    }

    private static <T> String toJsonObjsFilter(KB kb, Predicate<T> filter, Map<T, Integer> attrIxes) {
        String action;
        JSONObject json = new JSONObject();
        String acceptAll = "accept_all";
        String rejectAll = "reject_all";
        if (Predicates.alwaysTrue(filter)) {
            action = acceptAll;
        } else if (Predicates.alwaysFalse(filter)) {
            action = rejectAll;
        } else {
            BitSet objs = new BitSet(attrIxes.size());
            for (Map.Entry<T, Integer> entry : attrIxes.entrySet()) {
                if (!filter.test(entry.getKey())) continue;
                objs.set(entry.getValue());
            }
            int count = objs.cardinality();
            if (count == 0) {
                action = rejectAll;
            } else if (count == attrIxes.size()) {
                action = acceptAll;
            } else {
                if (objs.cardinality() > attrIxes.size() / 2) {
                    action = "reject";
                    objs.flip(0, attrIxes.size());
                } else {
                    action = "accept";
                }
                JSONArray objIds = new JSONArray();
                int m = objs.nextSetBit(0);
                while (m >= 0) {
                    objIds.add(m);
                    if (m == Integer.MAX_VALUE) break;
                    m = objs.nextSetBit(m + 1);
                }
                json.put("objects", objIds);
            }
        }
        json.put("action", action);
        return json.toJSONString();
    }

    public static Map<AttractorSim, Integer> writeAttractors(PrintWriter out, KB kb, Map<BehaviorSim, Integer> behaviors, Map<ANode, Integer> nodes, Map<IDistributedVal<?>, Integer> distributions) {
        if (kb.getRootAttractors().isEmpty()) {
            return Collections.emptyMap();
        }
        out.println("[attractors]");
        LinkedIdentityHashMap<AttractorSim, Integer> result = new LinkedIdentityHashMap<AttractorSim, Integer>();
        int ix = 0;
        for (AttractorSim attr : kb.getRootAttractors()) {
            result.put(attr, ix);
            JSONObject jobj = WriteMesh.toJsonAttractor(attr, behaviors, nodes, distributions);
            out.printf(Locale.US, "%d: %s%n", ix, jobj.toJSONString());
            ++ix;
        }
        out.println();
        return result;
    }

    private static JSONObject toJsonAttractor(AttractorSim attr, Map<BehaviorSim, Integer> behaviors, Map<ANode, Integer> nodes, Map<IDistributedVal<?>, Integer> distributions) {
        JSONObject jobj = new JSONObject();
        jobj.put("id", attr.getId());
        jobj.put("resultsId", attr.getResultsId());
        jobj.put("name", attr.name);
        jobj.put("type", attr.type.name());
        jobj.put("rank", attr.rank);
        jobj.put("awareness", attr.awareness.name());
        jobj.put("minAwarenessCount", attr.minAwarenessCount);
        jobj.put("minAwarenessTime", attr.minAwarenessTime);
        jobj.put("behavior", behaviors.get(attr.behavior));
        jobj.put("influenceFrom", attr.influenceFrom.name());
        jobj.put("influence", attr.getInfluence());
        jobj.put("reactTime", attr.reactTime.getInputFileInfo().toJson.get(attr.reactTime, d -> (Integer)distributions.get(d)));
        jobj.put("requiresCompletion", attr.requiresCompletion);
        jobj.put("forceConsiderationIfUnaware", attr.forceConsiderationIfOccBecomesUnaware);
        jobj.put("ignoreOccSusc", attr.ignoreOccSuscp);
        Optional<IOccFilter.InputFileInfo> occFilterInfo = IOccFilter.InputFileInfo.get(attr.occFilter);
        assert (occFilterInfo.isPresent());
        if (occFilterInfo.isPresent()) {
            jobj.put("occFilter", occFilterInfo.get().toJson.get(attr.occFilter));
        }
        if (attr.type == AttractorSim.PlaceType.PLACED && attr.getLocation() != null) {
            jobj.put("location", WriteMesh.toJsonTuple3d(attr.getLocation().p));
        }
        switch (attr.awareness) {
            case GLOBAL: {
                break;
            }
            case ROOM_ONLY: {
                break;
            }
            case ROOMS: {
                JSONArray rooms = new JSONArray();
                for (ANode aNode : attr.rooms) {
                    rooms.add(nodes.get(aNode));
                }
                jobj.put("rooms", rooms);
                break;
            }
            case LINE_OF_SIGHT: {
                jobj.put("radius", attr.influenceRadius);
            }
        }
        JSONArray influenceCurve = new JSONArray();
        for (Pair pair : attr.getInfluenceCurve()) {
            JSONObject influence = new JSONObject();
            influence.put("time", pair.v1);
            influence.put("influence", pair.v2);
            influenceCurve.add(influence);
        }
        jobj.put("influenceCurve", influenceCurve);
        return jobj;
    }

    private static JSONArray toJsonTuple3d(Tuple3d v) {
        return JsonUtil.toJson(v);
    }

    public static void writeDistributions(PrintWriter out, Collection<? extends IDistributedVal<?>> distributions) {
        if (distributions.isEmpty()) {
            return;
        }
        out.println("[distributions]");
        int ix = 0;
        for (IDistributedVal<?> distribution : distributions) {
            JSONObject obj = null;
            if (distribution instanceof ICurve) {
                obj = WriteMesh.curveToJson((ICurve)distribution);
            } else if (distribution instanceof IUrn) {
                obj = WriteMesh.urnToJson((IUrn)distribution);
            } else assert (false);
            out.println(ix + ": " + obj.toJSONString());
            ++ix;
        }
        out.println();
    }

    private static JSONObject curveToJson(ICurve curve) {
        JSONObject obj = new JSONObject();
        if (curve instanceof AutoCurve) {
            obj.put("type", "auto");
        } else if (curve instanceof ConstantCurve) {
            obj.put("type", "cc");
            obj.put("val", curve.getValue(null).toString());
        } else if (curve instanceof LogNormCurve) {
            LogNormCurve c = (LogNormCurve)curve;
            obj.put("type", "logNorm");
            obj.put("mean", c.getAvg().toString());
            obj.put("stDev", c.getStdDev().toString());
            obj.put("min", c.getMin().toString());
            obj.put("max", c.getMax().toString());
        } else if (curve instanceof StdNormCurve) {
            StdNormCurve c = (StdNormCurve)curve;
            obj.put("type", "stdNorm");
            obj.put("mean", c.getAvg().toString());
            obj.put("stDev", c.getStdDev().toString());
            obj.put("min", c.getMin().toString());
            obj.put("max", c.getMax().toString());
        } else if (curve instanceof UniformCurve) {
            UniformCurve c = (UniformCurve)curve;
            obj.put("type", "unif");
            obj.put("min", c.getMin().toString());
            obj.put("max", c.getMax().toString());
        }
        return obj;
    }

    public static void writeOccs(PrintWriter out, KB kb, Map<OccProfileSim, Integer> profiles, Map<BehaviorSim, Integer> behaviors, Map<IFunction1d, Integer> curves, Map<OccProfileSim.IShapeGen, Integer> shapes, Map<OccProfileSim.CompRestrictions, Integer> compRestrictionsMap, Map<Predicate<AttractorSim>, Integer> attrFilters) {
        out.println("[occupants]");
        int ix = 0;
        for (Occupant o : kb.getOccs()) {
            double angle;
            JSONObject jsonProp;
            int ixGoalProf = behaviors.get(o.behavior);
            Point3d loc = o.loc;
            out.printf(Locale.US, "%d: ", ix++);
            JSONObject json = new JSONObject();
            json.put("profile", profiles.get(o.parentProfile));
            Random rnd = new Random();
            WriteMesh.writeOccProp(kb, json, rnd, null, o, "name", () -> o.name, o.name);
            WriteMesh.writeOccProp(kb, json, rnd, null, o, "id", () -> o.id, o.id);
            WriteMesh.writeOccProp(kb, json, rnd, OccProfileSim.PROP_OCCMODEL, o, (String)OccProfileSim.PROP_OCCMODEL.key, () -> o.avatar == null ? "<null>" : o.avatar, o.avatar);
            WriteMesh.writeOccProp(kb, json, rnd, null, o, "behavior", () -> ixGoalProf, ixGoalProf);
            WriteMesh.writeOccProp(kb, json, rnd, null, o, "loc", () -> WriteMesh.format(loc), loc);
            WriteMesh.writeOccProp(kb, json, rnd, OccProfileSim.PROP_MAXVEL, o, (String)OccProfileSim.PROP_MAXVEL.key, () -> WriteMesh.ff(o.maxVel), Float.valueOf(o.maxVel), VEL_UNIT);
            IAgentBodyShape profileShape = o.parentProfile.getProperty(OccProfileSim.PROP_SHAPE).generateShape(o, rnd, o.getSeed(OccProfileSim.PROP_SHAPE), kb);
            if (!profileShape.getStaticHash().equals(o.bodyShape.getStaticHash())) {
                OccProfileSim.IShapeGen shapeGen = o.bodyShape.toShapeGen();
                Integer shapeix = shapes.get(shapeGen);
                if (shapeix != null) {
                    json.put(OccProfileSim.PROP_SHAPE.key, shapeix);
                } else if (o.bodyShape instanceof CylinderShape) {
                    CylinderShape cshape = (CylinderShape)o.bodyShape;
                    json.put("OccProfile.DIAMETER", cshape.getOccRadius() * 2.0);
                    json.put("OccProfile.HEIGHT", cshape.getHeight());
                    if (cshape.getGeomRadius() != cshape.getOccRadius()) {
                        json.put("OccProfile.GEOM_DIAMETER", cshape.getGeomRadius() * 2.0);
                    }
                } else assert (false);
            }
            WriteMesh.writeOccProp(kb, json, rnd, OccProfileSim.PROP_ACCEL_TIME, o, (String)OccProfileSim.PROP_ACCEL_TIME.key, () -> WriteMesh.df(1.0 / (double)o.accelFactor), 1.0 / (double)o.accelFactor, TIME_UNIT);
            if (!WriteMesh.sameColor(o)) {
                Color3f colorf = new Color3f(theUtil.toCCf(o.visColor.x), theUtil.toCCf(o.visColor.y), theUtil.toCCf(o.visColor.z));
                WriteMesh.writeOccProp(kb, json, rnd, OccProfileSim.PROP_COLOR, o, (String)OccProfileSim.PROP_COLOR.key, () -> colorf.toString(), colorf);
            }
            WriteMesh.writeOccProp(kb, json, rnd, null, o, (String)OccProfileSim.PROP_REAC_TIME.key, () -> WriteMesh.ff(o.reacTime), Float.valueOf(o.reacTime), TIME_UNIT);
            WriteMesh.writeOccProp(kb, json, rnd, OccProfileSim.PROP_PRIORITY_LEVEL, o, (String)OccProfileSim.PROP_PRIORITY_LEVEL.key, () -> WriteMesh.df(o.priority), o.priority);
            WriteMesh.writeOccProp(kb, json, rnd, null, o, "rseed", () -> o.rseed, o.rseed);
            WriteMesh.writeOccProp(kb, json, rnd, null, o, "orientSeed", () -> o.orientSeed, o.orientSeed);
            WriteMesh.writeOccProp(kb, json, rnd, OccProfileSim.PROP_MIN_SQUEEZE_FACTOR_CONST, o, (String)OccProfileSim.PROP_MIN_SQUEEZE_FACTOR_CONST.key, () -> WriteMesh.ff(o.minSqueezeFactor), (double)o.minSqueezeFactor != 1.0 ? Float.valueOf(o.minSqueezeFactor) : null, Unit.ONE);
            WriteMesh.writeOccProp(kb, json, rnd, OccProfileSim.PROP_PERSIST_TIME, o, (String)OccProfileSim.PROP_PERSIST_TIME.key, () -> WriteMesh.ff(o.persistTime), Float.valueOf(o.persistTime), TIME_UNIT);
            WriteMesh.writeOccProp(kb, json, rnd, OccProfileSim.PROP_COLLISION_RESPONSE_TIME, o, (String)OccProfileSim.PROP_COLLISION_RESPONSE_TIME.key, () -> WriteMesh.ff(o.collisionResponseTime), Float.valueOf(o.collisionResponseTime), TIME_UNIT);
            WriteMesh.writeComfortDist(json, rnd, o);
            if (!o.parentProfile.getProperty(OccProfileSim.PROP_SOCIAL_DIST_FILTER).equals(o.socialDistFilter)) {
                jsonProp = (JSONObject)WriteMesh.convertProfilePropToJson(OccProfileSim.PROP_SOCIAL_DIST_FILTER, o.socialDistFilter, shapes, curves, Collections.emptyMap(), compRestrictionsMap, Collections.emptyMap());
                WriteMesh.writeOccProp(kb, json, rnd, null, o, (String)OccProfileSim.PROP_SOCIAL_DIST_FILTER.key, () -> jsonProp, null);
            }
            WriteMesh.writeOccProp(kb, json, rnd, OccProfileSim.PROP_SOCIAL_DIST, o, (String)OccProfileSim.PROP_SOCIAL_DIST.key, () -> WriteMesh.ff(o.socialDist), Float.valueOf(o.socialDist), LENGTH_UNIT);
            WriteMesh.writeOccProp(kb, json, rnd, OccProfileSim.PROP_SLOW_FACTOR, o, (String)OccProfileSim.PROP_SLOW_FACTOR.key, () -> WriteMesh.ff(o.slowFactor), Float.valueOf(o.slowFactor), Unit.ONE);
            WriteMesh.writeOccProp(kb, json, rnd, OccProfileSim.PROP_ASSIST, o, (String)OccProfileSim.PROP_ASSIST.key, () -> "" + o.reqAssistedBy, o.reqAssistedBy);
            WriteMesh.writeOccProp(kb, json, rnd, OccProfileSim.PROP_REQUIRES_ASSISTANCE, o, (String)OccProfileSim.PROP_REQUIRES_ASSISTANCE.key, () -> "" + o.requiresAssistance, o.requiresAssistance);
            WriteMesh.writeOccProp(kb, json, rnd, OccProfileSim.PROP_OBEY_ONEWAY_DOORS, o, (String)OccProfileSim.PROP_OBEY_ONEWAY_DOORS.key, () -> "" + o.obeyOnewayDoors, o.obeyOnewayDoors);
            WriteMesh.writeOccProp(kb, json, rnd, OccProfileSim.PROP_ESCALATOR_PREF, o, (String)OccProfileSim.PROP_ESCALATOR_PREF.key, () -> String.valueOf((Object)o.movingTerrainPref), (Object)o.movingTerrainPref);
            WriteMesh.writeOccProp(kb, json, rnd, OccProfileSim.PROP_LOCAL_QUEUE_TIME_FACTOR, o, (String)OccProfileSim.PROP_LOCAL_QUEUE_TIME_FACTOR.key, () -> WriteMesh.df(o.localQueueTimeFactor), o.localQueueTimeFactor, Unit.ONE);
            WriteMesh.writeOccProp(kb, json, rnd, OccProfileSim.PROP_LOCAL_TRAVEL_TIME_FACTOR, o, (String)OccProfileSim.PROP_LOCAL_TRAVEL_TIME_FACTOR.key, () -> WriteMesh.df(o.localTravelTimeFactor), o.localTravelTimeFactor, Unit.ONE);
            WriteMesh.writeOccProp(kb, json, rnd, OccProfileSim.PROP_TAIL_TIME_FACTOR, o, (String)OccProfileSim.PROP_TAIL_TIME_FACTOR.key, () -> WriteMesh.df(o.tailTimeFactor), o.tailTimeFactor, Unit.ONE);
            WriteMesh.writeOccProp(kb, json, rnd, OccProfileSim.PROP_CURR_DOOR_PREF, o, (String)OccProfileSim.PROP_CURR_DOOR_PREF.key, () -> WriteMesh.df(o.currDoorFactor), o.currDoorFactor, Unit.ONE);
            WriteMesh.writeOccProp(kb, json, rnd, null, o, (String)OccProfileSim.PROP_CURRENT_ROOM_DIST_PENALTY.key, () -> WriteMesh.df(o.distTravelledFactor), o.distTravelledFactor, LENGTH_UNIT);
            WriteMesh.writeOccProp(kb, json, rnd, OccProfileSim.PROP_BOUNDARY_LAYER, o, (String)OccProfileSim.PROP_BOUNDARY_LAYER.key, () -> WriteMesh.ff(o.boundaryLayer), Float.valueOf(o.boundaryLayer), LENGTH_UNIT);
            WriteMesh.writeOccProp(kb, json, rnd, OccProfileSim.PROP_PRINT_EXTRA_OUTPUT, o, (String)OccProfileSim.PROP_PRINT_EXTRA_OUTPUT.key, () -> o.outputTimeHistory, o.outputTimeHistory, Unit.ONE);
            if (!o.parentProfile.getProperty(OccProfileSim.PROP_FUNDAMENTAL).equals(o.fundamental)) {
                WriteMesh.writeOccProp(kb, json, rnd, null, o, (String)OccProfileSim.PROP_FUNDAMENTAL.key, () -> curves.get(o.fundamental), null);
            }
            if (!o.parentProfile.getProperty(OccProfileSim.PROP_STAIR_SPEED_UP).equals(o.stairSpeed.upSpeed)) {
                WriteMesh.writeOccProp(kb, json, rnd, null, o, (String)OccProfileSim.PROP_STAIR_SPEED_UP.key, () -> curves.get(o.stairSpeed.upSpeed), null);
            }
            if (!o.parentProfile.getProperty(OccProfileSim.PROP_STAIR_FUNDAMENTAL_UP).apply(o.parentProfile).equals(o.stairSpeed.upFundamental)) {
                WriteMesh.writeOccProp(kb, json, rnd, null, o, (String)OccProfileSim.PROP_STAIR_FUNDAMENTAL_UP.key, () -> curves.get(o.stairSpeed.upFundamental), null);
            }
            if (!o.parentProfile.getProperty(OccProfileSim.PROP_STAIR_SPEED_DOWN).equals(o.stairSpeed.downSpeed)) {
                WriteMesh.writeOccProp(kb, json, rnd, null, o, (String)OccProfileSim.PROP_STAIR_SPEED_DOWN.key, () -> curves.get(o.stairSpeed.downSpeed), null);
            }
            if (!o.parentProfile.getProperty(OccProfileSim.PROP_STAIR_FUNDAMENTAL_DOWN).apply(o.parentProfile).equals(o.stairSpeed.downFundamental)) {
                WriteMesh.writeOccProp(kb, json, rnd, null, o, (String)OccProfileSim.PROP_STAIR_FUNDAMENTAL_DOWN.key, () -> curves.get(o.stairSpeed.downFundamental), null);
            }
            if (!o.parentProfile.getProperty(OccProfileSim.PROP_RAMP_SPEED_UP).equals(o.rampSpeed.upSpeed)) {
                WriteMesh.writeOccProp(kb, json, rnd, null, o, (String)OccProfileSim.PROP_RAMP_SPEED_UP.key, () -> curves.get(o.rampSpeed.upSpeed), null);
            }
            if (!o.parentProfile.getProperty(OccProfileSim.PROP_RAMP_FUNDAMENTAL_UP).apply(o.parentProfile).equals(o.rampSpeed.upFundamental)) {
                WriteMesh.writeOccProp(kb, json, rnd, null, o, (String)OccProfileSim.PROP_RAMP_FUNDAMENTAL_UP.key, () -> curves.get(o.rampSpeed.upFundamental), null);
            }
            if (!o.parentProfile.getProperty(OccProfileSim.PROP_RAMP_SPEED_DOWN).equals(o.rampSpeed.downSpeed)) {
                WriteMesh.writeOccProp(kb, json, rnd, null, o, (String)OccProfileSim.PROP_RAMP_SPEED_DOWN.key, () -> curves.get(o.rampSpeed.downSpeed), null);
            }
            if (!o.parentProfile.getProperty(OccProfileSim.PROP_RAMP_FUNDAMENTAL_DOWN).apply(o.parentProfile).equals(o.rampSpeed.downFundamental)) {
                WriteMesh.writeOccProp(kb, json, rnd, null, o, (String)OccProfileSim.PROP_RAMP_FUNDAMENTAL_DOWN.key, () -> curves.get(o.rampSpeed.downFundamental), null);
            }
            if (!o.parentProfile.getProperty(OccProfileSim.PROP_SPEED_IN_SMOKE).equals(o.smokeSpeed)) {
                jsonProp = (JSONObject)WriteMesh.convertProfilePropToJson(OccProfileSim.PROP_SPEED_IN_SMOKE, o.smokeSpeed, shapes, curves, Collections.emptyMap(), compRestrictionsMap, Collections.emptyMap());
                WriteMesh.writeOccProp(kb, json, rnd, null, o, (String)OccProfileSim.PROP_SPEED_IN_SMOKE.key, () -> jsonProp, null);
            }
            if ((angle = Trig.angle(new Vector3d(1.0, 0.0, 0.0), o.orient)) < 0.0) {
                angle += Math.PI * 2;
            }
            WriteMesh.writeOccProp(kb, json, rnd, OccProfileSim.PROP_INIT_ORIENT, o, (String)OccProfileSim.PROP_INIT_ORIENT.key, () -> WriteMesh.format(o.orient), angle, SI.RADIAN);
            WriteMesh.writeOccProp(kb, json, rnd, OccProfileSim.PROP_RESTRICTED_COMPONENTS, o, (String)OccProfileSim.PROP_RESTRICTED_COMPONENTS.key, () -> compRestrictionsMap.get(o.compRestrictions), o.compRestrictions, null);
            WriteMesh.writeOccProp(kb, json, rnd, OccProfileSim.PROP_ELEVATOR_WAIT_TIME, o, (String)OccProfileSim.PROP_ELEVATOR_WAIT_TIME.key, () -> WriteMesh.df(o.elevatorWaitTime.maxWaitTime), o.elevatorWaitTime.maxWaitTime, SI.SECOND);
            WriteMesh.writeOccProp(kb, json, rnd, OccProfileSim.PROP_ATTRACTOR_SUSCEPTIBILITY_SEEK, o, (String)OccProfileSim.PROP_ATTRACTOR_SUSCEPTIBILITY_SEEK.key, () -> WriteMesh.ff(o.attractorSuscSeek), o.attractorSuscSeek, Unit.ONE);
            WriteMesh.writeOccProp(kb, json, rnd, OccProfileSim.PROP_ATTRACTOR_SUSCEPTIBILITY_IDLE, o, (String)OccProfileSim.PROP_ATTRACTOR_SUSCEPTIBILITY_IDLE.key, () -> WriteMesh.ff(o.attractorSuscIdle), o.attractorSuscIdle, Unit.ONE);
            WriteMesh.writeOccProp(kb, json, rnd, OccProfileSim.PROP_ATTRACTOR_RESTRICTIONS, o, (String)OccProfileSim.PROP_ATTRACTOR_RESTRICTIONS.key, () -> attrFilters.get(o.allowedAttractors), o.allowedAttractors, null);
            Set<Tag> tags = kb.getTags(o);
            WriteMesh.writeOccProp(kb, json, rnd, OccProfileSim.PROP_TAGS, o, (String)OccProfileSim.PROP_TAGS.key, () -> WriteMesh.toJsonTags(tags), tags, Unit.ONE);
            WriteMesh.writeOccProp(kb, json, rnd, OccProfileSim.PROP_ANIMS_IDLE, o, (String)OccProfileSim.PROP_ANIMS_IDLE.key, () -> WriteMesh.toJsonArray(o.animTagsIdling, t -> t), o.animTagsIdling, Unit.ONE);
            WriteMesh.writeOccProp(kb, json, rnd, OccProfileSim.PROP_ANIMS_MOVING, o, (String)OccProfileSim.PROP_ANIMS_MOVING.key, () -> WriteMesh.toJsonArray(o.animTagsMoving, t -> t), o.animTagsMoving, Unit.ONE);
            out.println(json.toJSONString());
        }
        out.println();
    }

    private static <T> Object toJsonArray(Collection<T> vals, Function<T, Object> valToJson) {
        JSONArray jarr = new JSONArray();
        vals.stream().map(valToJson).forEach(t -> jarr.add(t));
        return jarr;
    }

    private static Object toJsonTags(Set<Tag> tags) {
        return WriteMesh.toJsonArray(tags, t -> t.name);
    }

    private static boolean sameColor(Occupant o) {
        Point3f c = o.parentProfile.getProperty(OccProfileSim.PROP_COLOR);
        Color3b profCol = new Color3b(theUtil.toCCb(c.x), theUtil.toCCb(c.y), theUtil.toCCb(c.z));
        Color3b occCol = o.visColor;
        return profCol.equals(occCol);
    }

    private static void writeOccProp(KB kb, JSONObject json, Random rnd, OccProfileSim.Prop<?> prop, Occupant o, String key, Supplier<Object> getFormattedValue, Object compareValue) {
        WriteMesh.writeOccProp(kb, json, rnd, prop, o, key, getFormattedValue, compareValue, null);
    }

    private static void writeComfortDist(JSONObject json, Random rnd, Occupant o) {
        UnitDouble parentComfortDist = o.parentProfile.getComfortDistance(rnd, o.rseed, new UnitDouble(o.bodyShape.getOccRadius(), SI.METER));
        if ((float)parentComfortDist.get(SI.METER) == o.comfortDist) {
            return;
        }
        json.put("comfortDist", WriteMesh.ff(o.comfortDist));
    }

    private static <T> void writeOccProp(KB kb, JSONObject json, Random rnd, OccProfileSim.Prop prop, Occupant o, String key, Supplier<Object> getFormatedValue, Object compareValue, Unit unit) {
        OccProfileSim parentProfile = o.parentProfile;
        boolean write = false;
        if (prop == null) {
            write = true;
        } else {
            Object profileProp = prop.isDistributed() ? parentProfile.getDistVal(prop, rnd, o.getSeed(prop)) : parentProfile.getProperty(prop);
            if (profileProp instanceof OccProfileSim.Spacing) {
                profileProp = parentProfile.getSpacingVal(rnd, o.rseed);
            }
            if (profileProp instanceof UnitDouble) {
                profileProp = unit != null ? ((UnitDouble)profileProp).getValue(unit) : ((UnitDouble)profileProp).getValueNoUnit();
            }
            if (profileProp == null && compareValue == null) {
                write = false;
            } else if (profileProp == null && compareValue != null || profileProp != null && compareValue == null) {
                write = true;
            } else if (profileProp == null) {
                write = true;
            } else if (profileProp instanceof Double && compareValue instanceof Double) {
                write = !theUtil.eq((Double)profileProp, (Double)compareValue, 1.0E-6);
            } else if (profileProp instanceof VehicleBody && compareValue instanceof VehicleBody) {
                write = !((VehicleBody)profileProp).equals((VehicleBody)compareValue);
            } else if (profileProp instanceof Predicate && compareValue instanceof Predicate) {
                write = !profileProp.equals(compareValue);
            } else if (!profileProp.toString().equals(compareValue.toString())) {
                write = true;
            }
        }
        if (write) {
            json.put(key, getFormatedValue.get());
        }
    }

    private static String writeAETeamName(String assistedEvacuationTeamName) {
        if (assistedEvacuationTeamName == null) {
            return "NA";
        }
        return assistedEvacuationTeamName.replace(" ", "_");
    }

    private static Map<AssistedEvacTeam, Integer> getAETeams(KB kb) {
        LinkedIdentityHashMap<AssistedEvacTeam, Integer> teams = new LinkedIdentityHashMap<AssistedEvacTeam, Integer>();
        Consumer<AssistedEvacTeam> add = team -> teams.putIfAbsent((AssistedEvacTeam)team, teams.size());
        Consumer<Collection> addGoals = goals -> {
            for (IGoal goal : goals) {
                if (goal instanceof WaitForAssistanceGoal) {
                    for (AssistedEvacTeam team : ((WaitForAssistanceGoal)goal).teams) {
                        add.accept(team);
                    }
                    continue;
                }
                if (!(goal instanceof AssistOccupantsGoal)) continue;
                add.accept(((AssistOccupantsGoal)goal).team);
            }
        };
        WriteMesh.getReferencedBehaviors(kb, true).forEach(b -> addGoals.accept(b.goals));
        return teams;
    }

    public static void writeAssistedEvacTeams(PrintWriter out, Map<AssistedEvacTeam, Integer> validTeams) {
        if (validTeams.isEmpty()) {
            return;
        }
        out.println("[assisted-evac-teams]");
        for (Map.Entry<AssistedEvacTeam, Integer> entry : validTeams.entrySet()) {
            AssistedEvacTeam aeData = entry.getKey();
            out.printf("%d: goals=%s,name=%s%n", entry.getValue(), WriteMesh.writeAEOccIDs(aeData), WriteMesh.writeAETeamName(aeData.teamName));
        }
        out.println();
    }

    public static Map<OccTarget, Integer> writeOccTargets(PrintWriter out, KB kb) {
        OccTargets targets = kb.getOccTargets();
        if (targets.getAll().isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedIdentityHashMap<OccTarget, Integer> result = new LinkedIdentityHashMap<OccTarget, Integer>();
        int ix = 0;
        out.println("[occupant-targets]");
        for (OccTarget target : targets.getAll()) {
            result.put(target, ix);
            JSONObject jobj = new JSONObject();
            jobj.put("id", target.id);
            jobj.put("name", target.name);
            if (target.orient != null) {
                jobj.put("orient", WriteMesh.toJsonTuple3d(target.orient));
            }
            jobj.put("loc", WriteMesh.toJsonTuple3d(target.location.p));
            jobj.put("priority", target.priority);
            out.printf(Locale.US, "%d: %s%n", ix, jobj);
            ++ix;
        }
        out.println();
        return result;
    }

    private static void writeOccSources(PrintWriter out, KB kb, Map<OccProfileSim, Integer> profiles, Map<BehaviorSim, Integer> behaviors, Map<IFunction1d, Integer> functions, Map<ANode, Integer> nodeMap, Map<IDistributedVal<?>, Integer> distributions) {
        if (kb.getOccSources().isEmpty()) {
            return;
        }
        out.println("[occupant-sources]");
        int ix = 0;
        for (OccSource occSource : kb.getOccSources()) {
            JSONObject json = new JSONObject();
            json.put("name", occSource.getName());
            json.put("seed", occSource.getSeed());
            json.put("occSourceFlowrate", occSource.getFlowrate().toJson(functions::get));
            json.put("profiles", distributions.get(WriteMesh.toIndexUrn(occSource.getProfileUrn(), profiles::get)));
            json.put("behaviors", distributions.get(WriteMesh.toIndexUrn(occSource.getBehaviorUrn(), behaviors::get)));
            JSONObject aaboxJson = new JSONObject();
            aaboxJson.put("min", occSource.getBounds().getMin().toString());
            aaboxJson.put("max", occSource.getBounds().getMax().toString());
            json.put("bounds", aaboxJson);
            json.put("enforceFlowrate", occSource.isEnforceFlowrate());
            if (occSource.getComponent() != null) {
                json.put("component", nodeMap.get(occSource.getComponent()));
            }
            json.put("groupTemplates", distributions.get(WriteMesh.toIndexUrn(occSource.getGroupUrn(), type -> type.getID())));
            if (occSource.getInitialOrient() != null) {
                json.put("initialOrient", distributions.get(occSource.getInitialOrient()));
            }
            json.put("emitAtMaxVel", occSource.getEmitAtMaxVel());
            JSONArray jOccLocs = JsonUtil.toJson(occSource.getSpawnLocations(), p -> JsonUtil.toJson(p));
            json.put("locations", jOccLocs);
            out.printf(Locale.US, "%d: %s %n", ix++, json.toJSONString());
        }
        out.println();
    }

    private static void writeOccGroups(PrintWriter out, KB kb, Map<OccProfileSim, Integer> profiles, Map<BehaviorSim, Integer> behaviors, Map<IDistributedVal<?>, Integer> distributions) {
        JSONObject json2;
        Integer ix;
        BiConsumer<JSONObject, IOccGroup> addCommonGroupData = (json, g) -> {
            json.put("maxDistance", g.getMaxDistance());
            json.put("slowdownTime", g.getSlowdownTime());
            json.put("requiresLeader", g.requiresLeader());
            json.put("color", WriteMesh.convertColorToJSON(g.getColor()));
            json.put("respectSocialDist", g.respectSocialDist());
        };
        BiConsumer<JSONObject, OccGroup> addOccGroupData = (json, g) -> {
            json.put("name", g.groupName);
            if (g.templateColor != null) {
                json.put("templateColor", WriteMesh.convertColorToJSON(g.templateColor));
            }
            if (g.getInitOccs() != null) {
                JSONArray jsonArray = new JSONArray();
                for (Occupant occ : g.getInitOccs()) {
                    jsonArray.add(occ.id);
                }
                json.put("members", jsonArray);
            }
            if (g.getInitLeader() != null) {
                json.put("leader", g.getInitLeader().id);
            }
        };
        BiConsumer<JSONObject, OccGroupType> addGroupTypeData = (json, g) -> {
            json.put("name", g.groupTypeName);
            if (g.allowSmallerGroups) {
                json.put("minNumberOfMembers", distributions.get(g.minNumberOfMembers));
            }
            json.put("prefNumberOfMembers", distributions.get(g.prefNumberOfMembers));
            json.put("allowSmallerGroups", g.allowSmallerGroups);
            boolean exactDistCalc = g.useExactDistCalc;
            json.put("exactDistanceCalculation", exactDistCalc);
            if (!exactDistCalc) {
                json.put("heightMultiplier", g.heightMultiplier);
            }
            boolean specifyProfiles = g.profileMap != null;
            json.put("specifyProfiles", specifyProfiles);
            OccProfileSim leaderProfile = g.leaderProfile;
            if (leaderProfile != null) {
                assert (profiles.containsKey(leaderProfile));
                json.put("leaderProfile", profiles.get(leaderProfile));
            }
            json.put("restrictRoom", g.restrictRoom);
            json.put("ungrouped", g.isNoGroupType);
            if (specifyProfiles) {
                JSONArray jsonArray = new JSONArray();
                for (OccProfileSim prof : g.profileMap.keySet()) {
                    if (!profiles.containsKey(prof)) continue;
                    int profID = (Integer)profiles.get(prof);
                    ICurve prefNumOfMembers = g.profileMap.get((Object)prof).prefNumberOfMembers;
                    if (prefNumOfMembers instanceof ConstantCurve && prefNumOfMembers.getAvg().get(Unit.ONE) == 0.0) continue;
                    int prefCurveID = (Integer)distributions.get(prefNumOfMembers);
                    boolean allowSmaller = g.profileMap.get((Object)prof).allowSmallerGroups;
                    Integer minCurveID = allowSmaller ? (Integer)distributions.get(g.profileMap.get((Object)prof).minNumberOfMembers) : null;
                    JSONObject obj = new JSONObject();
                    obj.put("profile", profID);
                    obj.put("prefNumberOfMembers", prefCurveID);
                    obj.put("allowSmallerGroups", allowSmaller);
                    if (minCurveID != null) {
                        obj.put("minNumberOfMembers", minCurveID);
                    }
                    jsonArray.add(obj);
                }
                json.put("profiles", jsonArray);
            }
        };
        if (!kb.getOccupantGroups().isEmpty()) {
            out.println("[groups]");
            ix = 0;
            for (OccGroup occGroup : kb.getOccupantGroups()) {
                json2 = new JSONObject();
                addCommonGroupData.accept(json2, occGroup);
                addOccGroupData.accept(json2, occGroup);
                out.printf(Locale.US, "%d: %s %n", ix, json2.toJSONString());
                ix = ix + 1;
            }
            out.println();
        }
        if (!kb.getOccupantGroupTypes().isEmpty()) {
            out.println("[group-templates]");
            ix = 0;
            for (OccGroupType occGroupType : kb.getOccupantGroupTypes()) {
                json2 = new JSONObject();
                addCommonGroupData.accept(json2, occGroupType);
                addGroupTypeData.accept(json2, occGroupType);
                out.printf(Locale.US, "%d: %s %n", ix, json2.toJSONString());
                ix = ix + 1;
            }
            out.println();
        }
    }

    private static void writeCounters(PrintWriter out, Map<Counter, Integer> counters) {
        if (counters.isEmpty()) {
            return;
        }
        out.println("[counters]");
        for (Map.Entry<Counter, Integer> entry : counters.entrySet()) {
            out.printf(Locale.US, "%d: %s%n", entry.getValue(), entry.getKey().value.toString());
        }
        out.println();
    }

    private static String writeAEOccIDs(AssistedEvacTeam aeData) {
        StringBuilder sb = new StringBuilder();
        if (aeData.clientOrder.isEmpty()) {
            sb.append("NA");
            return sb.toString();
        }
        int[] ids = new int[aeData.clientOrder.size()];
        for (Map.Entry<Integer, Integer> entry : aeData.clientOrder.entrySet()) {
            ids[entry.getValue().intValue()] = entry.getKey();
        }
        for (int i = 0; i < ids.length; ++i) {
            sb.append(ids[i]);
            if (i == ids.length - 1) continue;
            sb.append("|");
        }
        return sb.toString();
    }

    private static Map<OccProfileSim.CompRestrictions, Integer> getCompRestrictions(KB kb) {
        LinkedIdentityHashMap<OccProfileSim.CompRestrictions, Integer> map = new LinkedIdentityHashMap<OccProfileSim.CompRestrictions, Integer>();
        Consumer<OccProfileSim.CompRestrictions> add = comp -> map.putIfAbsent((OccProfileSim.CompRestrictions)comp, map.size());
        Set<BehaviorSim> behaviors = WriteMesh.getReferencedBehaviors(kb, false);
        IdentityHashSet visited = new IdentityHashSet();
        for (BehaviorSim b : behaviors) {
            b.getFutureProfileValues(visited, OccProfileSim.PROP_RESTRICTED_COMPONENTS, add);
        }
        for (Occupant occ : kb.getOccs()) {
            add.accept(occ.compRestrictions);
        }
        for (OccSource source : kb.getOccSources()) {
            source.getProfiles(false).forEach(prof -> add.accept(prof.getProperty(OccProfileSim.PROP_RESTRICTED_COMPONENTS)));
        }
        return map;
    }

    private static Set<BehaviorSim> getReferencedBehaviors(KB kb, boolean flattened) {
        LinkedIdentityHashSet<BehaviorSim> behaviors = new LinkedIdentityHashSet<BehaviorSim>();
        Consumer<BehaviorSim> add = flattened ? behavior -> {
            if (behaviors.add(behavior)) {
                behavior.getReferencedBehaviors(behaviors);
            }
        } : behaviors::add;
        for (Occupant occ : kb.getOccs()) {
            add.accept(occ.behavior);
        }
        for (OccSource source : kb.getOccSources()) {
            source.getBehaviors().forEach(add);
        }
        for (AttractorSim attr : kb.getRootAttractors()) {
            add.accept(attr.behavior);
        }
        return behaviors;
    }

    private static void writeCompRestrictions(PrintWriter out, Map<OccProfileSim.CompRestrictions, Integer> map, Map<ANode, Integer> nodeMap) {
        if (!map.isEmpty()) {
            out.println("[component-restrictions]");
            for (OccProfileSim.CompRestrictions compRestrictions : map.keySet()) {
                JSONObject json = new JSONObject();
                JSONArray nodeIDs = new JSONArray();
                for (ANode node : compRestrictions.nodes) {
                    nodeIDs.add(nodeMap.get(node));
                }
                json.put("components", nodeIDs);
                json.put("action", compRestrictions.reject ? "reject" : "accept");
                json.put("elevators-from-behavior", compRestrictions.elevatorsFromBehavior);
                out.printf(Locale.US, "%d: %s %n", map.get(compRestrictions), json.toJSONString());
            }
            out.println();
        }
    }

    private static String getTypeStr(Tri.Terrain terrain) {
        if (terrain.isOpen()) {
            return "open";
        }
        if (terrain.isStair()) {
            return "stair";
        }
        if (terrain.isRamp()) {
            return "ramp";
        }
        assert (false);
        return null;
    }

    public static <T> IUrn<Integer> toIndexUrn(IUrn<T> urn, Function<T, Integer> getIndex) {
        Map<T, Double> weights = urn.getWeights();
        LinkedIdentityHashMap urnMap = new LinkedIdentityHashMap();
        weights.forEach((k, v) -> urnMap.put((Integer)getIndex.apply(k), v));
        return UrnUtil.newUrn(urnMap);
    }

    public static <T> JSONObject urnToJson(IUrn<T> urn) {
        Map<T, Double> weights = urn.getWeights();
        String urnType = "";
        String urnSubType = null;
        JSONArray jsonArray = new JSONArray();
        for (Map.Entry<T, Double> entry : weights.entrySet()) {
            Object jval;
            String type;
            T val = entry.getKey();
            String subType = null;
            if (val == null) {
                type = null;
                jval = null;
            } else if (val instanceof Integer) {
                type = "int";
                jval = val;
            } else if (val instanceof Boolean) {
                type = "bool";
                jval = val;
            } else if (val instanceof String) {
                type = "string";
                jval = val;
            } else if (val instanceof UnitDouble) {
                type = "ud";
                jval = val;
            } else if (val instanceof Enum) {
                type = "enum";
                subType = val.getClass().getName();
                jval = ((Enum)val).name();
            } else if (val instanceof Set) {
                type = "set";
                Set set = (Set)val;
                if (set.isEmpty()) {
                    jval = new JSONArray();
                } else {
                    Object first = set.iterator().next();
                    if (first instanceof Tag) {
                        subType = "tag";
                        jval = WriteMesh.toArrayJson(set, t -> t.name);
                    } else if (first instanceof String) {
                        subType = "string";
                        jval = WriteMesh.toArrayJson(set, t -> t);
                    } else {
                        assert (false) : String.format(Locale.US, "Unhandled Set type in urnToJson: %s", set.iterator().next().getClass().getSimpleName());
                        subType = "string";
                        jval = WriteMesh.toArrayJson(set, t -> t.toString());
                    }
                }
            } else {
                assert (false) : String.format(Locale.US, "Unhandled Urn type in urnToJson: %s", val != null ? val.getClass().getSimpleName() : "null");
                type = null;
                jval = val == null ? null : val.toString();
            }
            JSONObject jentry = new JSONObject();
            jentry.put("val", jval);
            jentry.put("weight", entry.getValue());
            jsonArray.add(jentry);
            if (type != null) {
                assert (urnType.isEmpty() || Objects.equals(urnType, type)) : String.format(Locale.US, "Urn value types are inconsistent. Previous was %s; current is %s.", urnType, type);
                urnType = type;
            }
            if (subType == null) continue;
            assert (urnSubType == null || Objects.equals(urnSubType, subType)) : String.format(Locale.US, "Urn Set types are inconsistent. Previous was %s; current is %s.", urnSubType, subType);
            urnSubType = subType;
        }
        if (urnType.isEmpty()) {
            urnType = "string";
        }
        JSONObject json = new JSONObject();
        json.put("urn", jsonArray);
        json.put("type", urnType);
        if (urnSubType != null) {
            json.put("subType", urnSubType);
        }
        return json;
    }

    private static <T> JSONArray toArrayJson(Collection<T> items, Function<T, Object> toJson) {
        JSONArray jarr = new JSONArray();
        items.stream().map(toJson).forEach(v -> jarr.add(v));
        return jarr;
    }

    private static class UEdge {
        public final int i1;
        public final int i2;

        public UEdge(int i1, int i2) {
            this.i1 = i1;
            this.i2 = i2;
        }

        public int hashCode() {
            return this.i1 + this.i2;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            UEdge uedge = (UEdge)obj;
            return uedge.i1 == this.i1 && uedge.i2 == this.i2;
        }
    }
}

