/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.awt.Window;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.CompElementActions;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.tag.Tag;
import merlin.gui.PathObjsList;
import merlin.util.StringTagsUtil;
import thunderheadeng.gui.dialogs.ShowObjectsDialog;
import thunderheadeng.gui.dialogs.ShowTaggedObjsDialog;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.theUtil;

public class ShowTaggedObjects
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new ShowTaggedObjects(), Intl.intl("Show Tagged Objects..."));
    private ShowTaggedObjsDialog d_optionsDlg = null;

    public ShowTaggedObjects() {
        SelectionObserver.add(this, IMerlinObj.class);
        this.update(null);
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        if (this.d_optionsDlg == null) {
            this.d_optionsDlg = new ShowTaggedObjsDialog((Window)app.getActiveFrame());
        }
        IFilteredCollection<Tag> tags = md.selection.flatten(Tag.class);
        this.d_optionsDlg.setTags(tags, NamedMerlinObj::getName);
        if (this.d_optionsDlg.doModal() != 1) {
            return;
        }
        Set<ICompElement> objs = this.d_optionsDlg.getTaggedObjs(ShowTaggedObjects.getDialogCallback(md), tags);
        switch (this.d_optionsDlg.getShowMode()) {
            case SELECT: {
                try (MerlinData.WriteLock lock = md.lockWrite();){
                    Undo.begin(Intl.intl("Select Tagged Objects"));
                    Undo.insertUndoEntry_restoreSelection(md);
                    md.selection.clear();
                    md.selection.selectAll(objs);
                    Undo.end(md);
                    break;
                }
            }
            case LIST: {
                String title = this.generateTitle(md, this.d_optionsDlg.getTagsCombine().desc);
                ShowTaggedObjects.showTaggedObjects(app.getActiveFrame(), title, md, objs);
            }
        }
    }

    public static Set<? extends IMerlinObj> getObjsAny(MerlinData md, Set<Tag> tags) {
        return ShowTaggedObjsDialog.getObjsAny(ShowTaggedObjects.getDialogCallback(md), tags);
    }

    public static void showTaggedObjects(Window parent, String title, MerlinData md, Collection<? extends IMerlinObj> objs) {
        ShowObjectsDialog<IMerlinObj> dlg = new ShowObjectsDialog<IMerlinObj>(parent, title, new PathObjsList(md, Intl.intl("Select Tagged Objects"), true, true, objs));
        dlg.doModeless();
    }

    private String generateTitle(MerlinData md, String prefix) {
        Set<String> tags = md.selection.flatten(Tag.class).stream().map(tag -> tag.getName()).collect(Collectors.toSet());
        String joinedTags = StringTagsUtil.format(tags);
        return String.format(Intl.intl("Tagged Objects: %1$s %2$s"), prefix, joinedTags);
    }

    public static ShowTaggedObjsDialog.ICallback<ICompElement, Tag> getDialogCallback(final MerlinData vd) {
        return new ShowTaggedObjsDialog.ICallback<ICompElement, Tag>(){

            @Override
            public Collection<? extends ICompElement> getAllTaggable() {
                IFilteredCollection<ICompElement> compObjs = theUtil.filter(vd.getChildren(), ICompElement.class);
                return CompElementActions.flattenToLocallyDefined(MerlinData.TAGS, compObjs);
            }

            @Override
            public Set<? extends Tag> getTags(ICompElement obj) {
                return obj.getProp(MerlinData.TAGS).orElse(Collections.emptySet());
            }
        };
    }

    @Override
    public void update(Events events) {
        MerlinData md = MerlinApp.getApp().getData();
        this.setEnabled(!md.selection.isDeepEmpty(Tag.class));
    }
}

