/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import merlin.actions.Undo;
import merlin.data.GeomComposite;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import merlin.data.egress.Floor;

public class SetWorkingGroup {
    public static void setWorkingGroup(MerlinData md, Floor floor, GeomComposite<ICompElement> group) {
        ChangeWorkingGroupOp op = new ChangeWorkingGroupOp(floor, floor.getWorkingGeomGroup(), group);
        Undo.insertEntry(md, op.perform());
    }

    private static class ChangeWorkingGroupOp
    implements Undo.UndoOp {
        private final Floor floor;
        private final GeomComposite<ICompElement> oldGroup;
        private final GeomComposite<ICompElement> newGroup;

        public ChangeWorkingGroupOp(Floor floor, GeomComposite<ICompElement> oldGroup, GeomComposite<ICompElement> newGroup) {
            this.floor = floor;
            this.oldGroup = oldGroup;
            this.newGroup = newGroup;
        }

        @Override
        public Undo.UndoOp perform() {
            this.floor.setWorkingGeomGroup(this.newGroup);
            return new ChangeWorkingGroupOp(this.floor, this.newGroup, this.oldGroup);
        }

        @Override
        public boolean isMajor() {
            return true;
        }
    }
}

