/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.Collection;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import merlin.util.MerlinUtil;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;

public class SelectNonGroupDescendants
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new SelectNonGroupDescendants(), Intl.intl("Select Non-Group Descendants"));

    public SelectNonGroupDescendants() {
        SelectionObserver.add(this, Composite.class);
        this.update();
    }

    @Override
    public void update(Events events) {
        this.update();
    }

    public void update() {
        this.setEnabled(MerlinApp.getApp().getData().selection.contains(Composite.class));
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        try (MerlinData.WriteLock lock = md.lockWrite();){
            Undo.begin(Intl.intl("Select Non-Group Descendants"));
            Undo.insertUndoEntry_restoreSelection(md);
            Collection<ICompElement> toSelect = MerlinUtil.flattenComposites(md.selection.getSelected(ICompElement.class));
            md.selection.clear();
            md.selection.selectAll(toSelect);
            Undo.end(md);
        }
    }
}

