/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.Set;
import java.util.function.Predicate;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.MerlinData;
import merlin.data.egress.geom.IEgressComp;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class SelectConflictingComps
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new SelectConflictingComps(), Intl.intl("Select Conflicting Components"));

    public SelectConflictingComps() {
        MerlinApp.getApp().getData().getEvents().addObserver(this);
        this.update(null);
    }

    public static Predicate<IEgressComp> getFilter() {
        return new Predicate<IEgressComp>(){

            @Override
            public boolean test(IEgressComp o) {
                return !o.getConflicts().isEmpty();
            }
        };
    }

    @Override
    public void update(Events events) {
        if (events == null) {
            this.updateEnabled();
            return;
        }
        IEventRecord<IEgressComp> evts = events.getEvents(IEgressComp.class, new Class[0]);
        if (evts.isModified()) {
            this.updateEnabled();
        }
    }

    protected void updateEnabled() {
        MerlinData md = MerlinApp.getApp().getData();
        Set comps = md.selection.getDeepSelected(IEgressComp.class);
        this.setEnabled(!(comps = theUtil.filter(comps, SelectConflictingComps.getFilter())).isEmpty());
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        try (MerlinData.WriteLock lock = md.lockWrite();){
            Undo.begin(Intl.intl("Select Conflicting Components"));
            Undo.insertUndoEntry_restoreSelection(md);
            Set comps = MerlinApp.getApp().getData().selection.getDeepSelected(IEgressComp.class);
            comps = theUtil.filter(comps, SelectConflictingComps.getFilter());
            md.selection.clear();
            for (IEgressComp comp : comps) {
                for (Pair<IEgressComp, IEgressComp.ConflictType> conflict : comp.getConflicts()) {
                    md.selection.select((IEgressComp)conflict.v1);
                }
            }
            Undo.end(md);
        }
    }
}

