/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.Collection;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.IMerlinObj;
import merlin.data.ImportedGeom;
import merlin.data.MerlinData;
import merlin.data.material.Material;
import merlin.gui.MerlinComboBox;
import merlin.util.MerlinDepSnapshot;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.Sets;
import thunderheadeng.util.TypeFilter;

public class SelectByMaterial
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new SelectByMaterial(), Intl.intl("Select All by Material..."));

    public SelectByMaterial() {
        SelectionObserver.add(this, ImportedGeom.class);
        this.update(null);
    }

    protected Collection<ImportedGeom> getObjs(MerlinData md) {
        return md.selection.getDeepSelected(ImportedGeom.class);
    }

    @Override
    public void update(Events events) {
        this.setEnabled(!this.getObjs(MerlinApp.getApp().getData()).isEmpty());
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        LinkedIdentityHashSet selMats = new LinkedIdentityHashSet();
        LinkedIdentityHashSet selObjects = new LinkedIdentityHashSet();
        try (AutoCloseable lock = md.lockRead();){
            Set<Object> matchMats;
            MerlinDepSnapshot deps = new MerlinDepSnapshot(md, MerlinDepSnapshot.ACTIVE_SCENARIO, new TypeFilter<Object>(Material.class));
            deps.start(md, md.getChildren());
            deps.getObjReferences(ImportedGeom.class, Material.class, Predicates.alwaysTrue(), (source, link, target) -> {
                if (md.selection.isSelected(source)) {
                    selMats.add(target);
                }
            });
            if (selMats.isEmpty()) {
                JOptionPane.showMessageDialog(app.getActiveFrame(), Intl.intl("There are no materials in the selection."), Intl.intl("No Materials in Selection"), 1);
                return;
            }
            if (selMats.size() == 1) {
                matchMats = selMats;
            } else {
                guiRadioButton anyBtn = new guiRadioButton(Intl.intl("Any"));
                guiRadioButton oneBtn = new guiRadioButton("");
                new guiButtonGroup(anyBtn, oneBtn);
                MerlinComboBox matsCB = new MerlinComboBox(md, Material.class, Filters.accept(selMats), (IMerlinObj[])new Material[0]);
                LinkStatus.link((AbstractButton)oneBtn, matsCB);
                guiPanel matsPnl = new guiPanel();
                GridBagHelper gb = new GridBagHelper(matsPnl);
                gb.addRow(Intl.intl("The selection contains multiple materials.  Which one should be matched?"), 0);
                gb.indent();
                gb.addRow(anyBtn, 0);
                gb.addRow(oneBtn, matsCB, 0);
                gb.finalizeRows();
                anyBtn.setSelected(true);
                int sel = JOptionPane.showConfirmDialog(app.getActiveFrame(), matsPnl, Intl.intl("Which Material?"), 2);
                if (sel != 0) {
                    return;
                }
                matchMats = anyBtn.isSelected() ? selMats : Sets.fromArrayIHS((Material)matsCB.getSelectedItem());
            }
            deps.getObjReferences(ImportedGeom.class, Material.class, Filters.accept(matchMats), (src, link, target) -> selObjects.add(src));
        }
        if (selObjects.isEmpty()) {
            assert (false);
            return;
        }
        lock = md.lockWrite();
        try {
            Undo.begin(Intl.intl("Select All by Material"));
            Undo.insertUndoEntry_restoreSelection(md);
            md.selection.set(selObjects);
            Undo.end(md);
        }
        finally {
            if (lock != null) {
                ((MerlinData.WriteLock)lock).close();
            }
        }
        JOptionPane.showMessageDialog(app.getActiveFrame(), String.format(Intl.intl("%d objects selected."), selObjects.size()), Intl.intl("Selected Objects"), 1);
    }
}

