/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import merlin.EntryPoint;
import merlin.EntryPointFactory;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.IMerlinObj;
import merlin.data.INamed;
import merlin.data.MerlinData;
import merlin.data.egress.Floor;
import merlin.util.MerlinUtil;
import thunderheadeng.gui.RenameDialog;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class RenameAction
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new RenameAction(), Intl.intl("&Rename...,-,Rename selected objects"));
    private static final EnumSet<RenameDialog.DefaultKeywordOpts> s_allowedKeywords = EnumSet.complementOf(EnumSet.of(RenameDialog.DefaultKeywordOpts.SELECTION_IX));

    public RenameAction() {
        SelectionObserver.add(this, INamed.class);
        this.update(null);
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        Collection<INamed> objs = RenameAction.getRenameObjs(md);
        assert (!objs.isEmpty());
        INamed[] namedArr = theUtil.toArray(objs, INamed.class);
        RenameDialog.ICallback<INamed> callback = RenameAction.getRenameCallback(md);
        List keywords = RenameDialog.getDefaultKeywords(callback, objs, s_allowedKeywords);
        RenameDialog<INamed> dlg = new RenameDialog<INamed>((Window)app.getActiveFrame(), callback, keywords, objs);
        if (dlg.doModal() != 1) {
            return;
        }
        List<String> newNames = dlg.generateNames((INamed[])namedArr);
        if (newNames.isEmpty()) {
            return;
        }
        try (MerlinData.WriteLock lock = md.lockWrite();){
            assert (newNames.size() == namedArr.length);
            List<Pair> entries = IntStream.range(0, namedArr.length).filter(i -> newNames.get(i) != null).mapToObj(i -> new Pair<INamed, String>(namedArr[i], (String)newNames.get(i))).toList();
            List<INamed> filteredToRename = entries.stream().map(e -> (INamed)e.v1).toList();
            List<String> filteredNewNames = entries.stream().map(e -> (String)e.v2).toList();
            RenameAction.renameImpl(md, filteredToRename, filteredNewNames);
        }
    }

    private static RenameDialog.ICallback<INamed> getRenameCallback(final MerlinData md) {
        return new RenameDialog.ICallback<INamed>(){

            @Override
            public Object getRoot(INamed obj) {
                Object[] path = md.hierarchy.getPath(obj);
                return path == null || path.length < 2 ? null : path[1];
            }

            @Override
            public List<Object> flattenHierarchy(Object obj) {
                return MerlinUtil.flatten(md.hierarchy.getChildren(obj)).stream().toList();
            }

            @Override
            public Object getParent(Object obj) {
                return md.hierarchy.getParent(obj);
            }

            @Override
            public List<Object> getChildren(Object obj) {
                return md.hierarchy.getChildren(obj).stream().toList();
            }

            @Override
            public String getName(Object obj) {
                return MerlinUtil.getName(obj);
            }

            @Override
            public String getTypeString(INamed obj) {
                return EntryPointFactory.get(obj).getTypeString(md, obj);
            }

            @Override
            public OptionalLong getResultsId(INamed obj) {
                if (obj instanceof IMerlinObj) {
                    IMerlinObj iobj = (IMerlinObj)((Object)obj);
                    long id = iobj.getResultsId();
                    return id == -1L ? OptionalLong.empty() : OptionalLong.of(id);
                }
                return OptionalLong.empty();
            }

            @Override
            public Predicate<String> getNameValidator(INamed obj) {
                return EntryPointFactory.get(obj).getNameValidator(md, obj);
            }

            @Override
            public Object getUniqueNameGroup(INamed obj) {
                return EntryPointFactory.get(obj).getUniqueNameGroup(md, obj);
            }

            @Override
            public Collection<?> getGroupObjs(Object token) {
                Collection<Object> collection;
                if (token instanceof EntryPoint.INameGroup) {
                    EntryPoint.INameGroup group = (EntryPoint.INameGroup)token;
                    collection = group.get(md);
                } else {
                    collection = Collections.emptyList();
                }
                return collection;
            }
        };
    }

    private static void renameImpl(MerlinData md, List<? extends INamed> objs, List<String> newNames) {
        if (objs.isEmpty()) {
            return;
        }
        Undo.begin(Intl.intl("Rename"));
        RenameOp op = new RenameOp(objs, newNames, true);
        op.perform();
        Undo.insertEntry(md, op.getReverseOp());
        Undo.end(md);
    }

    public static boolean rename(MerlinData md, Window parent, Collection<? extends INamed> objs, String newName) {
        if (objs.isEmpty()) {
            return true;
        }
        Optional<Function<INamed, String>> validatedResult = RenameDialog.validateNames(parent, RenameAction.getRenameCallback(md), objs, o -> newName);
        if (validatedResult.isEmpty()) {
            return false;
        }
        Function<INamed, String> namesFunc = validatedResult.get();
        IFilteredCollection<INamed> renObjs = theUtil.filter(objs, o -> namesFunc.apply((INamed)o) != null);
        if (renObjs.isEmpty()) {
            return false;
        }
        List<String> newNames = renObjs.stream().map(namesFunc).toList();
        Undo.begin(Intl.intl("Rename"));
        RenameOp op = new RenameOp(new ArrayList<INamed>(renObjs), newNames, true);
        op.perform();
        Undo.insertEntry(md, op.getReverseOp());
        Undo.end(md);
        return renObjs.size() == objs.size();
    }

    public static Predicate<INamed> getIsRenameableFilter(MerlinData md) {
        return named -> EntryPointFactory.get(named).tvEntryPoint.canRename(md, (INamed)named);
    }

    private static boolean testShouldEnable(MerlinData md, Collection<INamed> selected) {
        return !selected.isEmpty();
    }

    private static Collection<INamed> getRenameObjs(MerlinData md) {
        return md.selection.get(INamed.class, RenameAction.getIsRenameableFilter(md));
    }

    @Override
    public void update(Events events) {
        MerlinData md = MerlinApp.getAppData();
        this.setEnabled(RenameAction.testShouldEnable(md, RenameAction.getRenameObjs(md)));
    }

    private static class RenameOp
    implements Undo.UndoOp,
    Cloneable {
        private final List<? extends INamed> d_objs;
        private final List<String> d_oldNames;
        private final List<String> d_newNames;
        private boolean d_ascend;

        public RenameOp(List<? extends INamed> objs, List<String> newNames, boolean ascend) {
            this.d_objs = objs;
            this.d_oldNames = new ArrayList<String>(objs.size());
            for (INamed iNamed : objs) {
                if (iNamed instanceof Floor) {
                    this.d_oldNames.add(((Floor)iNamed).getBaseName());
                    continue;
                }
                this.d_oldNames.add(iNamed.getName());
            }
            this.d_newNames = newNames;
            this.d_ascend = ascend;
        }

        private Undo.UndoOp getReverseOp() {
            try {
                RenameOp clone = (RenameOp)this.clone();
                clone.d_ascend = !clone.d_ascend;
                return clone;
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        @Override
        public Undo.UndoOp perform() {
            Undo.UndoOp undo = this.getReverseOp();
            if (this.d_ascend) {
                for (int m = 0; m < this.d_objs.size(); ++m) {
                    INamed obj = this.d_objs.get(m);
                    obj.setName(this.d_newNames.get(m));
                }
            } else {
                for (int m = this.d_objs.size() - 1; m >= 0; --m) {
                    INamed obj = this.d_objs.get(m);
                    String oldName = this.d_oldNames.get(m);
                    obj.setName(oldName);
                }
            }
            return undo;
        }

        @Override
        public boolean isMajor() {
            return true;
        }
    }
}

