/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.Delete;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.geom.IEgressOccupiable;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TypeFilter;
import thunderheadeng.util.theUtil;

public class ReducePopulation
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new ReducePopulation(), Intl.intl("Reduce Population..."));
    private static final Random s_rand = new Random(4204460082L);

    public ReducePopulation() {
        SelectionObserver.add(this, IMerlinObj.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        MerlinData md = MerlinApp.getApp().getData();
        this.setEnabled(!this.getSelection(md).isEmpty());
    }

    private Collection<EgressAgent> getSelection(MerlinData md) {
        IFilteredCollection<IMerlinObj> sel = md.selection.flatten(IMerlinObj.class, new TypeFilter(EgressAgent.class, IEgressOccupiable.class));
        return theUtil.flatMap(sel, obj -> {
            if (obj instanceof EgressAgent) {
                return Collections.singleton((EgressAgent)obj);
            }
            return ((IEgressOccupiable)obj).getOccupants();
        });
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        List<EgressAgent> toRemove;
        Collection<EgressAgent> agents = this.getSelection(md);
        if (agents.isEmpty()) {
            return;
        }
        ArrayList<EgressAgent> selGeom = new ArrayList<EgressAgent>(agents);
        Pair newCount = md.ui(() -> {
            NewCountDlg dlg = new NewCountDlg((Window)app.getActiveFrame(), selGeom.size());
            if (dlg.doModal() != 1) {
                return null;
            }
            return new Pair<Integer, NewCountDlg.Position>(dlg.getCount(), dlg.getPosition());
        });
        if (newCount == null) {
            return;
        }
        int removeCount = selGeom.size() - (Integer)newCount.v1;
        if (removeCount == 0) {
            return;
        }
        if (removeCount == selGeom.size()) {
            toRemove = selGeom;
        } else {
            switch (((NewCountDlg.Position)((Object)newCount.v2)).ordinal()) {
                case 1: {
                    toRemove = selGeom.subList(selGeom.size() - removeCount, selGeom.size());
                    break;
                }
                case 2: {
                    toRemove = selGeom.subList(0, removeCount);
                    break;
                }
                case 0: {
                    Collections.shuffle(selGeom, s_rand);
                    toRemove = selGeom.subList(0, removeCount);
                    break;
                }
                default: {
                    assert (false);
                    toRemove = Collections.emptyList();
                }
            }
        }
        Delete.uiDelete(app, md, toRemove, true);
    }

    private static class NewCountDlg
    extends guiDialog {
        private static final long serialVersionUID = -8432406727249271099L;
        private final guiComboBox<Position> positionCB;
        private final ValueField<Integer> countFld;

        public NewCountDlg(Window parent, int maxValue) {
            super(parent, Intl.intl("Occupant Count"), 9);
            this.countFld = ValueFields.intFld(maxValue, IntVR.between(0, maxValue, true, true));
            this.positionCB = new guiComboBox<Position>(Position.values());
            this.positionCB.setRenderer(new DefaultListCellRenderer(){
                private static final long serialVersionUID = 2264433975774340960L;

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    this.setText(((Position)((Object)value)).desc);
                    return this;
                }
            });
            GridBagHelper gb = new GridBagHelper(this.getDialogPane());
            gb.addRow(Intl.intl("New occupant count:"), this.countFld, 1.0);
            gb.addRow(Intl.intl("Occupants to keep:"), this.positionCB, 1.0);
            gb.finalizeRows();
        }

        public int getCount() {
            return (Integer)this.countFld.getValue();
        }

        public Position getPosition() {
            return this.positionCB.getSelectedItem();
        }

        private static enum Position {
            RANDOM(Intl.intl("Random")),
            FRONT(Intl.intl("First items in selection")),
            BACK(Intl.intl("Last items in selection"));

            public final String desc;

            private Position(String desc) {
                this.desc = desc;
            }
        }
    }
}

