/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.awt.Window;
import java.util.Set;
import javax.vecmath.Point3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.MerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.IOrientable;
import merlin.data.IRestorable;
import merlin.data.MerlinData;
import merlin.data.MerlinSelectionModel;
import merlin.geom.IMerlinGeomSrc;
import merlin.gui.MerlinUDF;
import merlin.mv.ModelView;
import merlin.mv.tools.IPointPickListener;
import org.jscience.physics.units.SI;
import thunderheadeng.gui.AbstractDlgListener;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class OrientOnAction
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook((MerlinOp)new OrientOnAction(), Intl.intl("Orient on Point...,-,Orients the selected occupants or occupant targets so they face toward a specific location."), 0);

    public OrientOnAction() {
        SelectionObserver.add(this, IOrientable.class);
        this.update(null);
    }

    @Override
    public void run(final MerlinApp app, final MerlinData md) {
        final ModelView mv = app.getModelView();
        final Set agents = md.selection.getDeepSelected(IOrientable.class);
        mv.getRenderComp().requestFocus();
        guiDialog dlg = new guiDialog((Window)app.getMainFrame(), Intl.intl("Choose Target Point"), 9);
        guiPanel panel = dlg.getDialogPane();
        GridBagHelper gb = new GridBagHelper(panel);
        guiPanel pointPnl = new guiPanel();
        GridBagHelper gb2 = new GridBagHelper(pointPnl);
        final MerlinUDF xFld = new MerlinUDF(0);
        final MerlinUDF yFld = new MerlinUDF(0);
        gb2.addRow(Intl.intl("X:"), xFld);
        gb2.addRow(Intl.intl("Y:"), yFld);
        gb2.finalizeRows();
        gb.addRow("<html>" + Intl.intl("Enter a target point or select one <br>by clicking on the navigation mesh.") + "</html>");
        gb.addIdentRow(pointPnl);
        gb.finalizeRows();
        dlg.addDlgListener(new AbstractDlgListener(this){

            @Override
            public void okPressed() {
                mv.stopChoosingPoints();
                UnitDouble x = (UnitDouble)xFld.getValue();
                UnitDouble y = (UnitDouble)yFld.getValue();
                Point3d target = new Point3d(x.getValue(SI.METER), y.getValue(SI.METER), 0.0);
                OrientOnAction.orientAgentsOn(app, md, agents, target);
            }

            @Override
            public void cancelPressed() {
                mv.stopChoosingPoints();
            }

            @Override
            public void closePressed() {
                mv.stopChoosingPoints();
            }
        });
        IPointPickListener listener = new IPointPickListener(){

            @Override
            public void pointPicked(IMerlinGeomSrc source, UnitPoint3D p) {
                if (p != null) {
                    xFld.setValue(p.xu());
                    yFld.setValue(p.yu());
                }
            }

            @Override
            public void stopPicking() {
            }

            @Override
            public Pair<SnapMode, IIsectFilter> getSnapInfo(CursorTool tool) {
                return new Pair<SnapMode, Object>(SnapMode.ANY, null);
            }

            @Override
            public boolean allowPickFromFloorZ() {
                return true;
            }
        };
        dlg.doModeless();
        mv.startChoosingPoints(listener);
    }

    private static void orientAgentsOn(MerlinApp app, MerlinData md, final Set<? extends IOrientable> objs, final Point3d target) {
        AMerlinOp op = new AMerlinOp(){

            @Override
            public void run(MerlinApp app, MerlinData md) {
                try (MerlinData.WriteLock lock = md.lockWrite();){
                    Undo.begin(Intl.intl("Orient on Point"));
                    Undo.insertUndoEntry_restore(md, theUtil.filter(objs, IRestorable.class));
                    for (IOrientable obj : objs) {
                        obj.setOrientTarget(target);
                    }
                    Undo.insertUndoEntry_restoreSelection(md);
                    md.selection.selectAll(objs);
                    Undo.end(md);
                }
            }
        };
        UIHook.run(app.getMainFrame(), "OrientOnAction.run", op, 0);
    }

    @Override
    public void update(Events events) {
        MerlinApp app = MerlinApp.getApp();
        MerlinData data = app.getData();
        MerlinSelectionModel sel = data.selection;
        this.setEnabled(!sel.isDeepEmpty(IOrientable.class));
    }
}

