/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.awt.Desktop;
import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.data.MerlinData;

public class OpenExternalLinkAction
extends AMerlinOp {
    private final Type d_type;
    private final Collection<String> d_targets;

    public OpenExternalLinkAction(Type type, String ... target) {
        this.d_type = type;
        this.d_targets = Arrays.asList(target);
    }

    public Collection<String> getTargets() {
        return this.d_targets;
    }

    @Override
    public void run(final MerlinApp app, MerlinData md) {
        final Exception[] caughtException = new Exception[]{null};
        for (String target : this.d_targets) {
            try {
                if (this.d_type == Type.FILE) {
                    Desktop.getDesktop().open(new File(target));
                } else {
                    Desktop.getDesktop().browse(URI.create(target));
                }
                System.out.println("Opened " + target);
                caughtException[0] = null;
                break;
            }
            catch (Exception e) {
                if (caughtException[0] != null) continue;
                caughtException[0] = e;
            }
        }
        if (caughtException[0] != null) {
            Runnable showError = new Runnable(){

                @Override
                public void run() {
                    JFrame mainFrame = app.getMainFrame();
                    caughtException[0].printStackTrace();
                    JOptionPane.showMessageDialog(mainFrame, caughtException[0].getLocalizedMessage(), Intl.intl("Error Opening Link"), 0);
                }
            };
            md.ui(showError);
        }
    }

    public static enum Type {
        URL,
        FILE;

    }
}

