/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.Set;
import merlin.EntryPointFactory;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.MerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.egress.scripting.attractors.Attractor;
import merlin.data.egress.scripting.attractors.AttractorRootComp;
import merlin.data.egress.scripting.attractors.AttractorTemplateComp;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;

public class NewAttractorTemplateObject
extends AMerlinOp
implements IEventObserver {
    private static final String s_uiHookLbl = Intl.intl("New Trigger Template");
    public static final UIHook MENU_HOOK = new UIHook((MerlinOp)new NewAttractorTemplateObject(true), s_uiHookLbl, EntryPointFactory.attractorIcon);
    public static final UIHook CONTEXT_HOOK = new UIHook(new NewAttractorTemplateObject(false), s_uiHookLbl);
    private final boolean d_mainMenu;

    public NewAttractorTemplateObject(boolean mainMenu) {
        this.d_mainMenu = mainMenu;
        if (!this.d_mainMenu) {
            SelectionObserver.add(this, IMerlinObj.class);
            this.update(null);
        }
    }

    @Override
    public void update(Events events) {
        MerlinData md = MerlinApp.getApp().getData();
        this.setEnabled(md.selection.isSingleExclusive(AttractorTemplateComp.class, AttractorRootComp.class));
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        try (MerlinData.WriteLock lock = md.lockWrite();){
            Set selTemplateGroups;
            Undo.begin(Intl.intl("Add Trigger Template"));
            AttractorTemplateComp group = null;
            if (!this.d_mainMenu && !(selTemplateGroups = md.selection.getSelected(AttractorTemplateComp.class)).isEmpty()) {
                group = (AttractorTemplateComp)selTemplateGroups.iterator().next();
            }
            if (group == null) {
                group = md.attractorTemplates;
            }
            Attractor newAttractor = new Attractor(md.attractorsNameGen.getCurrentName());
            md.attractorsNameGen.nextName();
            newAttractor.setProperty(Attractor.TYPE, Attractor.PlaceType.TEMPLATE);
            md.queueObjectNameGen.nextName();
            Undo.insertUndoEntry_delete(md, group, newAttractor);
            group.add(newAttractor);
            Undo.insertUndoEntry_restoreSelection(md);
            md.selection.set(newAttractor);
            Undo.end(md);
        }
    }
}

