/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import merlin.Intl;
import merlin.actions.OccGenerator;
import merlin.data.AMerlinObj;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.OccSourceObj;
import merlin.data.egress.SimError;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.OccLocation;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.montecarlo.MonteCarlo;
import merlin.data.montecarlo.VariationOccFilter;
import merlin.data.montecarlo.VariationPositionDistribution;
import merlin.data.montecarlo.VariationProfileRule;
import merlin.data.montecarlo.VariationRoomRule;
import org.jscience.physics.units.SI;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.IUrnSampler;
import thunderheadeng.util.stat.InfiniteUrn;
import thunderheadeng.util.stat.Urn;
import thunderheadeng.util.stat.UrnUtil;
import thunderheadeng.util.theUtil;

public class MonteCarloVariationGenerator {
    public static void generateVariations(MerlinData md, VariationConsumer consumer) {
        IUrn<OccProfile> profileUrn;
        LinkedHashMap<IEgressOccupiable, Set> roomOccMap;
        VariationRestoreState restoreState;
        ArrayList<OccSourceObj> occSources;
        Collection<EgressAgent> propsAgents;
        Collection<EgressAgent> posAgents;
        Collection<EgressAgent> profsAgents;
        int variationCount;
        MonteCarlo monteCarlo;
        try (MerlinData.ReadLock lock = md.lockRead();){
            monteCarlo = md.monteCarlo;
            variationCount = monteCarlo.get(MonteCarlo.VARIATION_COUNT);
        }
        if (variationCount <= 1) {
            consumer.accept(0, 1, Collections.emptyList());
            return;
        }
        try (MerlinData.ReadLock lock = md.lockRead();){
            Collection filters = md.monteCarlo.get(MonteCarlo.OCC_FILTERS);
            profsAgents = MonteCarloVariationGenerator.getAgents(md, md.monteCarlo.get(MonteCarlo.RANDOMIZE_PROFILES), VariationOccFilter::randomizeProfiles, filters);
            posAgents = MonteCarloVariationGenerator.getAgents(md, md.monteCarlo.get(MonteCarlo.RANDOMIZE_POSITIONS), VariationOccFilter::randomizePositions, filters);
            propsAgents = MonteCarloVariationGenerator.getAgents(md, md.monteCarlo.get(MonteCarlo.RANDOMIZE_PROPERTIES), VariationOccFilter::randomizeProperties, filters);
            occSources = new ArrayList<OccSourceObj>(md.occSources.flatten(OccSourceObj.class));
            restoreState = new VariationRestoreState();
            for (EgressAgent occ2 : profsAgents) {
                restoreState.profiles.put(occ2, occ2.getProfile().getProfParent());
            }
            for (EgressAgent occ2 : posAgents) {
                restoreState.occLocations.put(occ2, occ2.getLocation());
                restoreState.orientSeeds.put(occ2, occ2.getOrientSeed());
            }
            for (EgressAgent occ2 : propsAgents) {
                restoreState.profileSeeds.put(occ2, occ2.getProfileSeed());
                restoreState.orientSeeds.put(occ2, occ2.getOrientSeed());
            }
            for (OccSourceObj occSource : occSources) {
                restoreState.occSourceSeeds.put(occSource, occSource.getSeed());
            }
            roomOccMap = new LinkedHashMap<IEgressOccupiable, Set>();
            for (EgressAgent ea : posAgents) {
                roomOccMap.compute(ea.getRoom(), (key, set) -> {
                    if (set == null) {
                        set = new LinkedHashSet<EgressAgent>();
                    }
                    set.add(ea);
                    return set;
                });
            }
            profileUrn = switch (monteCarlo.get(MonteCarlo.PROFILE_RULE)) {
                default -> throw new MatchException(null, null);
                case VariationProfileRule.NEW_DISTRIBUTION -> monteCarlo.get(MonteCarlo.PROFILE_DIST);
                case VariationProfileRule.SHUFFLE_EXISTING -> new Urn<OccProfile>((Collection<OccProfile>)profsAgents.stream().map(occ -> occ.getProfile().getProfParent()).toList());
            };
        }
        Random rng = new Random(monteCarlo.get(MonteCarlo.RANDOMIZATION_SEED));
        for (int i = 0; i < variationCount; ++i) {
            ArrayList<SimError> errors = new ArrayList<SimError>();
            md.ui(() -> {
                try (MerlinData.WriteLock lock = md.lockWrite();){
                    MonteCarloVariationGenerator.randomizeAgentProfiles(md, rng, profileUrn, profsAgents, restoreState, errors);
                    MonteCarloVariationGenerator.randomizeAgentPositions(md, rng, monteCarlo.get(MonteCarlo.ROOM_RULE), monteCarlo.get(MonteCarlo.POSITION_DISTRIBUTION), roomOccMap, posAgents, restoreState, errors);
                    MonteCarloVariationGenerator.randomizeAgentProfileData(md, rng, propsAgents, errors);
                    MonteCarloVariationGenerator.randomizeAgentSourceObjs(md, rng, occSources, errors);
                }
            });
            if (!consumer.accept(i, variationCount, errors)) break;
        }
        md.ui(() -> {
            try (MerlinData.WriteLock lock = md.lockWrite();){
                for (Map.Entry<EgressAgent, OccProfile> entry : restoreState.profiles.entrySet()) {
                    entry.getKey().setProfileParent(entry.getValue());
                }
                for (Map.Entry<EgressAgent, Cloneable> entry : restoreState.occLocations.entrySet()) {
                    entry.getKey().setLocation((OccLocation)entry.getValue());
                }
                for (Map.Entry<EgressAgent, Serializable> entry : restoreState.orientSeeds.entrySet()) {
                    entry.getKey().setOrientSeed((Long)entry.getValue());
                }
                for (Map.Entry<EgressAgent, Serializable> entry : restoreState.profileSeeds.entrySet()) {
                    entry.getKey().setProfileSeed((Long)entry.getValue());
                }
                for (Map.Entry<AMerlinObj, Serializable> entry : restoreState.occSourceSeeds.entrySet()) {
                    ((OccSourceObj)entry.getKey()).set(OccSourceObj.PROP_SEED, (Long)entry.getValue());
                }
            }
        });
    }

    private static void randomizeAgentProfiles(MerlinData md, Random rng, IUrn<OccProfile> profUrnRaw, Collection<EgressAgent> occsToRandomize, VariationRestoreState restoreState, List<SimError> errors) {
        if (occsToRandomize.isEmpty()) {
            return;
        }
        if (profUrnRaw == null) {
            profUrnRaw = new InfiniteUrn<OccProfile>(md.profiles.NO_CHANGE);
        }
        Urn<OccProfile> profileUrn = UrnUtil.makeFinite(profUrnRaw, occsToRandomize.size()).shuffleRandomly(rng);
        IUrnSampler<OccProfile> profSampler = profileUrn.getSampler(rng);
        for (EgressAgent ea : occsToRandomize) {
            OccProfile prof = profSampler.sampleNext();
            if (prof != md.profiles.NO_CHANGE) {
                ea.setProfileParent(prof);
                continue;
            }
            ea.setProfileParent(restoreState.profiles.get(ea));
        }
    }

    private static void randomizeAgentProfileData(MerlinData md, Random rng, Collection<EgressAgent> occsToRandomize, List<SimError> errors) {
        if (occsToRandomize.isEmpty()) {
            return;
        }
        block0: for (EgressAgent ea : occsToRandomize) {
            ea.setProfileSeed(rng.nextLong());
            long seed = rng.nextLong();
            UnitDouble angle = ea.getProfile().toOccValue(OccProfile.PROP_INIT_ORIENT, 0L, seed);
            int maxAttempts = 400;
            for (int attempts = 0; attempts < maxAttempts; ++attempts) {
                if (!ea.isValidOrient(angle)) continue;
                ea.setOrientSeed(seed);
                continue block0;
            }
        }
    }

    private static void randomizeAgentPositions(MerlinData md, Random rng, VariationRoomRule roomRule, VariationPositionDistribution distPosRule, Map<IEgressOccupiable, Set<EgressAgent>> roomOccMap, Collection<EgressAgent> occsToRandomize, VariationRestoreState restoreState, List<SimError> errors) {
        boolean successful;
        if (occsToRandomize.isEmpty()) {
            return;
        }
        LinkedHashSet<OccProfile> profiles = new LinkedHashSet<OccProfile>();
        for (EgressAgent occ : occsToRandomize) {
            profiles.add(occ.getProfile().getProfParent());
        }
        LinkedHashSet<IEgressOccupiable> allUseableRooms = new LinkedHashSet<IEgressOccupiable>(md.floors.flatten(IEgressOccupiable.class, room -> room.isEnabled() && room.getOccupantsAllowed()));
        BiFunction<Set, Collection, Boolean> randomize = (comps, occs) -> {
            OccGenerator occGenerator = new OccGenerator(md, rng, OccGenerator.getModels(comps), OccGenerator.getMaxDiam(profiles), new UnitDouble(0.125, SI.SECOND), 400, null, null);
            return switch (distPosRule) {
                default -> throw new MatchException(null, null);
                case VariationPositionDistribution.UNIFORM -> occGenerator.generate(occs.size(), 0, 2, (Collection<EgressAgent>)occs);
                case VariationPositionDistribution.RANDOM -> occGenerator.generate(occs.size(), 1, 2, (Collection<EgressAgent>)occs);
            };
        };
        block0 : switch (roomRule) {
            default: {
                throw new MatchException(null, null);
            }
            case ANY: {
                boolean bl = randomize.apply(allUseableRooms, occsToRandomize);
                break;
            }
            case UNION: {
                boolean bl = randomize.apply(roomOccMap.keySet(), occsToRandomize);
                break;
            }
            case SAME: {
                boolean bl;
                for (Map.Entry<IEgressOccupiable, Set<EgressAgent>> entry : roomOccMap.entrySet()) {
                    if (randomize.apply(Collections.singleton(entry.getKey()), entry.getValue()).booleanValue()) continue;
                    bl = false;
                    break block0;
                }
                bl = successful = true;
            }
        }
        if (!successful) {
            errors.add(new SimError(SimError.Level.MODERATE, Intl.intl("Occupants' positions could not be randomized without overlap."), Intl.intl("Reduce the density of occupants in the model."), new IMerlinObj[0]));
            for (EgressAgent occ : occsToRandomize) {
                occ.setLocation(restoreState.occLocations.get(occ));
                occ.setOrientSeed(restoreState.orientSeeds.get(occ));
            }
        }
    }

    private static void randomizeAgentSourceObjs(MerlinData md, Random rng, Collection<OccSourceObj> sources, List<SimError> errors) {
        for (OccSourceObj src : sources) {
            src.set(OccSourceObj.PROP_SEED, theUtil.randomSeed(rng));
        }
    }

    private static Collection<EgressAgent> getAgents(MerlinData md, boolean defaultInclude, Function<VariationOccFilter, Boolean> filterInclude, Collection<VariationOccFilter> filters) {
        return new ArrayList<EgressAgent>(md.agents.flatten(EgressAgent.class, agent -> {
            boolean include = defaultInclude;
            for (VariationOccFilter filter : filters) {
                if (!md.hierarchy.isDescendent(filter.group(), agent)) continue;
                include = (Boolean)filterInclude.apply(filter);
            }
            return include;
        }));
    }

    @FunctionalInterface
    public static interface VariationConsumer {
        public boolean accept(int var1, int var2, Collection<SimError> var3);
    }

    private record VariationRestoreState(Map<EgressAgent, OccLocation> occLocations, Map<EgressAgent, Long> profileSeeds, Map<EgressAgent, Long> orientSeeds, Map<EgressAgent, OccProfile> profiles, Map<OccSourceObj, Long> occSourceSeeds) {
        public VariationRestoreState() {
            this(new LinkedIdentityHashMap<EgressAgent, OccLocation>(), new LinkedIdentityHashMap<EgressAgent, Long>(), new LinkedIdentityHashMap<EgressAgent, Long>(), new LinkedIdentityHashMap<EgressAgent, OccProfile>(), new LinkedIdentityHashMap<OccSourceObj, Long>());
        }
    }
}

