/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.awt.Component;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JOptionPane;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.MerlinOp;
import merlin.actions.UIHook;
import merlin.data.MerlinData;
import merlin.data.scenario.Scenario;
import merlin.data.scenario.ScenarioUtil;
import merlin.data.scenario.SimOutputDir;
import merlin.gui.guiUtil;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.Nullable;

public class MonteCarloResults
extends AMerlinOp {
    public static final UIHook UI_HOOK_COMPLETION_TIMES = new UIHook((MerlinOp)new MonteCarloResults("_montecarlo_completion_times.html"), Intl.intl("Show Monte Carlo Completion &Times...,-,Show Monte Carlo Completion Times..."), null);
    public static final UIHook UI_HOOK_TRAVEL_DISTANCES = new UIHook((MerlinOp)new MonteCarloResults("_montecarlo_travel_distances.html"), Intl.intl("Show Monte Carlo Travel &Distances...,-,Show Monte Carlo Travel Distances..."), null);
    private final String d_expectedFileSuffix;

    public MonteCarloResults(String expectedFilename) {
        this.d_expectedFileSuffix = expectedFilename;
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        ArrayList<Scenario> scenarios = new ArrayList<Scenario>(md.scenarios.flatten(Scenario.class));
        scenarios.sort(ScenarioUtil.SCENARIO_SORTER);
        Optional<Nullable<Scenario>> chosen = this.promptScenarioOrAll(app.getMainFrame(), scenarios, md.scenarios.getActive());
        if (chosen.isEmpty()) {
            return;
        }
        File file = this.getFile(app, md, (Scenario)chosen.get().val);
        if (file != null) {
            try {
                Desktop.getDesktop().open(file);
            }
            catch (Throwable e) {
                guiUtil.showError(app, Intl.intl("Monte Carlo Results Error"), Intl.intl("Could not show Monte Carlo results."), e);
            }
        }
    }

    private File getFile(MerlinApp app, MerlinData md, Scenario scenario) {
        try {
            if (md.filename != null) {
                int numScenarios = md.scenarios.flatten(Scenario.class).size();
                SimOutputDir outDir = scenario == null ? ScenarioUtil.getOutputDir(md.filename, "", 1, 0, 1) : ScenarioUtil.getOutputDir(md.filename, scenario.getName(), numScenarios, 0, 1);
                File file = outDir.current.getFilePath(Path.of(this.d_expectedFileSuffix, new String[0])).toFile();
                if (!file.exists()) {
                    String msg = Intl.intl("Unable to locate file. Have you run the simulation?");
                    JOptionPane.showMessageDialog(app.getMainFrame(), msg);
                    return null;
                }
                return file;
            }
        }
        catch (IOException | InvalidPathException e) {
            guiUtil.showError(app, Intl.intl("File Error"), Intl.intl("Failed to resolve output directory."), (Throwable)e);
        }
        return null;
    }

    private Optional<Nullable<Scenario>> promptScenarioOrAll(Component parent, Collection<Scenario> scenarios, Scenario defScenario) {
        if (scenarios.isEmpty()) {
            return Optional.empty();
        }
        if (!scenarios.contains(defScenario)) {
            defScenario = scenarios.iterator().next();
        }
        if (scenarios.size() == 1) {
            return Optional.of(Nullable.of(defScenario));
        }
        ArrayList<Scenario> options = new ArrayList<Scenario>(scenarios.size() + 1);
        options.add(null);
        options.addAll(scenarios);
        final guiComboBox<Object> scenarioChooser = new guiComboBox<Object>((Collection<Object>)options);
        scenarioChooser.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof Scenario) {
                    Scenario s = (Scenario)value;
                    guiUtil.decorateComboRenderer(MerlinApp.getAppData(), scenarioChooser, list, value, this, isSelected, cellHasFocus, true);
                    this.setText(s.getName());
                    scenarioChooser.setFont(this.getFont());
                } else {
                    this.setText(Intl.intl("<All Scenarios>"));
                    scenarioChooser.setFont(this.getFont().deriveFont(0));
                }
                return this;
            }
        });
        scenarioChooser.setSelectedItem(defScenario);
        guiPanel msgPanel = new guiPanel();
        GridBagHelper gb = new GridBagHelper(msgPanel);
        gb.addRow(Intl.intl("Show results for scenario:"));
        gb.addFilledRow(scenarioChooser);
        gb.finalizeRows();
        int choice = JOptionPane.showConfirmDialog(parent, msgPanel, Intl.intl("Select Scenario"), 2, 3);
        if (choice != 0) {
            return Optional.empty();
        }
        return Optional.of(Nullable.of((Scenario)scenarioChooser.getSelectedItem()));
    }
}

