/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AboutAction;
import merlin.actions.AddBGImage;
import merlin.actions.AddBackgroundQuad;
import merlin.actions.AddOccTargetsFromOccs;
import merlin.actions.AddOccsFromOccTargets;
import merlin.actions.AddOccupantSourceAction;
import merlin.actions.AddOccupants;
import merlin.actions.AlignBlockageNormalAction;
import merlin.actions.Behemoth;
import merlin.actions.CaptureCamera;
import merlin.actions.ChangeGroupAction;
import merlin.actions.CheckForUpdatesAction;
import merlin.actions.ClearSelection;
import merlin.actions.CloseGapsAction;
import merlin.actions.ConvertToAttractorTemplate;
import merlin.actions.ConvertToBlockage;
import merlin.actions.CreateElevator;
import merlin.actions.CreateGroupsAction;
import merlin.actions.CreateSingleGroupAction;
import merlin.actions.Delete;
import merlin.actions.EditMonteCarlo;
import merlin.actions.EditObjects;
import merlin.actions.EditPreferences;
import merlin.actions.EditProps;
import merlin.actions.EditSimParams;
import merlin.actions.EnableAction;
import merlin.actions.FilterVisible;
import merlin.actions.FindAction;
import merlin.actions.Hide;
import merlin.actions.IgnoreImportedGeom;
import merlin.actions.License;
import merlin.actions.MakeDoorsOneway;
import merlin.actions.ManageMaterials;
import merlin.actions.MergeImportedGeomAction;
import merlin.actions.MonteCarloResults;
import merlin.actions.New;
import merlin.actions.NewAttractorTemplateObject;
import merlin.actions.NewBehavior;
import merlin.actions.NewFloor;
import merlin.actions.NewGroup;
import merlin.actions.NewObject;
import merlin.actions.NewQueueObject;
import merlin.actions.NewSeeds;
import merlin.actions.NewViewFromCamera;
import merlin.actions.Open;
import merlin.actions.OrientOnAction;
import merlin.actions.PrioritizeOccTargetOnDist;
import merlin.actions.RandomizeOccPositions;
import merlin.actions.RandomizeOrientAction;
import merlin.actions.ReducePopulation;
import merlin.actions.RemoveImportedUVAction;
import merlin.actions.RenameAction;
import merlin.actions.ResumeInferno;
import merlin.actions.RunInferno;
import merlin.actions.Save;
import merlin.actions.SaveAs;
import merlin.actions.SaveOutputLogAction;
import merlin.actions.Screenshot;
import merlin.actions.SelectByColor;
import merlin.actions.SelectByMaterial;
import merlin.actions.SelectConflictingComps;
import merlin.actions.SelectConnectedComps;
import merlin.actions.SelectConnectedObjs;
import merlin.actions.SelectCustomOccs;
import merlin.actions.SelectInvalidObjs;
import merlin.actions.SelectNonGroupDescendants;
import merlin.actions.SelectReferencing;
import merlin.actions.SelectSubitems;
import merlin.actions.SetActiveFloor;
import merlin.actions.SetZAction;
import merlin.actions.Show;
import merlin.actions.ShowAll;
import merlin.actions.ShowAllFloors;
import merlin.actions.ShowFile;
import merlin.actions.ShowOverridingScenarios;
import merlin.actions.ShowReferencingObjects;
import merlin.actions.ShowTaggedObjects;
import merlin.actions.ShowView;
import merlin.actions.SortAlphaAction;
import merlin.actions.SortByFloor;
import merlin.actions.TimeHistoryPlots;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.actions.WriteMesh;
import merlin.actions.WriteScenarios;
import merlin.actions.WriteViews;
import merlin.actions.WriteVis;
import merlin.actions.copypaste.Copy;
import merlin.actions.copypaste.Paste;
import merlin.actions.floorextract.GenerateModelFromBIM;
import merlin.actions.geomops.CleanupRooms;
import merlin.actions.geomops.MergeGeom;
import merlin.actions.geomops.SeparateGeom;
import merlin.actions.importgeom.Import;
import merlin.builders.ToolNames;
import merlin.gui.guiUtil;
import merlin.mv.ModelView;
import thunderheadeng.gui.dialogs.CustomKeyAcceleratorDlg;
import thunderheadeng.gui.tool.Tool;
import thunderheadeng.gui.tool.ToolManager;
import thunderheadeng.io.KeyboardAcceleratorIO;
import thunderheadeng.util.Pair;

public class MerlinActionMap {
    private static MerlinActionMap INSTANCE;
    private static final Map<String, Shortcut> s_idToShortcutMap;
    private static final Map<Shortcut, String> s_viewActionNameMap;
    private static final List<Shortcut> s_fileSCs;
    private static final List<Shortcut> s_editSCs;
    private static final List<Shortcut> s_modelSCs;
    private static final List<Shortcut> s_viewSCs;
    private static final List<Shortcut> s_simSCs;
    private static final List<Shortcut> s_resultsSCs;
    private static final List<Shortcut> s_helpSCs;
    private static final List<Shortcut> s_selectionSCs;
    private static final List<Shortcut> s_contextSCs;
    private static final List<Shortcut> s_toolSCs;
    private final ModelView modelView;
    private final Map<Shortcut, KeyStroke> shortcutToKeystrokeMap = new HashMap<Shortcut, KeyStroke>();
    private final Map<Shortcut, Collection<UIHook>> shortcutToUIHookMap = new LinkedHashMap<Shortcut, Collection<UIHook>>();
    private final Map<Shortcut, String> shortcutToNameOverride = new HashMap<Shortcut, String>();
    private final Map<Shortcut, ToolManager.ToolProps> shortcutToToolbarProps = new HashMap<Shortcut, ToolManager.ToolProps>();
    private final Map<Shortcut, Tool> shortcutToToolBuilderAction = new HashMap<Shortcut, Tool>();
    private JComponent viewToolbar;

    private MerlinActionMap() {
        MerlinApp app = MerlinApp.getApp();
        this.modelView = app.getModelView();
        this.initShortcutToMerlinOpsMap(app);
        this.initShortcutToToolPropsMap(app);
    }

    private void initShortcutToMerlinOpsMap(MerlinApp app) {
        BiConsumer<Shortcut, UIHook> addToMap = (s, mo) -> this.shortcutToUIHookMap.computeIfAbsent((Shortcut)((Object)s), i -> new ArrayList()).add(mo);
        BiConsumer<Shortcut, UIHook> addToMapCacheName = (s, mo) -> {
            this.shortcutToUIHookMap.computeIfAbsent((Shortcut)((Object)s), i -> new ArrayList()).add(mo);
            this.shortcutToNameOverride.put((Shortcut)((Object)s), mo.getValue("Name").toString());
        };
        addToMap.accept(Shortcut.NEW, New.UI_HOOK);
        addToMap.accept(Shortcut.OPEN, Open.UI_HOOK);
        addToMap.accept(Shortcut.SAVE, Save.UI_HOOK);
        addToMap.accept(Shortcut.SAVE_AS, SaveAs.UI_HOOK);
        addToMap.accept(Shortcut.SAVE_OUTPUT_LOG, SaveOutputLogAction.UI_HOOK);
        addToMap.accept(Shortcut.IMPORT, Import.UI_HOOK);
        addToMap.accept(Shortcut.SCREENSHOT, Screenshot.UI_HOOK);
        addToMap.accept(Shortcut.WRITE_SCENARIOS, WriteScenarios.UI_HOOK);
        addToMap.accept(Shortcut.WRITE_MESH, WriteMesh.UI_HOOK);
        addToMap.accept(Shortcut.WRITE_VIEWS, WriteViews.UI_HOOK);
        addToMap.accept(Shortcut.WRITE_VIS, WriteVis.UI_HOOK);
        addToMap.accept(Shortcut.DELETE, Delete.UI_HOOK);
        addToMap.accept(Shortcut.HIDE, Hide.UI_HOOK);
        addToMap.accept(Shortcut.SHOW, Show.UI_HOOK);
        addToMap.accept(Shortcut.SHOW_ALL, ShowAll.UI_HOOK);
        addToMap.accept(Shortcut.FILTER, FilterVisible.UI_HOOK);
        addToMap.accept(Shortcut.SHOW_ALL_FLOORS, ShowAllFloors.UI_HOOK);
        addToMap.accept(Shortcut.SORT_BY_FLOOR, SortByFloor.UI_HOOK);
        addToMap.accept(Shortcut.SORT_ALPHA, SortAlphaAction.UI_HOOK);
        addToMap.accept(Shortcut.IGNORE_IMPORTED_GEOM, IgnoreImportedGeom.UI_HOOK);
        addToMap.accept(Shortcut.ENABLE, EnableAction.UI_ENABLE_HOOK);
        addToMap.accept(Shortcut.DISABLE, EnableAction.UI_DISABLE_HOOK);
        addToMap.accept(Shortcut.CAPTURE_CAMERA, CaptureCamera.CONTEXT_HOOK);
        addToMap.accept(Shortcut.NEW_VIEW_FROM_CAM, NewViewFromCamera.MENU_HOOK);
        addToMap.accept(Shortcut.NEW_VIEW_FROM_CAMERA_CONTEXT, NewViewFromCamera.CONTEXT_HOOK);
        addToMap.accept(Shortcut.SHOW_VIEW, ShowView.CONTEXT_HOOK);
        addToMapCacheName.accept(Shortcut.UNDO, Undo.UI_HOOK_UNDO);
        addToMapCacheName.accept(Shortcut.REDO, Undo.UI_HOOK_REDO);
        addToMapCacheName.accept(Shortcut.UNDO_EDIT, Undo.UI_HOOK_UNDO_MAJOR);
        addToMapCacheName.accept(Shortcut.REDO_EDIT, Undo.UI_HOOK_REDO_MAJOR);
        addToMap.accept(Shortcut.COPY, Copy.UI_HOOK);
        addToMap.accept(Shortcut.PASTE, Paste.UI_HOOK);
        addToMap.accept(Shortcut.CLEAR_SELECTION, ClearSelection.UI_HOOK);
        ModelView mv = app.getModelView();
        this.viewToolbar = mv.getViewsToolbar();
        addToMap.accept(Shortcut.RESET_VIEW, mv.getResetViewOp());
        addToMap.accept(Shortcut.FILL_VIEW, mv.getFillViewOp());
        addToMap.accept(Shortcut.RESET_TO_SELECTION, mv.getResetViewToSelOp());
        addToMap.accept(Shortcut.CHANGE_GROUP, ChangeGroupAction.UI_HOOK);
        addToMap.accept(Shortcut.FIND, FindAction.UI_HOOK);
        addToMap.accept(Shortcut.RENAME, RenameAction.UI_HOOK);
        addToMap.accept(Shortcut.ABOUT_DLG, AboutAction.UI_HOOK);
        addToMap.accept(Shortcut.LICENSE, License.UI_HOOK);
        addToMap.accept(Shortcut.CHECK_UPDATES, CheckForUpdatesAction.UI_HOOK);
        addToMap.accept(Shortcut.BEHEMOTH, Behemoth.UI_HOOK);
        addToMap.accept(Shortcut.RUN_INFERNO, RunInferno.UI_HOOK_RUN);
        addToMap.accept(Shortcut.DEBUG_INFERNO, RunInferno.UI_HOOK_DEBUG);
        addToMap.accept(Shortcut.RESUME_INFERNO, ResumeInferno.UI_HOOK);
        addToMap.accept(Shortcut.DOOR_FLOW_PLOTS, TimeHistoryPlots.UI_HOOK_DOOR_FLOW);
        addToMap.accept(Shortcut.ROOM_USAGE_PLOTS, TimeHistoryPlots.UI_HOOK_ROOM_USAGE);
        addToMap.accept(Shortcut.MONTE_CARLO_COMPLETION_TIME, MonteCarloResults.UI_HOOK_COMPLETION_TIMES);
        addToMap.accept(Shortcut.MONTE_CARLO_TRAVEL_DISTANCE, MonteCarloResults.UI_HOOK_TRAVEL_DISTANCES);
        addToMap.accept(Shortcut.SHOW_SUMMARY_FILE, ShowFile.SHOW_SUMMARY_HOOK);
        addToMap.accept(Shortcut.ADD_OCCS, AddOccupants.UI_HOOK);
        addToMap.accept(Shortcut.ADD_OCCUPANT_SOURCE, AddOccupantSourceAction.UI_HOOK);
        addToMap.accept(Shortcut.CREATE_OCCUPANT_GROUP, CreateGroupsAction.UI_HOOK);
        addToMap.accept(Shortcut.CREATE_SINGLE_OCCUPANT_GROUP, CreateSingleGroupAction.UI_HOOK);
        addToMap.accept(Shortcut.REMOVE_IMPORTED_TEX_UV, RemoveImportedUVAction.UI_HOOK);
        addToMap.accept(Shortcut.SELECT_BY_COLOR, SelectByColor.UI_HOOK);
        addToMap.accept(Shortcut.SELECT_BY_MATERIAL, SelectByMaterial.UI_HOOK);
        addToMap.accept(Shortcut.SELECT_CONFLICTS, SelectConflictingComps.UI_HOOK);
        addToMap.accept(Shortcut.SELECT_CONNS, SelectConnectedComps.UI_HOOK);
        addToMap.accept(Shortcut.SELECT_CUSTOM_OCCUPANTS, SelectCustomOccs.UI_HOOK);
        addToMap.accept(Shortcut.SELECT_INVALID_OBJECTS, SelectInvalidObjs.CRITICAL_HOOK);
        addToMap.accept(Shortcut.SELECT_INVALID_OBJECTS_MODERATE, SelectInvalidObjs.MODERATE_HOOK);
        addToMap.accept(Shortcut.SELECT_OCCS, SelectConnectedObjs.ROOM_OCCS);
        addToMap.accept(Shortcut.SELECT_OCC_TARGETS, SelectConnectedObjs.ROOM_TARGETS);
        addToMap.accept(Shortcut.SELECT_ROOM_BLOCKAGES, SelectConnectedObjs.ROOM_BLOCKAGES);
        addToMap.accept(Shortcut.SELECT_BLOCKAGE_ROOMS, SelectConnectedObjs.BLOCKAGE_ROOMS);
        addToMap.accept(Shortcut.SELECT_REFERENCING, SelectReferencing.UI_HOOK);
        addToMap.accept(Shortcut.SELECT_SUBITEMS, SelectSubitems.UI_HOOK);
        addToMap.accept(Shortcut.SELECT_NON_GROUP_DESCENDANTS, SelectNonGroupDescendants.UI_HOOK);
        addToMap.accept(Shortcut.SHOW_REFERENCING_OBJECTS, ShowReferencingObjects.UI_HOOK);
        addToMap.accept(Shortcut.SHOW_OVERRIDING_SCENARIOS, ShowOverridingScenarios.UI_HOOK);
        addToMap.accept(Shortcut.SHOW_TAGGED_OBJECTS, ShowTaggedObjects.UI_HOOK);
        addToMap.accept(Shortcut.CREATE_ELEVATOR, CreateElevator.UI_HOOK);
        addToMap.accept(Shortcut.SET_ONEWAY_DOORS, MakeDoorsOneway.UI_HOOK);
        addToMap.accept(Shortcut.SET_ACTIVE_FLOOR, SetActiveFloor.UI_HOOK);
        addToMap.accept(Shortcut.SET_Z, SetZAction.UI_HOOK);
        addToMap.accept(Shortcut.ALIGN_BLOCKAGE_NORMAL, AlignBlockageNormalAction.UI_HOOK);
        addToMap.accept(Shortcut.EDIT_SNAP_GRID, mv.getSnapGridOp());
        addToMap.accept(Shortcut.ORIENT_OCCS, OrientOnAction.UI_HOOK);
        addToMap.accept(Shortcut.PRIORITIZE_ON_DIST, PrioritizeOccTargetOnDist.UI_HOOK);
        addToMap.accept(Shortcut.RANDOMIZE_ORIENT, RandomizeOrientAction.UI_HOOK);
        addToMap.accept(Shortcut.MERGE_IMPORTED_GEOM, MergeImportedGeomAction.UI_HOOK);
        addToMap.accept(Shortcut.CONVERT_TO_BLOCKAGE, ConvertToBlockage.UI_HOOK);
        addToMap.accept(Shortcut.ADD_OCCTARGETS_FROM_OCCS, AddOccTargetsFromOccs.UI_HOOK);
        addToMap.accept(Shortcut.ADD_OCCS_FROM_OCCTARGETS, AddOccsFromOccTargets.UI_HOOK);
        addToMap.accept(Shortcut.RANDOMIZE_OCC_POSITIONS, RandomizeOccPositions.UI_HOOK);
        addToMap.accept(Shortcut.REDUCE_POPULATION, ReducePopulation.UI_HOOK);
        addToMap.accept(Shortcut.SEPARATE_ROOMS, SeparateGeom.UI_HOOK);
        addToMap.accept(Shortcut.CLOSE_GAPS, CloseGapsAction.UI_HOOK);
        addToMap.accept(Shortcut.MERGE_ROOMS, MergeGeom.UI_HOOK);
        addToMap.accept(Shortcut.REMOVE_VERTS, CleanupRooms.UI_HOOK);
        addToMap.accept(Shortcut.NEW_AGENT_SEEDS, NewSeeds.UI_HOOK);
        addToMap.accept(Shortcut.NEW_BEHAVIOR, NewBehavior.MENU_HOOK);
        addToMap.accept(Shortcut.NEW_BEHAVIOR_CONTEXT, NewBehavior.CONTEXT_HOOK);
        addToMap.accept(Shortcut.NEW_QUEUE, NewQueueObject.MENU_HOOK);
        addToMap.accept(Shortcut.NEW_QUEUE_CONTEXT, NewQueueObject.CONTEXT_HOOK);
        addToMap.accept(Shortcut.NEW_ATTRACTOR_TEMPLATE, NewAttractorTemplateObject.MENU_HOOK);
        addToMap.accept(Shortcut.NEW_ATTRACTOR_TEMPLATE_CONTEXT, NewAttractorTemplateObject.CONTEXT_HOOK);
        addToMap.accept(Shortcut.CONVERT_TO_ATTRACTOR_TEMPLATE_CONTEXT, ConvertToAttractorTemplate.CONTEXT_HOOK);
        addToMap.accept(Shortcut.NEW_FLOOR, NewFloor.UI_HOOK);
        addToMap.accept(Shortcut.NEW_GROUP, NewGroup.MENU_HOOK);
        addToMap.accept(Shortcut.NEW_GROUP_CONTEXT, NewGroup.CONTEXT_HOOK);
        addToMap.accept(Shortcut.NEW_PROFILE, NewObject.UI_HOOK_PROFILE);
        addToMap.accept(Shortcut.NEW_VEHICLE_SHAPE, NewObject.UI_HOOK_VEHICLE_SHAPE);
        addToMap.accept(Shortcut.NEW_ASSIST_TEAM, NewObject.UI_HOOK_ASSISTED_EVAC_TEAM);
        addToMap.accept(Shortcut.NEW_OCC_GROUP_TYPE, NewObject.UI_HOOK_OCCGROUP_TYPE);
        addToMap.accept(Shortcut.EDIT_PREFERENCES, EditPreferences.UI_HOOK);
        addToMap.accept(Shortcut.EDIT_PROPS, EditProps.UI_HOOK);
        addToMap.accept(Shortcut.EDIT_SIM_PARAMS, EditSimParams.UI_HOOK);
        addToMap.accept(Shortcut.EDIT_MONTE_CARLO, EditMonteCarlo.UI_HOOK);
        addToMap.accept(Shortcut.EDIT_OCC_PROFILES, EditObjects.UI_HOOK_PROFILE);
        addToMap.accept(Shortcut.EDIT_VEHICLE_SHAPES, EditObjects.UI_HOOK_VEHICLE_SHAPE);
        addToMap.accept(Shortcut.EDIT_ASSIST_TEAMS, EditObjects.UI_HOOK_ASSISTED_EVAC_TEAM);
        addToMap.accept(Shortcut.EDIT_OCC_GROUP_TYPES, EditObjects.UI_HOOK_OCC_GROUP_TYPES);
        addToMap.accept(Shortcut.EDIT_OCC_PROFILE_LIBS, EditObjects.UI_HOOK_LIBRARIES);
        addToMap.accept(Shortcut.EDIT_MATERIALS, ManageMaterials.UI_HOOK);
        addToMap.accept(Shortcut.EDIT_ANIMATIONS, EditObjects.UI_HOOK_ANIMATIONS);
        addToMap.accept(Shortcut.EDIT_SCENARIOS, EditObjects.UI_HOOK_SCENARIOS);
        addToMap.accept(Shortcut.BIM_EXTRACTION, GenerateModelFromBIM.UI_HOOK_GLOBAL);
        addToMap.accept(Shortcut.BIM_EXTRACTION_CONTEXT, GenerateModelFromBIM.UI_HOOK_CONTEXT);
        addToMap.accept(Shortcut.ADD_BACKGROUND_QUAD, AddBackgroundQuad.UI_HOOK);
        addToMap.accept(Shortcut.ADD_BACKGROUND_IMAGE, AddBGImage.UI_HOOK);
        addToMap.accept(Shortcut.ADD_QUEUE_SERVICE, mv.getQueueServiceHook());
        addToMap.accept(Shortcut.ADD_QUEUE_PATH, mv.getQueuePathHook());
        addToMap.accept(Shortcut.ADD_QUEUE_PATH_NODE, mv.getQueueNodeHook());
    }

    private void initShortcutToToolPropsMap(MerlinApp app) {
        ToolManager tm = app.getModelView().getTools();
        for (Tool t : tm.getTools()) {
            ToolManager.ToolProps tp = tm.getProps(t);
            String toolName = tp.action.getName();
            Shortcut sc = null;
            if (toolName.equals(ToolNames.MOVE)) {
                sc = Shortcut.MOVE_MANIP_TOOL;
            }
            if (toolName.equals(ToolNames.ROTATE)) {
                sc = Shortcut.ROTATE_MANIP_TOOL;
            }
            if (toolName.equals(ToolNames.MIRROR)) {
                sc = Shortcut.MIRROR_MANIP_TOOL;
            }
            if (toolName.equals(ToolNames.PERSPECTIVE_VIEW)) {
                sc = Shortcut.PERSPECTIVE_VIEW;
            }
            if (toolName.equals(ToolNames.TOP_VIEW)) {
                sc = Shortcut.TOP_VIEW;
            }
            if (toolName.equals(ToolNames.FRONT_VIEW)) {
                sc = Shortcut.FRONT_VIEW;
            }
            if (toolName.equals(ToolNames.LEFT_VIEW)) {
                sc = Shortcut.LEFT_VIEW;
            }
            if (toolName.equals(ToolNames.SELECT)) {
                sc = Shortcut.SELECT_TOOL;
            }
            if (toolName.equals(ToolNames.ORBIT)) {
                sc = Shortcut.ORBIT_TOOL;
            }
            if (toolName.equals(ToolNames.ROAM)) {
                sc = Shortcut.ROAM_TOOL;
            }
            if (toolName.equals(ToolNames.PAN)) {
                sc = Shortcut.PAN_TOOL;
            }
            if (toolName.equals(ToolNames.ZOOM)) {
                sc = Shortcut.ZOOM_TOOL;
            }
            if (toolName.equals(ToolNames.ZOOM_BOX)) {
                sc = Shortcut.ZOOM_BOX_TOOL;
            }
            if (toolName.equals(ToolNames.NEW_POLY_ROOM)) {
                sc = Shortcut.POLY_ROOM_TOOL;
            }
            if (toolName.equals(ToolNames.ADD_BLOCKAGE)) {
                sc = Shortcut.ADD_BLOCKAGE_TOOL;
            }
            if (toolName.equals(ToolNames.NEW_RECT_ROOM)) {
                sc = Shortcut.RECT_ROOM_TOOL;
            }
            if (toolName.equals(ToolNames.ADD_THIN_WALL)) {
                sc = Shortcut.THIN_WALL_TOOL;
            }
            if (toolName.equals(ToolNames.ADD_THICK_WALL)) {
                sc = Shortcut.THICK_WALL_TOOL;
            }
            if (toolName.equals(ToolNames.NEW_TWO_CLICK_STAIR)) {
                sc = Shortcut.TWO_STAIR_TOOL;
            }
            if (toolName.equals(ToolNames.NEW_ONE_CLICK_STAIR)) {
                sc = Shortcut.ONE_STAIR_TOOL;
            }
            if (toolName.equals(ToolNames.NEW_TWO_CLICK_RAMP)) {
                sc = Shortcut.TWO_RAMP_TOOL;
            }
            if (toolName.equals(ToolNames.NEW_ONE_CLICK_RAMP)) {
                sc = Shortcut.ONE_RAMP_TOOL;
            }
            if (toolName.equals(ToolNames.DRAW_DOOR)) {
                sc = Shortcut.DRAW_DOOR_TOOL;
            }
            if (toolName.equals(ToolNames.DRAW_OCCUPANT)) {
                sc = Shortcut.DRAW_OCC_TOOL;
            }
            if (toolName.equals(ToolNames.DRAW_OCCUPANT_GROUP)) {
                sc = Shortcut.DRAW_OCC_GROUP_TOOL;
            }
            if (toolName.equals(ToolNames.DRAW_MEASURE_REGION)) {
                sc = Shortcut.MEASURE_REGION_TOOL;
            }
            if (toolName.equals(ToolNames.ADD_ATTRACTOR)) {
                sc = Shortcut.ATTRACTOR_TOOL;
            }
            if (toolName.equals(ToolNames.ADD_SINGLE_OCC_LOC)) {
                sc = Shortcut.SINGLE_OCC_TARGET_TOOL;
            }
            if (toolName.equals(ToolNames.DRAW_OCCUPANT_SOURCE)) {
                sc = Shortcut.OCC_SOURCE_TOOL;
            }
            if (toolName.equals(ToolNames.EXTRACT_ROOM)) {
                sc = Shortcut.ROOM_EXTRACTION_TOOL;
            }
            if (toolName.equals(ToolNames.MEASURE)) {
                sc = Shortcut.MEASUREMENT_TOOL;
            }
            if (sc == null) continue;
            this.shortcutToToolbarProps.put(sc, tp);
        }
    }

    public static MerlinActionMap getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MerlinActionMap();
        }
        return INSTANCE;
    }

    public void resetActionMap() {
        this.updateActionMap(Collections.emptyMap());
    }

    public void updateActionMap(Map<String, KeyStroke> newKeyStrokeValues) {
        HashMap<String, String> defaultsToAdd = new HashMap<String, String>();
        for (Shortcut shortcut : s_idToShortcutMap.values()) {
            if (newKeyStrokeValues.containsKey(shortcut.key)) continue;
            defaultsToAdd.put(shortcut.key, shortcut.defaultShortcut);
        }
        this.shortcutToKeystrokeMap.clear();
        for (Map.Entry entry : defaultsToAdd.entrySet()) {
            KeyStroke ks = KeyStroke.getKeyStroke((String)entry.getValue());
            Shortcut s = s_idToShortcutMap.get(entry.getKey());
            this.shortcutToKeystrokeMap.put(s, ks);
        }
        for (Map.Entry entry : newKeyStrokeValues.entrySet()) {
            Shortcut s = s_idToShortcutMap.get(entry.getKey());
            this.shortcutToKeystrokeMap.put(s, (KeyStroke)entry.getValue());
        }
        this.updateActions();
    }

    private void updateActions() {
        for (Map.Entry<Shortcut, Collection<UIHook>> entry : this.shortcutToUIHookMap.entrySet()) {
            for (UIHook hook : entry.getValue()) {
                KeyStroke ks = this.shortcutToKeystrokeMap.get((Object)entry.getKey());
                hook.setKeyStroke(ks);
            }
        }
        for (Map.Entry<Shortcut, Object> entry : this.shortcutToToolbarProps.entrySet()) {
            KeyStroke ks = this.shortcutToKeystrokeMap.get((Object)entry.getKey());
            ToolManager.ToolProps tp = (ToolManager.ToolProps)entry.getValue();
            guiUtil.keyboardShortcutUpdate(tp.toolbarBtn, ks, tp.action.getTool());
        }
        BiConsumer<Shortcut, String> imUpdater = (sc, name) -> {
            KeyStroke ks = this.shortcutToKeystrokeMap.get(sc);
            guiUtil.keyboardShortcutUpdate(this.viewToolbar, ks, name);
        };
        imUpdater.accept(Shortcut.PERSPECTIVE_VIEW, ToolNames.PERSPECTIVE_VIEW);
        imUpdater.accept(Shortcut.TOP_VIEW, ToolNames.TOP_VIEW);
        imUpdater.accept(Shortcut.FRONT_VIEW, ToolNames.FRONT_VIEW);
        imUpdater.accept(Shortcut.LEFT_VIEW, ToolNames.LEFT_VIEW);
        for (Map.Entry<Shortcut, Tool> scToMVBuilderKV : this.shortcutToToolBuilderAction.entrySet()) {
            KeyStroke ks = this.shortcutToKeystrokeMap.get((Object)scToMVBuilderKV.getKey());
            Tool t = scToMVBuilderKV.getValue();
            this.modelView.getTools().getToolAction(t).addAccelerator(ks);
        }
    }

    public KeyStroke getKeyStrokeForActionKey(String key) {
        Shortcut sc = s_idToShortcutMap.get(key);
        return this.shortcutToKeystrokeMap.get((Object)sc);
    }

    public KeyStroke getDefaultKeyStrokeForActionKey(String key) {
        Shortcut sc = s_idToShortcutMap.get(key);
        return KeyStroke.getKeyStroke(sc.defaultShortcut);
    }

    private String getActionNameForShortcut(Shortcut sc) {
        if (this.shortcutToNameOverride.containsKey((Object)sc)) {
            return this.shortcutToNameOverride.get((Object)sc);
        }
        if (this.shortcutToUIHookMap.containsKey((Object)sc)) {
            Set actionNames = this.shortcutToUIHookMap.get((Object)sc).stream().map(hook -> (String)hook.getValue("Name")).collect(Collectors.toSet());
            assert (actionNames.size() == 1);
            return actionNames.isEmpty() ? "" : (String)actionNames.iterator().next();
        }
        if (this.shortcutToToolbarProps.containsKey((Object)sc)) {
            return this.shortcutToToolbarProps.get((Object)((Object)sc)).action.getName();
        }
        if (s_viewActionNameMap.containsKey((Object)sc)) {
            return s_viewActionNameMap.get((Object)sc);
        }
        if (this.shortcutToToolBuilderAction.containsKey((Object)sc)) {
            Tool t = this.shortcutToToolBuilderAction.get((Object)sc);
            return (String)this.modelView.getTools().getToolAction(t).getValue("Name");
        }
        assert (false) : sc.key + " isn't in the map!";
        return "";
    }

    private String getActionNameForActionKey(String key) {
        Shortcut sc = s_idToShortcutMap.get(key);
        return this.getActionNameForShortcut(sc);
    }

    private String getTooltipForActionKey(String key) {
        Shortcut sc = s_idToShortcutMap.get(key);
        Action action = null;
        if (this.shortcutToToolbarProps.get((Object)sc) != null) {
            action = this.shortcutToToolbarProps.get((Object)((Object)sc)).action;
        } else if (this.shortcutToUIHookMap.get((Object)sc) != null) {
            action = this.shortcutToUIHookMap.get((Object)sc).iterator().next();
        }
        if (action != null) {
            String longDesc = (String)action.getValue("LongDescription");
            if (longDesc != null && !longDesc.isEmpty()) {
                return longDesc;
            }
            return (String)action.getValue("ShortDescription");
        }
        return null;
    }

    private static String getLabelForShortcutType(ShortcutType type) {
        switch (type.ordinal()) {
            case 0: {
                return Intl.intl("File");
            }
            case 1: {
                return Intl.intl("Edit");
            }
            case 2: {
                return Intl.intl("Model");
            }
            case 3: {
                return Intl.intl("View");
            }
            case 4: {
                return Intl.intl("Simulation");
            }
            case 5: {
                return Intl.intl("Results");
            }
            case 6: {
                return Intl.intl("Help");
            }
            case 7: {
                return Intl.intl("Selection");
            }
            case 8: {
                return Intl.intl("Context");
            }
            case 9: {
                return Intl.intl("Tool");
            }
        }
        return Intl.intl("General");
    }

    private static List<String> getActionKeysForShortcutType(ShortcutType type) {
        Collection<Shortcut> scs = MerlinActionMap.getShortcutsForShortcutType(type);
        ArrayList<String> actionKeys = new ArrayList<String>();
        for (Shortcut sc : scs) {
            actionKeys.add(sc.key);
        }
        return actionKeys;
    }

    private static Collection<Shortcut> getShortcutsForShortcutType(ShortcutType type) {
        switch (type.ordinal()) {
            case 7: {
                return Collections.unmodifiableList(s_selectionSCs);
            }
            case 8: {
                return Collections.unmodifiableList(s_contextSCs);
            }
            case 9: {
                return Collections.unmodifiableList(s_toolSCs);
            }
            case 0: {
                return Collections.unmodifiableList(s_fileSCs);
            }
            case 1: {
                return Collections.unmodifiableList(s_editSCs);
            }
            case 2: {
                return Collections.unmodifiableList(s_modelSCs);
            }
            case 3: {
                return Collections.unmodifiableList(s_viewSCs);
            }
            case 4: {
                return Collections.unmodifiableList(s_simSCs);
            }
            case 5: {
                return Collections.unmodifiableList(s_resultsSCs);
            }
            case 6: {
                return Collections.unmodifiableList(s_helpSCs);
            }
        }
        assert (false);
        return Collections.emptyList();
    }

    static {
        s_idToShortcutMap = new HashMap<String, Shortcut>();
        Stream.of(Shortcut.values()).forEach(shortcut -> s_idToShortcutMap.put(shortcut.key, (Shortcut)((Object)shortcut)));
        s_viewActionNameMap = new HashMap<Shortcut, String>();
        s_viewActionNameMap.put(Shortcut.PERSPECTIVE_VIEW, ToolNames.PERSPECTIVE_VIEW);
        s_viewActionNameMap.put(Shortcut.TOP_VIEW, ToolNames.TOP_VIEW);
        s_viewActionNameMap.put(Shortcut.FRONT_VIEW, ToolNames.FRONT_VIEW);
        s_viewActionNameMap.put(Shortcut.LEFT_VIEW, ToolNames.LEFT_VIEW);
        s_fileSCs = new ArrayList<Shortcut>();
        s_editSCs = new ArrayList<Shortcut>();
        s_modelSCs = new ArrayList<Shortcut>();
        s_viewSCs = new ArrayList<Shortcut>();
        s_simSCs = new ArrayList<Shortcut>();
        s_resultsSCs = new ArrayList<Shortcut>();
        s_helpSCs = new ArrayList<Shortcut>();
        s_selectionSCs = new ArrayList<Shortcut>();
        s_contextSCs = new ArrayList<Shortcut>();
        s_toolSCs = new ArrayList<Shortcut>();
        block12: for (Shortcut sc : Shortcut.values()) {
            s_idToShortcutMap.put(sc.key, sc);
            switch (sc.category.ordinal()) {
                case 7: {
                    s_selectionSCs.add(sc);
                    continue block12;
                }
                case 8: {
                    s_contextSCs.add(sc);
                    continue block12;
                }
                case 9: {
                    s_toolSCs.add(sc);
                    continue block12;
                }
                case 0: {
                    s_fileSCs.add(sc);
                    continue block12;
                }
                case 1: {
                    s_editSCs.add(sc);
                    continue block12;
                }
                case 2: {
                    s_modelSCs.add(sc);
                    continue block12;
                }
                case 3: {
                    s_viewSCs.add(sc);
                    continue block12;
                }
                case 4: {
                    s_simSCs.add(sc);
                    continue block12;
                }
                case 5: {
                    s_resultsSCs.add(sc);
                    continue block12;
                }
                case 6: {
                    s_helpSCs.add(sc);
                    continue block12;
                }
                default: {
                    assert (false) : "invalid category";
                    continue block12;
                }
            }
        }
    }

    public static enum Shortcut {
        NEW("new", "ctrl N", ShortcutType.FILE),
        OPEN("open", "ctrl O", ShortcutType.FILE),
        SAVE("save", "ctrl S", ShortcutType.FILE),
        SAVE_AS("saveAs", ShortcutType.FILE),
        EDIT_PREFERENCES("editPreferences", ShortcutType.FILE),
        SCREENSHOT("screenshot", ShortcutType.FILE),
        IMPORT("import", ShortcutType.FILE),
        WRITE_MESH("writeMesh", ShortcutType.FILE),
        WRITE_SCENARIOS("writeScenarios", ShortcutType.FILE),
        WRITE_VIEWS("writeViews", ShortcutType.FILE),
        WRITE_VIS("writeVis", ShortcutType.FILE),
        UNDO("undo", "ctrl Z", ShortcutType.EDIT),
        REDO("redo", "ctrl Y", ShortcutType.EDIT),
        UNDO_EDIT("undoEdit", "ctrl shift Z", ShortcutType.EDIT),
        REDO_EDIT("redoEdit", "ctrl shift Y", ShortcutType.EDIT),
        COPY("copy", "ctrl C", ShortcutType.EDIT),
        PASTE("paste", "ctrl V", ShortcutType.EDIT),
        DELETE("delete", "DELETE", ShortcutType.EDIT),
        CLEAR_SELECTION("clearSelection", "ESCAPE", ShortcutType.EDIT),
        FIND("find", "ctrl F", ShortcutType.EDIT),
        HIDE("hide", "alt shift H", ShortcutType.EDIT),
        SHOW("show", "alt shift S", ShortcutType.EDIT),
        SHOW_ALL("showAll", "alt shift A", ShortcutType.EDIT),
        FILTER("filter", "alt shift F", ShortcutType.EDIT),
        NEW_GROUP("newGroup", ShortcutType.MODEL),
        EDIT_OCC_PROFILE_LIBS("editOccProfLibs", ShortcutType.MODEL),
        EDIT_MATERIALS("editMaterials", ShortcutType.MODEL),
        EDIT_ANIMATIONS("editAnimations", ShortcutType.MODEL),
        EDIT_SCENARIOS("editScenarios", ShortcutType.MODEL),
        BIM_EXTRACTION("extractFromBim", ShortcutType.MODEL),
        ADD_BACKGROUND_IMAGE("addBackgroundImage", ShortcutType.MODEL),
        EDIT_OCC_PROFILES("editOccProfiles", ShortcutType.MODEL),
        EDIT_VEHICLE_SHAPES("editVehicleShapes", ShortcutType.MODEL),
        EDIT_ASSIST_TEAMS("editAssistTeams", ShortcutType.MODEL),
        NEW_BEHAVIOR("newBehavior", ShortcutType.MODEL),
        ADD_OCCS("addOccupants", ShortcutType.MODEL),
        EDIT_OCC_GROUP_TYPES("editOccGroupTypes", ShortcutType.MODEL),
        CREATE_ELEVATOR("createElevator", ShortcutType.MODEL),
        NEW_VIEW_FROM_CAM("newViewFromCamera", ShortcutType.MODEL),
        MERGE_ROOMS("mergeRooms", "ctrl M", ShortcutType.MODEL),
        SEPARATE_ROOMS("separateRooms", "ctrl P", ShortcutType.MODEL),
        ADD_OCCUPANT_SOURCE("addOccupantSource", ShortcutType.MODEL),
        NEW_FLOOR("newFloor", ShortcutType.MODEL),
        NEW_QUEUE("addQueue", ShortcutType.MODEL),
        NEW_ATTRACTOR_TEMPLATE("addAttractorTemplate", ShortcutType.MODEL),
        RESET_VIEW("resetView", "ctrl R", ShortcutType.VIEW),
        FILL_VIEW("fillSelection", ShortcutType.VIEW),
        RESET_TO_SELECTION("resetToSelection", "ctrl E", ShortcutType.VIEW),
        PERSPECTIVE_VIEW("perspectiveView", "1", ShortcutType.VIEW),
        TOP_VIEW("topView", "2", ShortcutType.VIEW),
        FRONT_VIEW("frontView", "3", ShortcutType.VIEW),
        LEFT_VIEW("leftView", "4", ShortcutType.VIEW),
        SHOW_VIEW("showView", ShortcutType.VIEW),
        SHOW_ALL_FLOORS("showAllFloors", ShortcutType.VIEW),
        EDIT_SNAP_GRID("editSnapGrid", ShortcutType.VIEW),
        EDIT_SIM_PARAMS("editSimParams", ShortcutType.SIMULATION),
        EDIT_MONTE_CARLO("editMonteCarlo", ShortcutType.SIMULATION),
        RUN_INFERNO("runInferno", ShortcutType.SIMULATION),
        DEBUG_INFERNO("debugInferno", ShortcutType.SIMULATION),
        RESUME_INFERNO("resumeInferno", ShortcutType.SIMULATION),
        BEHEMOTH("behemoth", ShortcutType.RESULTS),
        DOOR_FLOW_PLOTS("doorTimeHistoryPlots", ShortcutType.RESULTS),
        ROOM_USAGE_PLOTS("roomTimeHistoryPlots", ShortcutType.RESULTS),
        MONTE_CARLO_COMPLETION_TIME("monteCarloCompletionTime", ShortcutType.RESULTS),
        MONTE_CARLO_TRAVEL_DISTANCE("monteCarloTravelDistance", ShortcutType.RESULTS),
        SHOW_SUMMARY_FILE("showSummary", ShortcutType.RESULTS),
        SAVE_OUTPUT_LOG("saveOutputLog", ShortcutType.HELP),
        ABOUT_DLG("about", ShortcutType.HELP),
        CHECK_UPDATES("checkForUpdates", ShortcutType.HELP),
        LICENSE("license", ShortcutType.HELP),
        EDIT_PROPS("editProps", ShortcutType.CONTEXT),
        NEW_GROUP_CONTEXT("newGroup_context", ShortcutType.CONTEXT),
        CHANGE_GROUP("changeGroupNode", ShortcutType.CONTEXT),
        BIM_EXTRACTION_CONTEXT("extractFromBimContext", ShortcutType.CONTEXT),
        NEW_BEHAVIOR_CONTEXT("newBehavior_context", ShortcutType.CONTEXT),
        NEW_QUEUE_CONTEXT("newQueue_context", ShortcutType.CONTEXT),
        NEW_ATTRACTOR_TEMPLATE_CONTEXT("newAttractorTemplate_context", ShortcutType.CONTEXT),
        CONVERT_TO_ATTRACTOR_TEMPLATE_CONTEXT("convertToAttractorTemplate_context", ShortcutType.CONTEXT),
        CAPTURE_CAMERA("captureCamera", ShortcutType.CONTEXT),
        ENABLE("enable", ShortcutType.CONTEXT),
        DISABLE("disable", ShortcutType.CONTEXT),
        RENAME("rename", ShortcutType.CONTEXT),
        IGNORE_IMPORTED_GEOM("ignoreImportedGeom", ShortcutType.CONTEXT),
        CLOSE_GAPS("closeGaps", ShortcutType.CONTEXT),
        REMOVE_VERTS("removeExtraVerts", ShortcutType.CONTEXT),
        ADD_BACKGROUND_QUAD("addBackgroundQuad", ShortcutType.CONTEXT),
        NEW_AGENT_SEEDS("newAgentSeeds", ShortcutType.CONTEXT),
        SORT_BY_FLOOR("sortByFloor", ShortcutType.CONTEXT),
        SORT_ALPHA("sortAlpha", ShortcutType.CONTEXT),
        SET_ONEWAY_DOORS("setOneWayDoors", ShortcutType.CONTEXT),
        SET_ACTIVE_FLOOR("setActiveFloor", ShortcutType.CONTEXT),
        SET_Z("setZ", ShortcutType.CONTEXT),
        ALIGN_BLOCKAGE_NORMAL("alignBlockageNormal", ShortcutType.CONTEXT),
        ORIENT_OCCS("orientOccs", ShortcutType.CONTEXT),
        PRIORITIZE_ON_DIST("prioritizeOnDist", ShortcutType.CONTEXT),
        RANDOMIZE_ORIENT("randomizeOrient", ShortcutType.CONTEXT),
        MERGE_IMPORTED_GEOM("mergeImportedGeom", ShortcutType.CONTEXT),
        CONVERT_TO_BLOCKAGE("convertToBlockage", ShortcutType.CONTEXT),
        ADD_OCCTARGETS_FROM_OCCS("addOccTargetsFromOcc", ShortcutType.CONTEXT),
        ADD_OCCS_FROM_OCCTARGETS("addOccsFromOccTargets", ShortcutType.CONTEXT),
        RANDOMIZE_OCC_POSITIONS("randomizeOccPos", ShortcutType.CONTEXT),
        REDUCE_POPULATION("reducePopulation", ShortcutType.CONTEXT),
        NEW_VIEW_FROM_CAMERA_CONTEXT("newViewFromCamera_context", ShortcutType.CONTEXT),
        NEW_PROFILE("newProfile", ShortcutType.CONTEXT),
        NEW_VEHICLE_SHAPE("newVehicleShape", ShortcutType.CONTEXT),
        NEW_ASSIST_TEAM("newAssistTeam", ShortcutType.CONTEXT),
        CREATE_OCCUPANT_GROUP("createOccupantGroup", ShortcutType.CONTEXT),
        CREATE_SINGLE_OCCUPANT_GROUP("createSingleOccupantGroup", ShortcutType.CONTEXT),
        NEW_OCC_GROUP_TYPE("newOccupantGroupType", ShortcutType.CONTEXT),
        REMOVE_IMPORTED_TEX_UV("removeImportedTexUV", ShortcutType.CONTEXT),
        ADD_QUEUE_PATH("addQueuePath", ShortcutType.CONTEXT),
        ADD_QUEUE_PATH_NODE("addQueuePathNode", ShortcutType.CONTEXT),
        ADD_QUEUE_SERVICE("addQueueService", ShortcutType.CONTEXT),
        MOVE_MANIP_TOOL("moveTool", ShortcutType.TOOL),
        ROTATE_MANIP_TOOL("rotateTool", ShortcutType.TOOL),
        MIRROR_MANIP_TOOL("mirrorTool", ShortcutType.TOOL),
        SELECT_TOOL("selectionTool", ShortcutType.TOOL),
        ORBIT_TOOL("orbitTool", ShortcutType.TOOL),
        ROAM_TOOL("roamTool", ShortcutType.TOOL),
        PAN_TOOL("panTool", ShortcutType.TOOL),
        ZOOM_TOOL("zoomTool", ShortcutType.TOOL),
        ZOOM_BOX_TOOL("zoomBoxTool", ShortcutType.TOOL),
        POLY_ROOM_TOOL("polyRoomTool", ShortcutType.TOOL),
        RECT_ROOM_TOOL("rectRoomTool", ShortcutType.TOOL),
        THIN_WALL_TOOL("thinWallTool", ShortcutType.TOOL),
        THICK_WALL_TOOL("thickWallTool", ShortcutType.TOOL),
        ADD_BLOCKAGE_TOOL("addBlockageTool", ShortcutType.TOOL),
        ONE_STAIR_TOOL("oneStepStairTool", ShortcutType.TOOL),
        TWO_STAIR_TOOL("twoStepStairTool", ShortcutType.TOOL),
        ONE_RAMP_TOOL("oneStepRampTool", ShortcutType.TOOL),
        TWO_RAMP_TOOL("twoStepRampTool", ShortcutType.TOOL),
        DRAW_DOOR_TOOL("drawDoorTool", ShortcutType.TOOL),
        DRAW_OCC_TOOL("drawOccupantTool", ShortcutType.TOOL),
        DRAW_OCC_GROUP_TOOL("drawOccupantGroupTool", ShortcutType.TOOL),
        MEASURE_REGION_TOOL("measurementRegionTool", ShortcutType.TOOL),
        ATTRACTOR_TOOL("attractorTool", ShortcutType.TOOL),
        SINGLE_OCC_TARGET_TOOL("occTargetTool", ShortcutType.TOOL),
        OCC_SOURCE_TOOL("occupantSourceTool", ShortcutType.TOOL),
        ROOM_EXTRACTION_TOOL("roomExtractionTool", ShortcutType.TOOL),
        MEASUREMENT_TOOL("measurementTool", ShortcutType.TOOL),
        SELECT_BY_COLOR("selectByColor", ShortcutType.SELECTION),
        SELECT_BY_MATERIAL("selectByMaterial", ShortcutType.SELECTION),
        SELECT_CONFLICTS("selectConflicts", ShortcutType.SELECTION),
        SELECT_CONNS("selectConnectedComponents", ShortcutType.SELECTION),
        SELECT_CUSTOM_OCCUPANTS("selectCustomOccupants", ShortcutType.SELECTION),
        SELECT_INVALID_OBJECTS("selectInvalidObjects", ShortcutType.SELECTION),
        SELECT_INVALID_OBJECTS_MODERATE("selectWarningObjs", ShortcutType.SELECTION),
        SELECT_OCCS("selectOccupants", ShortcutType.SELECTION),
        SELECT_OCC_TARGETS("selectOccTargets", ShortcutType.SELECTION),
        SELECT_ROOM_BLOCKAGES("selectRoomBlockages", ShortcutType.SELECTION),
        SELECT_BLOCKAGE_ROOMS("selectBlockageRooms", ShortcutType.SELECTION),
        SELECT_REFERENCING("selectReferencing", ShortcutType.SELECTION),
        SELECT_SUBITEMS("selectSubitems", ShortcutType.SELECTION),
        SELECT_NON_GROUP_DESCENDANTS("selectNonGroupDescendants", ShortcutType.SELECTION),
        SHOW_REFERENCING_OBJECTS("showReferencingObjects", ShortcutType.SELECTION),
        SHOW_TAGGED_OBJECTS("showTaggedObjects", ShortcutType.SELECTION),
        SHOW_OVERRIDING_SCENARIOS("showOverridingScenarios", ShortcutType.SELECTION);

        public final String key;
        public final String defaultShortcut;
        public final ShortcutType category;

        private Shortcut(String key, ShortcutType category) {
            this(key, "", category);
        }

        private Shortcut(String key, String defaultShortcut, ShortcutType category) {
            this.key = key;
            this.defaultShortcut = defaultShortcut;
            this.category = category;
        }
    }

    private static enum ShortcutType {
        FILE,
        EDIT,
        MODEL,
        VIEW,
        SIMULATION,
        RESULTS,
        HELP,
        SELECTION,
        CONTEXT,
        TOOL;

    }

    public static class MerlinCustomUIHelper
    implements CustomKeyAcceleratorDlg.ICustomKeyUIHelper {
        @Override
        public KeyStroke getKeyStrokeForID(String id) {
            return MerlinActionMap.getInstance().getKeyStrokeForActionKey(id);
        }

        @Override
        public KeyStroke getDefaultKeyStrokeForID(String id) {
            return MerlinActionMap.getInstance().getDefaultKeyStrokeForActionKey(id);
        }

        @Override
        public String getActionNameForID(String id) {
            return MerlinActionMap.getInstance().getActionNameForActionKey(id);
        }

        @Override
        public String getTooltipForID(String id) {
            return MerlinActionMap.getInstance().getTooltipForActionKey(id);
        }

        @Override
        public void saveToActionMap(Map<String, KeyStroke> keystrokes) {
            MerlinActionMap.getInstance().updateActionMap(keystrokes);
        }

        @Override
        public Collection<Pair<String, Collection<String>>> getTabStrings() {
            ArrayList<Pair<String, Collection<String>>> tabList = new ArrayList<Pair<String, Collection<String>>>();
            for (ShortcutType type : ShortcutType.values()) {
                String labelForType = MerlinActionMap.getLabelForShortcutType(type);
                List<String> actionKeys = type.equals((Object)ShortcutType.TOOL) || type.equals((Object)ShortcutType.SELECTION) || type.equals((Object)ShortcutType.CONTEXT) ? this.getSortedActionKeys(type) : MerlinActionMap.getActionKeysForShortcutType(type);
                tabList.add(new Pair<String, List<String>>(labelForType, actionKeys));
            }
            return tabList;
        }

        private List<String> getSortedActionKeys(ShortcutType type) {
            Collection<Shortcut> scs = MerlinActionMap.getShortcutsForShortcutType(type);
            HashMap<String, String> idToNameMap = new HashMap<String, String>();
            for (Shortcut sc : scs) {
                idToNameMap.put(sc.key, this.getActionNameForID(sc.key));
            }
            ArrayList asList = new ArrayList(idToNameMap.entrySet());
            asList.sort(Map.Entry.comparingByValue());
            ArrayList<String> sortedVals = new ArrayList<String>();
            for (Map.Entry entry : asList) {
                sortedVals.add((String)entry.getKey());
            }
            return sortedVals;
        }
    }

    public static class MerlinKeyboardAcceleratorIOHelper
    implements KeyboardAcceleratorIO.IKeyboardAcceleratorHelper {
        private final MerlinApp d_merApp;

        public MerlinKeyboardAcceleratorIOHelper(MerlinApp app) {
            this.d_merApp = app;
        }

        @Override
        public String getDefaultFileLocation() {
            return this.d_merApp.getAppDataDir() + "keybindings.json";
        }

        @Override
        public void updateActionMap(Map<String, KeyStroke> newKeyStrokeValues) {
            MerlinActionMap.getInstance().updateActionMap(newKeyStrokeValues);
        }

        @Override
        public Collection<String> getSortedActionList() {
            return Arrays.stream(Shortcut.values()).map(sc -> sc.key).sorted().collect(Collectors.toList());
        }

        @Override
        public KeyStroke getKeyStrokeForActionKey(String key) {
            return MerlinActionMap.getInstance().getKeyStrokeForActionKey(key);
        }
    }
}

