/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.JOptionPane;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.MerlinData;
import merlin.data.egress.geom.EgressCorridor;
import merlin.data.egress.geom.EgressDoor;
import merlin.data.egress.geom.EgressDoorDir;
import merlin.data.egress.geom.EgressRoom;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.geom.IEgressConnector;
import merlin.data.egress.geom.IEgressOccupiable;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.theUtil;

public class MakeDoorsOneway
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new MakeDoorsOneway(), Intl.intl("Make Doors One-way..."));
    private OptionsDlg d_dlg;

    public MakeDoorsOneway() {
        SelectionObserver.add(this, EgressRoom.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        Set rooms = MerlinApp.getApp().getData().selection.getSelected(EgressRoom.class);
        this.setEnabled(!rooms.isEmpty());
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        boolean showOverwrite;
        Set<EgressRoom> rooms = md.selection.getSelected(EgressRoom.class);
        LinkedIdentityHashSet<IEgressComp> shared = new LinkedIdentityHashSet<IEgressComp>();
        LinkedIdentityHashSet<IEgressComp> nonShared = new LinkedIdentityHashSet<IEgressComp>();
        MakeDoorsOneway.getPotentialOnewayComponents(rooms, nonShared, shared);
        if (nonShared.isEmpty()) {
            String msg = Intl.intl("There are no doors/stairs that can be made one-way with the current selection.");
            String title = Intl.intl("Cannot Make One-way");
            JOptionPane.showMessageDialog(app.getActiveFrame(), msg, title, 2);
            return;
        }
        IFilteredCollection<IEgressComp> onewayComps = theUtil.filter(nonShared, new OnewayFilter());
        boolean bl = showOverwrite = !onewayComps.isEmpty();
        if (this.d_dlg == null) {
            this.d_dlg = new OptionsDlg((Window)app.getMainFrame());
        }
        this.d_dlg.setOnewayVisible(showOverwrite);
        if (this.d_dlg.doModal() != 1) {
            return;
        }
        if (!this.d_dlg.getOverwrite()) {
            nonShared.removeAll(new ArrayList<IEgressComp>(onewayComps));
        }
        Map<IEgressComp, EgressDoorDir> toMakeOneway = MakeDoorsOneway.calcDirections(rooms, nonShared, this.d_dlg.getEnter());
        try (MerlinData.WriteLock lock = md.lockWrite();){
            Undo.begin(Intl.intl("Make Doors One-way"));
            Undo.insertUndoEntry_propRestore(md, toMakeOneway.keySet(), IEgressConnector.TRAVEL_DIR);
            for (Map.Entry<IEgressComp, EgressDoorDir> entry : toMakeOneway.entrySet()) {
                entry.getKey().setProperty(IEgressConnector.TRAVEL_DIR, entry.getValue());
            }
            Undo.end(md);
        }
    }

    private static void getPotentialOnewayComponents(Set<EgressRoom> rooms, Set<IEgressComp> nonShared, Set<IEgressComp> shared) {
        for (EgressRoom room : rooms) {
            MakeDoorsOneway.classifyConnections(rooms, room.getDoors(), nonShared, shared);
            MakeDoorsOneway.classifyConnections(rooms, room.getCorridors(), nonShared, shared);
        }
    }

    private static void classifyConnections(Set<EgressRoom> rooms, Collection<? extends IEgressComp> comps, Set<IEgressComp> nonShared, Set<IEgressComp> shared) {
        for (IEgressComp iEgressComp : comps) {
            IEgressOccupiable room2;
            IEgressOccupiable room1;
            if (iEgressComp instanceof EgressDoor && ((EgressDoor)iEgressComp).isExit() || nonShared.contains(iEgressComp) || shared.contains(iEgressComp)) continue;
            if (iEgressComp instanceof EgressDoor) {
                EgressDoor door = (EgressDoor)iEgressComp;
                room1 = door.getRoom1();
                room2 = door.getRoom2();
            } else {
                if (!(iEgressComp instanceof EgressCorridor)) continue;
                EgressCorridor corr = (EgressCorridor)iEgressComp;
                room1 = corr.getDoor1().getRoom();
                room2 = corr.getDoor2().getRoom();
            }
            if (rooms.contains(room1) && rooms.contains(room2)) {
                shared.add(iEgressComp);
                continue;
            }
            nonShared.add(iEgressComp);
        }
    }

    private static Map<IEgressComp, EgressDoorDir> calcDirections(Set<EgressRoom> rooms, Collection<IEgressComp> objs, boolean into) {
        LinkedIdentityHashMap<IEgressComp, EgressDoorDir> result = new LinkedIdentityHashMap<IEgressComp, EgressDoorDir>();
        for (IEgressComp comp : objs) {
            LineSeg edge = null;
            if (comp instanceof EgressDoor) {
                EgressDoor door = (EgressDoor)comp;
                edge = rooms.contains(door.getRoom1()) ? MakeDoorsOneway.convert(door.getEdge1()) : MakeDoorsOneway.convert(door.getEdge2());
            } else if (comp instanceof EgressCorridor) {
                EgressCorridor corr = (EgressCorridor)comp;
                edge = rooms.contains(corr.getDoor1().getRoom()) ? corr.getDoor1().getEdge() : corr.getDoor2().getEdge();
            }
            if (edge == null) continue;
            result.put(comp, EgressDoorDir.toDir(edge, into));
        }
        return result;
    }

    private static LineSeg convert(LineSeg3D seg) {
        return new LineSeg(seg.p1, seg.p2);
    }

    private static class OnewayFilter
    implements Predicate<IEgressComp> {
        private OnewayFilter() {
        }

        @Override
        public boolean test(IEgressComp o) {
            Object travelDir = o.getProperty(IEgressConnector.TRAVEL_DIR);
            return travelDir instanceof EgressDoorDir && (EgressDoorDir)((Object)travelDir) != EgressDoorDir.ALL;
        }
    }

    private static class OptionsDlg
    extends guiDialog {
        private static final long serialVersionUID = 9013033535555899384L;
        private final guiRadioButton d_exitRB = new guiRadioButton(Intl.intl("Exit only"));
        private final guiRadioButton d_enterRB;
        private final guiCheckBox d_overwriteExistingOnewayCB;

        public OptionsDlg(Window parent) {
            super(parent, Intl.intl("Make Doors One-way"), 9);
            this.d_exitRB.setToolTipText(Intl.intl("Occupants will only be able to exit the selected rooms."));
            this.d_enterRB = new guiRadioButton(Intl.intl("Enter only"));
            this.d_enterRB.setToolTipText(Intl.intl("Occupants will only be able to enter the selected rooms."));
            new guiButtonGroup(this.d_exitRB, this.d_enterRB);
            this.d_overwriteExistingOnewayCB = new guiCheckBox(Intl.intl("Overwrite existing one-way directions."));
            this.d_overwriteExistingOnewayCB.setToolTipText(Intl.intl("If selected, doors that are already have one-way markings will be overwritten."));
            GridBagHelper gb = new GridBagHelper(this.getDialogPane());
            gb.addRow(new TitleSeparator(Intl.intl("Direction:")), 0, 1.0);
            gb.indent();
            gb.addRow(this.d_exitRB, 0);
            gb.addRow(this.d_enterRB, 0);
            gb.unindent();
            gb.addRow(this.d_overwriteExistingOnewayCB);
            gb.finalizeRows();
            this.d_exitRB.setSelected(true);
        }

        public void setOnewayVisible(boolean vis) {
            this.d_overwriteExistingOnewayCB.setVisible(vis);
            this.pack();
        }

        public boolean getEnter() {
            return this.d_enterRB.isSelected();
        }

        public boolean getOverwrite() {
            return this.d_overwriteExistingOnewayCB.isSelected();
        }
    }
}

