/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.Set;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.Undo;
import merlin.data.ImportedGeom;
import merlin.data.MerlinData;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;

public class ImportedGeomOpts
extends AMerlinOp
implements IEventObserver {
    private final String d_name;
    private final int d_options;
    private final boolean d_state;

    public ImportedGeomOpts(String name, boolean state, int options) {
        this.d_name = name;
        this.d_options = options;
        this.d_state = state;
        SelectionObserver.add(this, ImportedGeom.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        this.setEnabled(!MerlinApp.getApp().getData().selection.isDeepEmpty(ImportedGeom.class));
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        try (MerlinData.WriteLock lock = md.lockWrite();){
            Undo.begin(this.d_name);
            Set objs = md.selection.getDeepSelected(ImportedGeom.class);
            Undo.insertUndoEntry_propRestore(md, objs, ImportedGeom.PROP_OPTIONS);
            for (ImportedGeom ig : objs) {
                ig.setOptions(this.d_state, this.d_options);
            }
            Undo.end(md);
        }
    }
}

