/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.Set;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.ImportType;
import merlin.data.ImportedGeom;
import merlin.data.MerlinData;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;

public class IgnoreImportedGeom
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new IgnoreImportedGeom(), Intl.intl("Exclude from room extraction"));

    public IgnoreImportedGeom() {
        SelectionObserver.add(this, ImportedGeom.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        this.setEnabled(!MerlinApp.getApp().getData().selection.isDeepEmpty(ImportedGeom.class));
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        try (MerlinData.WriteLock lock = md.lockWrite();){
            Undo.begin(Intl.intl("Exclude from room extraction"));
            Set objs = md.selection.getDeepSelected(ImportedGeom.class);
            Undo.insertUndoEntry_propRestore(md, objs, ImportedGeom.PROP_IMPORTED_TYPE);
            for (ImportedGeom ig : objs) {
                ig.setImportedType(ImportType.IGNORED);
            }
            Undo.end(md);
        }
    }
}

