/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.UIHook;
import merlin.data.Composite;
import merlin.data.JsonObj;
import merlin.data.MerlinData;
import merlin.gui.JsonDlg;
import merlin.gui.ManagerDlg;
import thunderheadeng.util.Predicates;

public class EditJsonObjs
extends AMerlinOp {
    public static final UIHook UI_HOOK = new UIHook(new EditJsonObjs(), Intl.intl("Edit &Json Objects..."));

    @Override
    public void run(MerlinApp app, MerlinData md) {
        EditJsonObjs.edit(app, md, null);
    }

    public static void edit(MerlinApp app, MerlinData md, JsonObj init) {
        CompositeManager mgr = new CompositeManager(md, md.json);
        JsonDlg dlg = new JsonDlg(app.getMainFrame(), app.getUnitSystem());
        dlg.init(md, mgr, init);
        dlg.doModal();
    }

    public static class CompositeManager
    implements ManagerDlg.IManager<JsonObj> {
        private final MerlinData d_md;
        private Composite<? super JsonObj> d_objs;
        private Predicate<JsonObj> d_filter = Predicates.alwaysTrue();

        public CompositeManager(MerlinData md, Composite<? super JsonObj> objs) {
            this.d_md = md;
            this.d_objs = objs;
        }

        @Override
        public String describe(JsonObj oProf) {
            String name = oProf.getName();
            return name;
        }

        @Override
        public Collection<JsonObj> getSorted() {
            List<JsonObj> sorted = this.d_objs.getMembers().stream().map(obj -> (JsonObj)obj).filter(this.d_filter).collect(Collectors.toList());
            return sorted;
        }

        @Override
        public int size() {
            int size = (int)this.d_objs.getMembers().stream().map(obj -> (JsonObj)obj).filter(this.d_filter).count();
            return size;
        }

        @Override
        public void filter(Predicate<JsonObj> filter) {
            this.d_filter = filter;
        }
    }
}

