/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import merlin.EntryPoint;
import merlin.EntryPointFactory;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.MerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.builders.NewCompUtil;
import merlin.data.Composite;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.egress.elevators.Elevator;
import merlin.data.egress.elevators.ElevatorDoor;
import merlin.data.egress.elevators.ElevatorRoom;
import merlin.data.egress.geom.EgressDoor;
import merlin.data.egress.geom.EgressRoom;
import merlin.data.egress.geom.IEgressComp;
import merlin.gui.MerlinComboBox;
import merlin.gui.PathObjsList;
import merlin.util.MerlinUtil;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepCallback;
import thunderheadeng.dependencies.DepSnapshot;
import thunderheadeng.dependencies.Dependency;
import thunderheadeng.gui.dialogs.ShowObjectsDialog;
import thunderheadeng.gui.framework.Deletion;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class Delete
extends AMerlinOp
implements IEventObserver {
    public static final Icon ICON = UIHook.loadIcon("thunderheadeng/gui/graphics/Delete16.gif");
    public static final UIHook UI_HOOK = new UIHook((MerlinOp)new Delete(), Intl.intl("&Delete...,D,Delete selected objects"), ICON);

    public Delete() {
        SelectionObserver.add(this, Object.class);
        this.update(null);
    }

    private boolean canDelete(MerlinData md) {
        return Delete.testShouldEnable(md, !md.selection.isEmpty());
    }

    public static boolean testShouldEnable(MerlinData md, boolean anySelected) {
        return anySelected;
    }

    @Override
    public void update(Events events) {
        MerlinData md = MerlinApp.getApp().getData();
        this.setEnabled(this.canDelete(md));
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        Set explicitSelObjs;
        try (MerlinData.ReadLock lock = md.lockRead();){
            explicitSelObjs = md.selection.getSelected(IMerlinObj.class);
        }
        Delete.uiDelete(app, md, explicitSelObjs, true);
    }

    public static Deletion.DelStatus uiDelete(MerlinApp app, MerlinData md, Collection<? extends IMerlinObj> explicitSelObjs, boolean confirmDel) {
        Pair<Deletion.DelStatus, Runnable> result = Delete.startUiDelete(app, md, explicitSelObjs, confirmDel);
        if (result.v1 != Deletion.DelStatus.SUCCESS) {
            return (Deletion.DelStatus)((Object)result.v1);
        }
        ((Runnable)result.v2).run();
        return (Deletion.DelStatus)((Object)result.v1);
    }

    public static Pair<Deletion.DelStatus, Runnable> startUiDelete(MerlinApp app, MerlinData md, Collection<? extends IMerlinObj> explicitSelObjs, boolean confirmDel) {
        return Delete.helper(md).startUiDelete(app, explicitSelObjs, confirmDel);
    }

    private static Deletion<MerlinData, IMerlinObj> helper(MerlinData md) {
        return new Deletion<MerlinData, IMerlinObj>(new AppCallback(md));
    }

    public static Deletion.DelStatus headlessDelete(MerlinData md, Collection<? extends IMerlinObj> explicitSelObjs, boolean removeContainedObjs) {
        return Delete.helper(md).headlessDelete(md, explicitSelObjs, removeContainedObjs);
    }

    public static Deletion.DelStatus headlessDelete(MerlinData md, Collection<? extends IMerlinObj> explicitSelObjs, boolean removeContainedObjs, Consumer<? super IMerlinObj> failedDeletions) {
        return Delete.helper(md).headlessDelete(md, explicitSelObjs, removeContainedObjs, failedDeletions);
    }

    static {
        UI_HOOK.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0));
        UI_HOOK.putValue("AcceleratorKey1", KeyStroke.getKeyStroke(8, 0));
    }

    private static class AppCallback
    implements Deletion.IAppCallback<MerlinData, IMerlinObj> {
        private final MerlinData md;

        private AppCallback(MerlinData data) {
            this.md = data;
        }

        @Override
        public Predicate<? super IMerlinObj> getUiDependentObjFilter() {
            return obj -> EntryPointFactory.get(obj).canShowInReferencingLists(this.md, (IMerlinObj)obj);
        }

        @Override
        public MerlinData getDomain() {
            return this.md;
        }

        @Override
        public Class<IMerlinObj> getObjType() {
            return IMerlinObj.class;
        }

        @Override
        public DepSnapshot<MerlinData> takeDependencySnapshot() {
            return this.md.takeFullDependencySnapshot();
        }

        public Composite<? extends IMerlinObj> getRoot(IMerlinObj obj) {
            EntryPoint<IMerlinObj> ep = EntryPointFactory.get(obj);
            return ep.getRootComposite(this.md);
        }

        @Override
        public IMerlinObj getParent(Object obj) {
            return (IMerlinObj)this.md.hierarchy.getParent(obj);
        }

        @Override
        public Collection<? extends IMerlinObj> getChildren(IMerlinObj obj) {
            return theUtil.filter(this.md.hierarchy.getChildren(obj), IMerlinObj.class);
        }

        @Override
        public String getDisplayName(IMerlinObj obj) {
            return MerlinUtil.getName(obj);
        }

        @Override
        public String getCategoryName(IMerlinObj obj) {
            return EntryPointFactory.get(obj).getCategoryName(this.md, obj);
        }

        @Override
        public boolean isGroup(Object obj) {
            return obj instanceof Composite;
        }

        @Override
        public boolean isAutoDeleteGroup(IMerlinObj obj) {
            return EntryPointFactory.get(obj).isAutoDeleteGroup(this.md, obj);
        }

        @Override
        public int getNumChildren(Object obj) {
            return this.md.hierarchy.getNumChildren(obj);
        }

        @Override
        public Collection<? extends IMerlinObj> flatten(Collection<?> objs) {
            return MerlinUtil.flatten(objs, IMerlinObj.class);
        }

        @Override
        public <T> Collection<? extends T> flatten(Collection<?> objs, Class<T> type) {
            return MerlinUtil.flatten(objs, type);
        }

        @Override
        public boolean isDeletionUndoable(IMerlinObj obj) {
            return EntryPointFactory.get(obj).isDeleteUndoable(this.md, obj);
        }

        @Override
        public Exception getDeletionError(Object obj) {
            EntryPoint<Object> ep = EntryPointFactory.get(obj);
            return ep.getDeletionErr(this.md, obj);
        }

        @Override
        public <T> Class<? super T> getDomainRequiredType(T obj) {
            return EntryPointFactory.get(obj).getDomainRequiredType(this.md, obj);
        }

        @Override
        public void showObjects(Window parent, String title, Collection<? extends IMerlinObj> objs) {
            ShowObjectsDialog<IMerlinObj> showObjs = new ShowObjectsDialog<IMerlinObj>(parent, title, new PathObjsList(this.md, "", false, true, objs));
            showObjs.doModal();
        }

        @Override
        public <T extends IMerlinObj> guiComboBox<T> newComboBox(Class<?> type, List<T> objs, String nullName) {
            MerlinComboBox combo = new MerlinComboBox(this.md, type, data -> objs);
            combo.setNullName(nullName);
            return combo;
        }

        @Override
        public <T extends IMerlinObj> Comparator<T> getSorter(Collection<? extends T> objs) {
            return MerlinUtil.getSorter(this.md, objs);
        }

        @Override
        public Collection<? extends IMerlinObj> gatherAddObjs(Deletion.DelInfo<MerlinData, IMerlinObj> delInfo) throws CancelledException {
            Collection<Elevator> delElevators = MerlinUtil.flatten(delInfo.delObjs(), Elevator.class);
            if (!delElevators.isEmpty()) {
                int option = JOptionPane.showConfirmDialog(MerlinApp.getApp().getActiveFrame(), Intl.intl("Would you like to restore the rooms used to create the deleted elevators?"), Intl.intl("Restore Original Rooms?"), 1);
                if (option == 0) {
                    ArrayList<IEgressComp> addObjs = new ArrayList<IEgressComp>();
                    for (Elevator elevator : delElevators) {
                        this.convertElevatorDischargeComps(elevator, addObjs);
                    }
                    return addObjs;
                }
                if (option != 1) {
                    throw new CancelledException();
                }
            }
            return Collections.emptyList();
        }

        private void convertElevatorDischargeComps(Elevator elevator, List<IEgressComp> comps) {
            ElevatorRoom er = elevator.getDischargeRoom();
            comps.add(new EgressRoom(er.getName(), er.getModel(), 0));
            for (ElevatorDoor ed : er.getElevatorDoors()) {
                comps.add(new EgressDoor(ed.getName(), false, ed.getRoom1(), ed.getRoom2(), ed.getDoorGeom()));
            }
        }

        @Override
        public void performDelete(Collection<? extends IMerlinObj> restoreSel, Deletion.DelInfo<MerlinData, IMerlinObj> delInfo, Collection<? extends IMerlinObj> addObjs, boolean undoable) {
            try (MerlinData.WriteLock lock = this.md.lockWrite();){
                Undo.begin(Intl.intl("Delete"));
                if (!undoable) {
                    Undo.insertEntry_breakChain(this.md);
                }
                this.restoreSelection(restoreSel);
                this.delete(delInfo);
                IFilteredCollection<IEgressComp> egressComps = theUtil.filter(addObjs, IEgressComp.class);
                assert (egressComps.isExclusive());
                NewCompUtil.addEgressComps(this.md, true, egressComps);
                Undo.end(this.md);
            }
            if (this.md.agents.getDeepMembers().isEmpty()) {
                this.md.occNameGen.reset();
            }
        }

        @Override
        public void delete(Deletion.DelInfo<MerlinData, IMerlinObj> delInfo) {
            if (delInfo.delObjs().isEmpty()) {
                return;
            }
            Predicate<Object> isMarkedForDeletion = obj -> {
                Object o = obj;
                while (o != null) {
                    if (delInfo.delObjs().contains(o)) {
                        return true;
                    }
                    o = this.md.hierarchy.getParent(o);
                }
                return false;
            };
            record RestoreInfo(Object src, DepCallback callback, Object ref) {
            }
            LinkedHashSet<RestoreInfo> toRestore = new LinkedHashSet<RestoreInfo>();
            for (Map.Entry<IMerlinObj, IMerlinObj> entry : delInfo.replacements().entrySet()) {
                IMerlinObj refObj = entry.getKey();
                Set dependents = delInfo.deps().getDependents(refObj);
                for (Dependency dep : dependents) {
                    if (dep.callback == null || isMarkedForDeletion.test(dep.source) || !dep.supportsReplacement()) continue;
                    toRestore.add(new RestoreInfo(dep.source, dep.callback, refObj));
                }
            }
            toRestore.forEach(info -> info.callback.replDep().insertUndoEntry(this.md, info.src, info.ref));
            for (Map.Entry<IMerlinObj, IMerlinObj> entry : delInfo.replacements().entrySet()) {
                Set dependents = delInfo.deps().getDependents(entry.getKey());
                for (Dependency dep : dependents) {
                    if (dep.callback == null || isMarkedForDeletion.test(dep.source)) continue;
                    assert (dep.supportsReplacement() || dep.link() == DLink.CONTAINED_BY);
                    if (!dep.supportsReplacement()) continue;
                    dep.replaceDependency(this.md, entry.getKey(), entry.getValue());
                }
            }
            for (IMerlinObj obj2 : delInfo.delObjs()) {
                EntryPoint<IMerlinObj> ep = EntryPointFactory.get(obj2);
                if (ep == null) continue;
                if (ep.isIndexed(this.md, obj2)) {
                    Undo.insertUndoEntry_insert(this.md, obj2);
                } else {
                    Undo.insertUndoEntry_add(this.md, obj2);
                }
                ep.delete(this.md, obj2);
            }
        }

        private void restoreSelection(Collection<? extends IMerlinObj> objs) {
            Undo.insertUndoEntry_restoreSelection(this.md);
            this.md.selection.clear();
        }
    }
}

