/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.IntPredicate;
import javax.swing.JOptionPane;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.AddObject;
import merlin.actions.Delete;
import merlin.actions.MergeImportedGeomAction;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.ImportType;
import merlin.data.ImportedGeom;
import merlin.data.MerlinData;
import merlin.data.egress.blockages.EgressBlockage;
import merlin.data.egress.blockages.EgressBlockageComp;
import merlin.util.MerlinUtil;
import thunderheadeng.gui.framework.Deletion;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.Pair;

public class ConvertToBlockage
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new ConvertToBlockage(), Intl.intl("Convert to Transient Obstacle...,-,Converts the selected objects into Obstacles whose effect on occupants can change over time."));

    public ConvertToBlockage() {
        SelectionObserver.add(this, ImportedGeom.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        MerlinData md = MerlinApp.getApp().getData();
        IFilteredCollection<IMerlinObj> igeom = MergeImportedGeomAction.getObjs(md);
        this.setEnabled(!md.selection.flatten(ImportedGeom.class).isEmpty() && igeom.isExclusive());
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        boolean delete;
        int delChoice;
        Runnable delAction = () -> {};
        LinkedIdentityHashMap<EgressBlockageComp, Collection<ICompElement>> toAdd = new LinkedIdentityHashMap<EgressBlockageComp, Collection<ICompElement>>();
        IntPredicate testCancelled = choice -> choice != 0 && choice != 1;
        ArrayList<IMerlinObj> objs = new ArrayList<IMerlinObj>(MergeImportedGeomAction.getObjs(md));
        Collection<ImportedGeom> igeoms = MerlinUtil.flatten(objs, ImportedGeom.class);
        boolean merge = false;
        if (igeoms.size() > 1) {
            int mergeChoice = md.ui(() -> {
                int defOption = objs.size() == 1 ? 0 : 1;
                return guiUtil.showConfirmDialog(app.getActiveFrame(), "<html>" + Intl.intl("Would you like to merge the selected objects into a single obstacle?<br>Select <b>No</b> to create multiple obstacles."), Intl.intl("Merge into Single Obstacle?"), 1, defOption);
            });
            if (testCancelled.test(mergeChoice)) {
                return;
            }
            boolean bl = merge = mergeChoice == 0;
        }
        if (testCancelled.test(delChoice = md.ui(() -> JOptionPane.showConfirmDialog(app.getActiveFrame(), Intl.intl("Do you want to delete the source objects?"), Intl.intl("Delete Source Objects?"), 0, 3)).intValue())) {
            return;
        }
        boolean bl = delete = delChoice == 0;
        if (delete) {
            Pair<Deletion.DelStatus, Runnable> delResult = Delete.startUiDelete(app, md, objs, false);
            if (delResult.v1 != Deletion.DelStatus.SUCCESS) {
                return;
            }
            delAction = (Runnable)delResult.v2;
        }
        BiConsumer<EgressBlockageComp, ImportedGeom> addObstacle = (blkgParent, ig) -> {
            EgressBlockage blkg = new EgressBlockage(ig.getName());
            blkg.setProp(EgressBlockage.DISPLAY_TYPE, EgressBlockage.DisplayType.CAD_GEOM);
            blkg.setProp(EgressBlockage.LINK_CAD_GEOM_TO_SEARCH, true);
            blkg.setProp(EgressBlockage.CAD_GEOM, ig.getDisplayGeom());
            toAdd.computeIfAbsent((EgressBlockageComp)blkgParent, p -> new ArrayList()).add(blkg);
        };
        IdentityHashMap<Object, EgressBlockageComp> groupMap = new IdentityHashMap<Object, EgressBlockageComp>();
        if (merge) {
            ImportedGeom merged = MergeImportedGeomAction.merge(igeoms, MerlinUtil.getName((IMerlinObj)objs.iterator().next()), ImportType.OBSTRUCTION);
            Object commonParent = md.hierarchy.getCommonParent(objs);
            EgressBlockageComp blkgParent2 = commonParent != null && md.hierarchy.isDescendent(md.sceneGeom, commonParent) && commonParent != md.sceneGeom ? ConvertToBlockage.getMirroredGroup(md, groupMap, toAdd, commonParent) : md.blockages;
            addObstacle.accept(blkgParent2, merged);
        } else {
            for (ImportedGeom ig2 : igeoms) {
                Object parent = md.hierarchy.getParent(ig2);
                EgressBlockageComp blkgParent3 = parent != null ? ConvertToBlockage.getMirroredGroup(md, groupMap, toAdd, parent) : md.blockages;
                addObstacle.accept(blkgParent3, ig2);
            }
        }
        try (MerlinData.WriteLock lock = md.lockWrite();){
            Undo.begin(Intl.intl("Convert to Obstacles"));
            delAction.run();
            for (Map.Entry entry : toAdd.entrySet()) {
                AddObject.add(md, (Composite)entry.getKey(), (Collection)entry.getValue());
            }
            Undo.end(md);
        }
    }

    private static EgressBlockageComp getMirroredGroup(MerlinData md, Map<Object, EgressBlockageComp> groupMap, Map<EgressBlockageComp, Collection<ICompElement>> newGroups, Object igGroup) {
        if (igGroup == md.sceneGeom) {
            return md.blockages;
        }
        EgressBlockageComp group = groupMap.get(igGroup);
        if (group != null) {
            return group;
        }
        Optional<EgressBlockageComp> existingGroup = md.hierarchy.findExistingGroup(md, EgressBlockageComp.class, md.blockages, igGroup, md.sceneGeom);
        group = existingGroup.orElse(null);
        if (group != null) {
            groupMap.put(igGroup, group);
            return group;
        }
        group = new EgressBlockageComp(MerlinUtil.getName(igGroup));
        groupMap.put(igGroup, group);
        Object igParent = md.hierarchy.getParent(igGroup);
        EgressBlockageComp parent = ConvertToBlockage.getMirroredGroup(md, groupMap, newGroups, igParent);
        newGroups.computeIfAbsent(parent, p -> new ArrayList()).add(group);
        return group;
    }
}

