/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.ArrayDeque;
import java.util.Iterator;
import merlin.actions.Undo;

public class CompositeUndo
implements Undo.UndoOp {
    private ArrayDeque<Undo.UndoOp> d_undoStack = new ArrayDeque();
    private final String d_name;

    public CompositeUndo(String actionName) {
        this.d_name = actionName;
    }

    public String getName() {
        return this.d_name;
    }

    public int marker() {
        return this.d_undoStack.size();
    }

    public boolean isEmpty() {
        return this.d_undoStack.isEmpty();
    }

    public void clear() {
        this.d_undoStack.clear();
    }

    public void insertEntry(Undo.UndoOp op) {
        this.d_undoStack.push(op);
    }

    public void cancelEntry() {
        this.d_undoStack.pop();
    }

    public void complete() {
        this.d_undoStack = new ArrayDeque<Undo.UndoOp>(this.d_undoStack);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append("[");
        Iterator<Undo.UndoOp> it = this.d_undoStack.descendingIterator();
        while (it.hasNext()) {
            sb.append(it.next().toString());
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Undo.UndoOp perform() {
        CompositeUndo redo = new CompositeUndo(this.d_name);
        for (Undo.UndoOp op : this.d_undoStack) {
            redo.insertEntry(op.perform());
        }
        return redo;
    }

    @Override
    public boolean isMajor() {
        for (Undo.UndoOp op : this.d_undoStack) {
            if (!op.isMajor()) continue;
            return true;
        }
        return false;
    }

    public void cancel(int marker) {
        while (this.d_undoStack.size() > marker) {
            this.d_undoStack.pop().perform();
        }
    }
}

