/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import merlin.Intl;
import merlin.actions.Undo;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.theUtil;

public class CompElementActions {
    public static void setProperty(Object prop, Collection<? extends ICompElement> objs, Object newVal) {
        MerlinData md = Composite.getDomain(objs);
        new DefProp<Object>(prop).set(md, objs, newVal);
    }

    public static List<ICompElement> flattenToLocallyDefined(Object prop, Collection<? extends ICompElement> objs) {
        return CompElementActions.flattenToLocallyDefined(prop, objs, ICompElement.class);
    }

    public static <T extends ICompElement> List<T> flattenToLocallyDefined(Object prop, Collection<? extends ICompElement> objs, Class<? extends T> objType) {
        return CompElementActions.flattenToAccepted(objs, obj -> obj.getPropTypes(1).contains(prop), objType);
    }

    public static <ObjT extends ICompElement> List<ObjT> flattenToAccepted(Collection<? extends ICompElement> objs, Predicate<? super ObjT> test, Class<? extends ObjT> objType) {
        ArrayList modObjs = new ArrayList();
        CompElementActions.flattenToLocallyDefined(objs, test, modObjs, objType);
        return modObjs;
    }

    private static <ObjT extends ICompElement> void flattenToLocallyDefined(Collection<? extends ICompElement> objs, Predicate<? super ObjT> test, List<? super ObjT> result, Class<? extends ObjT> objType) {
        for (ICompElement iCompElement : objs) {
            if (objType.isInstance(iCompElement) && test.test(objType.cast(iCompElement))) {
                result.add(objType.cast(iCompElement));
                continue;
            }
            CompElementActions.flattenToLocallyDefined(theUtil.filter(iCompElement.getChildren(), ICompElement.class), test, result, objType);
        }
    }

    private static <ObjT, T> Object getValue(MerlinData md, Collection<? extends ObjT> objs, Function<? super ObjT, Object> getValue, BiPredicate<? super T, ? super T> compare) {
        if (objs.isEmpty()) {
            return ICompElement.NOT_SUPPORTED;
        }
        Object val = ICompElement.NOT_SUPPORTED;
        for (ObjT obj : objs) {
            Object val2 = getValue.apply(obj);
            if (val2 == ICompElement.NON_UNIFORM) {
                return ICompElement.NON_UNIFORM;
            }
            if (val2 == ICompElement.NOT_SUPPORTED) continue;
            if (val == ICompElement.NOT_SUPPORTED) {
                val = val2;
                continue;
            }
            if (compare.test(val, val2)) continue;
            return ICompElement.NON_UNIFORM;
        }
        return val;
    }

    public static class DefProp<PropT>
    extends TypedDefProp<ICompElement, PropT> {
        public DefProp(Object prop) {
            this(prop, false);
        }

        public DefProp(Object prop, boolean localOnly) {
            super(prop, ICompElement.class, localOnly);
        }

        public DefProp(IPropertySet.Prop<PropT> prop) {
            this(prop, false);
        }

        public DefProp(IPropertySet.Prop<PropT> prop, boolean localOnly) {
            super(prop, ICompElement.class, localOnly);
        }
    }

    public static class MappedProp<ObjT extends ICompElement, PropT, BaseT>
    implements IObjectProp<ObjT, PropT> {
        public final IObjectProp<ObjT, BaseT> wrappedProp;
        public final BiFunction<? super ObjT, ? super BaseT, ? extends PropT> fromBase;
        public final BiFunction<? super ObjT, ? super PropT, ? extends BaseT> toBase;

        public MappedProp(IObjectProp<ObjT, BaseT> prop, BiFunction<? super ObjT, ? super BaseT, ? extends PropT> fromBase, BiFunction<? super ObjT, ? super PropT, ? extends BaseT> toBase) {
            this.wrappedProp = prop;
            this.fromBase = fromBase;
            this.toBase = toBase;
        }

        @Override
        public Collection<? extends ObjT> filterObjs(Collection<? extends ObjT> objs) {
            return this.wrappedProp.filterObjs(objs);
        }

        @Override
        public void set(MerlinData md, Collection<? extends ObjT> objs, PropT newVal) {
            Undo.begin(Intl.intl("Set Property"));
            for (ICompElement obj : this.filterObjs(objs)) {
                BaseT wrapped = this.toBase.apply(obj, newVal);
                this.wrappedProp.set(md, List.of(obj), wrapped);
            }
            Undo.end(md);
        }

        @Override
        public Object get(MerlinData md, Collection<? extends ObjT> objs) {
            BiPredicate<Object, Object> compare = (v1, v2) -> Objects.equals(v1, v2);
            return CompElementActions.getValue(md, this.filterObjs(objs), obj -> {
                Object val = this.wrappedProp.get(md, List.of(obj));
                if (val == Composite.NON_UNIFORM || val == Composite.NOT_SUPPORTED) {
                    return val;
                }
                return this.fromBase.apply(obj, val);
            }, compare);
        }
    }

    public static class TypedDefProp<ObjT extends ICompElement, PropT>
    implements IObjectProp<ObjT, PropT> {
        public final Object prop;
        public final Class<ObjT> objType;
        public final boolean localOnly;

        public TypedDefProp(Object prop, Class<ObjT> objType, boolean localOnly) {
            this.prop = prop;
            this.objType = objType;
            this.localOnly = localOnly;
        }

        public TypedDefProp(IPropertySet.Prop<PropT> prop, Class<ObjT> objType, boolean localOnly) {
            this((Object)prop, objType, localOnly);
        }

        public Object getProp() {
            return this.prop;
        }

        protected void saveState(MerlinData md, Object prop, Collection<? extends ObjT> objs, PropT newVal) {
            List<ICompElement> modObjs = CompElementActions.flattenToLocallyDefined(prop, objs);
            Undo.insertUndoEntry_propRestore(md, modObjs, prop);
        }

        protected void set(MerlinData md, Object prop, ObjT obj, PropT newVal) {
            obj.setProperty(prop, newVal);
        }

        protected Object get(MerlinData md, Object prop, ObjT obj) {
            return obj.getProperty(prop);
        }

        protected boolean equal(MerlinData md, PropT obj1, PropT obj2) {
            return Objects.equals(obj1, obj2);
        }

        @Override
        public Collection<? extends ObjT> filterObjs(Collection<? extends ObjT> objs) {
            return this.localOnly ? CompElementActions.flattenToLocallyDefined(this.prop, objs, this.objType) : objs;
        }

        @Override
        public void set(MerlinData md, Collection<? extends ObjT> objs, PropT newVal) {
            this.saveState(md, this.prop, objs, newVal);
            Collection<ObjT> finalObjs = this.filterObjs(objs);
            for (ICompElement obj : finalObjs) {
                this.set(md, this.prop, obj, newVal);
            }
        }

        @Override
        public Object get(MerlinData md, Collection<? extends ObjT> objs) {
            BiPredicate<Object, Object> compare = (v1, v2) -> this.equal(md, v1, v2);
            Collection<? extends ObjT> finalObjs = this.filterObjs(objs);
            return CompElementActions.getValue(md, finalObjs, obj -> this.get(md, this.prop, obj), compare);
        }
    }

    public static interface IObjectProp<ObjT, PropT> {
        public void set(MerlinData var1, Collection<? extends ObjT> var2, PropT var3);

        public Object get(MerlinData var1, Collection<? extends ObjT> var2);

        public Collection<? extends ObjT> filterObjs(Collection<? extends ObjT> var1);
    }
}

