/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.JOptionPane;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.AddObject;
import merlin.actions.Delete;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.EgressAgentComp;
import merlin.data.egress.agents.OccLocation;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.agents.OccTarget;
import merlin.data.egress.scripting.Behavior;
import merlin.geom.Geometry;
import merlin.gui.DistributionEditor;
import merlin.util.MerlinUtil;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.framework.Deletion;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.Tuple3;
import thunderheadeng.util.stat.IDistributedVal;
import thunderheadeng.util.stat.InfiniteUrn;

public class AddOccsFromOccTargets
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new AddOccsFromOccTargets(), Intl.intl("Create occupants from targets...,-,Creates occupants based on the selected occupant targets."));
    private final Random rnd = new Random(598927L);
    private DistributionEditor<OccProfile> profEd;
    private DistributionEditor<Behavior> behaviorEd;

    public AddOccsFromOccTargets() {
        SelectionObserver.add(this, OccTarget.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        IFilteredCollection<OccTarget> locs = MerlinApp.getApp().getData().selection.flatten(OccTarget.class);
        this.setEnabled(!locs.isEmpty());
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        boolean delLocs;
        int sel;
        Runnable delTask = () -> {};
        ArrayList groups = new ArrayList();
        ArrayList<EgressAgent> locs = new ArrayList<EgressAgent>();
        Pair distributions = md.ui(() -> this.getDistributions(app, md));
        if (distributions == null) {
            return;
        }
        LinkedIdentityHashSet<OccTarget> occTargets = new LinkedIdentityHashSet<OccTarget>((Collection<OccTarget>)md.selection.flatten(OccTarget.class));
        IdentityHashMap<Object, EgressAgentComp> groupMap = new IdentityHashMap<Object, EgressAgentComp>();
        ArrayList<OccTarget> skippedLocs = new ArrayList<OccTarget>();
        IDistributedVal profiles = (IDistributedVal)distributions.v1;
        IDistributedVal behaviors = (IDistributedVal)distributions.v2;
        LinkedList attemptedProfiles = new LinkedList();
        int maxProfAttempts = 10;
        int maxSeedAttempts = 10;
        for (OccTarget occTarget : occTargets) {
            double orient = occTarget.get(OccTarget.ORIENT).get(Geometry.ANGLE_UNIT);
            Behavior behavior = (Behavior)behaviors.getValue(this.rnd);
            Function<OccProfile, Pair> tryProfile = prof -> {
                for (int m = 0; m < 10; ++m) {
                    long nextSeed = MerlinUtil.newSeed();
                    OccLocation oloc = md.findValidOccLocation((OccProfile)prof, nextSeed, occTarget.get(OccTarget.LOCATION), orient, 0, Predicates.alwaysTrue());
                    if (oloc.room == null || oloc.overlapsWalls) continue;
                    return new Pair<OccLocation, Long>(oloc, nextSeed);
                }
                return null;
            };
            Supplier<Tuple3> getLocAndSeed = () -> {
                int nattempts;
                Iterator it = attemptedProfiles.iterator();
                for (nattempts = 0; it.hasNext() && nattempts < 10; ++nattempts) {
                    OccProfile prof = (OccProfile)it.next();
                    Pair attempt = (Pair)tryProfile.apply(prof);
                    if (attempt == null) continue;
                    it.remove();
                    return new Tuple3<OccProfile, OccLocation, Long>(prof, (OccLocation)attempt.v1, (Long)attempt.v2);
                }
                while (nattempts < 10) {
                    OccProfile prof = (OccProfile)profiles.getValue(this.rnd);
                    Pair attempt = (Pair)tryProfile.apply(prof);
                    if (attempt != null) {
                        return new Tuple3<OccProfile, OccLocation, Long>(prof, (OccLocation)attempt.v1, (Long)attempt.v2);
                    }
                    attemptedProfiles.add(prof);
                    ++nattempts;
                }
                return null;
            };
            Tuple3 loc = getLocAndSeed.get();
            if (loc == null) {
                skippedLocs.add(occTarget);
                continue;
            }
            EgressAgent agent = new EgressAgent(new OccProfile((OccProfile)loc.v1), behavior, (Long)loc.v3);
            agent.setName(String.format(Intl.intl("Occupant: %s"), occTarget.getName()));
            agent.setLocation((OccLocation)loc.v2);
            agent.setOrient(orient);
            Object[] path = md.hierarchy.getPath(occTarget, md.occTargets, false);
            if (path.length <= 1) {
                locs.add(agent);
                continue;
            }
            EgressAgentComp parent = AddOccsFromOccTargets.getParentGroup(groupMap, path, path.length - 2, groups);
            assert (parent != null);
            parent.add(agent);
        }
        if (!skippedLocs.isEmpty() && (sel = md.ui(() -> {
            if (skippedLocs.size() != occTargets.size()) {
                Object msg = skippedLocs.size() == 1 ? String.format(Intl.intl("An occupant cannot be created for %s."), ((OccTarget)skippedLocs.get(0)).getName()) : String.format(Intl.intl("%d occupants cannot be created."), skippedLocs.size());
                msg = "<html>" + (String)msg + "<br>";
                msg = (String)msg + Intl.intl("Would you like to create occupants for the remaining targets?");
                return JOptionPane.showConfirmDialog(app.getActiveFrame(), msg, Intl.intl("Cannot create all occupants"), 0);
            }
            JOptionPane.showMessageDialog(app.getActiveFrame(), Intl.intl("Cannot create occupants for any of the occupant targets."), Intl.intl("Cannot create occupants"), 2);
            return 2;
        }).intValue()) != 0) {
            return;
        }
        int selOpt = md.ui(() -> JOptionPane.showConfirmDialog(app.getActiveFrame(), Intl.intl("Would you like to delete the selected occupant targets?"), Intl.intl("Delete selected occupant targets?"), 1));
        if (selOpt == 0) {
            delLocs = true;
        } else if (selOpt == 1) {
            delLocs = false;
        } else {
            return;
        }
        if (delLocs) {
            occTargets.removeAll(skippedLocs);
            Pair<Deletion.DelStatus, Runnable> status = Delete.startUiDelete(app, md, occTargets, false);
            if (status.v1 == Deletion.DelStatus.CANCELLED) {
                return;
            }
            if (status.v1 == Deletion.DelStatus.SUCCESS) {
                delTask = (Runnable)status.v2;
            }
        }
        try (MerlinData.WriteLock lock = md.lockWrite();){
            Undo.begin(Intl.intl("Add Occupants"));
            delTask.run();
            AddObject.add(md, md.agents, groups);
            AddObject.add(md, md.agents, locs);
            Undo.end(md);
        }
    }

    private Pair<IDistributedVal<OccProfile>, IDistributedVal<Behavior>> getDistributions(MerlinApp app, MerlinData md) {
        if (this.profEd == null || this.behaviorEd == null) {
            this.profEd = new DistributionEditor<OccProfile>(md, Intl.intl("Profile"), md.profiles, OccProfile.class, null);
            this.behaviorEd = new DistributionEditor<Behavior>(md, Intl.intl("Behavior"), md.behaviors, Behavior.class, null);
        }
        if (this.profEd.getAvailable().size() == 1 && this.behaviorEd.getAvailable().size() == 1) {
            return new Pair<IDistributedVal<OccProfile>, IDistributedVal<Behavior>>(new InfiniteUrn<OccProfile>(this.profEd.getAvailable().get(0)), new InfiniteUrn<Behavior>(this.behaviorEd.getAvailable().get(0)));
        }
        guiDialog dlg = new guiDialog((Window)app.getActiveFrame(), Intl.intl("Choose Distributions"), 9);
        GridBagHelper gb = new GridBagHelper(dlg.getDialogPane());
        gb.addRow(Intl.intl("Profile:"), this.profEd, 1.0, 0);
        gb.addRow(Intl.intl("Behavior:"), this.behaviorEd, 1.0, 0);
        gb.finalizeRows();
        if (dlg.doModal() != 1) {
            return null;
        }
        return new Pair<IDistributedVal<OccProfile>, IDistributedVal<Behavior>>((IDistributedVal)this.profEd.getValue(), (IDistributedVal)this.behaviorEd.getValue());
    }

    private static EgressAgentComp getParentGroup(Map<Object, EgressAgentComp> groupMap, Object[] agentsPath, int index, List<? super EgressAgentComp> roots) {
        if (index < 0) {
            return null;
        }
        Object agentGroup = agentsPath[index];
        return groupMap.computeIfAbsent(agentGroup, g -> {
            EgressAgentComp lgroup = new EgressAgentComp(g instanceof IMerlinObj ? MerlinUtil.getName((IMerlinObj)g) : Intl.intl("Group"));
            EgressAgentComp parent = AddOccsFromOccTargets.getParentGroup(groupMap, agentsPath, index - 1, roots);
            if (parent == null) {
                roots.add(lgroup);
            } else {
                parent.add(lgroup);
            }
            return lgroup;
        });
    }
}

